
require import AllCore.

abstract theory HashTheory.

type hash_input.
type hash_output.

op H   : hash_input -> hash_output.
op his : hash_input distr.


(* Collision-resistance adversary and the CR-game *)
module type AdvCR = {
  proc adv() : hash_input * hash_input
}.

module GameCR(A:AdvCR) = {  
  proc main(): bool= {
    var x, x' : hash_input;

    (x, x') = A.adv();

    return H x = H x' /\ x <> x';
  }
}. 


(* Second-preimage resistance adversary and the game *)
module type AdvSPR = {
  proc adv(x : hash_input) : hash_input
}.

module GameSPR(A:AdvSPR) = {  
  proc main(): bool= {
    var x, x' : hash_input;

    x =$ his;
    x' = A.adv(x);

    return H x = H x' /\ x <> x';
  }
}.

(* reduction of AdvSPR to AdvCR *)
module T(A : AdvSPR) : AdvCR = {
  proc adv() : hash_input * hash_input = {
    var x, x';

    x =$ his;
    x' = A.adv(x);
    
   return (x, x'); 
  }
}.

(* If A wins SPR then T(A) wins CR *)
lemma sprpr : forall  (A <: AdvSPR),
  equiv [ GameSPR(A).main ~ GameCR(T(A)).main : ={glob A} ==> res{1} => res{2} ].
proof. move => A. proc. inline*. wp. call (_:true). rnd. skip. progress. 
qed.

(* conversion of PRHL equivalence into probabilities of events *)
lemma SP_CR &m : forall  (A <: AdvSPR),
  Pr[ GameSPR(A).main() @ &m : res ] <= Pr[ GameCR(T(A)).main() @ &m : res ].
proof. move => A. byequiv. conseq (sprpr A). progress. auto. trivial. 
qed.


end HashTheory.

