pragma Goals:printall.

require import FSet Int IntExtra Real SmtMap Distr.

require import BLT_Instance.


(* converting BLT adversary into CR-adversary  *)
module T(A : AdvBLT_RO) : AdvCR = {
  module G = GameBLT(BLTOracle, A)

  var p1, p2 : (message * tag)
  var b : bool

  proc adv() : (message * tag) * (message * tag) = {

    b = G.main();

    p1 = (oget BLTOracle.qs, tagGen TagOracle.sk BLTOracle.qt);    
    p2 = (GameBLT.m, GameBLT.tg);

    return (p1, p2);
  }
}.


section.

declare module A : AdvBLT_RO{BLTOracle, TagOracle, Ts, T}.

local lemma forgeInvariant  :
 hoare [ A(Ts, BLTOracle).forge : Ts.r = empty /\ TagOracle.usedFlag = BLTOracle.used ==>
    forall i y, Ts.r.[i] = y => y <> None
           => exists m, (Some m) = BLTOracle.qs 
          /\ y = Some (H (m, tagGen TagOracle.sk BLTOracle.qt)) ].
proof. proc*.

call (_: (forall i y, Ts.r.[i] = y => y <> None => exists m, Some m = BLTOracle.qs 
     /\ y = Some (H (m, tagGen TagOracle.sk BLTOracle.qt)))
     /\ (!BLTOracle.used => Ts.r = empty) /\  TagOracle.usedFlag = BLTOracle.used) .

proc. inline*. wp. skip. smt.
proc. if. inline*. wp. skip. progress. 
cut : i = Ts.t{hr} + 1. smt.
move => qq. smt. smt.
wp. skip.  progress. smt. skip. progress. smt.
qed.


local lemma reductionCR : hoare [ GameCR(T(A)).main : true ==> T.b => res ].
proof. proc.
inline*.
wp. call forgeInvariant. wp. rnd.
wp. rnd. skip.
progress;smt (@SmtMap).
qed.


local lemma rel1 : equiv [ GameBLT( BLTOracle, A).main ~ GameCR(T(A)).main : 
 ={glob A, glob BLTOracle} ==> res{1} = T.b{2} ].
proof. 
proc. inline*. wp.
call (_: ={glob Ts, glob BLTOracle, glob TagOracle}).
proc. inline*. wp. skip. auto.
proc. inline*. wp. skip. smt.
wp. rnd. wp. rnd.
skip. progress.
qed.


local lemma rel2 : equiv [ GameBLT(BLTOracle, A).main ~ GameCR(T(A)).main 
                   : ={glob A, glob BLTOracle} ==>  res{1} => res{2} ].
proof. 
conseq (_: ={glob A, glob BLTOracle, glob Ts} ==> res{1} => res{2}) 
       (_:true ==> true ) 
       (_:true ==> res = res). 
progress. progress.
proc. inline*. wp.
call (_:true). progress. progress. wp.
rnd. wp. rnd. skip. smt.
conseq (_: ={glob A, glob BLTOracle} ==> res{1} = T.b{2}) 
       (_:true ==> true ) 
       (_:true ==> (T.b => res)).
auto. progress. progress.
conseq reductionCR.
apply rel1.

qed.

  
lemma sec &m :
 Pr[ GameBLT(BLTOracle, A).main() @ &m : res ] 
   <= Pr [ GameCR(T(A)).main() @ &m : res ].
proof. byequiv (_: ={glob A, glob BLTOracle} ==> _). 
conseq rel2;auto. auto. trivial.
qed.

end section.
