require import Int Distr.

(* distribution of initial times for a timestamping service *)
op tdistr : int distr.

axiom d_ll : is_lossless tdistr.
axiom tdistr_pos t : t \in tdistr => 0 < t. 

(* unbounded tag system *) 
type pkey, skey, tag, message, hash_output.

op keyGen : (pkey * skey) distr.
op tagGen : skey -> int -> tag.
op tagVer : pkey -> int -> tag -> bool.

axiom validKeys pk sk t :  (pk, sk) \in keyGen => tagVer pk t (tagGen sk t) = true.  
axiom keyGen_lossless : is_lossless keyGen.


require BLT.

clone export BLT.BLT_Scheme_Theory as 
    BST with type pkey      <- pkey,
             type skey      <- skey,
             type tag       <- tag,
             type message   <- message,
             type data      <- message * tag,  (* repo holds message-tag pair *)
             op   bind      <- fun x, x,       (* binding is identity function *)
             op   keyGen    <- keyGen,
             op   tagGen    <- tagGen,
             op   tagVer    <- tagVer,
             op   tdistr    <- tdistr.


(* Type for adversaries who only can READ from the repository  *)
module type AdvBLT_RO(T : TS, O : BLTOracleT) = {
  proc forge(pk : pkey) : message * tag * int  {T.check O.sign}  (* O.put is forbidden *)
}.
