pragma Goals:printall.

require import FSet Int IntExtra Real SmtMap Distr.
require import BLT_Instance.

section.

declare module A : AdvBLT_RO{BLTOracle, TagOracle, Ts}.

(* If oracles are terminating then adversary is as well *)
axiom A_ll : forall (T <: TS{A}) (O <: BLTOracleT{A}), 
  islossless T.check => islossless O.sign => islossless A(T,O).forge.


local lemma forgeInvariant  :
 phoare [ A(Ts, BLTOracle).forge : Ts.r = empty /\ TagOracle.usedFlag = BLTOracle.used ==>
    forall i y, Ts.r.[i] = y => y <> None
           => exists m, Some m = BLTOracle.qs 
          /\ y = Some (m, tagGen TagOracle.sk BLTOracle.qt) ] = 1%r.
proof. proc*.
call (_: (forall i y, Ts.r.[i] = y => y <> None => exists m, Some m = BLTOracle.qs 
     /\ y = Some (m, tagGen TagOracle.sk BLTOracle.qt))
     /\ (!BLTOracle.used => Ts.r = empty) /\ TagOracle.usedFlag = BLTOracle.used).
apply A_ll.
proc. inline*. wp. skip. smt.
proc. if. inline*. wp. skip. progress. 
cut : i = Ts.t{hr} + 1. smt.
move => qq. smt. smt.
wp. skip.  progress. smt. skip. progress. smt.
qed.


local lemma final_sec' &m :
     Pr[ GameBLT(BLTOracle, A).main() @ &m : res => BLTOracle.qs = Some GameBLT.m 
        /\ (BLTOracle.qs <> Some GameBLT.m) ] 
     = 1%r.
proof. byphoare. proc. inline*. wp.
call forgeInvariant. wp. rnd. wp. rnd (fun x => x \in keyGen). skip.
progress;smt. auto. auto.
qed.


lemma sec &m :
 Pr[ GameBLT(BLTOracle, A).main() @ &m : res ] = 0%r.
proof.
cut : Pr[ GameBLT(BLTOracle, A).main() @ &m : !res ] >= 1%r.
rewrite - (final_sec' &m).
rewrite Pr [mu_sub];smt. 
cut : Pr[ GameBLT(BLTOracle, A).main() @ &m : !res ] = 1%r.
smt.
move => q1 q2. smt.
qed.


end section.
