require import  Int Distr.


(* distribution of initial times for the timestamping service *)
op tdistr : int distr.

axiom d_ll : is_lossless tdistr.
axiom tdistr_pos t : t \in tdistr => 0 < t. 


(* kpe-bounded tag system *)
type pkey, skey, tag, message, hash_output.

op keyGen : (pkey * skey) distr.
op tagGen : skey -> int -> tag.
op tagVer : pkey -> int -> tag -> bool.
op kpe : int.

axiom validKeys pk sk t :  (pk, sk) \in keyGen => t < kpe => tagVer pk t (tagGen sk t) = true.
axiom validTime pk sk tg t :  (pk, sk) \in keyGen => tagVer pk t tg = true => t < kpe.

axiom keyGen_lossless : is_lossless keyGen.
axiom kpePos : 0 < kpe.


require Hash.
clone import Hash.HashTheory as HM with type hash_input  <- message,
                                      type hash_output <- hash_output.

clone import Hash.HashTheory as HT with type hash_input  <- tag,
                                      type hash_output <- hash_output.

require BLT.
clone export BLT.BLT_Scheme_Theory as 
    BST with type pkey         <- pkey,
             type skey         <- skey,
             type tag          <- tag,
             type message      <- message,
             type hash_output  <- hash_output,
             type data         <- hash_output * hash_output,                       (* repository holds tuples of hashes *)
             op   bind         <- fun (x : message * tag), (HM.H x.`1, HT.H x.`2), (* binding computes a message hash 
                                                                                     paired with the tag hash  *)
             op   keyGen       <- keyGen,
             op   tagGen       <- tagGen,
             op   tagVer       <- tagVer,
             op   H            <- HT.H,
             op   tdistr       <- tdistr,
             op   kpe          <- kpe.



                                             
