pragma Goals:printall.

require import Int Real Distr SmtMap.

require import BLT_Instance.


module H(A : AdvBLT) = {
  module G = GameBLT(BLTOracle, A)

  var p1, p2 : message 
  var b : bool

  proc adv() : message * message = {

   b = G.main();

   p1 = (oget BLTOracle.qs);    
   p2 = (GameBLT.m);

   return (p1, p2);
  }
}.


section. 

declare module A : AdvBLT{TagOracle, BLTOracle, Ts, GameBLT}.


local lemma forgeInv0 :
 hoare [ A(Ts, BLTOracle).forge : 
     Ts.r = empty /\ Ts.t = Ts.i 
 /\  (TagOracle.usedFlag =>  BLTOracle.qt <= Ts.t)
 /\  TagOracle.usedFlag = BLTOracle.used
 /\  !BLTOracle.used /\ (TagOracle.pk, TagOracle.sk) \in keyGen 
 ==> BLTOracle.used => exists m, Some m = BLTOracle.qs 
        /\ Ts.r.[ BLTOracle.qt] 
        = Some (HM.H m, HT.H (tagGen TagOracle.sk BLTOracle.qt)) ].
proof. proc*.
call (_: (BLTOracle.used => exists m, Some m = BLTOracle.qs 
            /\ Ts.r.[ BLTOracle.qt] 
            = Some (HM.H m, (HT.H (tagGen TagOracle.sk BLTOracle.qt))))
   /\ (TagOracle.usedFlag => BLTOracle.qt <= Ts.t)
   /\ TagOracle.usedFlag = BLTOracle.used
   /\ (TagOracle.pk, TagOracle.sk) \in keyGen).

proc. if. inline*. wp. skip. progress;smt.
 wp. skip.  progress;smt.
proc. inline*. wp. skip. progress;smt.
proc. inline*. wp. skip. smt. 
skip. progress.  
qed.


local lemma reductionCR : 
  hoare [ HM.GameCR(H(A)).main : true 
  ==> H.b /\ BLTOracle.used 
   /\  BLTOracle.qt = GameBLT.t
        => HM.H H.p1 = HM.H H.p2 
           /\ H.p1 <> H.p2 ].
proof.
proc. inline*. wp. call forgeInv0. wp. rnd.
wp. rnd. skip.  smt. 
qed.



local lemma reductioneq' : 
  equiv [ GameBLT(BLTOracle, A).main ~ HM.GameCR(H(A)).main :
  ={glob A, glob BLTOracle}
  ==> res{1} = H.b{2} /\ ={glob BLTOracle, glob GameBLT} ].
proof. proc.
inline*. wp.
call (_: ={glob Ts, glob BLTOracle, glob TagOracle}).
proc. inline*. wp. skip. progress.
proc. inline*. wp. skip. smt.
proc. inline*. wp. skip. smt.
wp. rnd. wp. rnd. skip. progress. 
qed.


local lemma reductioneqf : 
  equiv [ GameBLT(BLTOracle, A).main ~ HM.GameCR(H(A)).main 
  : ={glob A, glob BLTOracle} ==> res{1} /\ BLTOracle.used{1} 
  /\  BLTOracle.qt{1} = GameBLT.t{1} => res{2} ].
proof. 
conseq (_: ={glob A, glob BLTOracle} 
  ==> res{1} 
   /\ BLTOracle.used{1} 
   /\  BLTOracle.qt{1} = GameBLT.t{1} => 
       (HM.H H.p1 = HM.H H.p2 /\ H.p1 <> H.p2){2}) 
  (_: true ==> true) 
  (_: true ==> 
    res = (HM.H H.p1 = HM.H H.p2 /\ H.p1 <> H.p2)).
smt. 
proc. inline*. wp. call (_:true). 
proc. inline*. wp. skip. auto.
proc. inline*. wp. skip. auto.
proc. inline*. wp. skip. auto.
wp. rnd. wp. rnd. skip. auto.
proc. inline*. wp.
call (_:true).
proc. inline*. wp. skip. auto.
proc. inline*. wp. skip. auto.
proc. inline*. wp. skip. auto.
wp. rnd. wp. rnd. skip. smt.

conseq (_: ={glob A, glob BLTOracle} ==> res{1} = H.b{2} 
  /\ ={glob BLTOracle, glob GameBLT}) (_:true ==> true) 
  (_:true ==> (H.b /\ BLTOracle.used 
              /\  BLTOracle.qt = GameBLT.t
              => HM.H H.p1 = HM.H H.p2 
              /\ H.p1 <> H.p2)).
auto. progress.
apply reductionCR. conseq reductioneq'. 
qed.


lemma case2' &m :
   Pr[ GameBLT(BLTOracle, A).main() @ &m : res /\ GameBLT.t = BLTOracle.qt ]  
   = Pr[ GameBLT(BLTOracle, A).main() @ &m : res /\ BLTOracle.used /\ GameBLT.t = BLTOracle.qt ].
proof. byequiv (_ : ={glob A, glob BLTOracle, glob Ts} ==> _). 
proc. inline*. wp.
call (_: (!BLTOracle.used{1} => BLTOracle.qt{1} = 0) 
    /\ ={glob BLTOracle, glob Ts} 
    /\ (0 < Ts.i{2}) 
    /\ (forall i, i \in Ts.r{2} => 0 < i) 
    /\ Ts.i{2} \in tdistr /\ (Ts.i <= Ts.t){2}).
proc. wp. if. smt.  wp. inline*. wp. skip. progress;smt. 
wp. skip. smt.
proc. wp. skip. smt. 
proc. wp. skip. smt. 
wp. rnd. wp. rnd.
skip. progress;smt. trivial. auto.
qed.

 
lemma case2 &m :
   Pr[ GameBLT(BLTOracle, A).main() @ &m : res /\ GameBLT.t = BLTOracle.qt  ] 
  <= Pr[ HM.GameCR(H(A)).main() @ &m : res ].
proof.
rewrite (case2' &m). 
byequiv (_ : ={glob A, glob BLTOracle} ==> _). 
conseq reductioneqf. progress. progress;smt. trivial. auto.
qed.

end section.
