pragma Goals:printall.

require import FSet Int IntExtra Real SmtMap Distr.

require import BLT_Instance.


module F(A:AdvBLT, O:TagOracleT) = {
  module A = A(Ts, BLTOracle)

  proc forge(pk:pkey) = {
   var tg, m, t;

   BLTOracle.qs   = None;
   BLTOracle.qt   = 0;
   BLTOracle.used = false;

   Ts.init();
   (m, tg, t) = A.forge(pk);

   return (tg, t);
  }

}.


section. 

declare module A : AdvBLT{TagOracle, Ts, BLTOracle}.

local lemma tgcollision : 
  equiv [ GameBLT(BLTOracle, A).main ~ GamePF(TagOracle, F(A)).main
  : ={glob A, glob TagOracle, glob BLTOracle, glob Ts} ==> 
  (res /\ tagGen TagOracle.sk GameBLT.t <> GameBLT.tg){1} => res{2} ].
proof. proc.
inline*. wp.
call (_: ={glob TagOracle, glob BLTOracle, glob Ts}).
proc. if.  auto. inline*. wp.  skip. progress. wp. skip. smt.
proc. inline*.  wp.  skip. smt.
proc. inline*. wp. skip. smt.
wp.  wp. rnd. wp. rnd. skip. progress. smt.
qed.


lemma case3_1 &m : 
  Pr [ GameBLT(BLTOracle, A).main() @ &m : res /\ tagGen TagOracle.sk GameBLT.t <> GameBLT.tg ] 
 <= Pr [ GamePF(TagOracle, F(A)).main() @ &m  : res ].
byequiv (_: ={glob A,  glob TagOracle, glob BLTOracle, glob Ts} 
 ==> (res /\ tagGen TagOracle.sk GameBLT.t <> GameBLT.tg){1} => res{2}).
conseq tgcollision;smt. auto. auto.
qed.

end section.



