pragma Goals:printall.

require import Int Real SmtMap Distr DInterval.

require import BLT_Instance.


module GameBLT'(BLTO : BLTOracleT, A : AdvBLT) = {
  module G = GameBLT(BLTO, A)

  var guess : int
  var r : bool
  proc main() : bool = {
    r = G.main();
    guess <$ dinter 1 kpe;
    return r;
  }
}.


module G(A:AdvBLT) = {
   module A = A(Ts, BLTDummy) 

   var guess : int   
   proc forge(pk:pkey) = {
      var r;

      Ts.init();
      A.forge(pk);
     
      r = Ts.r;
      guess =$ dinter 1 kpe;
     
      return ((oget r.[guess]).`2, guess);
    }
}.


section. 

declare module A : AdvBLT{TagOracle, BLTOracle, Ts, GameBLT}.

axiom A_ll : forall (T <: TS{A}) (O <: BLTOracleT{A}),
  islossless O.sign =>
  islossless T.put => islossless T.check => islossless A(T,O).forge.


local module BA : AdvTHU = G(A).  
  
local lemma zz2 &m : 
  phoare [ GameBLT(BLTOracle, A).main : 
    (glob A) = (glob A){m} /\ (glob BLTOracle) = (glob BLTOracle){m}
  ==> res  
  /\ tagGen TagOracle.sk GameBLT.t = GameBLT.tg
  /\ GameBLT.t <  BLTOracle.qt 
  /\ GameBLT.t < kpe 
  /\ 1 <= GameBLT.t ]  
  = Pr[ GameBLT(BLTOracle, A).main() @ &m : 
      res /\ tagGen TagOracle.sk GameBLT.t = GameBLT.tg
      /\ GameBLT.t <  BLTOracle.qt 
      /\ GameBLT.t < kpe 
      /\ 1 <= GameBLT.t ]. 
proof. bypr. move => &m0 _. 
byequiv.
proc. inline*. wp. call (_: ={glob BLTOracle, glob TagOracle, glob Ts}).
proc. if. smt. wp. inline*. wp.   skip. progress. wp. skip. smt.
proc. inline*. wp. skip. smt.
proc. inline*. wp. skip. smt.
wp. rnd. wp. rnd.  skip. smt. auto. auto.
qed.




local lemma zz &m : 
  phoare [ GameBLT'(BLTOracle, A).main : 
    (glob A) = (glob A){m} /\     (glob BLTOracle) = (glob BLTOracle){m}  
     ==> res 
     /\ tagGen TagOracle.sk GameBLT.t = GameBLT.tg 
     /\ GameBLT.t < BLTOracle.qt 
     /\ GameBLT.t < kpe 
     /\ 1 <= GameBLT.t
     /\ GameBLT.t = GameBLT'.guess ]
  = (Pr[ GameBLT(BLTOracle, A).main() @ &m 
     :  res 
     /\ tagGen TagOracle.sk GameBLT.t = GameBLT.tg
     /\ GameBLT.t <  BLTOracle.qt 
     /\ GameBLT.t < kpe 
     /\ 1 <= GameBLT.t ] * (1%r/kpe%r)).
proof. proc*.

inline GameBLT'(BLTOracle, A).main.

seq 1 : (GameBLT'.r 
  /\ tagGen TagOracle.sk GameBLT.t = GameBLT.tg
  /\ GameBLT.t <  BLTOracle.qt 
  /\ GameBLT.t < kpe 
  /\ 1 <= GameBLT.t)

 Pr[ GameBLT(BLTOracle, A).main() @ &m 
   : res 
  /\ tagGen TagOracle.sk GameBLT.t = GameBLT.tg
  /\ GameBLT.t <  BLTOracle.qt 
  /\ GameBLT.t < kpe 
  /\ 1 <= GameBLT.t ]

  (1%r/kpe%r)

  (1%r - Pr[ GameBLT(BLTOracle, A).main() @ &m 
         : res 
        /\ tagGen TagOracle.sk GameBLT.t = GameBLT.tg
        /\ GameBLT.t < BLTOracle.qt 
        /\ GameBLT.t < kpe 
        /\ 1 <= GameBLT.t])

  0%r. 

inline*. wp. call(_:true); auto.
call (zz2 &m);auto. progress.
wp. rnd (fun (x : int) =>  GameBLT.t = x). 
skip. progress.

cut : 1 <=  GameBLT.t{hr} <= kpe. smt.
move => www.

have z := dinter1E 1 kpe  (GameBLT.t{hr}).
rewrite www in z.

cut : mu1 [1..kpe] GameBLT.t{hr} = inv (kpe)%r. smt.
move => opp. rewrite - opp.

cut : ((=) (GameBLT.t{hr})) = pred1 (GameBLT.t{hr}).
apply fun_ext. move => x. smt.

move => oppz. rewrite oppz. smt.

wp. rnd. skip. smt. smt.  
qed.


local lemma zz3 &m : 
  Pr[ GameBLT'(BLTOracle, A).main() @ &m 
    : res 
   /\ tagGen TagOracle.sk GameBLT.t = GameBLT.tg
   /\ GameBLT.t < BLTOracle.qt 
   /\ GameBLT.t < kpe 
   /\ 1 <= GameBLT.t
   /\ GameBLT.t = GameBLT'.guess ] 
  = (Pr[ GameBLT(BLTOracle, A).main() @ &m 
    : res 
    /\ tagGen TagOracle.sk GameBLT.t = GameBLT.tg 
    /\ GameBLT.t <  BLTOracle.qt
    /\ GameBLT.t < kpe 
    /\ 1 <= GameBLT.t ] * (1%r/kpe%r)). 
proof. byphoare (_: (glob A) = (glob A){m} /\ (glob BLTOracle) = (glob BLTOracle){m} ==> _). 
apply (zz &m). auto. auto. 
qed.


local lemma wwwForB : equiv [ GameTHU(G(A)).main 
  ~ GameBLT'(BLTOracle, A).main
  : ={glob A, glob BLTOracle}
  ==> res{2} 
   /\ GameBLT.t{2} <  BLTOracle.qt{2}
   /\ (tagGen TagOracle.sk{2} (GameBLT.t{2}) = GameBLT.tg{2})
      => BLTOracle.used{2} 
       /\ (forall x, x < (BLTOracle.qt{2}) 
       /\ Ts.i{2} < x => Ts.r.[x]{1} = Ts.r.[x]{2})
       /\ (forall x, x <= Ts.i{2} => x \notin Ts.r{2})
       /\ (Ts.r.[GameBLT.t]{2} = Some ((HM.H GameBLT.m), ((HT.H GameBLT.tg))){2})
       /\ (GameBLT'.guess{2} = GameBLT.t{2} => res{1}) ].
proof. proc. 

inline*. wp. rnd. wp.

call (_: BLTOracle.used, (0 < Ts.i{2})  
 /\ (Ts.i{2} <= Ts.t{2}) /\ (Ts.i{1} <= Ts.t{1}) /\ (forall x, x <= Ts.i{2} => x \notin Ts.r{2})
 /\ ={glob Ts} /\ BLTOracle.used{2} = TagOracle.usedFlag{2}  
 /\ (forall x, x <  BLTOracle.qt{2} =>  (Ts.r.[x]{2} = Ts.r.[x]{1}))
 /\ (forall x, x <= Ts.t{2} => Ts.i{2} < x => x \in Ts.r{2})
 /\ (TagOracle.pk{2}, TagOracle.sk{2}) \in keyGen 
 /\ (forall y, y \in Ts.r{1} => y <= Ts.t{1}) /\ ={glob Ts} 
 /\ (!BLTOracle.used{2} => BLTOracle.qt{2} = 0)
 ,
 (Ts.i{1} = Ts.i{2}) /\
 ((TagOracle.usedFlag = BLTOracle.used) /\ ((TagOracle.pk, TagOracle.sk) \in keyGen 
 /\ BLTOracle.used 
 /\ TagOracle.usedFlag => Ts.r.[ BLTOracle.qt]{2} = Some (HM.H (oget BLTOracle.qs), 
                                                           (HT.H (tagGen TagOracle.sk BLTOracle.qt))){2}  
 /\  BLTOracle.qt <= Ts.t)){2} 
 /\  (Ts.i{2} <= Ts.t{2}) /\ (Ts.i{1} <= Ts.t{1}) 
 /\ (forall x, x <= Ts.i{2} => x \notin Ts.r{2})
 /\ (forall x, x <  BLTOracle.qt{2} =>  (Ts.r.[x]{2} = Ts.r.[x]{1}))
 /\ (forall x, x <= Ts.t{2} => Ts.i{2} < x => x \in Ts.r{2})
 /\ (forall x, x <= Ts.t{2} => x \in Ts.r{2} => Ts.i{2} < x)
 /\ BLTOracle.used{2} /\ ( BLTOracle.qt{2} <= Ts.t{2}) 
 /\ (TagOracle.pk{2}, TagOracle.sk{2}) \in keyGen  
 /\ (forall y, y \in Ts.r{1} => y <= Ts.t{1})).
apply A_ll.

proc. wp. if {2}. inline*. wp. skip. progress;smt. wp. skip. smt.

move => _ z. proc. auto.
move => _. proc. auto. if. inline*. wp. skip. smt. wp. skip. smt. 

proc. inline*. wp. skip. progress;smt. 

move => _ z. proc. inline*. wp. skip. progress. timeout 15. smt(@SmtMap). smt. smt.
move => _.  proc. inline*. wp. skip. progress;smt. 

proc. inline*. wp. skip. smt.

move => _ z. proc. inline*. wp. skip. smt.
move => _.   proc. inline*. wp. skip. smt.

wp. rnd. wp. rnd. skip. 
progress;smt.
qed.


local lemma zz4' &m : Pr[ GameBLT(BLTOracle, A).main() @ &m 
   : res /\ tagGen TagOracle.sk GameBLT.t = GameBLT.tg
  /\ GameBLT.t <  BLTOracle.qt 
  /\ GameBLT.t < kpe 
  /\ 1 <= GameBLT.t ] =
  Pr[ GameBLT(BLTOracle, A).main() @ &m 
    : res 
   /\ GameBLT.t < BLTOracle.qt 
   /\ tagGen TagOracle.sk GameBLT.t = GameBLT.tg ].
proof. byequiv. 
proc. inline*. wp. 

call (_: ={glob BLTOracle, glob TagOracle, glob Ts} 
  /\ (forall x, x \in Ts.r{2} => 1 <= x) 
  /\ BLTOracle.used{2} = TagOracle.usedFlag{2} 
  /\ 0 <= Ts.t{2}).

proc. if. smt. wp. inline*. wp.  wp. skip. progress;smt. wp. skip. smt.
proc. inline*. wp.  wp. skip. progress;smt.
proc. inline*. wp. skip. smt. 
wp. rnd. wp. progress. rnd. skip. smt. auto. auto.
qed.


local lemma zz4 &m : Pr[ GameBLT'(BLTOracle, A).main() @ &m 
    : res 
    /\ tagGen TagOracle.sk GameBLT.t = GameBLT.tg
    /\ GameBLT.t <  BLTOracle.qt 
    /\ GameBLT.t = GameBLT'.guess ]
  = Pr[ GameBLT'(BLTOracle, A).main() @ &m 
    : res 
    /\ tagGen TagOracle.sk GameBLT.t = GameBLT.tg
    /\ GameBLT.t <  BLTOracle.qt 
    /\ GameBLT.t < kpe 
    /\ 1 <= GameBLT.t
    /\ GameBLT.t = GameBLT'.guess ].
proof. byequiv.
proc. inline*. rnd. wp.
call (_: ={glob BLTOracle, glob TagOracle, glob Ts} 
        /\ (forall x, x \in Ts.r{2} => 1 <= x) 
        /\ BLTOracle.used{2} = TagOracle.usedFlag{2} 
        /\ 0 <= Ts.t{2}).
proc. if. smt. wp. inline*. wp. skip. progress;smt. wp. skip. smt.
proc. inline*. wp. wp. skip. smt. 
proc. inline*. wp. skip. smt. 
wp. rnd. wp. rnd. skip. progress;smt. auto. auto.
qed.


local lemma ccc &m : 
  Pr[ GameBLT'(BLTOracle, A).main() @ &m
   :  res 
   /\ tagGen TagOracle.sk GameBLT.t = GameBLT.tg
   /\ GameBLT.t < BLTOracle.qt 
   /\ GameBLT.t = GameBLT'.guess ]
  = (Pr[ GameBLT(BLTOracle, A).main() @ &m 
    : res 
   /\ tagGen TagOracle.sk GameBLT.t = GameBLT.tg
   /\ GameBLT.t < BLTOracle.qt 
   /\ GameBLT.t < kpe 
   /\ 1 <= GameBLT.t ] * (1%r/kpe%r)).
proof. rewrite (zz4 &m). apply (zz3 &m). 
qed.


(* GameBLT'(BLTOracle, A) is equivalent to GameBLT(BLTOracle, W(A)) form the paper *)
local lemma htueq : equiv [ GameTHU(G(A)).main 
  ~ GameBLT'(BLTOracle, A).main
  : ={glob A, glob BLTOracle}
  ==> res{2} 
   /\ GameBLT.t{2} <  BLTOracle.qt{2}
   /\ (tagGen TagOracle.sk{2} (GameBLT.t{2}) = GameBLT.tg{2})
  => (GameBLT'.guess{2} = GameBLT.t{2} => res{1}) ].
proof.  conseq wwwForB. progress. smt. qed.

local lemma case3' &m : 
  Pr[ GameBLT'(BLTOracle, A).main() @ &m 
  : res 
  /\ tagGen TagOracle.sk GameBLT.t = GameBLT.tg
  /\ GameBLT.t < BLTOracle.qt 
  /\ GameBLT.t = GameBLT'.guess ] 
  <= Pr[ GameTHU(G(A)).main() @ &m : res ].
proof. byequiv (_ : ={glob A, glob BLTOracle} ==> _). symmetry. 
conseq wwwForB; smt. auto. auto. 
qed.


lemma case3_2 &m : Pr[ GameBLT(BLTOracle, A).main() @ &m 
  : res /\ GameBLT.t < BLTOracle.qt /\ tagGen TagOracle.sk GameBLT.t = GameBLT.tg ]
  <= (Pr[GameTHU(G(A)).main() @ &m : res ] * kpe%r).
proof. 
cut : (Pr[ GameBLT(BLTOracle, A).main() @ &m 
  : res /\  GameBLT.t < BLTOracle.qt /\ tagGen TagOracle.sk GameBLT.t = GameBLT.tg ] * (1%r/kpe%r))
  <= Pr[ GameTHU(G(A)).main() @ &m : res ].
rewrite - (zz4' &m). rewrite - (ccc &m). apply (case3' &m).

move =>  case3''.

cut :  forall (a b c : real), a <= b => 0%r <= c => a * c <= b * c. smt. 

pose x := Pr[ GameBLT(BLTOracle, A).main() @ &m 
 : res /\ GameBLT.t < BLTOracle.qt ].

pose y := Pr[ GameTHU(G(A)).main() @ &m : res ].

cut : 0%r < kpe%r. smt.
move => ik.
smt.
qed.


end section. 
