pragma Goals:printall.

require import AllCore.
require import BLT_Instance.
require export Case1 Case2 Case3_1 Case3_2 .


lemma prSplit &m (A <: AdvBLT{BLTOracle, Ts}) : 
    Pr[ GameBLT(BLTOracle, A).main() @ &m : res ]
  = Pr[ GameBLT(BLTOracle, A).main() @ &m : res /\ GameBLT.t < BLTOracle.qt /\ tagGen TagOracle.sk GameBLT.t = GameBLT.tg ] 
  + Pr[ GameBLT(BLTOracle, A).main() @ &m : res /\ GameBLT.t < BLTOracle.qt /\ tagGen TagOracle.sk GameBLT.t <> GameBLT.tg ] 
  + Pr[ GameBLT(BLTOracle, A).main() @ &m : res /\ GameBLT.t = BLTOracle.qt ]
  + Pr[ GameBLT(BLTOracle, A).main() @ &m : res /\ BLTOracle.qt < GameBLT.t ].
proof. rewrite Pr[mu_split (GameBLT.t < BLTOracle.qt)]. 

cut : Pr[ GameBLT(BLTOracle, A).main() @ &m : res /\ GameBLT.t < BLTOracle.qt ] 
    = Pr[ GameBLT(BLTOracle, A).main() @ &m : res /\ GameBLT.t < BLTOracle.qt /\ tagGen TagOracle.sk GameBLT.t = GameBLT.tg ] 
    + Pr[ GameBLT(BLTOracle, A).main() @ &m : res /\ GameBLT.t < BLTOracle.qt /\ tagGen TagOracle.sk GameBLT.t <> GameBLT.tg ].
rewrite Pr[mu_split (tagGen TagOracle.sk GameBLT.t = GameBLT.tg)]. smt. 

cut : Pr[GameBLT(BLTOracle, A).main() @ &m : res /\ ! GameBLT.t < BLTOracle.qt]
      = Pr[ GameBLT(BLTOracle, A).main() @ &m : res /\ (BLTOracle.qt <= GameBLT.t ) ].
rewrite Pr[mu_eq]. smt. done.


      
cut : Pr[ GameBLT(BLTOracle, A).main() @ &m : res /\ BLTOracle.qt <= GameBLT.t ]
    = Pr[ GameBLT(BLTOracle, A).main() @ &m : res /\ BLTOracle.qt <= GameBLT.t /\ BLTOracle.qt = GameBLT.t ]
    + Pr[ GameBLT(BLTOracle, A).main() @ &m : res /\ BLTOracle.qt <= GameBLT.t /\ BLTOracle.qt <> GameBLT.t ].
rewrite Pr[mu_split (BLTOracle.qt = GameBLT.t)]. smt. 

cut : Pr[GameBLT(BLTOracle, A).main() @ &m :
       res /\ BLTOracle.qt <= GameBLT.t /\ BLTOracle.qt <> GameBLT.t] = Pr[GameBLT(BLTOracle, A).main() @ &m :
       res /\ BLTOracle.qt < GameBLT.t].
rewrite Pr [mu_eq]. smt. done.

cut : Pr[GameBLT(BLTOracle, A).main() @ &m :
       res /\ BLTOracle.qt <= GameBLT.t /\ BLTOracle.qt = GameBLT.t] = Pr[GameBLT(BLTOracle, A).main() @ &m :
       res /\ BLTOracle.qt = GameBLT.t].
rewrite Pr [mu_eq]. smt. done.
   
move => h1 h2 h3 h4 h5. rewrite h5 h4 h3 h2 h1.
smt.
qed.



section.

declare module A : AdvBLT{BLTOracle, Ts, TagOracle, GameBLT}.

(* A is terminating if oracles are *)
axiom A_ll : forall (T <: TS{A}) (O <: BLTOracleT{A}), 
  islossless O.sign => islossless T.put => islossless T.check => islossless A(T,O).forge.


lemma sec &m :  
  Pr[ GameBLT(BLTOracle, A).main() @ &m : res ]
  <= Pr[ GameFR(TagOracle, D(A, Ts)).main() @ &m : res ]
  +  Pr[ HM.GameCR(H(A)).main() @ &m : res ]
  +  Pr[ GameTHU(G(A)).main() @ &m : res ] * kpe%r 
  +  Pr[ GamePF(TagOracle, F(A)).main() @ &m  : res ].
proof. rewrite (prSplit &m (A)).  

cut : Pr[GameBLT(BLTOracle, A).main() @ &m :
         res /\ GameBLT.t = BLTOracle.qt] 
      <= Pr[ HM.GameCR(H(A)).main() @ &m : res ]. 
apply (case2 A &m ). 
 
cut : Pr[GameBLT(BLTOracle, A).main() @ &m :
         res /\ BLTOracle.qt < GameBLT.t ]
      <= Pr[ GameFR(TagOracle, D(A, Ts)).main() @ &m : res ]. 
apply (case1 A &m).

cut : Pr[ GameBLT(BLTOracle, A).main() @ &m : res 
         /\ GameBLT.t < BLTOracle.qt 
         /\ tagGen TagOracle.sk GameBLT.t = GameBLT.tg ]
      <= (Pr[ GameTHU(G(A)).main() @ &m : res ] * kpe%r).
apply (case3_2 A A_ll &m).

cut : Pr[ GameBLT(BLTOracle, A).main() @ &m : res 
          /\ GameBLT.t < BLTOracle.qt 
          /\ tagGen TagOracle.sk GameBLT.t <> GameBLT.tg ]
     <= Pr[ GameBLT(BLTOracle, A).main() @ &m : res 
        /\ tagGen TagOracle.sk GameBLT.t <> GameBLT.tg ].
rewrite Pr [mu_sub]; auto.

cut : Pr [ GameBLT(BLTOracle, A).main() @ &m : res 
           /\ tagGen TagOracle.sk GameBLT.t <> GameBLT.tg ] 
      <= Pr [ GamePF(TagOracle, F(A)).main() @ &m  : res ].
apply (case3_1 A &m).

move => i1 i2 i3 i4. 

smt.
qed.
