require import Int Distr.

(* distribution of initial times for a timestampign service *)
op tdistr : int distr.

axiom tdistr_lossless : is_lossless tdistr.
axiom tdistr_pos t : t \in tdistr => 0 < t.

(* unbounded tag system *)
type pkey, skey, tag, message, hash_output.

op keyGen : (pkey * skey) distr.
op tagGen : skey -> int -> tag.
op tagVer : pkey -> int -> tag -> bool.

axiom tagCorrectU pk sk t : (pk, sk) \in keyGen => tagVer pk t (tagGen sk t) = true.  
axiom keyGen_lossless : is_lossless keyGen.

 
require BLT.

clone export BLT.BLT_Scheme_Theory as 
    BST with type pkey         <- pkey,
             type skey         <- skey,
             type tag          <- tag,
             type message      <- message,
             type hash_output  <- hash_output,
             type data         <- message * tag, (* Ts repository contains plain message-tag pairs *)
             op   bind         <- fun x, x,      (* binding is identity *) 
             op   keyGen       <- keyGen,
             op   tagGen       <- tagGen,
             op   tagVer       <- tagVer,
             op   tdistr       <- tdistr.
             
