pragma Goals:printall.

require import Int Real Distr SmtMap.
require import BLT_Instance.
require import Tags.

module D(A : AdvBLT, TsO : TS) (O:TagOracleT) = {
  module A = A(TsO, BLTOracle)

  proc forge(pk:pkey) = {
     var m : message;
     var tg : tag;
     var t : int;

     TsO.init();
     BLTOracle.used = false;
     (m, tg, t) = A.forge(pk);

     return (tg, t);
  }
}.


section. 

declare module A : AdvBLT{TagOracle, BLTOracle, Ts}.
              
local lemma c1 : 
  equiv [ GameBLT(BLTOracle, A).main ~ GameFR(TagOracle, D(A, Ts)).main : 
  ={glob A} ==> 
  BLTOracle.qt{1} < GameBLT.t{1} /\ res{1} => res{2} ]. 
proof. proc.
inline*. wp.
call (_: ={glob TagOracle, glob Ts}
  /\ (TagOracle.usedFlag{2} => BLTOracle.qt{1} = TagOracle.usedTime{2})
  /\ (TagOracle.usedFlag{2} => BLTOracle.qt{2} = TagOracle.usedTime{2})
  /\ (TagOracle.pk{2}, TagOracle.sk{2}) \in keyGen
  /\ (TagOracle.usedFlag{2} => BLTOracle.qt{2} = BLTOracle.qt{1})
  /\ BLTOracle.used{1} = TagOracle.usedFlag{2}
  /\ TagOracle.usedFlag{2} = BLTOracle.used{2}
  /\ BLTOracle.qt{1} = TagOracle.usedTime{1}).
proc. inline*. wp. skip. smt.
proc. inline*. wp. skip. smt.
proc. inline*. wp. skip. smt.
wp. swap {2} 6 -5. wp.
rnd. wp. rnd. wp. skip. progress. smt.
qed.


lemma case1 &m : 
  Pr[ GameBLT(BLTOracle, A).main() @ &m : 
  res /\ BLTOracle.qt < GameBLT.t ]
  <= Pr[ GameFR(TagOracle, D(A, Ts)).main() @ &m : res ].
proof. byequiv. conseq c1;smt. auto. trivial. 
qed.

end section.
