pragma Goals:printall.

require import Int FSet IntExtra Real SmtMap Distr.

require import BLT_Instance.


op filterH : (int -> (message * tag) -> bool)-> (int, (message * tag)) fmap -> int * (message * tag) =
 fun p m,  let x = pick (fdom (SmtMap.filter p m)) in (x, oget m.[x]).


module C(A:AdvBLT, T : TS, O:BLTOracleT) = {
   module A = A(Ts, O) 

   proc forge(pk:pkey) = {
      var z, t;
      A.forge(pk);
      (t,z) = filterH (fun (a:int) (b:message * tag) => tagVer pk a b.`2) Ts.r;
     
      return (z.`1, z.`2, t);
    }
}.


section. 
declare module A : AdvBLT{TagOracle, BLTOracle, Ts}.


axiom A_ll : forall (T <: TS{A}) (O <: BLTOracleT{A}), 
  islossless O.sign => islossless T.put => islossless T.check => islossless A(T,O).forge.


lemma filterHLemma (mp : (int, (message * tag)) fmap) t x (P : int -> message * tag -> bool) 
  :  mp.[t] = (Some x) /\ P t x => exists t' e,  filterH P mp = (t' , e) /\ P t' e /\  P t' e /\ mp.[t'] = Some e.
proof. move => z. 
cut : (SmtMap.filter P mp) <> empty. smt (@SmtMap).
simplify filterH.
cut : forall z t, (SmtMap.filter P mp).[t] = Some z => P t z. smt (@SmtMap).
pose fm := filter P mp.
move => h1 h2.
cut : (pick (fdom fm)) \in fm. smt (@SmtMap @FSet).
pose i := pick (fdom fm).
move => h3.
cut : exists z,  fm.[i] = Some z. smt (@SmtMap).
move => h4.
elim h4. move => z0 e.
exists i z0. 
progress;smt(@SmtMap).
qed.


local lemma wwwForB : 
  equiv [ GameBLT(BLTDummy, C(A)).main ~ GameBLT(BLTOracle, A).main
  : ={glob A} ==> res{2} /\ GameBLT.t{2} < BLTOracle.qt{2} => 
      (forall x, x < (BLTOracle.qt{2}) /\ Ts.i{2} < x => Ts.r.[x]{1} = Ts.r.[x]{2}) 
   /\ (forall x, x <= Ts.i{2} => x \notin Ts.r{2}) 
   /\ (Ts.r.[GameBLT.t]{2} = Some (GameBLT.m, GameBLT.tg){2})
   /\ res{1} ]. 
proof. proc. 
inline*. wp.

call (_: BLTOracle.used,   
       (0 < Ts.i{2})
  /\   (Ts.i{2} <= Ts.t{2}) /\ (forall x, x <= Ts.i{2} => x \notin Ts.r{2})
  /\  ={glob Ts} /\ BLTOracle.used{2} = TagOracle.usedFlag{2} 
  /\   (forall x, x <  BLTOracle.qt{2} => Ts.i{2} < x => (Ts.r.[x]{2} = Ts.r.[x]{1}))
  /\   (forall x, x <= Ts.t{2} => Ts.i{2} < x => x \in Ts.r{2})
  /\   (TagOracle.pk{2}, TagOracle.sk{2}) \in keyGen /\ (forall y, y \in Ts.r{1} => y <= Ts.t{1})
  ,
       (TagOracle.usedFlag = BLTOracle.used 
  /\   ((TagOracle.pk, TagOracle.sk) \in keyGen /\ BLTOracle.used 
       /\ TagOracle.usedFlag  => Ts.r.[BLTOracle.qt] = Some (oget BLTOracle.qs, tagGen TagOracle.sk BLTOracle.qt) 
                                 /\  BLTOracle.qt <= Ts.t)){2} 
  /\   (Ts.i{2} <= Ts.t{2}) /\ (forall x, x <= Ts.i{2} => x \notin Ts.r{2})
  /\   (forall x, x <  BLTOracle.qt{2} => Ts.i{2} < x => (Ts.r.[x]{2} = Ts.r.[x]{1}))
  /\   (forall x, x <= Ts.t{2} => Ts.i{2} < x => x \in Ts.r{2})
  /\   BLTOracle.used{2} 
  /\   BLTOracle.qt{2} <= Ts.t{2}
  /\   (TagOracle.pk{2}, TagOracle.sk{2}) \in keyGen  
  /\   (forall y, y \in Ts.r{1} => y <= Ts.t{1})). 
apply A_ll. 
proc. wp. if {2}. inline*. wp. skip.  progress;smt (@SmtMap).
wp. skip. smt.
move => _ z. proc. auto.
move => _.   proc. auto. 
if. inline*. wp. skip. smt.
wp. skip. smt.
proc. inline*. wp. skip.
progress;smt (@SmtMap). 
move => _ z. proc. inline*.
wp. skip. progress. timeout 20. smt(@SmtMap). smt.
move => _.  proc.  inline*. wp. skip.
progress;smt(@SmtMap). 
(* get *)
proc. inline*.
wp. skip. smt.
move => _ z. proc. inline*. wp. skip. smt.
move => _.  proc. inline*.  wp. skip. smt.
wp.
rnd. wp. rnd. skip. progress. smt. smt. smt. smt. smt. smt. smt.  case used_R. move => ur. smt.
smt. case used_R. move => ur. smt. smt.
qed.


local lemma gl : 
  equiv [ GameBLT(BLTDummy, C(A)).main ~ GameBLT(BLTOracle, A).main
  :  ={glob A} ==> res{2} /\ GameBLT.t{2} < BLTOracle.qt{2} => res{1} ]. 
proof. conseq wwwForB. progress. smt. qed.

local lemma bbbla : 
  equiv [ GameBLT(BLTDummy, C(A)).main ~ GameFR(TagOracle, N(C(A))).main
  : ={glob A} ==> res{1} => res{2} ].
proof. proc.    
inline*. wp.
call (_: ={glob TagOracle, glob Ts} 
     /\ (forall x, x \in Ts.r{1} => 0 < x) 
     /\ 0 <= Ts.i{1} 
     /\ Ts.i{1} <= Ts.t{1}).
proc. skip. smt.
proc. inline*. wp. skip. progress;smt.
proc. inline*. wp. skip. progress. 
wp. swap {2} 6 -5.
wp. rnd. wp. rnd. wp.  skip.
progress;smt.
qed.


lemma blt_dummy_tag_prb &m : 
  Pr[ GameBLT(BLTDummy, C(A)).main() @ &m : res ]
  <= Pr[ GameFR(TagOracle, N(C(A))).main() @ &m : res ].
proof. byequiv.  conseq bbbla;smt. auto. trivial. qed.


lemma case3 &m : 
 Pr[ GameBLT(BLTOracle, A).main() @ &m : res /\ GameBLT.t < BLTOracle.qt ] 
 <= Pr[ GameFR(TagOracle, N(C(A))).main() @ &m : res ]. 
proof. 

cut : Pr[ GameBLT(BLTOracle, A).main() @ &m : res /\ GameBLT.t < BLTOracle.qt ]  
   <= Pr[ GameBLT(BLTDummy, C(A)).main() @ &m : res ].
byequiv. symmetry. conseq wwwForB; smt. auto. auto. trivial.
smt (blt_dummy_tag_prb).
qed.

end section.

