pragma Goals:printall.

require import AllCore.
require import BLT_Instance Case1 Case2 Case3 .


lemma prSplit &m (A <: AdvBLT{BLTOracle, Ts}) : 
    Pr[ GameBLT(BLTOracle, A).main() @ &m : res ]
  = Pr[ GameBLT(BLTOracle, A).main() @ &m : res /\ GameBLT.t < BLTOracle.qt ] 
  + Pr[ GameBLT(BLTOracle, A).main() @ &m : res /\ GameBLT.t = BLTOracle.qt ]
  + Pr[ GameBLT(BLTOracle, A).main() @ &m : res /\ BLTOracle.qt < GameBLT.t ].
proof. rewrite Pr[mu_split (GameBLT.t < BLTOracle.qt)]. 

cut : Pr[GameBLT(BLTOracle, A).main() @ &m : res /\ ! GameBLT.t < BLTOracle.qt]
      = Pr[ GameBLT(BLTOracle, A).main() @ &m : res /\ (BLTOracle.qt <= GameBLT.t ) ].
rewrite Pr[mu_eq]. smt. done.

cut : Pr[ GameBLT(BLTOracle, A).main() @ &m : res /\ BLTOracle.qt <= GameBLT.t ]
    = Pr[ GameBLT(BLTOracle, A).main() @ &m : res /\ BLTOracle.qt <= GameBLT.t /\ BLTOracle.qt = GameBLT.t ]
    + Pr[ GameBLT(BLTOracle, A).main() @ &m : res /\ BLTOracle.qt <= GameBLT.t /\ !(BLTOracle.qt = GameBLT.t) ].
rewrite Pr[mu_split (BLTOracle.qt = GameBLT.t)].  smt. 

cut : Pr[GameBLT(BLTOracle, A).main() @ &m :
       res /\ BLTOracle.qt <= GameBLT.t /\ BLTOracle.qt <> GameBLT.t] = Pr[GameBLT(BLTOracle, A).main() @ &m :
       res /\ BLTOracle.qt < GameBLT.t].
rewrite Pr [mu_eq]. smt. done.

cut : Pr[GameBLT(BLTOracle, A).main() @ &m :
       res /\ BLTOracle.qt <= GameBLT.t /\ BLTOracle.qt = GameBLT.t] = Pr[GameBLT(BLTOracle, A).main() @ &m :
       res /\ BLTOracle.qt = GameBLT.t].
rewrite Pr [mu_eq]. smt. done.
   
move => h1 h2 h3 h4. rewrite h4 h3 h2 h1.
smt.
qed.



section.

declare module A : AdvBLT{BLTOracle, Ts, TagOracle}.

(* A is terminating if oracles are terminating *)
axiom A_ll : forall (T <: TS{A}) (O <: BLTOracleT{A}), 
  islossless O.sign => islossless T.put => islossless T.check => islossless A(T,O).forge.


lemma sec &m :  
  Pr[ GameBLT(BLTOracle, A).main() @ &m : res ]
  <= Pr[ GameFR(TagOracle, N(C(A))).main() @ &m : res ]
  +  Pr[ GameFR(TagOracle, D(A, Ts)).main() @ &m : res ].
proof. rewrite (prSplit &m (A)).  
cut : Pr[GameBLT(BLTOracle, A).main() @ &m :
   res /\ BLTOracle.qt < GameBLT.t ]
 <= Pr[ GameFR(TagOracle, D(A, Ts)).main() @ &m : res ]. 
apply (case1 A &m).
cut : Pr[GameBLT(BLTOracle, A).main() @ &m :
   res /\ GameBLT.t = BLTOracle.qt] = 0%r. 
apply (case2 A A_ll &m). 
cut : Pr[GameBLT(BLTOracle, A).main() @ &m :
         res /\ GameBLT.t < BLTOracle.qt ]
 <= Pr[ GameFR(TagOracle, N(C(A))).main() @ &m : res ].
apply (case3 A A_ll &m).
move => i1 i2 i3. rewrite i2. simplify. clear i2.
smt.
qed.

end section.
