 
require import Int Bool SmtMap Distr.

abstract theory Timestamping.

(* data and tdistr are parameters of this theory *)
type data.
op   tdistr : int distr.

type Time = int.

(* interface of timestamping services *)
module type TS = {
  proc * init()      : unit
  proc clock()       : Time
  proc put(d : data) : Time
  proc check(t : Time, d : data)  : bool
}.


(* simplest and "obviously" correct instance of TS *)
module Ts : TS = {

  var r : (Time, data) fmap  (* finite map of "timestamped" *)
  var i : Time               (* initial time *)
  var t : Time               (* current time *)
  
  proc init() = {
    i =$ tdistr;              (* initial time is sampled from tdistr *)
    t =  i;
    r =  empty<:Time, data>;   (* initially the map is empty *)
  }
  
  proc clock() = {
    return t;
  }  
  
  proc put(d : data) = {
     t = t + 1;
     r = r.[t <- d];
     return t;
  }
  
  proc check(t : Time, d : data) = {
    return r.[t] = Some d;
  }  

}.


(* Properties *)

(** Type of an adversary  **)

module type AdvTS(TsO : TS) = {
  proc main() : unit {TsO.check TsO.put}
}.

section.

declare module A : AdvTS {Ts}.

(**  Backdating Resistance  **) 
lemma immutableTs : forall i d, 
  hoare [ A(Ts).main : i <= Ts.t /\ Ts.r.[i] = d ==> i <= Ts.t /\ Ts.r.[i] = d ].
proof. move => i d. 
proc*. 
call (_:  i <= Ts.t /\ Ts.r.[i] = d).
proc. skip. auto.
proc. wp. skip. smt.
skip.  progress.
qed.

(** Soundness  **)
lemma soundTs : forall i d, 
  phoare [ Ts.put : arg = d /\ i = Ts.t ==> Ts.r.[i+1] = Some d ] = 1%r.
proof. move => i d. 
proc. 
wp. skip. smt.
qed.



(** Completeness  **)
lemma completeTs : forall a b f, 
  phoare [ Ts.check : arg = (a, b) /\ f = (Ts.r.[a] = Some b) ==> res = f ] = 1%r.
proof. move => i d f. 
proc. 
wp. skip. smt.
qed.


end section.

end Timestamping.
