

module Completeness where

open import Relation.Binary
open import Relation.Binary.PropositionalEquality hiding ([_] ; inspect)
open import Relation.Nullary.Core
open import Data.Product hiding (map)
open import Grammar
open import Data.Nat hiding (_<_ ; _*_) renaming (_≟_ to _?=_) 
open import Data.List
open import Data.Bool hiding (T)
open import TriplesStruct
open import Logic
open import ListProperties
open import ArithmeticProperties
open import Data.Empty
open import Power
open import ParseTree
open import ListMonad


sngl-rhs-rules-com :  ∀ {A t Rs} → (prf : (A ─> t) ∈ Rs) 
  → (A , prf) ∈ sngl-rhs-rules t Rs
sngl-rhs-rules-com {A} {t} {Rs}  prf 
   with list-monad-ht (A , prf)  (∈-lst Rs) 
        (λ { (p₁ , p₂) → sngl-help p₁ p₂ t }) 
        (A ─> t , prf) (∈-lst-complete (A ─> t) Rs prf)
... | p with (t =t t) 
sngl-rhs-rules-com prf | p₁ | yes refl = p₁ here
sngl-rhs-rules-com prf | p  | no ¬p    = ex-falso-quodlibet (¬p refl)


rhs-rules-com :  ∀ {A B C Rs} → (prf : (A ─> B ∙ C) ∈ Rs) 
  → (A , prf) ∈ rhs-rules B C Rs
rhs-rules-com {A} {B} {C} {Rs} prf 
   with list-monad-ht (A , prf) (∈-lst Rs) 
        (con-help B C) (A ─> B ∙ C , prf) 
        (∈-lst-complete (A ─> B ∙ C)  Rs prf) 
rhs-rules-com {A} {B} {C} {Rs} prf | p  with B =n B | C =n C  
rhs-rules-com {A} {B} {C} {Rs} prf | p₂ | yes refl | yes refl = p₂ here
rhs-rules-com {A} {B} {C} {Rs} prf | p₁ | yes p | no ¬p = ex-falso-quodlibet (¬p refl)
rhs-rules-com {A} {B} {C} {Rs} prf | p | no ¬p | dec2   = ex-falso-quodlibet (¬p refl)


asc-ls-comp : ∀ {k n} → (i : ℕ) → k < n → (i + k) ∈ (asc-ls i n) 
asc-ls-comp {n} {zero} i ()
asc-ls-comp {k} {(suc n)} i lss = 
  elth  k  0 (i + k) (asc-ls i (suc n)) 
        (subst (λ ind → k < ind) (sym (asc-ls-len i (suc n))) lss) 
        (asc-ls-el k (suc n) i lss) 


subs-comp : (t : T) → (ts : List T) → ∀ i → (sub : Substring1 t ts i) 
   → (t , sub) ∈ (subs i ts)
subs-comp t .(t ∷ xs) .0 (scon1 {xs}) = here
subs-comp t .(y ∷ xs) .(suc i) (scon2 {y} {xs} {i} sub) with subs-comp t xs i sub
... | IH with ∃-split (t , sub) (subs i xs) IH 
... | p1 , p2 , p3 rewrite p3 | subs-lft-thm {y} p1 ((t , sub) ∷ p2)  
  = ∈-weak-lft {_} {subs-lft p1} {(t , scon2 sub) ∷ subs-lft p2} {(t , scon2 sub)} here


-- _*_ is complete
*-complete :  ∀ {A B C i k j s} → (t1 : s [ i , k [◂ B)
 → (t2 : s [ k , j [◂ C)
 → (Q1 Q2 : Mtrx s)
 → (i , k , B , t1) ∈ Q1  
 → (k , j , C , t2) ∈ Q2  
 → (x : (A ─> B ∙ C) ∈ Rs )
 → (i , j , A , cons x t1 t2) ∈ (Q1 * Q2)
*-complete {A} {B} {C} {i} {k} {j} {s} t1 t2 Q1 Q2 in1 in2 rin 
  with list-monad-ht (i , j , A , cons rin t1 t2) Q2 
                     (λ {(_ , _ , _ , t₃) → t1 ** t₃ }) 
                     (k , j , C , t2) in2 
... | w with k ?= k 
*-complete {A} {B} {C} {i} {k} {j}  t1 t2 Q1 Q2 in1 in2 rin | w | yes refl 
   = list-monad-ht (i , j , A , cons rin t1 t2) Q1
                   (λ {(_ , _ , _ , t₁) → 
                   Q2 >>= λ {(_ , _ , _ , t₂) → t₁ ** t₂}})
                   (i , k , B , t1) in1 
                   (w (list-monad-ht  (i , j , A , cons rin t1 t2)  
                                      (rhs-rules B C Rs)  
                                      (λ { (rhs , prf) → [ _ , _ ,  _ , cons prf t1 t2 ] })
                                      (A , rin) (rhs-rules-com rin) here))
*-complete t1 t2 Q1 Q2 in1 in2 rin | w | no ¬p = ex-falso-quodlibet (¬p refl)




-- main completeness theorem
complete : ∀ {s} → (st : N) → (n i j  : ℕ) → (accn : Acc n) 
  → (t : s [ i , j [◂ st)
  → (j ≡ n + i) 
  → (_ , _ , _ , t) ∈ pow (m-init s) n accn
-- t = empt
complete  .Λ-NT zero .0 .0 (acc x) (empt x₁) prf with inspect Nullable?
complete  .Λ-NT zero .0 .0 (acc x) (empt x₁) prf | it true k rewrite uip x₁ k = here
complete  .Λ-NT zero .0 .0 (acc x) (empt x₁) prf | it false k = ex-falso-quodlibet (absurdum Nullable? x₁ k)
complete  .Λ-NT (suc n) .0 .0 accn (empt x) ()

-- t = sngl, basically proving that `m-init` is complete
complete  st zero i .(suc i) accn (sngl x x₁) ()
complete {s}  st (suc zero) i .(suc i) (acc y) (sngl x x₁) prf = 
   list-monad-ht (i , suc i , st , sngl x x₁) (asc-ls 0 (foldr (λ _ → suc) 0 s)) 
                 (λ pos → (subs pos s)        >>=  λ { (t , sub)     → 
                 (sngl-rhs-rules  t Rs)         >>=  λ { (rhs , prf)   → 
                 [ _ , _ , _ , sngl prf sub ] }}) i (asc-ls-comp 0 (subst-lemm x₁))
                 (list-monad-ht (i , suc i , st , sngl x x₁) (subs i s) (λ { (t , sub)  → 
                                (sngl-rhs-rules  t Rs)   >>=  λ { (rhs , prf)   → 
                                [ _ , _ , _ , sngl prf sub ] }}) (_ , x₁) (subs-comp _ s i x₁ )
                                (list-monad-ht (i , suc i , st , sngl x x₁)  (sngl-rhs-rules _ Rs) 
                                               (λ { (rhs , prf) → [ _ , _ , _ , sngl prf x₁ ] }) (st , x)
                                               (sngl-rhs-rules-com x) here))

-- t = sngl, sngl trees cannot appear in 2+i powers of m-init
complete st (suc (suc n)) i .(suc i) accn (sngl x x₁) prf 
 rewrite +-comm n i = ex-falso-quodlibet (∸-lemm10  prf) 

-- t = cons t₂ t₃,  cannot have a `cons t₂ t₃` tree 
-- with  t₂ : CYKTree s G .C 0 j  and t₃ : CYKTree s G .B i 0
complete {s} st n i j accn (cons {.i} {zero} x t₂ t₃) prf 
 with cyktree-lem1 t₂
complete {s} st n .0 j accn (cons {.0} {zero} x t₂ t₃) prf | refl 
 with cyktree-lem3 t₂ 
complete {s} st n ._ j accn (cons {._} {zero} x t₂ t₃) prf | refl | refl 
  = ex-falso-quodlibet (Λ-NT-Rule1 Rs x)

-- t = cons t₂ t₃, (t₂ : CYKTree s G .C 0 j) =(cyktree-lem2)=> ∃ p1 . j ≡ suc p1 + i
complete {s} st zero i .i accn (cons {.i} {suc l} x t₂ t₃) refl with cyktree-lem2 t₂
-- i ≡ 0 ∧ t₃ : CYKTree s G _ (suc p1) 0 => absurd
complete {s} st zero zero .zero accn (cons {.zero} {suc .(p1 + 0)} x t₂ t₃) refl | p1 , refl
 with cyktree-lem1 t₃ 
... | () 

-- t = cons t₂ t₃,  (t₃ : CYKTree s G .C (2 + p1 + i)) (1 + i)) => absurd
complete {s} st zero (suc i) .(suc i) accn (cons {.(suc i)} {suc .(p1 + suc i)} x t₂ t₃) refl | p1 , refl
 with cyktree-lem2 t₃ 
... | o1 , o2  
  rewrite +-comm (suc p1) (suc i) 
  | sym (+-assoc (suc o1) (suc i) (suc p1)) 
  | +-comm  o1 (suc i) 
  | +-assoc i o1 (suc p1) = ex-falso-quodlibet (∸-lemm10 o2)

-- t = cons t₂ t₃, suc n
complete {s} st (suc n) i j accn (cons {.i} {suc j₁} x t₂ t₃) prf 
  with cyktree-lem2 t₂  
  | cyktree-lem2 (subst (λ ind → (s [ (suc j₁) , ind [◂ _ )) prf t₃) 
-- cons in power 1 => absurd
complete {s} st (suc zero) i .(suc i) accn (cons {.i} {suc .(p1 + i)} x t t₃) refl | p1 , refl | q1 , q2 
  rewrite +-comm (suc p1) i 
  | sym (+-assoc q1 i (suc p1)) 
  | +-comm q1 i = ex-falso-quodlibet (∸-lemm11 {i} q2)

-- t = cons t₂ t₃, suc (suc n), main case, described in paper
complete {s} st (suc (suc n)) i j (acc y) (cons {.i} {suc .(p1 + i)} .{suc n} .{st} {B} {C} x t₂ t₃) prf 
  | p1 , refl | q1 , q2 
  with ∸-lemm9 {suc (suc n)} {i} {suc q1} {suc p1} q2 
complete {s} st (suc (suc n)) i j (acc y) (cons  {.i} {suc .(p1 + i)} .{suc n} .{st} {B} {C} x t₂ t₃) prf 
  | p1 , refl | q1 , q2 | arth4p 
  rewrite (trans prf q2) 
  with complete C (suc q1) _ _ 
                (y (suc q1) (<-lemm2 {p1}  arth4p)) t₃ refl -- inductive hyp 1
  |    complete B (suc p1) _ _ 
                (y (suc p1) (<-lemm3 {p1} arth4p)) t₂ refl   -- inductive hyp 2
complete {s} st (suc (suc n)) i j (acc y) (cons {.i} {suc .(p1 + i)} .{suc n} .{st} {B} {C} x t₂ t₃) prf 
  | p1 , refl | q1 , q2 | arth4p | IH-t2 | IH-t1 
  = list-monad-ht  (i , suc (q1 + suc (p1 + i)) , st , cons x t₂ t₃) 
                   (triples (suc n)) 
                   (λ { (l₁ , l₂ , l₃) →  
                      (pow (m-init s) (suc l₁) (y (suc l₁) (<-lemm3 {l₁} l₃)))   *
                      (pow (m-init s) (suc l₂) (y (suc l₂) (<-lemm2 {l₁} l₃)))})
                   (p1 , q1 , arth4p)  
                   (triples-complete p1 q1 (suc n) arth4p) 
                   (*-complete t₂ t₃ _ _ IH-t1 IH-t2 x)


