
module ListProperties where

open import Relation.Nullary
open import Relation.Binary
open import Relation.Nullary.Decidable hiding (map)
open import Data.List
open import Relation.Binary.PropositionalEquality as PropEq hiding ([_])
open import Data.Product hiding (map)
open import Data.Empty
open import Data.Nat hiding (_<_)
open import Logic
open import ArithmeticProperties
open import Data.Sum hiding (map)


++-assoc : {A : Set} → (a b c : List A) → a ++ b ++ c ≡ (a ++ b) ++ c
++-assoc [] b c = refl
++-assoc (x ∷ a) b c = cong (_∷_ x) (++-assoc a b c)

++-rgt-id : {X : Set}(xs : List X) →  xs ++ [] ≡ xs
++-rgt-id [] = refl
++-rgt-id (x ∷ xs) = cong (_∷_ x) (++-rgt-id xs )


data _∈_ {A : Set} : A → List A → Set where
  here  : ∀ {x}   {xs : List A} → x ∈ (x ∷ xs)
  there : ∀ {x y} {xs : List A} (x∈xs : x ∈ xs) → x ∈ (y ∷ xs)


∈-cong : {X Y : Set} → (x : X) → (xs : List X) → (f : X → Y) → x ∈ xs → f x ∈ map f xs
∈-cong x .(x ∷ xs) f (here {.x} {xs}) = here
∈-cong x .(y ∷ xs) f (there {.x} {y} {xs} xin) = there (∈-cong x xs f xin)

∈-weak-lft : {X : Set}{xs₁ xs₂ : List X}{x : X} → x ∈ xs₂ 
 → x ∈ (xs₁ ++ xs₂)
∈-weak-lft {X} {[]} xin = xin
∈-weak-lft {X} {x ∷ xs₁} xin = there (∈-weak-lft {_} {xs₁} xin)

∈-weak-rgt : {X : Set}{b c : List X}{a : X} → a ∈ c → a ∈ (c ++ b)
∈-weak-rgt here = here
∈-weak-rgt (there i) = there (∈-weak-rgt i)

∈-split : {X : Set} →  {xs₁ xs₂ : List X} → {x : X}
 →  x ∈ (xs₁ ++ xs₂) 
 → (x ∈ xs₁) ⊎ (x ∈ xs₂)
∈-split {X} {[]} xin = inj₂ xin
∈-split {X} {x ∷ xs₁}  here = inj₁ here
∈-split {X} {x ∷ xs₁}  (there xin) with ∈-split {X} {xs₁} xin 
∈-split {X} {x₂ ∷ xs₁} (there xin) | inj₁ x₁ = inj₁ (there x₁)
∈-split {X} {x₁ ∷ xs₁} (there xin) | inj₂ y = inj₂ y


∃-after-map : {X Y : Set} → (d : X) →  (xs : List X) → (f : X → Y)
 → d ∈ xs → (f d) ∈ (map f xs)
∃-after-map d .(d ∷ xs) f (here {.d} {xs}) = here 
∃-after-map d .(y ∷ xs) f (there {.d} {y} {xs} x∈xs) = there (∃-after-map d xs f x∈xs)

∃-split : {X : Set}(x : X)(xs : List X) →  x ∈ xs 
 → Σ[ zs ∈ List X ] Σ[ ds ∈ List X ] xs ≡ zs ++ (x ∷ ds)
∃-split x .(x ∷ xs) (here {.x} {xs}) = [] , xs , refl
∃-split x .(y ∷ xs) (there {.x} {y} {xs} x∈xs) with ∃-split x xs x∈xs 
∃-split x .(y ∷ xs) (there {.x} {y} {xs} x∈xs) | proj₁ , proj₁' , proj₂ 
 = y ∷ proj₁ , proj₁' , cong (_∷_ y) proj₂


∈-lst : {X : Set} → (xs : List X)  → List (Σ[ x ∈ X ] x ∈ xs )
∈-lst [] = []
∈-lst (x ∷ xs) 
 = (x , here) ∷ map (λ p → (proj₁ p , there (proj₂ p))) (∈-lst xs)

∈-lst-complete : ∀ {X} → (x : X) → (xs : List X) → (prf : (x ∈ xs)) → (x , prf) ∈ (∈-lst xs)
∈-lst-complete x [] ()
∈-lst-complete .x₁ (x₁ ∷ xs) here = here
∈-lst-complete x (x₁ ∷ xs)  (there prf) 
 = there (∈-cong (x , prf) 
         (∈-lst xs) 
         (λ {(p₁ , p₂) → (p₁ , there p₂)}) 
         (∈-lst-complete x xs prf))



foldl-unf : {A B : Set} → (ys : List B) → (l : List A) 
  → (f : A → List B)
  → foldl (λ res el → res ++ f el) ys l ≡ 
      ys ++ foldl (λ res el → res ++ f el  ) [] l
foldl-unf ys [] f =  sym (++-rgt-id _)
foldl-unf ys (x ∷ l) f rewrite 
 foldl-unf (ys ++ f x)  l f 
 | foldl-unf (f x) l f 
 = sym (++-assoc ys (f x) (foldl (λ res el → res ++ f el) [] l)) 


-- returning element from the list (with default value)
el : ∀ {X : Set} →  (i : ℕ) → (def : X) → List X → X
el n default [] = default
el zero d (x ∷ xs) = x
el (suc n) d (x ∷ xs) = el n d xs


elth : ∀ {X : Set} → (i : ℕ) → (d e : X) → (ls : List X) 
 → i < length ls → el i d ls ≡ e → e ∈ ls
elth i d e [] () prf
elth zero d e (.e ∷ ls) lss refl = here
elth (suc i) d e (x ∷ ls) lss prf = there (elth i d e ls (<-cong2 lss) prf)
