{-# OPTIONS --type-in-type #-}

module Logic where
open import Data.Empty
open import Relation.Binary.PropositionalEquality as PropEq hiding ([_] ; inspect)
open import Data.Nat hiding (_<_)
open import ArithmeticProperties
open import Data.Bool


ex-falso-quodlibet : {p : Set} → (x : ⊥) → p
ex-falso-quodlibet ()

absurdum : ∀ a → a ≡ true → a ≡ false → ⊥
absurdum .true refl ()

uip : {X : Set} → {a b : X} → (eq1 : a ≡ b) → (eq2 : a ≡ b) → eq1 ≡ eq2
uip refl refl = refl

data Inspect {A : Set}(x : A) : Set where
  it : (y : A) → x ≡ y → Inspect x

inspect : {A : Set}(x : A) → Inspect x
inspect x = it x refl


data Acc (x : ℕ) : Set₁ where
  acc : (∀ y → y < x → Acc y) → Acc x


Well-founded : Set
Well-founded = ∀ x → Acc x


mutual 
 aux : ∀ x y → y < x → Acc  y
 aux .(suc y) y <-base = <-ℕ-wf y
 aux .(suc x) y (<-step {x} y<x) = aux x y y<x

 <-ℕ-wf : ∀ x → Acc x
 <-ℕ-wf x = acc (aux x)
