
module MemPower where

open import Relation.Binary.PropositionalEquality hiding ([_] ; inspect)
open import Relation.Nullary.Core
open import Data.Nat hiding (_<_ ; _*_) 
open import Data.List
open import Data.Bool hiding (_≟_ ; T)
open import Data.Product hiding (map)
open import Data.Empty
open import Data.Maybe

open import Power
open import TriplesStruct
open import ArithmeticProperties
open import ListProperties
open import Logic
open import Grammar
open import ParseTree
open import ListProperties
open import ListMonad


-- type synonym for memo table entry 
MemTblEntry : ∀ {s} → Mtrx s → ℕ → Set
MemTblEntry {s} t p = Maybe (Σ[ mt ∈ Mtrx s ] mt ≡ pow t p (<-ℕ-wf p))


-- type synonym for memo table
MemTbl : ∀ {s} → Mtrx s → Set
MemTbl {s} t = (p : ℕ) → MemTblEntry t p


-- memo table update
memTbl-upd : ∀ {s} → (t : Mtrx s) → MemTbl t → (p : ℕ) 
  → MemTblEntry t p
  → MemTbl t
memTbl-upd t tbl i₁ ent i₂ with i₁ ≟ i₂ 
memTbl-upd t tbl .i₂ ent i₂ | yes refl = ent
memTbl-upd t tbl i₁ ent i₂ | no ¬p = tbl i₂


-- memoized version of `pow` function (does not constructa MemTbl, just uses it)
pow-mem : ∀ {s} → (t : Mtrx s) → (n : ℕ) → MemTbl t → Mtrx s
pow-mem t zero f with inspect Nullable? 
pow-mem t zero f | it true prf = [ _ , _ , _ , empt prf ]
pow-mem t zero f | it false prf = []
pow-mem t (suc zero)  f = t
pow-mem t (suc n)  f =  (triples n) >>= λ { (l₁ , l₂ , _) →  
      (maybe proj₁ (pow t (suc l₁) (<-ℕ-wf (suc l₁))) (f (suc l₁))) *
      (maybe proj₁ (pow t (suc l₂) (<-ℕ-wf (suc l₂))) (f (suc l₂))) }


-- showing that accessability argument is irrelevant for the result
pow≡mem-sub-accn : ∀ {s} → (t : Mtrx s) → (n : ℕ) → (f : MemTbl t) 
 → (accn1 accn2 : Acc n) 
 → (trpls : List (Σ[ i ∈ ℕ ] Σ[ j ∈ ℕ ] (suc i) + (suc j) ≡ n))   
 → pow-par t n accn1 trpls ≡ pow-par t n accn2 trpls
pow≡mem-sub-accn t zero f accn1 accn2 trpls = refl
pow≡mem-sub-accn t (suc zero) f accn1 accn2 trpls = refl
pow≡mem-sub-accn t (suc (suc n)) f (acc x) (acc x₁) [] = refl
pow≡mem-sub-accn t (suc (suc n)) f (acc x) (acc x₁) ((t1 , t2 , t3) ∷ trpls) 
  with pow≡mem-sub-accn t (suc (suc n)) f (acc x) (acc x₁) trpls  
  | pow≡mem-sub-accn t ((suc t1)) f (x ( (suc t1)) (<-lemm3 t3)) (x₁ (suc t1) (<-lemm3 t3)) (triples t1)
  | pow≡mem-sub-accn t (suc t2) f (x (suc t2) (<-lemm2 {t1} t3)) (x₁ (suc t2) (<-lemm2 {t1} t3)) (triples t2)
  | >>=split [ (t1 , t2 , t3) ] trpls
    (λ {(l₁ , l₂ , l₃) →  
     (pow t (suc l₁) (x (suc l₁) (<-lemm3 {l₁} l₃))) *
     (pow t (suc l₂) (x (suc l₂) (<-lemm2 {l₁}  l₃)))})
  | >>=split [ (t1 , t2 , t3) ] trpls
  (λ {(l₁ , l₂ , l₃) →  
   (pow t (suc l₁) (x₁ (suc l₁) (<-lemm3 {l₁} l₃))) *
   (pow t (suc l₂) (x₁ (suc l₂) (<-lemm2 {l₁}  l₃))) })
... | d1 | d2 | d3 | d4 | d5 rewrite d5 | d4 | d1 | d2 | d3 = refl


-- Acc n is irrelevant for `pow`
pow≡pow-mem-sub-accn : ∀ {s} → (t : Mtrx s) → (n : ℕ) → (f : MemTbl t) 
   → (accn1 accn2 : Acc n)
   → pow t n accn1 ≡ pow t n accn2 
pow≡pow-mem-sub-accn t zero f accn1 accn2 = refl
pow≡pow-mem-sub-accn t (suc zero) f accn1 accn2 = refl
pow≡pow-mem-sub-accn t (suc (suc n)) f (acc x) (acc x₁) 
   = pow≡mem-sub-accn t (suc (suc n)) f (acc x) (acc x₁) (triples (suc n))


-- parsing with MemTbl is correct
pow≡pow-mem-sub : ∀ {s} → (t : Mtrx s) → (n : ℕ) → (f : MemTbl t)
  → (y : (m : ℕ) → m < suc n → Acc m) → ∀ l
  →  (maybe proj₁ (pow t (suc (projTI l)) (<-ℕ-wf (suc (proj₁ l))) ) (f (suc (projTI l)))) *
      (maybe proj₁ (pow t (suc (projTJ l)) (<-ℕ-wf (suc (proj₁ (proj₂ l))))) (f (suc (projTJ l))))
      ≡ 
      (pow t (suc (projTI l)) (y (suc (projTI l)) (<-lemm3 {projTI l} (projTP l))))   *
      (pow t (suc (projTJ l)) (y (suc (projTJ l)) (<-lemm2 {projTI l}  (projTP l))))
pow≡pow-mem-sub t n f y l with (f (suc (projTI l))) | (f (suc (projTJ l)))
pow≡pow-mem-sub t n f y (l1 , l2 , l3) | just (p , pr) | just (x , xp) 
 rewrite pr | xp
 | pow≡pow-mem-sub-accn t (suc l1) f (acc (aux (suc l1))) (y (suc l1) (<-lemm3 l3)) 
 | pow≡pow-mem-sub-accn t (suc l2) f (acc (aux (suc l2))) (y (suc l2) (<-lemm2 {l1} l3)) = refl
pow≡pow-mem-sub t n f y (l1 , l2 , l3) | just (p , pr) | nothing 
 rewrite pr 
 | pow≡pow-mem-sub-accn t (suc l1) f (acc (aux (suc l1))) (y (suc l1) (<-lemm3 l3))
 | pow≡pow-mem-sub-accn t (suc l2) f (acc (aux (suc l2))) (y (suc l2) (<-lemm2 {l1} l3)) = refl
pow≡pow-mem-sub t n f y (l1 , l2 , l3) | nothing | just (x , xp)
 rewrite xp
 | pow≡pow-mem-sub-accn t (suc l1) f (acc (aux (suc l1))) (y (suc l1) (<-lemm3 l3))
 | pow≡pow-mem-sub-accn t (suc l2) f (acc (aux (suc l2))) (y (suc l2) (<-lemm2 {l1} l3)) = refl
pow≡pow-mem-sub t n f y (l1 , l2 , l3) | nothing | nothing 
  rewrite 
  pow≡pow-mem-sub-accn t (suc l1) f (acc (aux (suc l1))) (y (suc l1) (<-lemm3 l3))
  | pow≡pow-mem-sub-accn t (suc l2) f (acc (aux (suc l2))) (y (suc l2) (<-lemm2 {l1} l3)) = refl


-- memoized and non-memoized functions give the same results
pow≡pow-mem : ∀ {s} → (t : Mtrx s) → (n : ℕ) → (f : MemTbl t) → (accn : Acc n)
   → pow-mem t n f ≡ pow t n accn
pow≡pow-mem t zero f accn with inspect Nullable? 
... | it true  prf = refl
... | it false prf = refl
pow≡pow-mem t (suc zero) f accn = refl
pow≡pow-mem t (suc (suc n)) f (acc y) = >>=cong 
  (λ { (l₁ , l₂ , l₃) → 
    (maybe proj₁ (pow t (suc l₁) (<-ℕ-wf (suc l₁))) (f (suc l₁))) *
    (maybe proj₁ (pow t (suc l₂) (<-ℕ-wf (suc l₂))) (f (suc l₂)))})
  (λ { (l₁ , l₂ , l₃) →  
      (pow t (suc l₁) (y (suc l₁) (<-lemm3 {l₁} l₃))) *
      (pow t (suc l₂) (y (suc l₂) (<-lemm2 {l₁}  l₃)))})
  (triples (suc n))
  (pow≡pow-mem-sub t (suc n) f y)


-- iteratively fill memo table
pow-mem-itr :  ∀ {s} → (t : Mtrx s) → (n m : ℕ) → (f : MemTbl t) → Mtrx s
pow-mem-itr t n zero f = pow-mem t n f 
pow-mem-itr  t n (suc m) f with inspect (pow-mem t n f)
... | it [] y        = pow-mem-itr t (suc n) m (memTbl-upd t f n 
                        (just ([] , trans (sym y) (pow≡pow-mem t n f (acc (aux n))))))
... | it (x ∷ xs) y  = pow-mem-itr t (suc n) m (memTbl-upd t f n 
                        (just (x ∷ xs , trans (sym y) (pow≡pow-mem t n f (acc (aux n))))))
