
module ParseTree where

open import Grammar
open import Relation.Binary
open import Relation.Binary.PropositionalEquality hiding ([_])
open import Relation.Nullary.Core
open import Data.Nat hiding (_<_)
open import Data.List renaming (_++_ to _+++_)
open import Data.Bool hiding (T ; _≟_)
open import Data.Product hiding (map)
open import Data.Empty
open import ListProperties
open import ListMonad
open import ArithmeticProperties
open import Logic


data Substring1 {X : Set} : X → List X → ℕ → Set where
  scon1 : ∀ {xs x}     → Substring1 x (x ∷ xs) 0 
  scon2 : ∀ {y xs i x} → Substring1 x xs i → Substring1 x (y ∷ xs) (suc i) 



postulate Rs : Rules

data _[_,_[◂_    (s : List T) : ℕ → ℕ → N → Set where
  empt :  Nullable? ≡ true 
          → s [ 0 , 0 [◂ Λ-NT
  sngl : ∀{i A t} 
         → (A ─> t) ∈ Rs
         → Substring1 t s i 
         → s [ i , (1 + i) [◂ A
  cons : ∀{i j n A B C}
         → (A ─> B ∙ C) ∈ Rs
         → s [ i , j [◂ B
         → s [ j , n [◂ C
         → s [ i , n [◂ A


-- some tree structure properties
cyktree-lem1 : ∀ {s st i} → s [ i , 0 [◂ st → i ≡ 0
cyktree-lem1  {xs} .{Λ-NT} .{0} (empt x) = refl
cyktree-lem1   (cons x y' y0 ) 
 rewrite cyktree-lem1  y0 = cyktree-lem1 y'  


cyktree-lem2 : ∀ {s st i j} → s [ i , (suc j) [◂ st 
  → Σ[ n ∈ ℕ ] (suc j) ≡ (suc n + i)
cyktree-lem2 {s} {st} .{j} {j} (sngl x x₁) = 0 , refl
cyktree-lem2 {s} {st} {i} {j} (cons  .{i} {zero} .{suc j} .{st} {st₁} {st₂}  y y' y0) 
    with cyktree-lem1 y' 
... | d rewrite d = j , sym (+-comm (suc j) 0)
cyktree-lem2 {s} {st} {i} {j} (cons  .{i} {suc k} .{suc j} .{st} {st₁} {st₂}  y y' y0) 
    with cyktree-lem2 {s} {st₁} {i} {k} y' | cyktree-lem2  y0
... | d1 , d2 | f1 , f2  rewrite f2 | d2  = d1 + suc f1 ,  trans (cong suc (sym (+-assoc f1 (suc d1) i))) 
        (cong suc (subst (λ ind → ind + i ≡ d1 + suc f1 + i) (sym (+-comm f1 (suc d1))) 
          (subst (λ ind → suc (d1 + f1 + i) ≡ ind + i) (+-comm (suc f1) d1) 
            (cong suc (subst (λ ind → ind + i ≡ f1 + d1 + i) (+-comm f1 d1) refl)))))


cyktree-lem3 : ∀ {xs A}
 → xs [ 0 , 0 [◂ A → A ≡ Λ-NT
cyktree-lem3 {xs} .{Λ-NT} (empt x) = refl
cyktree-lem3 {xs} {A} (cons x t t₁) with cyktree-lem1 t₁ 
cyktree-lem3 {xs} {A} (cons x t t₁) | refl with cyktree-lem3 t 
cyktree-lem3 {xs} {A} (cons x t t₁) | refl | refl 
  = ex-falso-quodlibet (Λ-NT-Rule1 {A} Rs x)



-- generating the list of all substrings
subs-lft : ∀ {X x ts i} → List (Σ[ t ∈ X ] Substring1 t ts i) 
  → List (Σ[ t ∈ X ] Substring1 t (x ∷ ts) (suc i))
subs-lft [] = []
subs-lft ((proj₁ , proj₂) ∷ l) = (proj₁ , scon2 proj₂) ∷ subs-lft l

subs-lft-thm : ∀ {x ts i} → (ls1 ls2 : List (Σ[ t ∈ T ] Substring1 t ts i))
  → subs-lft {_} {x} {ts} {i} (ls1 +++ ls2) ≡ subs-lft ls1 +++ subs-lft ls2
subs-lft-thm [] ls2 = refl
subs-lft-thm (x₁ ∷ ls1) ls2 = cong (_∷_ _) (subs-lft-thm ls1 ls2)


subs : {X : Set} → (i : ℕ) → (ts : List X) → List (Σ[ t ∈ X ] Substring1 t ts i)
subs zero [] = []
subs zero (x ∷ ts) = [ x , scon1 ]
subs (suc i) [] = []
subs (suc i) (x ∷ ts) = subs-lft (subs i ts)

subst-lemm :  ∀ {X : Set} →  {t : X} → ∀ {ts i} → Substring1 t ts i → i < (length ts)
subst-lemm {_} {t} .{(t ∷ xs)} .{0} (scon1 {xs}) = <-0suc (length xs)
subst-lemm {_} {t} .{(y ∷ xs)} .{(suc i)} (scon2 {y} {xs} {i} subs) = <-cong1 (subst-lemm subs)
