{-# OPTIONS --type-in-type #-}

module Power where

open import Relation.Binary
open import Relation.Binary.PropositionalEquality hiding ([_] ; inspect)
open import Relation.Nullary.Core
open import Data.Nat hiding (_<_;  _*_) 
open import Data.List renaming (_++_ to _+++_)
open import Function
open import Data.Bool hiding (_≟_ ; T)
open import Data.Product hiding (map)


open import ArithmeticProperties
open import ListProperties
open import Logic
open import Grammar
open import ParseTree
open import TriplesStruct
open import ListMonad


-- COO matrix representation
MtrxEl : List T → Set
MtrxEl s = Σ[ i ∈ ℕ ] Σ[ j ∈ ℕ ] Σ[ B ∈ N ] s [ i , j [◂ B 

Mtrx : List T → Set
Mtrx s = List (MtrxEl s)


-- matrix multiplication
_**_ : ∀ {i k l m s B C} → s [ i , k [◂ B → s [ l , m [◂ C → Mtrx s
_**_ {i} {k} {l} {m} {s} {B} {C} t1 t2 with k ≟ l 
_**_  {i} {k} .{k} {m} {s} {B} {C} t1 t2 | yes refl 
  = (rhs-rules B C Rs)          >>= λ { (rhs , prf) → 
    [ _ , _ ,  _ , cons prf t1 t2 ] }
... | no p = [] 


_*_ : ∀ {s} → Mtrx s → Mtrx s → Mtrx s
_*_ {s} xs ys = xs     >>= λ { (_ , _ , _ , t₁) → 
                    ys     >>= λ { (_ , _ , _ , t₂) → 
                    t₁ ** t₂ }}


-- non-memoized version of powering (parametrized start)
pow-par : ∀ {s} → Mtrx s → (n : ℕ) → Acc n 
  → List (Σ[ i ∈ ℕ ] Σ[ j ∈ ℕ ] (suc i) + (suc j) ≡ n)
  → Mtrx s
pow-par m zero accn trpls with inspect Nullable? 
pow-par m zero accn trpls | it true prf = [ _ , _ , _ , empt prf ]
pow-par m zero accn trpls | it false prf = []
pow-par m (suc zero) accn trpls  = m
pow-par m (suc n) (acc acf) trpls = trpls   >>=  λ { (l₁ , l₂ , l₃) →  
  (pow-par m (suc l₁) (acf (suc l₁) (<-lemm3 {l₁} l₃)) (triples l₁) )  *
  (pow-par m (suc l₂) (acf (suc l₂) (<-lemm2 {l₁}  l₃))  (triples l₂)) }


pow : ∀ {s} → Mtrx s → (n : ℕ) → Acc n → Mtrx s
pow m zero accn with inspect Nullable? 
pow m zero accn | it true prf = [ _ , _ , _ , empt prf ]
pow m zero accn | it false prf = []
pow m (suc n) accn = pow-par m (suc n) accn (triples n)


-- matrix initialization
m-init : (s : List T) → Mtrx s
m-init s =     [0… (length s)]                   >>=  λ pos   → 
                 (subs pos s)                      >>=  λ { (t , sub)  → 
                 (sngl-rhs-rules  t Rs)             >>=  λ { (rhs , prf)   → 
                 [ _ , _ , _ , sngl prf sub ] }}
