
open import Relation.Nullary
open import Relation.Binary
open import Relation.Nullary.Decidable hiding (map)

module ListProperties where

open import Data.List
open import Relation.Binary.PropositionalEquality 
           as PropEq hiding ([_] ; inspect)
open import Data.Product hiding (map)
open import Data.Product hiding (map)
open import Data.Empty
open import Data.Nat
open import Data.Bool hiding (_∨_)

open import Logic
open import ListsAddition

-- ### the library of various properties for the List datatype


open import NatProperties

kkk' : {X : Set}(a b : List X) → length (a ++ b) ≡ (length a + length b)
kkk' [] b = refl
kkk' (x ∷ a) b = cong suc (kkk' a b)

kkk : {X : Set}(a b : X)(Rs p1 p2 : List X) → (a ∷ Rs) ≡ (p1 ++ (b ∷ p2))
      → (a ≡ b → ⊥) → length Rs ≡ length (p1 ++ p2)
kkk {X} a b Rs p1 p2 p ie rewrite kkk' p1 p2 
  with cong length p  | kkk' p1 (b ∷ p2)
kkk {X} a b Rs p1 p2 p ie | e | e2 
  rewrite e2 | +-com (length p1) (length (b ∷ p2)) 
  | +-com (length p2) (length p1)  = cong pred e


addsToNil : {X : Set}(a b : List X) →  a ++ b ≡ [] → b ≡ [] 
addsToNil [] [] p = refl
addsToNil [] (x ∷ b) ()
addsToNil (x ∷ a) b ()

addsToNilL : {X : Set}(a b : List X) →  a ++ b ≡ [] → a ≡ [] 
addsToNilL [] [] p = refl
addsToNilL [] (x ∷ b) ()
addsToNilL (x ∷ a) b ()


tailseq : {X : Set} → (a : X) → (xs ys : List X) 
                    → (a ∷ xs) ≡ (a ∷ ys) → xs ≡ ys
tailseq a .ys ys refl = refl

nequallists : {X : Set} →  (a b c : X) → (xs : List X) 
                                → (a ∷ b ∷ xs) ≢ (c ∷ xs)
nequallists a b c [] ()
nequallists a b c (x ∷ xs) ()

incSngl : {X : Set}{a b : X} → a ∈ (b ∷ []) → a ≡ b
incSngl base = refl
incSngl (step ())

snglt : {X : Set} → {A B : X} → A ∈ [ B ] → A ≡ B
snglt base = refl
snglt (step ())


incLem : {X : Set}{A : X}{a b : List X} → A ∈ (a ++ b) 
                                        → (A ∈ a) ∨ (A ∈ b)
incLem {X} {A} {[]} i = inr i
incLem {X} {.x} {x ∷ a} base = inl base
incLem {X} {A} {x ∷ a} (step i) 
   with incLem {X} {A} {a} i 
incLem {X} {A} {x₁ ∷ a} (step i) 
   | inl x = inl (step x)
incLem {X} {A} {x₁ ∷ a} (step i) 
   | inr x = inr x


foldlnest : {X Y : Set}(u : List Y)(v : List Y)(st : X)
  → (f : X → Y → X)
  → foldl f st (u ++ v)
    ≡ foldl f (foldl f st u) v
foldlnest [] v stm f = refl
foldlnest (x ∷ xs) v stm f = foldlnest xs v (f stm x) f


++-assoc : {X : Set}(a b c : List X) → a ++ b ++ c ≡ (a ++ b) ++ c
++-assoc [] b c = refl
++-assoc (x ∷ xs) b c = cong (_∷_ x) (++-assoc xs b c)


++-th : {X : Set}(xs : List X) →  xs ++ [] ≡ xs
++-th [] = refl
++-th (x ∷ xs) = cong (_∷_ x) (++-th xs )


ex1_comp' : {X Y : Set} → (d : X) →  (xs : List X) → (f : X → Y)
                                       → d ∈ xs → (f d) ∈ (map f xs)
ex1_comp' d .(d ∷ xs) f (base {.d} {xs}) = base 
ex1_comp' d .(y ∷ xs) f (step {.d} {y} {xs} x∈xs) 
  = step (ex1_comp' d xs f x∈xs)


exists-split : {X : Set}(x : X)(xs : List X) →  x ∈ xs 
        → Σ[ zs ∈ List X ] Σ[ ds ∈ List X ] xs ≡ zs ++ (x ∷ ds)
exists-split x .(x ∷ xs) (base {.x} {xs}) = [] , xs , refl
exists-split x .(y ∷ xs) (step {.x} {y} {xs} x∈xs) 
   with exists-split x xs x∈xs 
exists-split x .(y ∷ xs) (step {.x} {y} {xs} x∈xs) 
  | proj₁ , proj₁' , proj₂ = y ∷ proj₁ , proj₁' , cong (_∷_ y) proj₂


exists-vis : {X : Set} → (x : X) → (xs ys : List X) → x ∈ (xs ++ (x ∷ ys))
exists-vis x [] ys = base
exists-vis x (x' ∷ xs) ys = step (exists-vis x xs ys)


exists-mid : {X : Set}(x : X)(a b c : List X) → x ∈ b → x ∈ a ++ b ++ c
exists-mid x a .(x ∷ xs) c (base {.x} {xs}) = exists-vis x a (xs ++ c)
exists-mid x [] .(y ∷ x ∷ xs) c (step {.x} {y} (base {.x} {xs})) = step base
exists-mid x [] .(y ∷ y' ∷ xs) c (step {.x} {y} (step {.x} {y'} {xs} x∈xs))
   = step (step (exists-mid x [] xs c x∈xs))
exists-mid x (x' ∷ xs) .(y ∷ xs') c (step {.x} {y} {xs'} x∈xs) 
   = step (exists-mid x xs (y ∷ xs') c (step x∈xs))


exists-sngl : {X : Set} → (a b : X) → a ∈ [ b ] → a ≡ b
exists-sngl .b b base = refl
exists-sngl a b (step ())


exists-trio : (st : ℕ) (bigb1 n1 bigb2 bigb3 : List ℕ) → st ∈ n1
                            →  st ∈ ((bigb1 ++ (n1 ++ bigb2)) ++ bigb3)
exists-trio st b1 n1 b2 b3 p rewrite sym (++-assoc b1 (n1 ++ b2) b3) 
 | sym (++-assoc n1 b2 b3) = exists-mid st b1 n1 (b2 ++ b3) p

exists-duo : {X : Set}(x : X)(xs ys : List X) → x ∈ xs → x ∈ (ys ++ xs)
exists-duo x xs [] p = p
exists-duo x xs (x' ∷ xs') p = step (exists-duo x xs xs' p )



data Substring1 {X : Set} : X → List X → ℕ → Set where
  scon1 : ∀{xs x} → Substring1 x (x ∷ xs) 0 
  scon2 : ∀{y xs i x} → Substring1 x xs i  → Substring1 x (y ∷ xs) (suc i) 

find-el : {X : Set} → ℕ → (xs : List X) → List X
find-el zero [] = []
find-el zero (x ∷ xs) = [ x ]
find-el (suc n) [] = []
find-el (suc n) (x ∷ xs) = find-el n xs

find-el-sub : {X : Set}(xs : List X) → (m1 : X) → (i : ℕ) 
                      → m1 ∈ find-el i xs → Substring1 m1 xs i
find-el-sub [] m1 zero ()
find-el-sub [] m1 (suc n) ()
find-el-sub (x ∷ xs) m1 zero p rewrite exists-sngl m1 x p = scon1 
find-el-sub (x ∷ xs) m1 (suc n) p = scon2 (find-el-sub xs m1 n p)


foldth3 : {X : Set}(x : X)(xs ys : List X) → x ∈ xs ++ ys 
    → x ∉ ys → x ∈ xs
foldth3 x [] ys p1 p2 = ex-falso-quodlibet (p2 p1)
foldth3 .x' (x' ∷ xs) ys base p2 = base
foldth3 x (x' ∷ xs) ys (step x∈xs) p2 = step (foldth3 x xs ys x∈xs p2)


foldth2 : {X Y : Set}(xs : List X)(ys : List Y)(f : X → List Y) 
 → foldl (λ res el → f el ++ res) ys xs
    ≡ (foldl (λ res el → f el ++ res) [] xs) ++ ys
foldth2 [] ys f = refl
foldth2 (x ∷ xs) ys f rewrite ++-th (f x) 
    | foldth2 xs (f x) f 
    | foldth2 xs (f x ++ ys) f 
      with foldl (λ res el → f el ++ res) [] xs
... | d   = ++-assoc d (f x) ys


lemm1 : {Y : Set}{r : Y} → r ∉ []
lemm1 ()


lemm2 : ∀ {Y x xs}{r : Y} → r ∈ (x ∷ xs) → r ≢ x → r ∉ xs → ⊥
lemm2 base p2 p3 = p2 refl
lemm2 (step x∈xs) p2 p3 = p3 x∈xs


module DecExistance (Y : Set) (_≟_ : Decidable (_≡_ {A = Y})) where

 _∈?_ : Decidable {A = Y} {B = List Y}  _∈_
 r ∈? [] = no (λ h → lemm1 h)
 r ∈? (x ∷ xs) with r ≟ x 
 .x ∈? (x ∷ xs) | yes refl = yes base
 r ∈? (x ∷ xs) | no ¬p with r ∈? xs 
 r ∈? (x ∷ xs) | no ¬p | yes p = yes (step p)
 r ∈? (x ∷ xs) | no ¬p' | no ¬p = no (λ h → lemm2 h ¬p' ¬p)

 fold-scheme : {X : Set}(x : Y)(xs : List X)(f : X → List Y) → List Y
 fold-scheme x xs f = foldl (λ res el → f el ++ res) [] xs 

 foldlth : {X : Set}(x : Y)(xs : List X)(f : X → List Y) 
   → x ∈ foldl (λ res el → f el ++ res) [] xs 
   → Σ[ d ∈ X ] d ∈ xs × x ∈ f d
 foldlth x [] f ()
 foldlth x (x' ∷ xs) f p  with x ∈? (f x') 
 foldlth x (x' ∷ xs) f p' | yes p rewrite ++-th (f x') = x' , base , p
 foldlth x (x' ∷ xs) f p  | no ¬p rewrite ++-th (f x') | foldth2 xs (f x')  f
   with foldth3 x (foldl (λ res el → f el ++ res) [] xs) (f x') p ¬p 
 foldlth x (x' ∷ xs) f p  | no ¬p | d with foldlth x xs f d
 foldlth x (x' ∷ xs) f p  | no ¬p | d | (p1 , p2 , p3) = p1 , step p2 , p3



module DecListMinus (X : Set) (_≟_ : Decidable (_≡_ {A = X})) where

 _/_ : List X → X → List X
 [] / x = []
 (x ∷ xs) / x₁ with x ≟ x₁
 (x ∷ xs) / x₁ | yes p = xs / x₁
 (x ∷ xs) / x₁ | no ¬p = x ∷ xs / x₁


 complete/ : {x : X}(xs : List X) → x ∉ (xs / x)
 complete/ [] ()
 complete/ {x} (x₁ ∷ xs) i with x₁ ≟ x
 complete/ {x} (.x ∷ xs) i | yes refl = complete/ xs i
 complete/ (x₁ ∷ xs) base | no ¬p = ¬p refl
 complete/ (x₁ ∷ xs) (step i) | no ¬p = complete/ xs i

 sound/ : {x y : X}(xs : List X) → y ∈ xs → x ≢ y → y ∈ (xs / x)
 sound/ {x} {y} .(y ∷ as) (base {.y} {as}) ine with y ≟ x
 sound/ {x} {y} .(y ∷ as) (base {.y} {as}) ine | yes p with ine (sym p)
 sound/ {x} {y} .(y ∷ as) (base {.y} {as}) ine | yes p | ()
 sound/ {x} {y} .(y ∷ as) (base {.y} {as}) ine | no ¬p = base
 sound/ {x} {y} .(b ∷ as) (step {.y} {b} {as} i) ine with b ≟ x
 sound/ {x} {y} .(b ∷ as) (step {.y} {b} {as} i) ine | yes p = sound/ as i ine
 sound/ {x} {y} .(b ∷ as) (step {.y} {b} {as} i) ine | no ¬p 
    = step (sound/ as  i ine)

 no-suprises-/ : ∀ a x xs → a ∈ (xs / x) → a ∈ xs
 no-suprises-/ a x [] ein = ein
 no-suprises-/ a x (x₁ ∷ xs) ein with x₁ ≟ x 
 no-suprises-/ a x (x₁ ∷ xs) ein | yes p = step (no-suprises-/ a x xs ein)
 no-suprises-/ .x₁ x (x₁ ∷ xs) base | no ¬p = base
 no-suprises-/ a x (x₁ ∷ xs) (step ein) | no ¬p = step (no-suprises-/ a x xs ein)


inTwo : {X : Set}{a : X}{b c : List X} → a ∈ b → a ∈ c ++ b
inTwo {X} {a} {b} {[]} i = i
inTwo {X} {a} {b} {x ∷ c} i = step (inTwo {X} {a} {b} {c} i)

inFirst : {X : Set}{a : X}{c b : List X} → a ∈ c → a ∈ c ++ b
inFirst base = base
inFirst (step i) = step (inFirst i)


inmap2 : {X : Set} →  ∀ xs ys →  (y : X) → xs ∈ ys → (y ∷ xs) ∈ map (_∷_ y) ys
inmap2 xs .(xs ∷ as) y (base {.xs} {as}) = base
inmap2 xs .(b ∷ as) y (step {.xs} {b} {as} rin) = step (inmap2 xs as y rin)

subseqcombs : ∀ {X : Set}{F : X → Bool}(xs ys : List X) 
                               → SubSeq F xs ys → xs ∈ allSubSeq F ys
subseqcombs {X} {f} .[] .[] con1 = base
subseqcombs {X} {f} xs .(y ∷ ys) (con2 {.xs} {ys} {y} sub x) 
  rewrite x = inFirst {List X} {xs} {allSubSeq f ys} (subseqcombs xs ys sub)
subseqcombs {X} {f} .(y ∷ xs) .(y ∷ ys) (con3 {xs} {ys} {y} sub) 
 with f y 
subseqcombs {X} {f} .(y ∷ xs) .(y ∷ ys) (con3 {xs} {ys} {y} sub) 
 | true = inTwo {List X} {y ∷ xs} {_} {allSubSeq f ys} 
                         (inmap2 xs _ y (subseqcombs xs ys sub))
subseqcombs {X} {f} .(y ∷ xs) .(y ∷ ys) (con3 {xs} {ys} {y} sub) 
 | false = inmap2 xs _ y (subseqcombs xs ys sub) 


inmap : ∀ X xs ys y → xs ∈ map (_∷_ y) ys → Σ[ xs' ∈ List X ] xs ≡ y ∷ xs'
inmap X xs [] y ()
inmap X .(y ∷ ys) (ys ∷ ys₁) y base = ys , refl
inmap X xs (ys ∷ ys₁) y (step rin) = inmap X xs ys₁ y rin


inmap' :  {X : Set} → ∀  xs ys →  (y : X) 
                  → (y ∷ xs) ∈ map (_∷_ y) ys → xs ∈ ys
inmap' xs [] y ()
inmap' .ys (ys ∷ ys₁) y base = base
inmap' xs (ys ∷ ys₁) y (step rin) = step (inmap' xs ys₁ y rin)


subseqcombsInv : ∀ {X : Set}{F : X → Bool}(xs ys : List X) 
   → xs ∈ allSubSeq F ys → SubSeq F xs ys 
subseqcombsInv .[] [] base = con1
subseqcombsInv xs [] (step ())
subseqcombsInv {X} {F} xs (y ∷ ys) rin with inspect (F y)
subseqcombsInv {X} {F} xs (y ∷ ys) rin | it true p1 
    rewrite p1 with incLem {_} {xs} {foldr
       (λ x res →
          if F x then res ++ map (_∷_ x) res else map (_∷_ x) res)
       ([] ∷ []) ys} {map (_∷_ y)
       (foldr
        (λ x res →
           if F x then res ++ map (_∷_ x) res else map (_∷_ x) res)
        ([] ∷ []) ys)} rin
subseqcombsInv {X} {F} xs (y ∷ ys) rin | it true p1 | inl x 
  = con2 (subseqcombsInv {X} {F} xs ys x) p1
subseqcombsInv {X} {F} xs (y ∷ ys) rin | it true p1 | inr x 
    rewrite p1 with inmap _ xs  (foldr
       (λ x res → if F x then res ++ map (_∷_ x) res else map (_∷_ x) res)
       ([] ∷ []) ys) y x
... | d1 , d2 rewrite d2 = con3 (subseqcombsInv d1 ys (inmap' d1 (foldr
      (λ x res → if F x then res ++ map (_∷_ x) res else map (_∷_ x) res)
      ([] ∷ []) ys) y x))
subseqcombsInv {X} {F} xs (y ∷ ys) rin | it false p1 
   rewrite p1 with inmap _ xs (foldr
       (λ x res → if F x then res ++ map (_∷_ x) res else map (_∷_ x) res)
       ([] ∷ []) ys) y rin
... | d1 , d2 rewrite d2 = con3 (subseqcombsInv d1 ys (inmap' d1 (foldr
      (λ x res → if F x then res ++ map (_∷_ x) res else map (_∷_ x) res)
      ([] ∷ []) ys) y rin))


subseqlemm : {X : Set} → (f : X → Bool) → (x : X) 
                  → (xs : List X) → SubSeq f [ x ] xs → x ∈ xs
subseqlemm f x .(y ∷ ys) (con2 {.(x ∷ [])} {ys} {y} sub x₁) 
  = step (subseqlemm f x ys sub)
subseqlemm f x .(x ∷ ys) (con3 {.[]} {ys} sub) = base


foldInc' : {X Y : Set}(hs : List Y)(i2 : List X)(f : X → List Y) 
  → foldl (λ res r → (f r) ++ res) hs i2 ≡ 
       foldl (λ res r → (f r) ++ res) [] i2 ++ hs
foldInc' hs [] f = refl
foldInc' hs (x ∷ i2) f 
  rewrite foldInc' (f x ++ hs) i2 f 
  | foldInc' (f x ++ []) i2 f 
  | ++-th  (f x) = ++-assoc (foldl (λ res r → f r ++ res) [] i2) (f x) hs


foldIncG : {X Y : Set}(h1 : Y)(hs : List Y)(i2 : List X)(f : X → List Y) 
  → h1 ∈ hs 
  → h1 ∈ foldl (λ res r → (f r) ++ res) hs i2
foldIncG h1 hs i2 f rin 
  rewrite foldInc' hs i2 f 
  = inTwo {_} {h1} {_} {foldl (λ res r → (f r) ++ res) [] i2} rin


foldlLem : {X Y : Set}(a b : List X)(t : List Y)(f : List Y → X → List Y) 
  → foldl f t (a ++ b) ≡ foldl f (foldl f t a) b
foldlLem [] b t f = refl
foldlLem (x ∷ a) b t f = foldlLem a b (f t x) f


foldInc'' : {X : Set}{h1 : X}(a b : List X) →  h1 ∈ a ++ (h1 ∷ b)
foldInc'' [] b = base
foldInc'' (x ∷ a) b = step (foldInc'' a b) 


foldInc : {X Y : Set}(h1 : Y)(hs : List Y)(i2 : List X)(f : X → List Y) 
  →  h1 ∈ foldl (λ res r → (f r) ++ res) (h1 ∷ hs) i2
foldInc h1 hs i2 f rewrite foldInc' (h1 ∷ hs) i2 f 
  = foldInc'' (foldl (λ res r → f r ++ res) [] i2) hs


map-comp : {X Y : Set} → (f : X → Y) → (xs ys : List X) 
                      → map f (xs ++ ys) ≡ map f xs ++ map f ys
map-comp f [] ys = refl
map-comp f (x ∷ xs) ys = cong (_∷_ _) (map-comp f xs ys)

combs-id : {X : Set}(xs : List X) → (f : X → Bool) → xs ∈ allSubSeq f xs
combs-id [] f = base
combs-id (x ∷ xs) f with f x 
combs-id (x ∷ xs) f | true 
    with exists-split xs _ (combs-id xs f) 
... | o1 , o2 , o3 
    rewrite o3 | map-comp (_∷_ x) o1 (xs ∷ o2) 
    = inTwo {_}  {x ∷ xs} 
      {map (_∷_ x) o1 ++ (x ∷ xs) ∷ map (_∷_ x) o2} 
      {(o1 ++ xs ∷ o2)} 
      (inTwo {_} {x ∷ xs} {(x ∷ xs) ∷ map (_∷_ x) o2}  
             {map (_∷_ x) o1} base)
combs-id (x ∷ xs) f | false 
    with exists-split xs _ (combs-id xs f)  
... | o1 , o2 , o3 
    rewrite o3 | map-comp (_∷_ x) o1 (xs ∷ o2) 
    = inTwo {_} {x ∷ xs} {(x ∷ xs) ∷ map (_∷_ x) o2} {map (_∷_ x) o1} base


length-comp : {X : Set} → (xs ys : List X) 
   → length (xs ++ ys) ≡ length xs + length ys
length-comp [] ys = refl
length-comp (x ∷ xs) ys = cong suc (length-comp xs ys)


∉p1 : {X : Set} → (xs ys : List X) → (z : X)
   → z ∉ (ys ++ xs) → z ∉ xs 
∉p1 xs ys z pr zin = ex-falso-quodlibet (pr (inTwo {_} {z} {xs} {ys} zin))


∉p2 : {X : Set} → (xs ys : List X) → (z : X)
   → z ∉ (xs ++ ys) → z ∉ xs 
∉p2 xs ys z pr pr1 = ex-falso-quodlibet (pr (inFirst {_} {z} {xs} {ys} pr1))


∉p : {X : Set} → (xs ys : List X) → (z : X) 
   → z ∉ (xs ++ ys) → z ∉ xs × z ∉ ys
∉p xs ys z pin = ∉p2 xs ys z pin , ∉p1 ys xs z pin 


∈∉ : {X : Set} → (xs ys : List X) → (z : X) 
   → z ∈ (xs ++ ys) → z ∉ xs → z ∈ ys
∈∉ [] ys z p pin = p
∈∉ (x ∷ xs) ys .x base pin = ex-falso-quodlibet (pin base)
∈∉ (x ∷ xs) ys .a (step {a} p) pin = ∈∉ xs ys a p (λ axs → pin (step axs))


∉∈ : {X : Set} → (xs ys : List X) → (z : X) → z ∈ (xs ++ ys) 
   → z ∉ ys → z ∈ xs
∉∈ [] ys z pin pin2 = ex-falso-quodlibet (pin2 pin)
∉∈ (x ∷ xs) ys .x base pin2 = base
∉∈ (x ∷ xs) ys .a (step {a} pin) pin2 = step (∉∈ xs ys a pin pin2)


lss2 : {X : Set} → (n : ℕ) → (a c : List X) → (b d : X) 
   → n ≤ length (a ++ b ∷ c) 
   → n ≤ length (a ++ d ∷ c)
lss2 .0 [] c b d z≤n = z≤n
lss2 .(suc m) [] c b d (s≤s {m} prf) = s≤s prf
lss2 .0 (x ∷ l) c b d z≤n = z≤n
lss2 .(suc m) (x ∷ l) c b d (s≤s {m} prf) 
  = s≤s (lss2 m l c b d prf)


eq' : {X : Set}{x y : X}{xs ys : List X} → _≡_ {_} {List X} (x ∷ xs) (y ∷ ys) → x ≡ y
eq' refl = refl

liftDecEqToList : {X : Set} → Decidable (_≡_ {A = X}) → Decidable (_≡_ {A = List X})
liftDecEqToList d [] [] = yes refl
liftDecEqToList d [] (x ∷ l2) = no (λ { () })
liftDecEqToList d (x ∷ l1) [] = no (λ { () })
liftDecEqToList d (x ∷ l1) (x₁ ∷ l2) with d x x₁
liftDecEqToList d (.x₁ ∷ l1) (x₁ ∷ l2) | yes refl with liftDecEqToList d l1 l2 
liftDecEqToList d (.x₁ ∷ .l2) (x₁ ∷ l2) | yes refl | yes refl = yes refl
liftDecEqToList d (.x₁ ∷ l1) (x₁ ∷ l2) | yes refl | no ¬p = no (λ t → ¬p (cong (drop 1) t))
liftDecEqToList {X} d (x ∷ l1) (x₁ ∷ l2) | no ¬p = no (λ { t → ¬p (eq' t)} )



incLemm : {X : Set}{a : X} {b : List X} {c : X} {d : List X} →  a ∈ (b ++ c ∷ d) → a ∈ (c ∷ b ++ d)
incLemm {_} {a} {b} {c} {d} i with incLem {_} {a} {b} {c ∷ d} i
incLemm {_} {a} {b} {c} {d} i | inl x = step (inFirst {_} {a} x)
incLemm i | inr base = base
incLemm {_}  {a} {b} {c} {d} i | inr (step x) = step (inTwo {_} {a} {d} {b} x)


∈lem : {X : Set}{xs : List X}{a : X} →  a ∈ xs → Σ[ xs₁ ∈ List X ] Σ[ xs₂ ∈ List X ] xs ≡ xs₁ ++ [ a ] ++ xs₂
∈lem {_} .{(a ∷ as)} {a} (base {.a} {as}) = [] , as , refl
∈lem {_} .{(b ∷ as)} {a} (step {.a} {b} {as} n) with ∈lem {_} {as} {a} n 
... | k1 , k2 , k3 = b ∷ k1 , k2 , cong (_∷_ b) k3

lemm' : {X : Set} → {ys₁ zs₁ : List X} →
 ys₁ ++ zs₁ ≡ [] → ys₁ ≡ []
lemm' {X} {[]} i = refl
lemm' {X} {x ∷ ys₁} ()

lemm'' : {X : Set} → {ys₁ zs₁ : List X} →
 ys₁ ++ zs₁ ≡ [] → zs₁ ≡ []
lemm'' {X} {[]} i = i
lemm'' {X} {x ∷ ys₁} ()


lemmR'' : {X : Set} {a b : X} {xs : List X} → 
  a ∈ (b ∷ xs) → (a ≡ b → ⊥) → a ∈ xs
lemmR'' base p2 with p2 refl 
... | ()
lemmR'' (step p1) p2 = p1

helpp :  {X : Set} → (a b : List X) →  a ++ b ≡ [] → b ++ a ≡ []
helpp [] [] eq = refl
helpp [] (x₃ ∷ b) ()
helpp (x₃ ∷ a) b  ()






