
module ListsAddition where

open import Data.List hiding (filter)
open import Data.Bool hiding (_∨_)
open import Relation.Binary.PropositionalEquality hiding ([_])
open import Logic
open import Data.Empty

infix 5 _∈_
data _∈_ {X : Set} : X → List X  → Set where
  base : ∀ {a   as} → a ∈ a ∷ as
  step : ∀ {a b as} → a ∈ as → a ∈ b ∷ as


infix 5 _∉_
_∉_ : {X : Set} → X → List X → Set
_∉_ x xs = x ∈ xs → ⊥

data SubSeq {X : Set} (F : X → Bool) :  List X → List X → Set where
  con1 : SubSeq F [] []
  con2 : ∀ {xs ys y} → SubSeq F xs ys → F y ≡ true → SubSeq F xs (y ∷ ys)
  con3  : ∀ {xs ys y} → SubSeq F xs ys → SubSeq F (y ∷ xs) (y ∷ ys)


allSubSeq : {X : Set} → (f : X → Bool) → List X → List (List X)
allSubSeq f xs 
  = foldr (λ x res → if f x then res ++ (map (_∷_ x) res) else map (_∷_ x) res) [ [] ] xs
