


module Logic where

open import Data.Nat
open import Data.List
open import Data.Empty

open import Relation.Binary.PropositionalEquality 
            hiding ([_] ; inspect)



_≠_ : {X : Set} → (a b : X) → Set
_≠_ a b = a ≢ b 


ex-falso-quodlibet : {p : Set}(x : ⊥) → p
ex-falso-quodlibet ()


infix 3 _∨_ 
data _∨_  (A B : Set) : Set where
 inl : A → A ∨ B
 inr : B → A ∨ B


data Inspect {A : Set}(x : A) : Set where
  it : (y : A) → x ≡ y → Inspect x

inspect : {A : Set}(x : A) → Inspect x
inspect x = it x refl


Rel' : Set → Set₁
Rel' A = A → A → Set

module WF< where

  letn : (n : ℕ) → n < (suc n)
  letn zero = s≤s z≤n
  letn (suc n) = s≤s (letn n) 


  module WF {A : Set} (_<_ : Rel' A) where
    data Acc (x : A) : Set where
      acc : (∀ y → y < x → Acc y) → Acc x


    Well-founded : Set
    Well-founded = ∀ x → Acc x


  open WF _<_ public
  open import NatProperties

  <-ℕ-wf : WF.Well-founded _<_
  <-ℕ-wf x = acc (aux x)
     where
       aux : (x y : ℕ) → y < x → Acc y
       aux ._ .0 (s≤s {zero} p) = acc (λ { i () })
       aux .(suc n) .(suc m) (s≤s {suc m} {n} p) with <-ℕ-wf n 
       ... | (acc q) = acc (λ i ip → q i (trans≤ _ _ _ ip p))


  module Inverse-image-Well-founded { A B }
    (_<_ : Rel' B)(f : A → B) where
    _⊰_ : Rel' A
    x ⊰ y = f x < f y


    ii-acc : ∀ {x} → WF.Acc _<_ (f x) → WF.Acc _⊰_ x
    ii-acc (WF.acc g) = WF.acc (λ y fy<fx → ii-acc (g (f y) fy<fx))
    -- unwraps and then wraps it up again!


    ii-wf : WF.Well-founded _<_ → WF.Well-founded _⊰_
    ii-wf wf x = ii-acc (wf (f x))


  module <-on-length-Well-founded { A } where
    open Inverse-image-Well-founded { List A } _<_ length public
    wf : WF.Well-founded _⊰_
    wf = ii-wf <-ℕ-wf



open import Data.Bool hiding (_∨_ ; _≟_)

ab : ∀ {a b} → a ∧ b ≡ true → a ≡ true
ab {true} {true} p = refl
ab {false} {true} ()
ab {true} {false} ()
ab {false} {false} ()


bb' : ∀ {a b} → a ∧ b ≡ true → b ≡ true
bb' {a} {true} p = refl
bb' {true} {false} ()
bb' {false} {false} ()
