

open import Relation.Binary
open import Relation.Nullary.Core
open import Relation.Binary.PropositionalEquality 
            hiding ([_])
open import Data.List
open import ListsAddition


module NormCorrectness   
  (N T : Set)(_=n_ : Decidable (_≡_ {A = N}))(_=t_ : Decidable (_≡_ {A = T}))
  (newntlst : List N → N)  
  (newntlstlem : (ns : List N) → (newntlst ns) ∉ ns) where


open import Data.Product hiding (map)
open import Data.Nat hiding (_≟_)

open import Function

open import Logic

open import TopDownTree N T _=n_ _=t_
open import TopDownTreeProperties N T _=n_ _=t_
open import NormEpsRules N T _=n_ _=t_  
open import NormUnitRules N T _=n_ _=t_ 
open import NormInvariants N T _=n_ _=t_ newntlst newntlstlem 
open import NormLongRules N T _=n_ _=t_ newntlst newntlstlem
open import NormTermRules N T _=n_ _=t_ newntlst newntlstlem
open import NormFreshNonterminals N T _=n_ _=t_ newntlst newntlstlem


{- normalization function -}
norm : Rules → Rules
norm = norm-u ∘ norm-e ∘ norm-t ∘ norm-l


norm-progress : ∀ Rs A xs → A ⟶ xs ∈ (norm Rs) 
   → (Σ[ n1 ∈ N ] Σ[ n2 ∈ N ]  xs ≡ (nt n1 ∷ nt n2 ∷ [])) ∨ 
      (Σ[ t ∈ T ] xs ≡ [ tm t ])
norm-progress Rs A [] rin = 
  ex-falso-quodlibet (nur-eps-invariant (norm-e (norm-t (norm-l Rs))) 
             (λ A2 rin2 → ne-progress A2 (norm-t (norm-l Rs)) rin2) A 
             (filterSnglsRHS (norm-e (norm-t (norm-l Rs)))) rin)
norm-progress Rs A (tm x ∷ []) rin = (inr (x , refl))
norm-progress Rs A (tm x ∷ x₁ ∷ xs) rin with nur-term-invariant 
             (norm-e (norm-t (norm-l Rs)))  
             (λ A2 xs2 rin2 → ner-term-invariant (norm-t (norm-l Rs)) A2 xs2 
               (λ A3 xs3 rin3 → nt-progress (norm-l Rs) A3 xs3  rin3) rin2)  A 
             (filterSnglsRHS (norm-e (norm-t (norm-l Rs)))) (tm x ∷ x₁ ∷ xs) rin 
norm-progress Rs A (tm x ∷ x₁ ∷ xs) rin | inl (inl ())
norm-progress Rs A (tm x ∷ x₁ ∷ xs) rin | inl (inr (proj₁ , ()))
norm-progress Rs A (tm x ∷ x₁ ∷ xs) rin | inr () 
norm-progress Rs A (nt x ∷ []) rin 
  = ex-falso-quodlibet (nu-progress A x (norm-e (norm-t (norm-l Rs))) rin) 
norm-progress Rs A (nt x ∷ tm x₁ ∷ xs) rin with nur-term-invariant 
             (norm-e (norm-t (norm-l Rs)))  
             (λ A2 xs2 rin2 → ner-term-invariant (norm-t (norm-l Rs)) A2 xs2 
               (λ A3 xs3 rin3 → nt-progress (norm-l Rs) A3 xs3  rin3) rin2)  A 
             (filterSnglsRHS (norm-e (norm-t (norm-l Rs)))) (nt x ∷ tm x₁ ∷ xs) rin 
norm-progress Rs A (nt x ∷ tm x₁ ∷ xs) rin | inl (inl ())
norm-progress Rs A (nt x ∷ tm x₁ ∷ xs) rin | inl (inr (proj₁ , ()))
norm-progress Rs A (nt x ∷ tm x₁ ∷ xs) rin | inr ()
norm-progress Rs A (nt x ∷ nt x₁ ∷ []) rin = inl (x , x₁ , refl)
norm-progress Rs A (nt x ∷ nt x₁ ∷ x₂ ∷ xs) rin with nur-long-invariant 
              (norm-e (norm-t (norm-l Rs))) 
              (λ A2 xs2 rin2 → ner-long-invariant (norm-t (norm-l Rs)) A2 xs2 
                (λ A3 xs3 rin3 → nt-efct  (norm-l Rs) 
                  (λ A4 xs4 rin4 → nl-progress A4 xs4 Rs rin4) A3 xs3 
                    (ntr-length (norm-l Rs)) rin3 ) rin2)  A 
              (filterSnglsRHS (norm-e (norm-t (norm-l Rs)))) 
              (nt x ∷ nt x₁ ∷ x₂ ∷ xs) rin
norm-progress Rs A (nt x ∷ nt x₁ ∷ x₂ ∷ xs) rin | s≤s (s≤s ())


norm-snd : ∀ Rs A xs → Tree (norm Rs) A xs 
    → (nt A) ∈ filterAllSmbls Rs → Tree Rs A xs
norm-snd Rs A xs tree sin = nl-snd Rs A xs (nl-measure Rs)  
          (nt-snd (norm-l Rs) A xs  
              (ne-snd A (norm-t (norm-l Rs)) xs 
                   ((nu-snd 
                   (norm-e (norm-t (norm-l Rs)))
                   A xs tree)))
          (stepPreservesSymbols (nt A) Rs (nl-measure Rs) sin))
      sin


norm-cmplt : ∀ Rs A xs → Tree Rs A xs 
     → xs ≠ [] → Tree (norm Rs) A xs
norm-cmplt Rs A xs tree prop = nu-cmplt 
           (norm-e (norm-t (norm-l Rs))) A xs
                 (ne-cmplt A (norm-t (norm-l Rs)) xs 
                       (nt-cmplt (norm-l Rs) A xs 
                            (nl-cmplt Rs A xs (nl-measure Rs) tree))
                  prop)
