
open import Relation.Binary
open import Relation.Nullary.Core
open import Relation.Binary.PropositionalEquality 
            hiding ([_])
open import Data.List
open import ListsAddition


module NormEpsRules (N T : Set)(_=n_ : Decidable (_≡_ {A = N}))(_=t_ : Decidable (_≡_ {A = T})) where

open import Data.Empty
open import Data.Product hiding (map)
open import Data.List
open import Data.Bool hiding (_≟_ ; _∨_)
open import Data.Nat hiding (_≟_)


open import ListProperties 
open DecListMinus
open DecExistance renaming (_∈?_ to _∈??_) 

open import TopDownTree N T _=n_ _=t_
open import TopDownTreeProperties N T _=n_ _=t_
open import Nullable N T _=n_ _=t_
open import NullableUtility N T _=n_ _=t_
open import NullableSound N T _=n_ _=t_
            renaming (sound to null-sound)
open import NullableComplete N T _=n_ _=t_
            renaming (complete to null-complete)
 
norm-e-f : Rules → Rule → Rules
norm-e-f rs (N ⟶ ws)  
 = _/_ Rule _≟_ (
      foldl (λ res rhs → N ⟶ rhs ∷ res) [] 
            (allSubSeq (λ s → s lft∈? nullables rs) ws)) 
            (N ⟶ [])


norm-e : Rules → Rules
norm-e rs
  = foldl (λ res r → norm-e-f rs r ++ res) [] rs


filterNonEmpty : ∀ {Rs xs ys} → (ListOfTs Rs xs ys) → Symbols
filterNonEmpty {Rs} .{[]} .{[]} ⟦⟧ = []
filterNonEmpty {Rs} .{(tm t ∷ xs)} .{(tm t ∷ ys)} (_∷t_ {xs} {ys} t ls) 
  = (tm t) ∷ (filterNonEmpty ls)
filterNonEmpty {Rs} .{(nt n ∷ xs)} .{(ys)} (_∷n_ {xs} {ys} {n} {[]} x ls) 
  = filterNonEmpty ls
filterNonEmpty {Rs} .{(nt n ∷ xs)} .{(x ∷ zs ++ ys)} (_∷n_ {xs} {ys} {n} {x ∷ zs} x₁ ls) 
  = (nt n) ∷ filterNonEmpty ls 



filterLem : ∀ {Rs xs ys} → (lot : ListOfTs Rs xs ys) 
  → SubSeq ((λ s → s lft∈? nullables Rs)) (filterNonEmpty lot) xs
filterLem ⟦⟧ = con1
filterLem (t ∷t lot) = con3 (filterLem lot)
filterLem (_∷n_ {xs} {ys} {n} {[]} x lot) 
  = con2 (filterLem lot) (∈?Complete _ _ (nlbls-cmplt _ x))
filterLem (_∷n_ {xs} {ys} {n} {x ∷ zs} x₁ lot) 
  = con3 (filterLem lot)


filterLem2 : ∀ {Rs xs ys} → (lot : ListOfTs Rs xs ys) 
               → ys ≢ [] → filterNonEmpty lot ≢ []
filterLem2 ⟦⟧ p1 p2 = p1 refl
filterLem2 (t ∷t lot) p1 ()
filterLem2 (_∷n_ {xs} {ys} {n} {[]} x lot) p1 p2 
  rewrite ++-th ys = filterLem2 lot  p1 p2
filterLem2 (_∷n_ {xs} {ys} {n} {x ∷ zs} x₁ lot) p1 ()


completeLem : ∀ {A Rs xs ys}→ A ⟶ xs ∈ Rs
  → (lot : ListOfTs Rs xs ys) → ys ≢ [] 
  → A ⟶ (filterNonEmpty lot) ∈ norm-e Rs
completeLem {A} {Rs} {xs} {ys}  rin lot p with ∈lem rin
... | d1 , d2 , d3 rewrite d3 
    | foldlLem d1 (A ⟶ xs ∷ d2) [] 
                  (λ res r → norm-e-f (d1 ++ A ⟶ xs ∷ d2) r ++ res) 
    with subseqcombs _ _ (filterLem lot) 
... | q =  foldIncG (A ⟶ filterNonEmpty lot) ((Rule / _≟_)
       (foldl (λ res rhs → A ⟶ rhs ∷ res) []
        (foldr
         (λ x res →
            if
            x lft∈?
            nlbls (d1 ++ A ⟶ xs ∷ d2)
            (foldr (λ _ → suc) 0 (d1 ++ A ⟶ xs ∷ d2))
            then res ++ Data.List.map (_∷_ x) res else
            Data.List.map (_∷_ x) res)
         ([] ∷ []) xs))
       (A ⟶ [])
       ++ foldl (λ res r → norm-e-f (d1 ++ A ⟶ xs ∷ d2) r ++ res) [] d1) d2  
       (norm-e-f (d1 ++ A ⟶ xs ∷ d2)) 
       (inFirst {Rule} {A ⟶ filterNonEmpty lot} {(Rule / _≟_)
       (foldl (λ res rhs → A ⟶ rhs ∷ res) []
        (foldr
         (λ x res →
            if
            x lft∈?
            nlbls (d1 ++ A ⟶ xs ∷ d2)
            (foldr (λ _ → suc) 0 (d1 ++ A ⟶ xs ∷ d2))
            then res ++ Data.List.map (_∷_ x) res else
            Data.List.map (_∷_ x) res)
         ([] ∷ []) xs))
       (A ⟶ [])} {foldl (λ res r → norm-e-f (d1 ++ A ⟶ xs ∷ d2) r ++ res) [] d1} 
       (sound/ Rule _≟_ {A ⟶ []} {A ⟶ filterNonEmpty lot} 
   (foldl (λ res rhs → A ⟶ rhs ∷ res) []
  (foldr
    (λ x res →
    if
    x lft∈?
    nlbls (d1 ++ A ⟶ xs ∷ d2)
    (foldr (λ _ → suc) 0 (d1 ++ A ⟶ xs ∷ d2))
    then res ++ Data.List.map (_∷_ x) res else
    Data.List.map (_∷_ x) res)
 ([] ∷ []) xs)) 
   (norm-ε-f-lem {A} 
   {filterNonEmpty lot} 
   {((allSubSeq (λ s → s lft∈? nullables (d1 ++ A ⟶ xs ∷ d2)) xs))} 
   (subseqcombs (filterNonEmpty lot) xs (filterLem  lot))) 
   (λ eq → filterLem2 lot p (sym (lemmR' eq)))))


‌‌‌ 
mutual
 ne-cmplt :  ∀ A Rs xs → Tree Rs A xs → xs ≢ [] → Tree (norm-e Rs) A xs
 ne-cmplt A Rs [] (node x x₁) p with p refl
 ... | ()
 ne-cmplt A Rs (x ∷ xs) (node {[]} x₁ ()) p
 ne-cmplt A Rs (x ∷ xs) (node {x₁ ∷ xs₁} x₂ x₃) p 
   = node (completeLem x₂ x₃ p) (completeMut x₃)

 completeMut :  ∀ {Rs ws xs} → (lot : ListOfTs Rs ws xs) 
                → ListOfTs (norm-e Rs) (filterNonEmpty lot) xs
 completeMut ⟦⟧ = ⟦⟧
 completeMut (t ∷t lot) = _∷t_ t (completeMut lot)
 completeMut (_∷n_ {xs} {ys} {n} {[]} x lot) 
   rewrite ++-th ys = completeMut lot
 completeMut (_∷n_ {xs} {ys} {n} {x ∷ zs} x₁ lot) 
   = _∷n_ (ne-cmplt _ _ _ x₁ (λ { () })) (completeMut lot)


soundLem : ∀ A zs Rs → A ⟶ zs ∈ (norm-e Rs) 
         → Σ[ xs ∈ Symbols ] (A ⟶ xs) ∈ Rs × 
           SubSeq ((λ s → s lft∈? nullables Rs)) zs xs
soundLem A zs Rs rin 
  with foldlth Rule _≟_  (A ⟶ zs) Rs (norm-e-f Rs) rin
... | x ⟶ x₁ , d2 , d3 
  with soundLem' (A ⟶ zs) ((foldl (λ res rhs → x ⟶ rhs ∷ res) []
       (foldr
        (λ x₂ res →
           if x₂ lft∈? nlbls Rs (foldr (λ _ → suc) 0 Rs) then
           res ++ map (_∷_ x₂) res else Data.List.map (_∷_ x₂) res)
        ([] ∷ []) x₁))) (x ⟶ []) d3
... | z with soundLem'' A zs x ((allSubSeq (λ s → s lft∈? nullables Rs) x₁)) z 
... | q rewrite soundLem''' A zs x ((allSubSeq (λ s → s lft∈? nullables Rs) x₁)) z  
  = x₁ , d2 , subseqcombsInv  {_} {(λ s → s lft∈? nullables Rs)} zs x₁ q


mutual
 ne-snd :  ∀ A Rs xs → Tree (norm-e Rs) A xs → Tree Rs A xs
 ne-snd A Rs xs (node {zs} x x₁) with soundLem A zs Rs x
 ... | d1 , d2 , d3 with soundMut Rs zs d1 xs d3 x₁
 ... | f = node d2 f

 soundMut : ∀ Rs zs xs ws →
    SubSeq (λ s → s lft∈? nullables Rs) zs xs →
       ListOfTs (norm-e Rs) zs ws → ListOfTs Rs xs ws
 soundMut Rs .[] .[] .[] con1 ⟦⟧ = ⟦⟧
 soundMut Rs zs .(tm x ∷ ys) ws (con2 {.zs} {ys} {tm x} sub ()) lot
 soundMut Rs zs .(nt x ∷ ys) ws (con2 {.zs} {ys} {nt x} sub x₁) lot 
     with _∷n_ (nlbls-snd (length Rs) Rs (∈?Sound x _ x₁)) (soundMut Rs zs ys ws sub lot) 
 ... | d rewrite ++-th ws = d
 soundMut Rs .(tm x ∷ xs) .(tm x ∷ ys) .(tm x ∷ ys₁) (con3 {xs} {ys} {tm x} sub) (_∷t_ {.xs} {ys₁} .x lot) 
  = _∷t_ x (soundMut Rs xs ys ys₁ sub lot)
 soundMut Rs .(nt x ∷ xs) .(nt x ∷ ys) .(zs ++ ys₁) (con3 {xs} {ys} {nt x} sub) 
   (_∷n_ {.xs} {ys₁} {.x} {zs} x₁ lot)
  = _∷n_ (ne-snd x Rs zs x₁) (soundMut Rs xs ys ys₁ sub lot)


nulls-gen : ∀ Rs xs ys ds → SubSeq (λ s → s lft∈? nullables Rs) xs ys 
                                   → ListOfTs Rs xs ds → ListOfTs Rs ys ds 
nulls-gen Rs .[] .[] .[] con1 ⟦⟧ = ⟦⟧
nulls-gen Rs xs .(tm x ∷ ys) ds (con2 {.xs} {ys} {tm x} sub ()) lot 
nulls-gen Rs xs .(nt x ∷ ys) ds (con2 {.xs} {ys} {nt x} sub x₁) lot 
  = _∷n_ (nlbls-snd (length Rs) Rs (∈?Sound x _ x₁)) 
         (nulls-gen Rs xs ys ds sub lot)
nulls-gen Rs .(tm t ∷ xs) .(tm t ∷ ys) .(tm t ∷ ys₁) (con3 {xs} {ys} sub) 
  (_∷t_ {.xs} {ys₁} t lot) = _∷t_ t (nulls-gen Rs xs ys ys₁ sub lot)
nulls-gen Rs .(nt n ∷ xs) .(nt n ∷ ys) .(zs ++ ys₁) (con3 {xs} {ys} sub) 
  (_∷n_ {.xs} {ys₁} {n} {zs} x lot) = _∷n_ x (nulls-gen Rs xs ys ys₁ sub lot)


ne-progress :  ∀ A Rs → A ⟶ [] ∉ (norm-e Rs)
ne-progress  A Rs rin with foldlth Rule _≟_ {Rule} (A ⟶ []) Rs (norm-e-f Rs) rin
ne-progress A Rs rin | x ⟶ x₁ , d2 , d3 with soundLem''' A [] x ((foldr
        (λ x₂ res →
           if x₂ lft∈? nlbls Rs (foldr (λ _ → suc) 0 Rs) then
           res ++ Data.List.map (_∷_ x₂) res else Data.List.map (_∷_ x₂) res)
        ([] ∷ []) x₁)) (soundLem' (A ⟶ []) (foldl (λ res rhs → x ⟶ rhs ∷ res) []
       (foldr
        (λ x₂ res →
           if x₂ lft∈? nlbls Rs (foldr (λ _ → suc) 0 Rs) then
           res ++ map (_∷_ x₂) res else map (_∷_ x₂) res)
        ([] ∷ []) x₁)) (x ⟶ []) d3) 
... | d rewrite d 
  = complete/ Rule _≟_  {(x ⟶ [])} (foldl (λ res rhs → x ⟶ rhs ∷ res) []
       (foldr
        (λ x₂ res →
           if x₂ lft∈? nlbls Rs (foldr (λ _ → suc) 0 Rs) then
           res ++ map (_∷_ x₂) res else map (_∷_ x₂) res)
        ([] ∷ []) x₁)) d3






