module NormExample where


open import NormInvariants
open import Data.List
open import Data.Empty
open import Relation.Nullary
open import Relation.Binary
open import Relation.Nullary.Decidable hiding (map)
open import Relation.Binary.PropositionalEquality as PropEq hiding ([_] ; inspect)
open import Data.Product hiding (map)
open import Data.Nat hiding (_≟_)
open import Data.Nat.Show 
open import Data.Bool hiding (_∨_ ; T ; _≟_)


open import Foreign.Haskell
open import IO.Primitive
open import Data.String renaming (_++_ to _++s_) hiding (_≟_)
open import Data.Char hiding (_≟_)


open import ListsAddition
open import NormNatInstance

module Example1 where


  {-
              ### Example 1 ###
     Expr 	→ Term 	| Expr AddOp Term 	| AddOp Term
     Term 	→ Factor 	| Term MulOp Factor
     Factor 	→ Primary 	| Factor ^ Primary
     Primary 	→ Number 	| Variable 	| ( Expr )
     AddOp 	→ + 	| −
     MulOp 	→ * 	| /
  -}

  -- nonterminals
  Expr    = 1
  Term    = 2
  Factor  = 3
  Primary = 4
  AddOp   = 5
  MulOp   = 6
  Number  = 7
  Variable = 8
  -- terminals
  + = 2
  * = 3
  / = 4
  - = 5
  ^ = 6
  [ = 7
  ] = 8



  nt2str : ℕ → String
  nt2str 1 = "Expr"
  nt2str 2 = "Term"
  nt2str 3 = "Factor"
  nt2str 4 = "Primary"
  nt2str 5 = "AddOp"
  nt2str 6 = "MulOp"
  nt2str 7 = "Number"
  nt2str 8 = "Variable"
  nt2str n = "New" ++s (show n)

  tm2str : ℕ → String
  tm2str 1 = "1"
  tm2str 2 = "+"
  tm2str 3 = "*"
  tm2str 4 = "/"
  tm2str 5 = "-"
  tm2str 6 = "^"
  tm2str 7 = "("
  tm2str 8 = ")"
  tm2str 9 = "x"
  tm2str _ = ""



  rs : Rules
  rs =   Expr ⟶ (nt Term ∷ []) 
       ∷ Expr ⟶ (nt Expr ∷ nt AddOp ∷ nt Term ∷ []) 
       ∷ Expr ⟶ (nt AddOp ∷ nt Term ∷ [])

       ∷ Term ⟶ (nt Factor ∷ []) 
       ∷ Term ⟶ (nt Term ∷ nt MulOp ∷ nt Factor ∷ []) 

       ∷ Factor ⟶ (nt Primary ∷ []) 
       ∷ Factor ⟶ (nt Factor ∷ tm ^ ∷ nt Primary ∷ [])

       ∷ Primary ⟶ (nt Number ∷ [])
       ∷ Primary ⟶ (nt Variable ∷ [])
       ∷ Primary ⟶ (tm [ ∷ nt Expr ∷ tm ] ∷ [])
       
       ∷ AddOp ⟶ (tm + ∷ [])
       ∷ AddOp ⟶ (tm - ∷ [])


       ∷ MulOp ⟶ (tm * ∷ [])
       ∷ MulOp ⟶ (tm / ∷ [])

       ∷ Number ⟶ (tm 1 ∷ [])

       ∷ Variable ⟶ (tm 9 ∷ [])

       ∷ []

  G : Grammar
  G = record{ Rs = rs ; S = Expr }


  symb2str : Symbols → String
  symb2str [] = ""
  symb2str (tm x ∷ []) = tm2str x
  symb2str (nt x ∷ []) = nt2str x
  symb2str (tm x ∷ xs) = tm2str x ++s "∙" ++s symb2str xs
  symb2str (nt x ∷ xs) = nt2str x ++s "∙" ++s symb2str xs


  rules2str : Rules → String
  rules2str [] = ""
  rules2str (x ⟶ x₁ ∷ rs) = nt2str x ++s " ⟶ " ++s (symb2str x₁) ++s "\n"  ++s rules2str rs

  grammar2str : Grammar → String
  grammar2str G = "Start Nonterminal:" ++s (nt2str (S G)) ++s "\n" ++s rules2str (Rs G)

module Example2 where

  A = 1
  B = 2
  C = 3
  D = 4

  c = 1

  rs2 =  A ⟶ (nt B ∷ nt C ∷ nt D ∷ [])
       ∷ A ⟶ (nt B ∷ [])

       ∷ B ⟶ []
       ∷ B ⟶ (nt A ∷ [])
       

       ∷ C ⟶ (tm c ∷ [])

       ∷ D ⟶ []

       ∷ []


  {-
                 A
                 |
            B ∙  C ∙ D
            |    |   |
            A    |   |
            |    |   |
            B    |   |
            |    |   |
           [ ]   c  [ ]
  -}


  t : Tree rs2 A (tm c ∷ [])
  t = node base 
         (node (step (step (step base))) 
               (node (step base) 
                     (node (step (step base)) ⟦⟧ ∷n ⟦⟧) 
               ∷n ⟦⟧) 
          ∷n 
       (node (step (step (step (step base)))) (c ∷t ⟦⟧) ∷n 
       (node (step (step (step (step (step base))))) ⟦⟧ ∷n ⟦⟧)))

  nrs-e = ne-snd _ rs2 _ ( (ne-cmplt _ _ _ t (λ { () })))

  nrs-u = nu-snd rs2 _ _ (nu-cmplt rs2 _ _ t)



open Example2 


open Example1
main : IO Unit
main = putStrLn (toCostring (rules2str (norm rs)))

