

open import Relation.Binary
open import Relation.Nullary.Core
open import Relation.Binary.PropositionalEquality 
            hiding ([_])
open import Data.List
open import ListsAddition


module NormFreshNonterminals  (N T : Set)(_=n_ : Decidable (_≡_ {A = N}))(_=t_ : Decidable (_≡_ {A = T}))  
  (newntlst : List N → N) 
  (newntlstlem : (ns : List N) → (newntlst ns) ∉ ns) where


open import TopDownTree N T _=n_ _=t_

open import Data.Empty 
open import ListProperties
open import Logic 

ntonly : List Symbol → List N
ntonly [] = []
ntonly (tm x ∷ xs) = ntonly xs
ntonly (nt x ∷ xs) = x ∷ ntonly xs


newnt : Rules → N
newnt [] = newntlst []
newnt Rs = newntlst (ntonly (filterAllSmbls Rs))


ntonly-lem : ∀ xs ys →  ntonly (xs ++ ys) ≡ ntonly xs ++ ntonly ys
ntonly-lem [] ys = refl
ntonly-lem (tm x ∷ xs) ys = ntonly-lem xs ys 
ntonly-lem (nt x ∷ xs) ys rewrite ntonly-lem xs ys =  refl

ntonly-lem2 : ∀ xs n → (nt n) ∈ xs →  n ∈ ntonly xs 
ntonly-lem2 [] n ()
ntonly-lem2 (.(nt n) ∷ xs) n base = base
ntonly-lem2 (tm x ∷ xs) n (step prf) = ntonly-lem2 xs n prf 
ntonly-lem2 (nt x ∷ xs) n (step prf) = step (ntonly-lem2 xs n prf)


newntlem33 : (Rs : Rules) → (n : N) → (nt n) ∈ (filterAllSmbls Rs)
 → n ∈ (ntonly (filterAllSmbls Rs))
newntlem33 [] n ()
newntlem33 (x ⟶ x₁ ∷ Rs) n prf 
  rewrite foldth2 Rs (nt x ∷ x₁ ++ []) filterAllSmbls-f 
  with incLem {_} {nt n} {(filterAllSmbls Rs)} {nt x ∷ x₁ ++ []} prf 
... | inl o with newntlem33 Rs n o 
... | z rewrite ntonly-lem (filterAllSmbls Rs) (nt x ∷ x₁ ++ []) 
  = inFirst {_} {n} {ntonly (filterAllSmbls Rs)} {x ∷ ntonly (x₁ ++ [])} z

newntlem33 (x ⟶ x₁ ∷ Rs) n prf | inr o rewrite ++-th (nt x ∷ x₁) 
 | ntonly-lem (filterAllSmbls Rs) (nt x ∷ x₁)  
 = inTwo {_} {n} {ntonly (nt x ∷ x₁)} {ntonly (filterAllSmbls Rs)} (ntonly-lem2 (nt x ∷ x₁) n o)


newntlem : (Rs : Rules) → (nt (newnt Rs)) ∉ (filterAllSmbls Rs)
newntlem [] ()
newntlem (r ∷ Rs) prf with newntlem33 (r ∷ Rs) (newnt (r ∷ Rs)) prf 
... | o =  newntlstlem _ o


