
open import Relation.Binary
open import Relation.Nullary.Core
open import Relation.Binary.PropositionalEquality 
            hiding ([_]; inspect)
open import Data.List
open import ListsAddition

module NormGrammar  
  (N T : Set)(_=n_ : Decidable (_≡_ {A = N}))(_=t_ : Decidable (_≡_ {A = T}))
  (newntlst : List N → N)  
  (newntlstlem : (ns : List N) → (newntlst ns) ∉ ns) where


open import Data.Empty
open import Data.Product hiding (map)
open import Data.Nat hiding (_≟_)
open import Data.Bool hiding (_∨_ ; T ; _≟_)
open import Function.Equivalence

open import ListProperties
open import Logic

open import TopDownTree N T _=n_ _=t_
open import TopDownTreeProperties N T _=n_ _=t_

open import NormEpsRules N T _=n_ _=t_ public
open import Nullable N T _=n_ _=t_
open import NullableUtility N T _=n_ _=t_
open import NullableSound  N T _=n_ _=t_
open import NullableComplete N T _=n_ _=t_
open import NormUnitRules N T _=n_ _=t_ public
open import NormLongRules N T _=n_ _=t_ newntlst newntlstlem public
open import NormTermRules N T _=n_ _=t_ newntlst newntlstlem public
open import NormCorrectness N T _=n_ _=t_ newntlst newntlstlem   
open import NormGrammarInvariants N T _=n_ _=t_ newntlst newntlstlem  
open import NormFreshNonterminals N T _=n_ _=t_ newntlst newntlstlem public


-- CFG as a list of rules with dedicated start nonterminal
record Grammar : Set where
  field
    S  : N
    Rs : Rules    
open Grammar public

-- well-formedness predicate 
-- (start nonterminal must be used in the rules)
well-formed : (G : Grammar) → Set
well-formed G 
  = nt (S G) ∈ filterAllSmbls (Rs G)

-- language of the grammar
TreeS : Grammar → Symbols → Set
TreeS G s = Tree (Rs G) (S G) s


-- grammar normalization function
normS : Grammar → Grammar
normS G = record { 
  S  = S'; 
  Rs = if (S G) ∈? nullables (Rs G)
       then S' ⟶ [] ∷ Rs'
       else Rs'
  } 
 where
   S'  = newnt (Rs G)
   Rs' = norm (newnt (Rs G) ⟶ [ nt (S G) ] ∷ Rs G)


-- progress
rhslem : ∀ S Rs → (nt S) ∈ filterAllSmbls Rs → S ∉ RHS Rs → S ∉ RHS (norm Rs)
rhslem S Rs sin sout 
 with nlr-g-inv (nl-measure Rs) Rs S sin sout 
      | stepPreservesSymbols (nt S) Rs (nl-measure Rs) sin
... | s-out | s-in 
    with ntr-g-inv (ntr-length (norm-l Rs)) (norm-l Rs) S s-in s-out 
... | t-s-out = normuRHS∉ (norm-e (norm-t (norm-l Rs))) S 
                      (normeRHS∉ (norm-t (norm-l Rs)) S t-s-out)


rhslemG' : ∀ Rs S → (nt S) ∈ filterAllSmbls Rs → S ≢ (newnt Rs)
rhslemG' Rs .(newnt Rs) sin refl = newntlem Rs sin


rhslemG : ∀ S Rs → (nt S) ∈ filterAllSmbls Rs 
                 → (newnt Rs) ∉ RHS (norm (newnt Rs ⟶ [ nt S ] ∷ Rs))
rhslemG S Rs sin  newin with S =n (newnt Rs) 
... | yes p = rhslemG' Rs S sin p
... | no ¬p = rhslem (newnt Rs) ((newnt Rs ⟶ [ nt S ] ∷ Rs)) 
               (LHS-All (newnt Rs) 
               ((newnt Rs ⟶ [ nt S ] ∷ Rs)) 
               (LHS-complete (newnt Rs) [ nt S ]  
               (newnt Rs ⟶ [ nt S ] ∷ Rs) base))  
               (λ prf → hlp (newnt Rs) prf (newntlem3 Rs) ¬p) 
               newin
  where
   hlp : ∀ L → L ∈ (S ∷ RHS Rs) → L ∉ (RHS Rs) → S ≢ L → ⊥
   hlp .S base snin neq = neq refl
   hlp L (step prf) snin neq  = snin prf



-- normalized grammar is in CNF
progress : (G : Grammar) → (nt (S G)) ∈ (filterAllSmbls (Rs G))
  → (A : N) → (rhs : Symbols)
  → let G' = normS G in A ⟶ rhs ∈ (Rs G')
  → (((Σ[ n₁ ∈ N ] Σ[ n₂ ∈ N ] rhs ≡ (nt n₁ ∷ nt n₂ ∷ [])) ∨ 
     (Σ[ t ∈ T ] rhs ≡ [ tm t ] )) ∨ 
     (rhs ≡ [] × A ≡ (S G'))) ×
      (S G') ∉ RHS (Rs G')

progress G wf A rhs pin with (S G) ∈? nullables (Rs G) 
progress G wf A rhs pin | false
    with norm-progress (newnt (Rs G) ⟶ [ nt (S G) ] ∷ Rs G) A rhs pin 
... | inl x = inl (inl x) , rhslemG (S G) (Rs G) wf
... | inr x = inl (inr x) , rhslemG (S G) (Rs G) wf
progress G wf A rhs (step pin) | true 
  with norm-progress (newnt (Rs G) ⟶ [ nt (S G) ] ∷ Rs G) A rhs pin 
progress G wf A rhs (step pin) | true 
  | inl x = inl (inl x) , rhslemG (S G) (Rs G) wf
progress G wf A rhs (step pin) | true 
  | inr x = inl (inr x) , rhslemG (S G) (Rs G) wf
progress G wf .(newnt (Rs G)) .[] base 
  | true = inr (refl , refl) , rhslemG (S G) (Rs G) wf





-- completeness
cmplt : (G : Grammar) → (s : Symbols) → Tree (Rs G) (S G) s 
                                      → Tree (Rs (normS G)) (S (normS G)) s
cmplt G s t with inspect ((S G) ∈? nullables (Rs G))
cmplt G [] t | it false o rewrite o with nlbls-cmplt (Rs G) t 
... | p rewrite ∈?Complete (S G) _ p with o
... | ()
cmplt G (x ∷ xs) t | it false o rewrite o 
  with node base ((Rs-weaken (Rs G) (S G) (x ∷ xs) 
                            (newnt (Rs G) ⟶ (nt (S G) ∷ [])) t) ∷n ⟦⟧) 
... | t' rewrite ++-th (x ∷ xs)
   = (norm-cmplt _ _ _ t' (λ { () }))
cmplt G [] t | it true o rewrite o 
   = node base ⟦⟧ 
cmplt G (x ∷ xs) t 
    | it true o rewrite o 
    with node base ((Rs-weaken (Rs G) (S G) (x ∷ xs) 
                            (newnt (Rs G) ⟶ (nt (S G) ∷ [])) t) ∷n ⟦⟧) 
... | t' rewrite ++-th (x ∷ xs) 
    = Rs-weaken _ _ _ _ (norm-cmplt _ _ _ t' (λ { () }))



-- soundness
mutual
 snd-strngh : ∀ Rs L R A s → Tree (L ⟶ [ nt R ] ∷ Rs) A s  
   → L ∉ RHS Rs
   → Tree Rs A s ∨ (A ≡ L × Tree Rs R s)
 snd-strngh RS L R .L .(zs ++ []) (node base (_∷n_ {.[]} {.[]} {.R} {zs} x ⟦⟧)) pr 
   with snd-strngh _ _ _ _ _ x pr 
 ... | inl q rewrite ++-th zs = inr (refl , q)
 snd-strngh RS L .L .L .(zs ++ []) (node base (_∷n_ {.[]} {.[]} {.L} {zs} x ⟦⟧)) pr 
     | inr (refl , proj₂) rewrite ++-th zs = inr (refl , proj₂)
 snd-strngh RS L R A s (node (step x) x₁) pr 
     = inl (node x (snd-strngh-mut _ _ _ _ _ x₁ pr (RHS∉c RS L pr A _ x)))

 snd-strngh-mut : ∀ Rs L R rhs s → ListOfTs (L ⟶ [ nt R ] ∷ Rs) rhs s  
    → L ∉ RHS Rs
    → (nt L) ∉ rhs
    → ListOfTs Rs rhs s  
 snd-strngh-mut Rs L R .[] .[] ⟦⟧ pr1 pr2 = ⟦⟧
 snd-strngh-mut Rs L R .(tm t ∷ xs) .(tm t ∷ ys) (_∷t_ {xs} {ys} t lt) pr1 pr2 
     = t ∷t snd-strngh-mut  Rs L R xs ys lt pr1 (λ ntlin → pr2 (step ntlin)) 
 snd-strngh-mut Rs L R .(nt n ∷ xs) .(zs ++ ys) (_∷n_ {xs} {ys} {n} {zs} x lt) pr1 pr2 
     with snd-strngh _ _ _ _ _ x pr1 
 snd-strngh-mut Rs L R .(nt n ∷ xs) .(zs ++ ys) (_∷n_ {xs} {ys} {n} {zs} x lt) pr1 pr2 
     | inl x₁ = x₁ ∷n snd-strngh-mut _ _ _ _ _ lt pr1  (λ ntlin → pr2 (step ntlin))
 snd-strngh-mut Rs L R .(nt L ∷ xs) .(zs ++ ys) (_∷n_ {xs} {ys} {.L} {zs} x lt) pr1 pr2 
     | inr (refl , proj₂) with pr2 base 
 ... | ()


mutual 
 snd-hlp : ∀ Rs L A s → Tree (L ⟶ [] ∷ Rs) A s → L ∉ RHS Rs
  → Tree Rs A s ∨ (A ≡ L × s ≡ [])
 snd-hlp Rs L .L .[] (node base ⟦⟧) z 
    = inr (refl , refl) 
 snd-hlp Rs L A s (node (step x) x₁) z 
    = inl (node x (snd-hlp-mut _ _ _ _ x₁ z (RHS∉c Rs L z A _ x )))

 snd-hlp-mut : ∀ Rs L rhs s → ListOfTs (L ⟶ [] ∷ Rs) rhs s → L ∉ RHS Rs
   → (nt L) ∉ rhs
   → ListOfTs Rs rhs s  
 snd-hlp-mut Rs L .[] .[] ⟦⟧ pr pr1 = ⟦⟧
 snd-hlp-mut Rs L .(tm t ∷ xs) .(tm t ∷ ys) (_∷t_ {xs} {ys} t ts) pr pr1
    = t ∷t snd-hlp-mut Rs L xs ys ts pr (λ rin → pr1 (step rin))
 snd-hlp-mut Rs L .(nt n ∷ xs) .(zs ++ ys) (_∷n_ {xs} {ys} {n} {zs} x ts) pr pr1 
   with snd-hlp Rs L n zs x pr 
 ... | inl x₁ = x₁ ∷n snd-hlp-mut Rs L xs ys ts pr (λ prin → pr1 (step prin))
 snd-hlp-mut Rs L .(nt L ∷ xs₁) .([] ++ ys) (_∷n_ {xs₁} {ys} (node x x₁) ts) pr pr1 
     | inr (refl , refl) with pr1 base 
 ... | ()


snd : (G : Grammar) → well-formed G → (s : Symbols) 
            → Tree (Rs (normS G)) (S (normS G)) s → Tree (Rs G) (S G) s
snd G p s t with inspect ((S G) ∈? nullables (Rs G)) 
snd G p s t | it true x rewrite x 
  with snd-hlp _ (newnt (Rs G)) _ _ t (rhslemG (S G) (Rs G) p ) 
snd G p s t  | it true x | inl x₁ 
  with let q = (LHS-All (newnt (Rs G)) 
                  ((newnt (Rs G) ⟶ [ nt (S G) ] ∷ Rs G)) 
                  (LHS-complete (newnt (Rs G)) [ nt (S G) ] 
                  (newnt (Rs G) ⟶ [ nt (S G) ] ∷ Rs G) base)) 
       in norm-snd (newnt (Rs G) ⟶ [ nt (S G) ] ∷ Rs G) _ _ x₁ q
snd G p s t  | it true x | inl x₁ | t'' 
  with snd-strngh _ _ _ _ _ t'' (newntlem3 (Rs G)) 
snd G p s t  | it true x | inl x₁ | t'' | inl (node f r) 
  with newntlem4 (Rs G) (LHS-complete _ _ _ f) 
... | ()
snd G p s t  | it true x | inl x₁ | t'' | inr x₂ = proj₂ x₂
snd G p .[] t  | it true x | inr (refl , refl) 
  = nlbls-snd (length (Rs G)) _ 
              (∈?Sound (S G)  (nlbls (Rs G) (length (Rs G))) x) 
snd G p s t   | it false x rewrite x 
   with let q = (LHS-All (newnt (Rs G)) 
                  ((newnt (Rs G) ⟶ [ nt (S G) ] ∷ Rs G)) 
                  (LHS-complete (newnt (Rs G)) [ nt (S G) ] 
                  (newnt (Rs G) ⟶ [ nt (S G) ] ∷ Rs G) base)) 
       in norm-snd (newnt (Rs G) ⟶ [ nt (S G) ] ∷ Rs G) _ _ t q
snd G p s t  | it false x |  t'' 
  with snd-strngh _ _ _ _ _ t'' (newntlem3 (Rs G)) 
snd G p s t  | it false x | t'' | inl (node f r) 
  with newntlem4 (Rs G) (LHS-complete _ _ _ f) 
... | ()
snd G p s t  | it false x |  t'' | inr x₂ = proj₂ x₂


-- grammar normalization is sound and complete
snd&cmplt : (G : Grammar) → (s : Symbols)
   → well-formed G
   → TreeS G s ⇔ TreeS (normS G) s 
snd&cmplt G s wf = equivalence 
                      (λ t → cmplt G s t) 
                      (λ t → snd G wf s t)


