
open import Relation.Binary
open import Relation.Nullary.Core
open import Relation.Binary.PropositionalEquality 
            hiding ([_] ; inspect)
open import Data.List
open import ListsAddition




module NormInvariants (N T : Set)(_=n_ : Decidable (_≡_ {A = N}))(_=t_ : Decidable (_≡_ {A = T}))
  (newntlst : List N → N)  
  (newntlstlem : (ns : List N) → (newntlst ns) ∉ ns) where

open import Data.List
open import Data.Empty
open import Data.Product hiding (map)
open import Data.Nat hiding (_≟_)
open import Data.Bool hiding (_∨_ ; T ; _≟_)

open import Logic

open import ListProperties
open DecExistance hiding (_∈?_)
open DecListMinus

open import TopDownTree  N T _=n_ _=t_
open import TopDownTreeProperties  N T _=n_ _=t_

open import Nullable  N T _=n_ _=t_
open import NullableUtility  N T _=n_ _=t_

open import NormEpsRules N T _=n_ _=t_
open import NormUnitRules N T _=n_ _=t_ 
open import NormLongRules N T _=n_ _=t_ newntlst newntlstlem
open import NormTermRules N T _=n_ _=t_ newntlst newntlstlem
open import NormFreshNonterminals N T _=n_ _=t_ newntlst newntlstlem

{- norm-l is not removing any symbols from grammar -}
nor-l-rulein-step : ∀ Rs A xs → A ⟶ xs ∈ Rs 
  → Σ[ ys ∈ Symbols ] A ⟶ ys ∈ nl-step Rs
nor-l-rulein-step Rs A xs rin 
  with applyToFirstLem nl-step-p (nl-step-f Rs) Rs 
nor-l-rulein-step Rs A xs rin 
  | inl x rewrite x = xs , rin
nor-l-rulein-step Rs A xs rin 
  | inr (x1 , x2 , x ⟶ [] , x4 , () , x6)
nor-l-rulein-step Rs A xs rin 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ []) , x4 , () , x6)
nor-l-rulein-step Rs A xs rin 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ []) , x4 , () , x6)
nor-l-rulein-step .(x1 ++ x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ x2) A xs rin 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) , refl , x5 , x6) 
  with incLem {Rule} {A ⟶ xs} {x1} {x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ x2} rin 
nor-l-rulein-step .(x1 ++ x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ x2) A xs rin 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) , refl , x5 , x6) 
  | inl x₅ rewrite x6 = xs , inFirst {_} {A ⟶ xs} {x1} {_}  x₅
nor-l-rulein-step .(x1 ++ x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ x2) .x .(x₁ ∷ x₂ ∷ x₃ ∷ x₄) rin 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) , refl , x5 , x6) 
  | inr base rewrite x6 
  = (nt (newnt (x1 ++ x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ x2)) ∷ x₃ ∷ x₄) , 
     inTwo {_} {x ⟶
       (nt (newnt (x1 ++ x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ x2)) ∷ x₃ ∷ x₄)}  
       {x ⟶ (nt (newnt (x1 ++ x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ x2)) ∷ x₃ ∷ x₄) ∷
       newnt (x1 ++ x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ x2) ⟶ (x₁ ∷ x₂ ∷ []) ∷ x2} {x1} 
       base 
nor-l-rulein-step .(x1 ++ x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ x2) A xs rin 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) , refl , x5 , x6) 
  | inr (step x₅) 
  rewrite x6 
  = xs , inTwo {_} {A ⟶ xs} 
    {x ⟶ (nt (newnt (x1 ++ x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ x2)) ∷ x₃ ∷ x₄) ∷
       newnt (x1 ++ 
        x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ x2) ⟶ (x₁ ∷ x₂ ∷ []) ∷ x2} 
    {x1} (step (step x₅))


nor-l-rulein : ∀ n Rs A xs → A ⟶ xs ∈ Rs 
            → Σ[ ys ∈ Symbols ] A ⟶ ys ∈ repeatStep Rs n
nor-l-rulein zero Rs A xs rin = xs , rin
nor-l-rulein (suc n) Rs A xs rin 
    with nor-l-rulein n Rs A xs rin 
... | o1 , o2 = nor-l-rulein-step _ A o1 o2


norm-l-smbs : ∀ A Rs →  A ∈ LHS Rs → A ∈ LHS (norm-l Rs)
norm-l-smbs A Rs sin with LHS-sound A Rs  sin 
norm-l-smbs A Rs sin 
  | xs , rin 
  with nor-l-rulein (nl-measure Rs) Rs A xs rin 
norm-l-smbs A Rs sin 
  | xs , rin 
  | ys , rin2 = LHS-complete A ys (norm-l Rs) rin2


{- GENERAL: norm-e preverves all properties of RHS of the grammar
given that property remains to hold for all subsequences of the RHS -}
ne-efct : ∀ Rs → (P : Symbols → Set) 
  → (∀ f xs zs → xs ∈ allSubSeq f zs → P zs → P xs) 
  → ∀ A xs → (∀ N zs → N ⟶ zs ∈ Rs → P zs) → A ⟶ xs ∈ (norm-e Rs) → P xs 
ne-efct Rs P Pprop A xs  Gprop rin  
  with foldlth Rule _≟_ (A ⟶ xs) Rs (norm-e-f Rs) rin 
ne-efct Rs P Pprop A xs Gprop rin 
  | x ⟶ x₁ , p2 , p3 
  with foldlth Rule _≟_ (A ⟶ xs) Rs (norm-e-f Rs) rin 
ne-efct Rs P Pprop A xs Gprop rin 
  | x ⟶ x₁ , p2 , p3 
  | f1 , f2 , f3 
  with no-suprises-/ Rule _≟_  (A ⟶ xs) (x ⟶ []) 
         (foldl (λ res rhs → x ⟶ rhs ∷ res) []
         (foldr
          (λ x₂ res →
             if x₂ lft∈? nlbls Rs (foldr (λ _ → suc) 0 Rs) then
             res ++ map (_∷_ x₂) res else map (_∷_ x₂) res)
          ([] ∷ []) x₁)) p3 
... 
  | o with foldlth Rule _≟_  (A ⟶ xs) (foldr
         (λ x₂ res →
            if x₂ lft∈? nlbls Rs (foldr (λ _ → suc) 0 Rs) then
            res ++ map (_∷_ x₂) res else map (_∷_ x₂) res)
         ([] ∷ []) x₁) (λ smbs → [ x ⟶ smbs ]) o 
ne-efct Rs P Pprop .x .d1 Gprop rin 
  | x ⟶ x₁ , p2 , p3 
  | f1 , f2 , f3 
  | o 
  | d1 , d2 , base 
  = Pprop (λ x₂ → x₂ lft∈? nlbls Rs (foldr (λ _ → suc) 0 Rs)) 
    d1 x₁ d2 (Gprop x x₁ p2)
ne-efct Rs P Pprop A xs Gprop rin 
  | x ⟶ x₁ , p2 , p3 
  | f1 , f2 , f3 
  | o 
  | d1 , d2 , step ()



{- instance of property for predicate (length xs ≤ n) needed for
ne-efct -}
nlr-ner-instance : {X : Set} → (n : ℕ) →  (xs zs : List X) → (f : X → Bool) 
  → SubSeq f xs zs → length zs ≤ n → length xs ≤ n
nlr-ner-instance n .[] .[] f con1 lss = lss
nlr-ner-instance .(suc n) xs .(y ∷ ys) f 
  (con2 {.xs} {ys} {y} sub x) 
  (s≤s {.(foldr (λ _ → suc) 0 ys)} {n} lss)
  = nlr-ner-instance'' _ _ (nlr-ner-instance n xs ys f sub lss)
  where
    nlr-ner-instance'' : ∀ a n → a ≤ n → a ≤ suc n
    nlr-ner-instance'' .0 n z≤n = z≤n
    nlr-ner-instance'' .(suc m) .(suc n) 
     (s≤s {m} {n} lss) = s≤s (nlr-ner-instance'' m n lss)
nlr-ner-instance .(suc n) .(y ∷ xs) .(y ∷ ys) f 
  (con3 {xs} {ys} {y} sub) 
  (s≤s {.(foldr (λ _ → suc) 0 ys)} {n} lss) 
  = s≤s (nlr-ner-instance n xs ys f sub lss)


{- norm-e preserves invariant of norm-l -}
ner-long-invariant : ∀ Rs A xs 
  → (∀ N zs → N ⟶ zs ∈ Rs → length zs ≤ 2) 
  → A ⟶ xs ∈ (norm-e Rs) → length xs ≤ 2
ner-long-invariant Rs A xs p rin 
  = ne-efct Rs (λ smbs → length smbs ≤ 2) 
  (λ f xs zs sin prop → nlr-ner-instance 2 xs zs f 
  (subseqcombsInv  {Symbol} {f} xs zs sin) prop) A xs p rin


not-all-nonterms-lem : ∀ a b t 
  → not-all-nonterminals (a ++ (tm t)  ∷ b) ≡ true
not-all-nonterms-lem [] b t = refl
not-all-nonterms-lem (tm x ∷ a) b t = refl
not-all-nonterms-lem (nt x ∷ a) b t = not-all-nonterms-lem a b t 


{- instance of property for predicate needed for ne-efct -}
ner-gen-term-instance : (ws xs : Symbols) → (f : Symbol → Bool) 
  → SubSeq f ws xs 
  → ((xs ≡ []) ∨ (Σ[ t ∈ T ] xs ≡ (tm t) ∷ [])) ∨ (not-all-nonterminals xs ≡ false) 
  → ((ws ≡ []) ∨ (Σ[ t ∈ T ] ws ≡ (tm t) ∷ [])) ∨ (not-all-nonterminals ws ≡ false) 
ner-gen-term-instance  .[] .[] f con1 prop = prop
ner-gen-term-instance  ws .(y ∷ ys) f 
  (con2 {.ws} {ys} {y} sub x) (inl (inl ()))
ner-gen-term-instance  .[] .(tm proj₁ ∷ []) f (con2 con1 x) 
  (inl (inr (proj₁ , refl))) = inl (inl refl)
ner-gen-term-instance  ws .(tm x ∷ ys) f 
  (con2 {.ws} {ys} {tm x} sub x₁) (inr ())
ner-gen-term-instance  ws .(nt x ∷ ys) f 
  (con2 {.ws} {ys} {nt x} sub x₁) (inr x₂) 
  = ner-gen-term-instance  ws ys f sub (inr x₂) 
ner-gen-term-instance  .(y ∷ xs) .(y ∷ ys) f 
  (con3 {xs} {ys} {y} sub) (inl (inl ()))
ner-gen-term-instance  .(tm proj₁ ∷ []) .(tm proj₁ ∷ []) f 
  (con3 con1) (inl (inr (proj₁ , refl))) = inl (inr (proj₁ , refl))
ner-gen-term-instance  .(tm x ∷ xs) .(tm x ∷ ys) f 
  (con3 {xs} {ys} {tm x} sub) (inr ())
ner-gen-term-instance  .(nt x ∷ xs) .(nt x ∷ ys) f 
  (con3 {xs} {ys} {nt x} sub) (inr x₁) 
  with ner-gen-term-instance  xs ys f sub (inr x₁) 
ner-gen-term-instance  .(nt x₂ ∷ []) .(nt x₂ ∷ ys) f 
  (con3 {.[]} {ys} {nt x₂} sub) (inr x₁) 
  | inl (inl refl) = inr refl
ner-gen-term-instance  .(nt x₂ ∷ tm proj₁ ∷ []) .(nt x₂ ∷ ys) f 
  (con3 {.(tm proj₁ ∷ [])} {ys} {nt x₂} sub) (inr x₁) 
  | inl (inr (proj₁ , refl)) 
  with exists-split (tm proj₁) ys (subseqlemm f (tm proj₁) ys sub)  
... | o1 , o2 , o3  rewrite o3 
    | not-all-nonterms-lem o1 o2 proj₁ with x₁ 
... | ()
ner-gen-term-instance .(nt x₂ ∷ xs) .(nt x₂ ∷ ys) f 
  (con3 {xs} {ys} {nt x₂} sub) (inr x₁) 
  | inr x = inr x


{- norm-e preserves the invariant of norm-t -}
ner-term-invariant : ∀ Rs A xs 
  → (∀ N ws → N ⟶ ws ∈ Rs 
      → ((ws ≡ []) ∨ 
          (Σ[ t ∈ T ] ws ≡ (tm t) ∷ [])) ∨ (not-all-nonterminals ws ≡ false))
  → A ⟶ xs ∈ (norm-e Rs) 
  → ((xs ≡ []) ∨ (Σ[ t ∈ T ] xs ≡ (tm t) ∷ [])) 
     ∨ (not-all-nonterminals xs ≡ false)
ner-term-invariant Rs A xs prop rin 
  = ne-efct Rs (λ ws → ((ws ≡ []) ∨ (Σ[ t ∈ T ] ws ≡ (tm t) ∷ [])) ∨ 
    (not-all-nonterminals ws ≡ false)) 
    (λ f xs1 zs1 sin1 prop1 → 
      ner-gen-term-instance xs1 zs1 f 
      (subseqcombsInv {Symbol} {f} xs1 zs1 sin1)  prop1 ) A xs prop rin


{- norm-u preserves invariant of norm-e -}
nur-invariant : ∀ Rs → (∀ A → A ⟶ [] ∉ Rs) → ∀ A N 
                                → A ⟶ [] ∉ (nu-step N Rs)
nur-invariant Rs prop A N rin 
  with foldlth _ _≟_ (A ⟶ []) Rs (nur-f N Rs) rin
nur-invariant Rs prop A N rin 
  | x ⟶ x₁ , proj₂ , proj₃ 
  with liftDecEqToList _=s_ x₁ (nt N ∷ []) 
nur-invariant Rs prop A N rin 
  | x ⟶ x₁ , proj₂ , proj₃ 
  | yes p 
  with foldlth _ _≟_ (A ⟶ []) ((List Symbol / liftDecEqToList _=s_)
         (foldl (λ res r → filterRHS-f N r ++ res) [] Rs) (nt N ∷ [])) 
         (λ smbs → x ⟶ smbs ∷ []) proj₃
nur-invariant Rs prop .x N rin 
  | x ⟶ x₁ , proj₂ , proj₃ 
  | yes p 
  | .[] , o2 , base 
  with soundLem' _  
     (foldl (λ res r → filterRHS-f N r ++ res) [] Rs) [ nt N ] o2 
... | o = prop N 
    (filterRHS-complete [] Rs N (soundLem' []  
    (foldl (λ res r → filterRHS-f N r ++ res) [] Rs) [ nt N ] o2))
nur-invariant Rs prop A N rin 
  | x ⟶ x₁ , proj₂ , proj₃ 
  | yes p 
  | o1 , o2 , step ()
nur-invariant Rs prop .x N rin 
  | x ⟶ .[] , proj₂ , base 
  | no ¬p = prop x proj₂
nur-invariant Rs prop A N rin 
  | x ⟶ x₁ , proj₂ , step () 
  | no ¬p


nur-eps-invariant : ∀ Rs → (∀ A → A ⟶ [] ∉ Rs) 
                    → ∀ A xs → A ⟶ [] ∉ apply xs Rs
nur-eps-invariant Rs prop A []  rin = prop A  rin
nur-eps-invariant Rs prop A (x ∷ xs) rin 
  = nur-invariant (apply xs Rs) 
    (λ A rin2 → nur-eps-invariant Rs prop  A xs rin2) A x rin


{- GENERAL: norm-u preserves all properties of RHS of the rules -}
nur-step-gen-invariant : ∀ (P : Symbols → Set) Rs 
  → (∀ A xs → A ⟶ xs ∈ Rs → P xs) → ∀ A N xs → A ⟶ xs ∈ nu-step N Rs → P xs
nur-step-gen-invariant P Rs prop A N xs rin 
  with foldlth Rule _≟_ (A ⟶ xs) Rs (nur-f N Rs) rin 
nur-step-gen-invariant P Rs prop A N xs rin 
  | x ⟶ x₁ , o2 , o3 
  with liftDecEqToList _=s_ x₁ (nt N ∷ []) 
nur-step-gen-invariant P Rs prop A N xs rin 
  | x ⟶ .(nt N ∷ []) , o2 , o3 
  | yes refl 
  with foldlth Rule _≟_ (A ⟶ xs) ((List Symbol / liftDecEqToList _=s_)
        (foldl (λ res r → filterRHS-f N r ++ res) [] Rs) (nt N ∷ [])) 
        (λ s → [ x ⟶ s ]) o3 
nur-step-gen-invariant P Rs prop .x N .z1 rin 
  | x ⟶ .(nt N ∷ []) , o2 , o3 
  | yes refl 
  | z1 , z2 , base 
  with no-suprises-/ Symbols (liftDecEqToList _=s_) z1 [ nt N ] 
       (foldl (λ res r → filterRHS-f N r ++ res) [] Rs) z2
... | q = prop N z1 (filterRHS-complete z1 Rs N q)
nur-step-gen-invariant P Rs prop A N xs rin 
  | x ⟶ .(nt N ∷ []) , o2 , o3 
  | yes refl 
  | z1 , z2 , step ()
nur-step-gen-invariant P Rs prop .x N .x₁ rin 
  | x ⟶ x₁ , o2 , base 
  | no ¬p = prop x x₁ o2
nur-step-gen-invariant P Rs prop A N xs rin 
  | x ⟶ x₁ , o2 , step () 
  | no ¬p


nu-efct : ∀ (P : Symbols → Set) Rs → (∀ A xs → A ⟶ xs ∈ Rs → P xs) 
                                   → ∀ A Rs' xs → A ⟶ xs ∈ apply Rs' Rs → P xs
nu-efct P Rs prop A [] xs rin = prop A xs rin
nu-efct P Rs prop A (x ∷ Rs') xs rin 
  = nur-step-gen-invariant P (apply Rs' Rs)  
    (λ A' N' rin2 →  nu-efct P Rs prop A' Rs' N' rin2) A x xs rin


{- norm-u preserves invariant of norm-l -}
nur-long-invariant : ∀ Rs → (∀ A xs → A ⟶ xs ∈ Rs → length xs ≤ 2) 
                     → ∀ A Rs' xs → A ⟶ xs ∈ apply Rs' Rs → length xs ≤ 2
nur-long-invariant Rs prop A Rs' xs rin 
  = nu-efct  (λ xs → length xs ≤ 2) Rs prop A Rs' xs rin


{- norm-u preserves invariant of norm-t -}
nur-term-invariant : ∀ Rs → (∀ A xs → A ⟶ xs ∈ Rs 
  → ((xs ≡ []) ∨ (Σ[ t ∈ T ] xs ≡ (tm t) ∷ [])) ∨ (not-all-nonterminals xs ≡ false)) 
  → ∀ A Rs' xs 
    → A ⟶ xs ∈ apply Rs' Rs 
    → ((xs ≡ []) ∨ (Σ[ t ∈ T ] xs ≡ (tm t) ∷ [])) ∨ 
      (not-all-nonterminals xs ≡ false)
nur-term-invariant Rs prop A Rs' xs rin 
  = nu-efct 
    (λ ws → ((ws ≡ []) ∨ (Σ[ t ∈ T ] ws ≡ (tm t) ∷ [])) 
    ∨ (not-all-nonterminals ws ≡ false)) Rs prop A Rs' xs rin


{- norm-t preserves invariant of norm-l -}
nt-step-long-invariant : ∀ Rs → (∀ A xs → A ⟶ xs ∈ Rs → (length xs) ≤ 2) 
                          → ∀ A xs → A ⟶ xs ∈ nt-step Rs → (length xs) ≤ 2
nt-step-long-invariant Rs prop A xs rin 
  with applyToFirstLem nt-step-p (nt-step-f Rs) Rs 
nt-step-long-invariant Rs prop A xs rin 
  | inl x rewrite x = prop A xs rin
nt-step-long-invariant Rs prop A xs rin 
  | inr (x1 , x2 , x ⟶ [] , x4 , () , x6) 
nt-step-long-invariant Rs prop A xs rin 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ []) , x4 , () , x6) 
nt-step-long-invariant Rs prop A xs rin 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃) , x4 , x5 , x6) 
  with inspect (not-all-nonterminals (x₁ ∷ x₂ ∷ x₃))
nt-step-long-invariant Rs prop A xs rin 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃) , x4 , x5 , x6) 
  | it true d with (not-all-nonterminals-lem (x₁ ∷ x₂ ∷ x₃) d) 
nt-step-long-invariant Rs prop A xs rin 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃) , x4 , x5 , x6) 
  | it true d 
  | o1 , o2 , o3 , o4 
  with incLem {Rule} {A ⟶ xs} {x1} {_} (subst (λ r → A ⟶ xs ∈ r) x6  rin) 
nt-step-long-invariant Rs prop A xs rin 
  | inr (x1 , x2 , x ⟶ (x₂ ∷ x₃ ∷ x₄) , x4 , x5 , x6) 
  | it true d 
  | o1 , o2 , o3 , o4 
  | inl x₁ 
  rewrite x4 
  = prop A xs (inFirst {Rule} {A ⟶ xs} {x1} {x ⟶ (x₂ ∷ x₃ ∷ x₄) ∷ x2} x₁ )
nt-step-long-invariant Rs prop .x .(o1 ++ nt (newnt Rs) ∷ o2) rin 
  | inr (x1 , x2 , x ⟶ (x₂ ∷ x₃ ∷ x₄) , x4 , x5 , x6) 
  | it true d 
  | o1 , o2 , o3 , o4 
  | inr base rewrite x4 
  | o4 
  with prop x (o1 ++ tm o3 ∷ o2) 
   (inTwo {_} { x ⟶ (o1 ++ tm o3 ∷ o2)} {x ⟶ (o1 ++ tm o3 ∷ o2) ∷ x2} 
    {x1} base) 
... | o rewrite length-comp  o1 (tm o3 ∷ o2) 
  | length-comp o1 (nt (newnt (x1 ++ x ⟶ (o1 ++ tm o3 ∷ o2) ∷ x2)) ∷ o2) = o
nt-step-long-invariant Rs prop .(newnt Rs) .(tm o3 ∷ []) rin 
  | inr (x1 , x2 , x ⟶ (x₂ ∷ x₃ ∷ x₄) , x4 , x5 , x6) 
  | it true d 
  | o1 , o2 , o3 , o4 
  | inr (step base) = s≤s z≤n
nt-step-long-invariant Rs prop A xs rin 
  | inr (x1 , x2 , x ⟶ (x₂ ∷ x₃ ∷ x₄) , x4 , x5 , x6) 
  | it true d 
  | o1 , o2 , o3 , o4 
  | inr (step (step x₁)) rewrite x4  
  = prop A xs (inTwo {_} {A ⟶ xs} {x ⟶ (x₂ ∷ x₃ ∷ x₄) ∷ x2} {x1} (step x₁))
nt-step-long-invariant Rs prop A xs rin 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃) , x4 , x5 , x6) 
  | it false d rewrite x5 with d 
... | ()


nt-efct : ∀ Rs → (∀ A xs → A ⟶ xs ∈ Rs → (length xs) ≤ 2) 
  → ∀ A xs n 
  → A ⟶ xs ∈ repeatOn nt-step Rs n → (length xs) ≤ 2
nt-efct Rs prop A xs zero rin = prop A xs rin
nt-efct Rs prop A xs (suc n) rin 
  = nt-step-long-invariant (repeatOn nt-step Rs n) 
  (λ A xs rin2 → nt-efct Rs prop A xs n rin2) A xs rin
