
open import Relation.Binary
open import Relation.Nullary.Core
open import Relation.Binary.PropositionalEquality 
            hiding ([_] ; inspect)
open import Data.List
open import ListsAddition



module NormLongRules 
  (N T : Set)(_=n_ : Decidable (_≡_ {A = N}))(_=t_ : Decidable (_≡_ {A = T}))
  (newntlst : List N → N)  
  (newntlstlem : (ns : List N) → (newntlst ns) ∉ ns) where

open import Data.Empty
open import Data.List
open import Data.Bool hiding (_≟_ ; _∨_)
open import Data.Product
open import Data.Nat
open import Data.Empty

open import Logic
open import ListProperties
open import NatProperties

open import TopDownTree N T _=n_ _=t_
open import TopDownTreeProperties N T _=n_ _=t_

open import NormFreshNonterminals N T _=n_ _=t_ newntlst newntlstlem




newntlem3 : (Rs : Rules) → (newnt Rs) ∉ RHS Rs
newntlem3 Rs ntin with RHS-sound (newnt Rs) Rs ntin 
... | a , b , c , d 
  = newntlem Rs (filter-RHS-All (newnt Rs) Rs (RHS-compl a (newnt Rs) b  Rs c d))


newntlem4 : (Rs : Rules) → (newnt Rs) ∉ LHS Rs
newntlem4 Rs ntin = newntlem Rs (LHS-All (newnt Rs) Rs ntin)

applyToFirst : {X : Set} → (X → Bool) → (X → List X) → List X → List X
applyToFirst p f [] = []
applyToFirst p f (x ∷ xs) with p x
... | true  = f x ++ xs
... | false = x ∷ applyToFirst p f xs


applyToFirstLem : {X : Set} → ∀ p f → (Rs : List X) 
  → (applyToFirst p f Rs ≡ Rs) ∨ 
    (Σ[ Rs1 ∈ List X ] 
     Σ[ Rs2 ∈ List X ] 
     Σ[ x ∈ X ] 
     Rs ≡ Rs1 ++ [ x ] ++ Rs2 ×
     p x ≡ true ×
     applyToFirst p f Rs ≡ Rs1 ++ f x ++ Rs2)
applyToFirstLem p f [] = inl refl
applyToFirstLem p f (x ∷ Rs) 
    with inspect (p x)
... | it true p1 rewrite p1 = inr ([] , Rs , x , refl , p1 , refl)
... | it false p1 
    with applyToFirstLem p f Rs
applyToFirstLem p f (x₁ ∷ Rs) 
    | it false p1 
    | inl x rewrite p1 = inl (cong (_∷_ _) x)
applyToFirstLem p f (x₁ ∷ Rs) 
    | it false p1 
    | inr (x1 , x2 , x3 , x4 , x5 , x6) 
    rewrite p1 
    = inr (x₁ ∷ x1 , x2 , x3 , cong (_∷_ _) x4 , x5 , cong (_∷_ _) x6)


nl-measure : Rules → ℕ
nl-measure [] = 0
nl-measure (x ⟶ [] ∷ Rs) = nl-measure Rs
nl-measure (x ⟶ (x₁ ∷ []) ∷ Rs) = nl-measure Rs
nl-measure (x ⟶ (x₁ ∷ x₂ ∷ x₃) ∷ Rs) = length x₃ + nl-measure Rs


nl-step-p : Rule  → Bool
nl-step-p (x ⟶ x₁) with  (length x₁) ≤? 2
... | yes p = false
... | no  p = true


nl-step-f : Rules → Rule → Rules
nl-step-f Rs (x ⟶ []) = [ x ⟶ [] ]
nl-step-f Rs (x ⟶ (x₁ ∷ [])) = [ x ⟶ (x₁ ∷ []) ]
nl-step-f Rs (x ⟶ (x₁ ∷ x₂ ∷ [])) = [ x ⟶ (x₁ ∷ x₂ ∷ [])  ]
nl-step-f Rs (x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄)) = 
   x ⟶ ((nt (newnt Rs)) ∷ x₃ ∷ x₄) ∷ (newnt Rs) ⟶ (x₁ ∷ x₂ ∷ []) ∷ []


nl-step : Rules → Rules
nl-step Rs = applyToFirst nl-step-p (nl-step-f Rs) Rs


repeatStep : Rules → ℕ → Rules
repeatStep Rs n = fold Rs (λ res → nl-step res) n


mutual
 nl-step-complete : ∀ Rs A xs → Tree Rs A xs → Tree (nl-step Rs) A xs
 nl-step-complete Rs A xs (node {ws} x x₁) 
  with applyToFirstLem  nl-step-p (nl-step-f Rs)  Rs
 nl-step-complete Rs A xs (node {ws} x x₁) 
  | inl d rewrite d = node x x₁
 nl-step-complete Rs A xs (node x₂ x₃) | inr (d1 , d2 , x ⟶ [] , d4 , () , d6)
 nl-step-complete Rs A xs (node x₃ x₄) 
  | inr (d1 , d2 , x ⟶ (x₁ ∷ []) , d4 , () , d6)
 nl-step-complete Rs A xs (node x₄ x₅) 
  | inr (d1 , d2 , x ⟶ (x₁ ∷ x₂ ∷ []) , d4 , () , d6)
 nl-step-complete Rs A xs (node {ws} x₅ x₆) 
  | inr (d1 , d2 , x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) , d4 , refl , d6) 
  with incLem {Rule} {A ⟶ ws} {d1} 
              {x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ d2} (subst (λ R → A ⟶ ws ∈ R) d4 x₅)
 nl-step-complete Rs A xs (node {ws} x₅ x₆) 
  | inr (d1 , d2 , x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) , d4 , refl , d6) 
  | inl ind1  with nl-step-completeMut Rs ws xs x₆
 ... | lot2 rewrite d6 = node (inFirst ind1) lot2
 nl-step-complete Rs A xs₁ (node {ws} x₅ x₆) 
  | inr (d1 , d2 , x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) , d4 , refl , d6) 
  | inr (step ind2) with nl-step-completeMut Rs ws xs₁ x₆
 ... | lot2 rewrite d6 
  = node (inTwo {Rule} {A ⟶ ws} 
                {x ⟶ (nt (newnt Rs) ∷ x₃ ∷ x₄) ∷ newnt Rs ⟶ (x₁ ∷ x₂ ∷ []) ∷ d2}
                {d1} (step (step ind2))) lot2
 nl-step-complete Rs .x xs (node x₅ x₆) 
  | inr (d1 , d2 , x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) , d4 , refl , d6) 
  | inr base with nl-step-completeMut Rs (x₁ ∷ x₂ ∷ x₃ ∷ x₄) xs x₆
 nl-step-complete Rs .x xs (node x₅ x₆) 
  | inr (d1 , d2 , x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) , d4 , refl , d6) 
  | inr base 
  | z with tree-div (nl-step Rs) (x₁ ∷ x₂ ∷ [])  (x₃ ∷ x₄) xs z
 nl-step-complete Rs .x xs (node x₅ x₆) 
  | inr (d1 , d2 , x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) , d4 , refl , d6) 
  | inr base | z 
  | f1 , f2 , f3 , f4 , f5 rewrite d6 
  with node (inTwo {Rule} {newnt Rs ⟶ (x₁ ∷ x₂ ∷ [])} 
             {x ⟶ (nt (newnt Rs) ∷ x₃ ∷ x₄) ∷ newnt Rs ⟶ (x₁ ∷ x₂ ∷ []) ∷ d2} 
             {d1} (step base)) f3
 ... | q rewrite (sym f5) 
  = node (inTwo {Rule} 
          {x ⟶ (nt (newnt Rs) ∷ x₃ ∷ x₄)} 
          {x ⟶ (nt (newnt Rs) ∷ x₃ ∷ x₄) ∷ newnt Rs ⟶ (x₁ ∷ x₂ ∷ []) ∷ d2} 
          {d1} base) (_∷n_ q  f4)

 nl-step-completeMut : ∀ Rs xs ys → ListOfTs Rs xs ys 
                            → ListOfTs (nl-step Rs) xs ys
 nl-step-completeMut Rs .[] .[] ⟦⟧ = ⟦⟧
 nl-step-completeMut Rs .(tm t ∷ xs) .(tm t ∷ ys) (_∷t_ {xs} {ys} t lot) 
   = _∷t_ t (nl-step-completeMut Rs xs ys lot)
 nl-step-completeMut Rs .(nt n ∷ xs) .(zs ++ ys) (_∷n_ {xs} {ys} {n} {zs} x lot) 
   = _∷n_ (nl-step-complete Rs n zs x) (nl-step-completeMut  Rs xs ys lot)


data AllInG {X : Set} : List X → List X → Set where
  all_c1 : {ys : List X} → AllInG [] ys
  all_c2 : {x : X}{xs : List X}{ys : List X} 
              → AllInG xs ys → x ∈ ys → AllInG  (x ∷ xs) ys


filterAllSmblsLem1'' : {X : Set} → (xs ys : List X) → (z : X) 
                            → AllInG xs ys → AllInG xs (z ∷ ys)
filterAllSmblsLem1'' .[] ys z all_c1 = all_c1
filterAllSmblsLem1'' .(x ∷ xs) ys z (all_c2 {x} {xs} allin x₁) 
 = all_c2 (filterAllSmblsLem1'' xs ys z allin) (step x₁)

filterAllSmblsLem1' : {X : Set} → (xs ys zs : List X) 
                            → AllInG ys (xs ++ ys ++ zs)
filterAllSmblsLem1' [] [] zs = all_c1
filterAllSmblsLem1' [] (x ∷ ys) zs 
  = all_c2 (filterAllSmblsLem1'' ys (ys ++ zs) x  
            (filterAllSmblsLem1'  [] ys zs)) base
filterAllSmblsLem1' (x ∷ xs) ys zs 
  = filterAllSmblsLem1'' ys (xs ++ ys ++ zs) x (filterAllSmblsLem1' xs ys zs)


filterAllSmblsLem1 : ∀ A xs Rs → A ⟶ xs ∈ Rs → AllInG xs (filterAllSmbls Rs)
filterAllSmblsLem1 A xs Rs rin with exists-split (A ⟶ xs) Rs rin
filterAllSmblsLem1 A xs Rs rin 
  | z1 , z2 , z3 rewrite z3 
  | foldlnest z1 (A ⟶ xs ∷ z2) [] 
     (λ res r → filterAllSmbls-f r ++ res) 
  | foldInc' (nt A ∷ xs ++ foldl (λ res r → filterAllSmbls-f r ++ res) [] z1) 
     z2 filterAllSmbls-f  
  with filterAllSmblsLem1' (foldl (λ res r → filterAllSmbls-f r ++ res) [] z2 ++
       [ nt A ]) xs (foldl (λ res r → filterAllSmbls-f r ++ res) [] z1)
... | z with foldl (λ res r → filterAllSmbls-f r ++ res) [] z2 
    | foldl (λ res r → filterAllSmbls-f r ++ res) [] z1
... | a | b  rewrite ++-assoc (a ++ nt A ∷ []) xs b  
    | sym (++-assoc a [ nt A ] xs) | sym (++-assoc a (nt A ∷ xs) b) =  z


newntlemcorol1 : ∀ A xs Rs → A ⟶ xs ∈ Rs → nt A ∈ (filterAllSmbls Rs)
newntlemcorol1 A xs Rs rin with exists-split (A ⟶ xs) Rs rin
newntlemcorol1 A xs Rs rin | z1 , z2 , z3 rewrite z3 
  | foldlnest z1 (A ⟶ xs ∷ z2) [] (λ res r → filterAllSmbls-f r ++ res) 
  = foldInc (nt A) 
     (xs ++ foldl (λ res r → filterAllSmbls-f r ++ res) [] z1) 
     z2 filterAllSmbls-f


newntlemcorol : ∀ Rs xs ys → (newnt Rs) ⟶ xs ∈ (nl-step Rs) 
                                 → (newnt Rs) ⟶ ys ∈ (nl-step Rs) → xs ≡ ys
newntlemcorol Rs xs ys rin1 rin2 
  with applyToFirstLem nl-step-p (nl-step-f Rs) Rs
newntlemcorol Rs xs ys rin1 rin2 | inl x 
  rewrite x 
  = ex-falso-quodlibet (newntlem Rs (newntlemcorol1 (newnt Rs) xs Rs rin1))
newntlemcorol Rs xs ys rin1 rin2 | inr (x1 , x2 , x ⟶ [] , x4 , () , x6)
newntlemcorol Rs xs ys rin1 rin2 | inr (x1 , x2 , x ⟶ (x₁ ∷ []) , x4 , () , x6)
newntlemcorol Rs xs ys rin1 rin2 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ []) , x4 , () , x6)
newntlemcorol Rs xs ys rin1 rin2 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) , x4 , x5 , x6) 
  rewrite x6 
  with incLem {Rule} 
        {newnt Rs ⟶ ys} {x1} 
        {x ⟶ (nt (newnt Rs) ∷ x₃ ∷ x₄) ∷ newnt Rs ⟶ (x₁ ∷ x₂ ∷ []) ∷ x2} rin2
newntlemcorol Rs xs ys rin1 rin2 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) , x4 , x5 , x6) 
  | inl z 
  = ex-falso-quodlibet 
     (newntlem Rs 
      (newntlemcorol1 (newnt Rs) ys Rs 
        (subst (λ r →  newnt Rs ⟶ ys ∈ r) 
         (sym x4) 
         (inFirst {Rule} {newnt Rs ⟶ ys} {x1} 
          {x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ x2} z))))
newntlemcorol Rs xs .(nt (newnt Rs) ∷ x₃ ∷ x₄) rin1 rin2 
  | inr (x1 , x2 , .(newnt Rs) ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) , x4 , x5 , x6) 
  | inr base 
  = ex-falso-quodlibet 
     (newntlem Rs 
      (newntlemcorol1 (newnt Rs) (x₁ ∷ x₂ ∷ x₃ ∷ x₄) Rs 
       (subst (λ r → newnt Rs ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∈ r) (sym x4) 
        (inTwo {Rule} {newnt Rs ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄)} 
         {newnt Rs ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ x2} {x1} base)))) 
newntlemcorol Rs xs ys rin1 rin2 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) , x4 , x5 , x6) 
  | inr (step (step z)) 
  = ex-falso-quodlibet 
     (newntlem Rs 
      (newntlemcorol1 (newnt Rs) ys Rs 
       (subst (λ r → newnt Rs ⟶ ys ∈ r) (sym x4)  
        (inTwo {Rule} {newnt Rs ⟶ ys} 
         {x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ x2} {x1} (step z)))))
newntlemcorol Rs xs .(x₁ ∷ x₂ ∷ []) rin1 rin2 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) , x4 , x5 , x6) 
  | inr (step base) 
  with incLem {Rule} {newnt Rs ⟶ xs} {x1} 
        {x ⟶ (nt (newnt Rs) ∷ x₃ ∷ x₄) ∷ newnt Rs ⟶ (x₁ ∷ x₂ ∷ []) ∷ x2} rin1
newntlemcorol Rs xs .(x₁ ∷ x₂ ∷ []) rin1 rin2 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) , x4 , x5 , x6) 
  | inr (step base) 
  | inl z 
  = ex-falso-quodlibet 
     (newntlem Rs 
      (newntlemcorol1 (newnt Rs) xs Rs  
       (subst (λ r →  newnt Rs ⟶ xs ∈ r) (sym x4) 
        (inFirst {Rule} {newnt Rs ⟶ xs} {x1} 
         {x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ x2} z))))
newntlemcorol Rs .(nt (newnt Rs) ∷ x₃ ∷ x₄) .(x₁ ∷ x₂ ∷ []) rin1 rin2 
  | inr (x1 , x2 , .(newnt Rs) ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) , x4 , x5 , x6) 
  | inr (step base) 
  | inr base 
  = ex-falso-quodlibet 
     (newntlem Rs 
      (newntlemcorol1 (newnt Rs) (x₁ ∷ x₂ ∷ x₃ ∷ x₄) Rs 
       (subst (λ r → newnt Rs ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∈ r) (sym x4) 
        (inTwo {Rule} {newnt Rs ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄)} 
         {newnt Rs ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ x2} {x1} base))))
newntlemcorol Rs .(x₁ ∷ x₂ ∷ []) .(x₁ ∷ x₂ ∷ []) rin1 rin2 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) , x4 , x5 , x6) 
  | inr (step base) | inr (step base) = refl
newntlemcorol Rs xs .(x₁ ∷ x₂ ∷ []) rin1 rin2 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) , x4 , x5 , x6) 
  | inr (step base) | inr (step (step z)) 
  = ex-falso-quodlibet 
     (newntlem Rs 
      (newntlemcorol1 (newnt Rs) xs Rs 
       (subst (λ r → newnt Rs ⟶ xs ∈ r) (sym x4) 
        (inTwo {Rule} {newnt Rs ⟶ xs} 
         {x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ x2} {x1} (step z)))))



mutual
 nl-step-sound : ∀ Rs A xs → Tree (nl-step Rs) A xs 
                → (nt A) ∈ (filterAllSmbls Rs) → Tree Rs A xs
 nl-step-sound Rs A xs (node {ws} x x₁) ntin 
   with applyToFirstLem nl-step-p (nl-step-f Rs) Rs
 nl-step-sound Rs A xs (node x₁ x₂) ntin | inl x rewrite x = node x₁ x₂
 nl-step-sound Rs A xs (node {ws} x₁ x₂) ntin 
   | inr (x1 , x2 , x3 , x4 , x5 , x6 ) 
   with incLem {Rule} {A ⟶ ws} {x1} 
               {nl-step-f Rs x3 ++ x2} (subst (λ r → A ⟶ ws ∈ r)  x6 x₁)
 nl-step-sound Rs A xs (node {ws} x₁ x₂) ntin 
   | inr (x1 , x2 , x3 , x4 , x5 , x6) 
   | inl z 
   = node ((subst (λ r → A ⟶ ws ∈ r) (sym x4) 
          (inFirst {Rule} {A ⟶ ws} {x1} {x3 ∷ x2} z))) 
          (nl-step-soundMut Rs ws xs x₂ 
           (filterAllSmblsLem1  A ws Rs 
            (subst (λ r → A ⟶ ws ∈ r) (sym x4) 
             (inFirst {Rule} {A ⟶ ws} {x1} {x3 ∷ x2} z))))
 nl-step-sound Rs A xs (node {ws} x₁ x₂) ntin 
   | inr (x1 , x2 , x3 , x4 , x5 , x6 ) 
   | inr z
   with incLem  {Rule} {A ⟶ ws} {nl-step-f Rs x3} {x2} z 
 nl-step-sound Rs A xs (node {ws} x₁ x₂) ntin 
   | inr (x1 , x2 , x3 , x4 , x5 , x6 ) 
   | inr z | inr q  rewrite x4 
   = node ((inTwo {Rule} {A ⟶ ws} {x3 ∷ x2} {x1} (step q))) 
     (nl-step-soundMut (x1 ++ x3 ∷ x2) ws xs x₂ 
      (filterAllSmblsLem1 A ws (x1 ++ x3 ∷ x2) 
       (inTwo {Rule} {A ⟶ ws} {x3 ∷ x2} {x1} (step q))))
 nl-step-sound Rs A xs₁ (node x₂ x₃) ntin 
  | inr (x1 , x2 , x ⟶ [] , x4 , () , x6) | inr z | inl q
 nl-step-sound Rs A xs₁ (node x₃ x₄) ntin 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ []) , x4 , () , x6) | inr z | inl q
 nl-step-sound Rs A xs₁ (node x₄ x₅) ntin 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ []) , x4 , () , x6) | inr z | inl q
 nl-step-sound Rs .x .(zs ++ ys) 
   (node x₅ (_∷n_ {.(x₃ ∷ x₄)} {ys} 
         {.(newnt Rs)} {zs} (node {ss} x₆ x₇) x₈)) ntin 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) , x4 , refl , x6) 
  | inr z 
  | inl base 
  with newntlemcorol Rs ss (x₁ ∷ x₂ ∷ []) x₆ 
       (subst (λ r → newnt Rs ⟶ (x₁ ∷ x₂ ∷ []) ∈ r) (sym x6)  
        (inTwo {Rule} {newnt Rs ⟶ (x₁ ∷ x₂ ∷ [])} 
         {x ⟶ (nt (newnt Rs) ∷ x₃ ∷ x₄) ∷ newnt Rs ⟶ (x₁ ∷ x₂ ∷ []) ∷ x2} 
         {x1} (step base))) 
 nl-step-sound Rs .x .(zs ++ ys) 
  (node x₅ (_∷n_ {.(x₃ ∷ x₄)} {ys} {.(newnt Rs)} {zs} (node {ss} x₆ x₇) x₈)) 
  ntin 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) , x4 , refl , x6) 
  | inr z | inl base | v 
  with filterAllSmblsLem1 x (x₁ ∷ x₂ ∷ x₃ ∷ x₄) Rs 
        (subst (λ r → x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∈ r) 
         (sym x4) 
          (inTwo {Rule} {x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄)} 
                 {x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ x2} {x1} base))
 nl-step-sound Rs .x .(zs ++ ys) 
  (node x₉ (_∷n_ {.(x₃ ∷ x₄)} {ys} {.(newnt Rs)} {zs} (node x₈ x₁₀) x₁₁)) 
  ntin 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) , x4 , refl , x6) 
  | inr z 
  | inl base 
  | v 
  | all_c2 (all_c2 (all_c2 o x₅) x₆) x₇ 
  rewrite v 
  with nl-step-soundMut Rs (x₁ ∷ x₂ ∷ []) zs x₁₀ (all_c2 (all_c2 all_c1 x₆) x₇)
  | nl-step-soundMut Rs (x₃ ∷ x₄) ys x₁₁  (all_c2 o x₅)
 ... | lot1 | lot2 = node 
  (subst (λ r → x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∈ r) (sym x4) 
   (inTwo {Rule} {x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄)} 
          {x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ x2} {x1} base)) 
   (lot-cont Rs (x₁ ∷ x₂ ∷ []) zs (x₃ ∷ x₄) ys  lot1 lot2) 
 nl-step-sound Rs A xs₁ (node x₅ x₆) ntin 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) , x4 , refl , x6) 
  | inr z | inl (step (step ()))
 nl-step-sound Rs .(newnt Rs) xs₁ (node x₅ x₆) ntin 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) , x4 , refl , x6) | inr z 
  | inl (step base) = ex-falso-quodlibet (newntlem Rs ntin)


 nl-step-soundMut : ∀ Rs xs ys → ListOfTs (nl-step Rs) xs ys 
                  → AllInG xs (filterAllSmbls Rs) → ListOfTs Rs xs ys
 nl-step-soundMut Rs .[] .[] ⟦⟧ allin = ⟦⟧
 nl-step-soundMut Rs .(tm t ∷ xs) .(tm t ∷ ys) (_∷t_ {xs} {ys} t lot) 
   (all_c2 allin x) = _∷t_ t (nl-step-soundMut Rs xs ys lot allin) --
 nl-step-soundMut Rs .(nt n ∷ xs) .(zs ++ ys) (_∷n_ {xs} {ys} {n} {zs} x lot) 
   (all_c2 allin x₁) 
   = _∷n_ (nl-step-sound Rs n zs x x₁) (nl-step-soundMut Rs xs ys lot allin)


filterComp : ∀ xs ys 
  → filterAllSmbls (xs ++ ys) ≡ filterAllSmbls ys ++ filterAllSmbls xs
filterComp [] ys = sym (++-th (filterAllSmbls ys))
filterComp (x ⟶ x₁ ∷ xs) ys 
  rewrite foldInc' (nt x ∷ x₁ ++ []) (xs ++ ys) filterAllSmbls-f 
  | foldInc' (nt x ∷ x₁ ++ []) xs filterAllSmbls-f 
  | filterComp xs ys 
  = sym (++-assoc (filterAllSmbls ys) (filterAllSmbls xs) (nt x ∷ x₁ ++ []))


stepPreservesSymbols' : ∀ x Rs → x ∈ filterAllSmbls Rs 
                        → x ∈ filterAllSmbls (nl-step Rs) 
stepPreservesSymbols' x Rs smbin 
  with applyToFirstLem nl-step-p (nl-step-f Rs) Rs
stepPreservesSymbols' x Rs smbin 
 | inl z rewrite z = smbin
stepPreservesSymbols' x₂ Rs smbin 
 | inr (z1 , z2 , x ⟶ [] , z4 , () , z6)
stepPreservesSymbols' x₃ Rs smbin 
 | inr (z1 , z2 , x ⟶ (x₁ ∷ []) , z4 , () , z6)
stepPreservesSymbols' x₄ Rs smbin 
 | inr (z1 , z2 , x ⟶ (x₁ ∷ x₂ ∷ []) , z4 , () , z6)
stepPreservesSymbols' x₅ Rs smbin 
 | inr (z1 , z2 , x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) , z4 , z5 , z6) 
 rewrite z4 | filterComp z1 (x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ z2) 
 with incLem {Symbol} {x₅} 
             {filterAllSmbls (x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ z2)}  
             {filterAllSmbls z1} smbin
stepPreservesSymbols' x₅ Rs smbin 
  | inr (z1 , z2 , x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) , z4 , z5 , z6) 
  | inr o 
  rewrite z6 
  | filterComp z1 
     (x ⟶ (nt (newnt (z1 ++ x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ z2)) ∷ x₃ ∷ x₄) ∷
       newnt (z1 ++ x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ z2) ⟶ (x₁ ∷ x₂ ∷ []) ∷ z2) 
  = inTwo {Symbol} {x₅} {filterAllSmbls z1} 
          {foldl (λ res r → filterAllSmbls-f r ++ res)
       (nt (newnt (z1 ++ x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ z2)) ∷ x₁ ∷ x₂ ∷ nt x ∷
        nt (newnt (z1 ++ x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ z2)) ∷ x₃ ∷ x₄ ++ []) z2} o
stepPreservesSymbols' x₅ Rs smbin 
  | inr (z1 , z2 , x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) , z4 , z5 , z6) 
  | inl o 
  rewrite foldInc' (nt x ∷ x₁ ∷ x₂ ∷ x₃ ∷ x₄ ++ []) z2 filterAllSmbls-f 
  with incLem {Symbol} {x₅} {filterAllSmbls z2} 
              {nt x ∷ x₁ ∷ x₂ ∷ x₃ ∷ x₄ ++ []} o
stepPreservesSymbols' x₅ Rs smbin 
  | inr (z1 , z2 , x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) , z4 , z5 , z6) 
  | inl o 
  | inl z 
  rewrite z6 
  | filterComp z1 
       (x ⟶ (nt (newnt (z1 ++ x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ z2)) ∷ x₃ ∷ x₄) ∷
       newnt (z1 ++ x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ z2) ⟶ (x₁ ∷ x₂ ∷ []) ∷ z2) 
  | foldInc' ((nt (newnt (z1 ++ x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ z2)) ∷ x₁ ∷ x₂ ∷ 
       nt x ∷ nt (newnt (z1 ++ x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ z2)) ∷ x₃ ∷ x₄ ++ [])) 
       z2 filterAllSmbls-f 
  = inFirst {Symbol} {x₅} {(foldl (λ res r → filterAllSmbls-f r ++ res) [] z2 ++
        nt (newnt (z1 ++ x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ z2)) ∷ x₁ ∷ x₂ ∷ nt x ∷ nt 
        (newnt (z1 ++ x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ z2)) 
           ∷ x₃ ∷ x₄ ++ [])} 
        {filterAllSmbls z1}  
        (inFirst {Symbol} {x₅} {filterAllSmbls z2} z) 
stepPreservesSymbols' x₅ Rs smbin 
  | inr (z1 , z2 , x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) , z4 , z5 , z6) 
  | inl o 
  | inr z 
  rewrite z6 
  | filterComp z1 (x ⟶ (nt (newnt (z1 ++ x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ z2)) ∷ x₃ ∷ x₄) ∷
       newnt (z1 ++ x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ z2) ⟶ (x₁ ∷ x₂ ∷ []) ∷ z2) 
  | foldInc' (nt (newnt (z1 ++ x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ z2)) ∷ x₁ ∷ x₂ ∷ nt x ∷
        nt (newnt (z1 ++ x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ z2)) ∷ x₃ ∷ x₄ ++ [])
        z2 filterAllSmbls-f 
  = inFirst {Symbol} {x₅} {(foldl (λ res r → filterAllSmbls-f r ++ res) [] z2 ++
        nt (newnt (z1 ++ x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ z2)) ∷ x₁ ∷ x₂ ∷ nt x ∷
        nt (newnt (z1 ++ x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ z2)) ∷ x₃ ∷ x₄ ++ [])} 
     (inTwo {Symbol} {x₅} 
            {nt (newnt (z1 ++ x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ z2)) ∷ x₁ ∷ x₂ ∷ nt x ∷
       nt (newnt (z1 ++ x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ z2)) ∷ x₃ ∷ x₄ ++ []}  
      {filterAllSmbls z2} 
      (stepPreservesSymbols'' {Symbol} x₅ (nt x) x₁ x₂ x₃ 
       (nt (newnt (z1 ++ x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ z2))) 
       (nt (newnt (z1 ++ x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ z2)) ) (x₄ ++ []) z ))
  where   
    stepPreservesSymbols'' : {X : Set} → (x₅ x x₁ x₂ x₃ y z : X) → (x₄ : List X)
      → x₅ ∈ (x ∷ x₁ ∷ x₂ ∷ x₃ ∷ x₄)
      →  x₅ ∈  (y ∷ x₁ ∷ x₂ ∷ x ∷ z ∷ x₃ ∷ x₄)
    stepPreservesSymbols'' .a2 a2 a3 a4 a5 a6 a7 a8 base 
      = step (step (step base))
    stepPreservesSymbols'' .a3 a2 a3 a4 a5 a6 a7 a8 (step base) 
      = step base
    stepPreservesSymbols'' .a4 a2 a3 a4 a5 a6 a7 a8 (step (step base)) 
      = step (step base)
    stepPreservesSymbols'' .a5 a2 a3 a4 a5 a6 a7 a8 (step (step (step base))) 
      = step (step (step (step (step base))))
    stepPreservesSymbols'' a1 a2 a3 a4 a5 a6 a7 a8 (step (step (step (step smbin)))) 
      = step (step (step (step (step (step smbin)))))



stepPreservesSymbols : ∀ x Rs n → x ∈ filterAllSmbls Rs 
                     → x ∈ filterAllSmbls (repeatStep Rs n) 
stepPreservesSymbols x Rs zero smbin = smbin
stepPreservesSymbols x Rs (suc n) smbin 
 = stepPreservesSymbols' x ((repeatStep Rs n)) 
 (stepPreservesSymbols x Rs n smbin)


{- full completeness -}
nl-cmplt : ∀ Rs A xs n → Tree Rs A xs → Tree (repeatStep Rs n) A xs
nl-cmplt Rs A xs zero tree = tree
nl-cmplt Rs A xs (suc n) tree 
  = nl-step-complete _ A xs (nl-cmplt Rs A xs n tree)


{- full soundness -}
nl-snd : ∀ Rs A xs n → Tree (repeatStep Rs n) A xs 
                     → (nt A) ∈ (filterAllSmbls Rs) → Tree Rs A xs
nl-snd Rs A xs zero tree ntin = tree
nl-snd Rs A xs (suc n) tree ntin 
  = nl-snd Rs A xs n (nl-step-sound 
      (fold Rs nl-step n) A xs tree 
      (stepPreservesSymbols (nt A) Rs n ntin)) ntin


nl-measureComp : ∀ xs ys → nl-measure (xs ++ ys) ≡ nl-measure xs + nl-measure ys
nl-measureComp [] ys = refl
nl-measureComp (x ⟶ [] ∷ xs) ys = nl-measureComp xs ys
nl-measureComp (x ⟶ (x₁ ∷ []) ∷ xs) ys = nl-measureComp xs ys
nl-measureComp (x ⟶ (x₁ ∷ x₂ ∷ x₃) ∷ xs) ys 
  rewrite nl-measureComp xs ys 
  = +-ass (length x₃) (nl-measure xs) (nl-measure ys)


nl-measureDec' : ∀ Rs ff → (applyToFirst nl-step-p ff Rs) ≡ Rs 
  → ((x : N) → (x₁ x₂ x₃ : Symbol)(x₄ : Symbols) 
  → Σ[ r1 ∈ Rule ] Σ[ r2 ∈ Rule ] ff (x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄)) ≡ r1 ∷ r2 ∷ [])
  → nl-measure Rs ≡ 0
nl-measureDec' [] ff eq p = refl 
nl-measureDec' (x ⟶ [] ∷ Rs) ff  eq p 
 = nl-measureDec' Rs ff (tailseq (x ⟶ []) 
    (applyToFirst nl-step-p ff Rs) Rs eq) p
nl-measureDec' (x ⟶ (x₁ ∷ []) ∷ Rs) ff eq p 
 = nl-measureDec' Rs ff (tailseq  (x ⟶ (x₁ ∷ [])) 
    (applyToFirst nl-step-p ff Rs) Rs eq) p
nl-measureDec' (x ⟶ (x₁ ∷ x₂ ∷ []) ∷ Rs) ff eq p 
  = nl-measureDec' Rs ff (tailseq  (x ⟶ (x₁ ∷ x₂ ∷ [])) 
    (applyToFirst nl-step-p ff Rs) Rs eq) p
nl-measureDec' (x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ Rs) ff eq p 
    with p x x₁ x₂ x₃ x₄
... | z1 , z2 , z3 rewrite z3 
  = ex-falso-quodlibet (nequallists z1 z2 (x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄)) Rs eq)


{- Number of steps to make. -}
nl-measureDec : (Rs : Rules) → (n : ℕ) 
          → nl-measure Rs ≡ suc n → nl-measure (nl-step Rs) ≡ n
nl-measureDec Rs n eq 
  with applyToFirstLem nl-step-p (nl-step-f Rs) Rs
nl-measureDec Rs n eq 
  | inl x rewrite x 
  with nl-measureDec' Rs (nl-step-f Rs) x 
       (λ x₁ x₂ x₃ x₄ x₅ → x₁ ⟶ (nt (newnt Rs) ∷ x₄ ∷ x₅) , 
         newnt Rs ⟶ (x₂ ∷ x₃ ∷ [])  , refl)
... | q rewrite q with eq
... | () 
nl-measureDec Rs n eq | inr (x1 , x2 , x ⟶ [] , x4 , () , x6)
nl-measureDec Rs n eq | inr (x1 , x2 , x ⟶ (x₁ ∷ []) , x4 , () , x6)
nl-measureDec Rs n eq | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ []) , x4 , () , x6)
nl-measureDec Rs n eq | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) , x4 , x5 , x6)
  rewrite x6 | x4 
  | nl-measureComp x1 (x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ x2) 
  | nl-measureComp x1 (
     x ⟶ (nt (newnt (x1 ++ x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ x2)) ∷ x₃ ∷ x₄) ∷
       newnt (x1 ++ x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ x2) ⟶ (x₁ ∷ x₂ ∷ []) ∷ x2) 
  with nl-measure x1 | length x₄ + nl-measure x2
... | a | b  rewrite +-com a (suc b) | +-com b a  = cong pred eq


nl-measurePreserves0 : ∀ Rs → nl-measure Rs ≡ 0 → nl-measure (nl-step Rs) ≡ 0
nl-measurePreserves0 Rs eq with applyToFirstLem nl-step-p (nl-step-f Rs) Rs
nl-measurePreserves0 Rs eq | inl x rewrite x = eq
nl-measurePreserves0 Rs eq | inr (x1 , x2 , x ⟶ [] , x4 , () , x6)
nl-measurePreserves0 Rs eq | inr (x1 , x2 , x ⟶ (x₁ ∷ []) , x4 , () , x6)
nl-measurePreserves0 Rs eq | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ []) , x4 , () , x6)
nl-measurePreserves0 Rs eq 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) , x4 , x5 , x6) 
  rewrite x4 
  | nl-measureComp x1 (x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄) ∷ x2) 
  | +-com (nl-measure x1) (suc (foldr (λ _ → suc) 0 x₄ + nl-measure x2)) 
  with eq
... | ()


{- Normalization -}
repeatOn : {X : Set} → (g : X → X) → X → ℕ → X
repeatOn g x zero = x
repeatOn g x (suc n) = g (repeatOn g x n)


tozero : {X : Set} → (x : X) → (n : ℕ) →  (f : X → ℕ) → (g : X → X) 
  → (∀ x n → f x ≡ suc n → f (g x) ≡ n) 
  → (∀ x → f x ≡ 0 → f (g x) ≡ 0) 
  → f (repeatOn g x n) ≡ f x ∸ n
tozero x zero f g prop prop2 = refl
tozero {X} x (suc n) f g prop prop2 with inspect (f (repeatOn g x n) )
tozero x (suc n) f g prop prop2
    | it zero p rewrite prop2 (repeatOn g x n) p with tozero x n f g prop prop2
... | q rewrite p = sym (minuProp1 (f x) n (sym q))
tozero x (suc n) f g prop prop2 
    | it (suc v) p with tozero x n f g prop prop2 | prop (repeatOn g x n) v p
... | z | q rewrite q | z = sym (minuProp2 (f x) n v  p)



{- if nl-measure ≡ 0 -}
nl-measure0 : ∀ Rs A xs → nl-measure Rs ≡ 0 → A ⟶ xs ∈ Rs → (length xs) ≤ 2
nl-measure0 .(A ⟶ [] ∷ as) A [] eq (base {.(A ⟶ [])} {as}) = z≤n
nl-measure0 .(A ⟶ (x ∷ []) ∷ as) A (x ∷ []) eq (base {.(A ⟶ (x ∷ []))} {as}) 
  = s≤s z≤n
nl-measure0 .(A ⟶ (x ∷ x₁ ∷ []) ∷ as) A (x ∷ x₁ ∷ []) eq 
  (base {.(A ⟶ (x ∷ x₁ ∷ []))} {as}) = s≤s (s≤s z≤n)
nl-measure0 .(A ⟶ (x ∷ x₁ ∷ x₂ ∷ xs) ∷ as) A (x ∷ x₁ ∷ x₂ ∷ xs) () 
  (base {.(A ⟶ (x ∷ x₁ ∷ x₂ ∷ xs))} {as})
nl-measure0 .(b ∷ as) A xs eq (step {.(A ⟶ xs)} {b} {as} rin) 
  = nl-measure0 as  A xs (nl-measure0' b as eq) rin
  where
   nl-measure0' : ∀ r Rs → nl-measure (r ∷ Rs) ≡ 0 → nl-measure Rs ≡ 0
   nl-measure0' (x ⟶ []) Rs eq = eq
   nl-measure0' (x ⟶ (x₁ ∷ [])) Rs eq = eq
   nl-measure0' (x ⟶ (x₁ ∷ x₂ ∷ [])) Rs eq = eq
   nl-measure0' (x ⟶ (x₁ ∷ x₂ ∷ x₃ ∷ x₄)) Rs ()


repeatOnRepeatStep : ∀ Rs n → repeatOn nl-step Rs n ≡ repeatStep Rs n
repeatOnRepeatStep Rs zero = refl
repeatOnRepeatStep Rs (suc n) rewrite repeatOnRepeatStep Rs n = refl


normalization1 : ∀ Rs n →
  nl-measure (repeatStep Rs n) ≡ (nl-measure Rs) ∸ n
normalization1 Rs n 
 rewrite sym (repeatOnRepeatStep Rs n) 
 = tozero Rs n nl-measure nl-step 
    (λ x n eq → nl-measureDec x n eq) 
    (λ x eq → nl-measurePreserves0 x eq)


norm-l : Rules → Rules
norm-l Rs = repeatStep Rs (nl-measure Rs)


{- full normalization  -}
nl-progress :  ∀ A xs Rs
 → A ⟶ xs ∈ norm-l Rs → (length xs) ≤ 2
nl-progress A xs Rs rin 
  = nl-measure0  
    (repeatStep Rs (nl-measure Rs)) A xs 
    (trans (normalization1 Rs (nl-measure Rs))
     (-self (nl-measure Rs))) rin 


