

module NormNatInstance where


open import Relation.Nullary
open import Relation.Binary
open import Relation.Nullary.Decidable hiding (map)
open import Relation.Binary.PropositionalEquality 
            as PropEq hiding ([_] ; inspect)
open import Data.Nat
open import Data.Empty
open import Data.List
open import Data.Sum
open import ListsAddition
open import Logic
open import NatProperties

open import TopDownTree ℕ ℕ _≟_ _≟_ renaming (_≟_ to treeEq) public



{- efficient max -}
max : List ℕ → ℕ
max [] = 0
max (x ∷ xs) = x ⊔ (max xs)

⊔-s : ∀ x y → x ≤ y → x ⊔ y ≡ y
⊔-s .0 y z≤n = refl
⊔-s .(suc x) .(suc y) (s≤s {x} {y} pr) = cong suc (⊔-s x y pr)

⊔-c : ∀ x y → x ⊔ y ≡ y ⊔ x
⊔-c zero zero = refl
⊔-c zero (suc y) = refl
⊔-c (suc x) zero = refl
⊔-c (suc x) (suc y) = cong suc (⊔-c x y)

{- inefficient max (but better for proofs) -}
max' : List ℕ → ℕ
max' [] = 0
max' (x ∷ xs) with x ≤? (max' xs) 
max' (x ∷ xs) | yes p = max' xs
max' (x ∷ xs) | no ¬p = x

max'=max : (l : List ℕ) → max' l ≡ max l
max'=max [] = refl
max'=max (x ∷ l) with x ≤? max' l 
max'=max (x ∷ l) | yes p rewrite max'=max l = sym (⊔-s  _ _ p)
max'=max (x ∷ l) | no ¬p rewrite max'=max l with (≤-o _ _ ¬p) 
... | xpr rewrite ⊔-c x (max l) = sym (⊔-s _ _ xpr)


max-cor : (xs : List ℕ) → (x : ℕ) → x ∈ xs → x ≤ max' xs 
max-cor (x ∷ xs) .x base with x ≤? max' xs 
max-cor (x ∷ xs) .x base | yes p = p
max-cor (x ∷ xs) .x base | no ¬p = refl≤ x
max-cor (y ∷ xs) x (step pin) with y ≤? max' xs 
max-cor (y ∷ xs) x (step pin) | yes p = max-cor xs x pin
max-cor (y ∷ xs) x (step pin) | no ¬p with max-cor xs x pin 
... | IH = trans≤  _ _ _ IH (weak≤ _ _ (dec y (max' xs) ¬p)) 



help : Rules → List ℕ 
help Rs = Data.List.map (λ { (nt a) → a ; (tm a) → a }) (filterAllSmbls Rs)


newntlst' : List ℕ → ℕ
newntlst' xs = suc (max' xs)

newntlst : List ℕ → ℕ
newntlst xs = suc (max xs)


newntlst-cor : (ns : List ℕ) → (n : ℕ) → n ∈ ns → n < newntlst' ns
newntlst-cor ns n prf = s≤s (max-cor ns n prf)

newntlstlem' : (ns : List ℕ) → (newntlst' ns) ∉ ns
newntlstlem' ns prf = ⊥≤ _ (newntlst-cor ns (newntlst' ns) prf)

newntlstlem : (ns : List ℕ) → (newntlst ns) ∉ ns
newntlstlem ns prf rewrite (sym (max'=max ns)) = newntlstlem' ns prf


open import NormCorrectness ℕ ℕ _≟_ _≟_ newntlst newntlstlem public
open import NormGrammar ℕ ℕ _≟_ _≟_ newntlst newntlstlem public






