
open import Relation.Binary
open import Relation.Nullary.Core
open import Relation.Binary.PropositionalEquality 
            hiding ([_] ; inspect)
open import Data.List
open import ListsAddition




module NormTermRules (N T : Set)(_=n_ : Decidable (_≡_ {A = N}))(_=t_ : Decidable (_≡_ {A = T}))

  (newntlst : List N → N)  
  (newntlstlem : (ns : List N) → (newntlst ns) ∉ ns) where



open import Data.Bool hiding (_≟_ ; _∨_ ; T)
open import Data.Product
open import Data.Nat hiding (_<_)
open import Data.Empty


open import ListProperties
open DecExistance
open import Logic
open import NatProperties

open import TopDownTree N T _=n_ _=t_ 
open import TopDownTreeProperties N T _=n_ _=t_ 
open import NormFreshNonterminals N T _=n_ _=t_ newntlst newntlstlem
open import NormLongRules N T _=n_ _=t_ newntlst newntlstlem 



ntr-length-f : Symbols → ℕ
ntr-length-f [] = 0
ntr-length-f (tm x ∷ r) = 1 + ntr-length-f r
ntr-length-f (nt x ∷ r) = ntr-length-f r

ntr-length : Rules → ℕ
ntr-length [] = 0
ntr-length (x ⟶ [] ∷ Rs) = ntr-length Rs
ntr-length (x ⟶ (x₁ ∷ []) ∷ Rs) = ntr-length Rs
ntr-length (x ⟶ (x₁ ∷ x₂ ∷ xs) ∷ Rs) 
  = ntr-length-f (x₁ ∷ x₂ ∷ xs) + ntr-length Rs


not-all-nonterminals : Symbols → Bool
not-all-nonterminals [] = false
not-all-nonterminals (tm x ∷ ss) = true
not-all-nonterminals (nt x ∷ ss) = not-all-nonterminals ss


not-all-nonterminals-lem : ∀ xs → 
  not-all-nonterminals xs ≡ true → 
  Σ[ xs1 ∈ Symbols ] 
  Σ[ xs2 ∈ Symbols ] 
  Σ[ x ∈ T ] xs ≡ xs1 ++ [ tm x ] ++ xs2
not-all-nonterminals-lem [] ()
not-all-nonterminals-lem (tm x ∷ xs) run = [] , xs , x , refl
not-all-nonterminals-lem (nt x ∷ xs) run 
  with not-all-nonterminals-lem xs run 
... | x1 , x2 , x3 ,  x4 = nt x ∷ x1 , x2 , x3 , cong (_∷_ _) x4


nt-step-p : Rule → Bool
nt-step-p (x ⟶ []) = false
nt-step-p (x ⟶ (x₁ ∷ [])) = false
nt-step-p (x ⟶ (x₁ ∷ x₂ ∷ x₃)) 
  = not-all-nonterminals (x₁ ∷ x₂ ∷ x₃)

nt-step-f : Rules → Rule → Rules
nt-step-f Rs (x ⟶ []) = [ x ⟶ [] ]
nt-step-f Rs (x ⟶ (x₁ ∷ [])) = [ x ⟶ [ x₁ ]  ]
nt-step-f Rs (x ⟶ (x₁ ∷ x₂ ∷ x₃)) 
  with inspect (not-all-nonterminals (x₁ ∷ x₂ ∷ x₃)) 
nt-step-f Rs (x ⟶ (x₁ ∷ x₂ ∷ x₃)) 
  | it false p = [ (x ⟶ (x₁ ∷ x₂ ∷ x₃)) ]
nt-step-f Rs (x ⟶ (x₁ ∷ x₂ ∷ x₃)) 
  | it true p 
  with not-all-nonterminals-lem (x₁ ∷ x₂ ∷ x₃) p 
nt-step-f Rs (x ⟶ (x₁ ∷ x₂ ∷ x₃)) 
  | it true p 
  | x1 , x2 , x3 , x4 
  = x ⟶ ( x1 ++ [ nt (newnt Rs) ] ++ x2) ∷ (newnt Rs) ⟶ [ tm x3 ] ∷ []


nt-step : Rules → Rules
nt-step Rs = applyToFirst nt-step-p (nt-step-f Rs) Rs


ntr-spss : ∀ x₅ x o1 o3 o2 o
 →  x₅ ∈ (o1 ++ tm o3 ∷ o2) 
 →  x₅ ∈ (tm o3 ∷ nt x ∷ o1 ++ o ∷ o2)
ntr-spss x5 x o1 o3 o2 o sin  
  with incLem {_} {x5} {o1} {tm o3 ∷ o2} sin 
ntr-spss x5 x₁ o1 o3 o2 o sin 
  | inl x = step (step (inFirst {_} {x5} {o1}  {o ∷ o2} x))
ntr-spss .(tm o3) x₁ o1 o3 o2 o sin 
  | inr base = base
ntr-spss x5 x₁ o1 o3 o2 o sin 
  | inr (step x) = step (step (inTwo {_} {x5} {o ∷ o2} {o1} (step x)))


nt-step-preserves-symbols-step : ∀ x Rs 
  → x ∈ filterAllSmbls Rs → x ∈ filterAllSmbls (nt-step Rs) 
nt-step-preserves-symbols-step x Rs sin 
  with applyToFirstLem nt-step-p (nt-step-f Rs) Rs 
nt-step-preserves-symbols-step x₁ Rs sin 
  | inl x rewrite x = sin
nt-step-preserves-symbols-step x₂ Rs sin 
  | inr (x1 , x2 , x ⟶ [] , x4 , x5 , x6) rewrite x6 | x4 = sin
nt-step-preserves-symbols-step x₃ Rs sin 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ []) , x4 , x5 , x6) rewrite x6 | x4  = sin
nt-step-preserves-symbols-step x₄ Rs sin 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃) , x4 , x5 , x6) 
  with inspect (not-all-nonterminals (x₁ ∷ x₂ ∷ x₃))
nt-step-preserves-symbols-step x₄ Rs sin 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃) , x4 , x5 , x6) 
  | it true j with (not-all-nonterminals-lem (x₁ ∷ x₂ ∷ x₃) j) 
nt-step-preserves-symbols-step x₄ Rs sin 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃) , x4 , x5 , x6) 
  | it true j 
  | o1 , o2 , o3 , o4  
  with foldlth Symbol _=s_ x₄ Rs filterAllSmbls-f sin 
nt-step-preserves-symbols-step x₄ Rs sin 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃) , x4 , x5 , x6) 
  | it true j 
  | o1 , o2 , o3 , o4 
  | d1 , d2 , d3 
  with incLem {_} {d1} {x1} {_} (subst (λ r → d1 ∈ r) x4 d2) 
nt-step-preserves-symbols-step x₅ Rs sin 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃) , x4 , x5 , x6) 
  | it true j | o1 , o2 , o3 , o4 
  | d1 , d2 , d3 | inl x₄ 
  with exists-split d1 x1 x₄ 
... | z1 , z2 , z3  
  rewrite x6 | filterComp x1 
                (x ⟶ (o1 ++ nt (newnt Rs) ∷ o2) ∷ newnt Rs ⟶ (tm o3 ∷ []) ∷ x2) 
  | z3 
  | filterComp z1 (d1 ∷ z2) 
  | ++-th (filterAllSmbls-f d1) 
  | foldth2 z2 (filterAllSmbls-f d1) filterAllSmbls-f 
  with foldl (λ res r → filterAllSmbls-f r ++ res)
       (nt (newnt Rs) ∷ tm o3 ∷ nt x ∷ (o1 ++ nt (newnt Rs) ∷ o2) ++ [])
       x2 
  | foldl (λ res el → filterAllSmbls-f el ++ res) [] z2 
  | filterAllSmbls-f d1 
  | foldl (λ res r → filterAllSmbls-f r ++ res) [] z1 
... | a | b | c | d 
  = inTwo {_} {x₅} {(b ++ c) ++ d} {a} 
     (inFirst {_} {x₅} {b ++ c} {d} (inTwo {_} {x₅} {c} {b} d3))
nt-step-preserves-symbols-step .(nt x) Rs sin 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃) , x4 , x5 , x6) 
  | it true j 
  | o1 , o2 , o3 , o4 
  | .(x ⟶ (x₁ ∷ x₂ ∷ x₃)) , d2 , base 
  | inr base rewrite x6 
  | filterComp x1 
     (x ⟶ (o1 ++ nt (newnt Rs) ∷ o2) ∷ newnt Rs ⟶ (tm o3 ∷ []) ∷ x2) 
  | ++-th (nt (newnt Rs) ∷ tm o3 ∷ nt x ∷ (o1 ++ nt (newnt Rs) ∷ o2)) 
  | foldth2 x2 
     (nt (newnt Rs) ∷ tm o3 ∷ nt x ∷ o1 ++ nt (newnt Rs) ∷ o2) filterAllSmbls-f
  = inFirst {_} {nt x} {(foldl (λ res el → filterAllSmbls-f el ++ res) [] x2 ++
        nt (newnt Rs) ∷ tm o3 ∷ nt x ∷ o1 ++ nt (newnt Rs) ∷ o2)} 
        {foldl (λ res r → filterAllSmbls-f r ++ res) [] x1} 
        (inTwo {_} {nt x} 
          {nt (newnt Rs) ∷ tm o3 ∷ nt x ∷ o1 ++ nt (newnt Rs) ∷ o2} 
          {foldl (λ res el → filterAllSmbls-f el ++ res) [] x2} 
          (step (step base)))
nt-step-preserves-symbols-step x₅ Rs sin 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃) , x4 , x5 , x6) 
  | it true j 
  | o1 , o2 , o3 , o4 
  | .(x ⟶ (x₁ ∷ x₂ ∷ x₃)) , d2 , step d3 
  | inr base rewrite x6 
  | filterComp x1 
     (x ⟶ (o1 ++ nt (newnt Rs) ∷ o2) ∷ newnt Rs ⟶ (tm o3 ∷ []) ∷ x2) 
  | foldth2 x2 
     (nt (newnt Rs) ∷ tm o3 ∷ nt x ∷ (o1 ++ nt (newnt Rs) ∷ o2) ++ []) 
     filterAllSmbls-f 
  | o4 
  | ++-th (nt (newnt Rs) ∷ tm o3 ∷ nt x ∷ (o1 ++ nt (newnt Rs) ∷ o2)) 
  = inFirst {_} {x₅} {(foldl (λ res el → filterAllSmbls-f el ++ res) [] x2 ++
        nt (newnt Rs) ∷ tm o3 ∷ nt x ∷ (o1 ++ nt (newnt Rs) ∷ o2) )} 
        {foldl (λ res r → filterAllSmbls-f r ++ res) [] x1} 
        (inTwo {_} {x₅} 
         {nt (newnt Rs) ∷ tm o3 ∷ nt x ∷ (o1 ++ nt (newnt Rs) ∷ o2) } 
         {filterAllSmbls x2} (step (ntr-spss x₅ x o1 o3 o2 (nt (newnt Rs)) d3)))
nt-step-preserves-symbols-step x₅ Rs sin 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃) , x4 , x5 , x6) 
  | it true j 
  | o1 , o2 , o3 , o4 
  | d1 , d2 , d3 
  | inr (step x₄) 
  with exists-split d1 x2 x₄
nt-step-preserves-symbols-step x₅ Rs sin 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃) , x4 , x5 , x6) 
  | it true j 
  | o1 , o2 , o3 , o4 
  | d1 , d2 , d3 
  | inr (step x₄) 
  | z1 , z2 , z3 
  rewrite x6 
  | filterComp x1 (x ⟶ (o1 ++ nt (newnt Rs) ∷ o2) ∷ newnt Rs ⟶ (tm o3 ∷ []) ∷ x2) 
  | ++-th (nt (newnt Rs) ∷ tm o3 ∷ nt x ∷ (o1 ++ nt (newnt Rs) ∷ o2)) 
  | foldth2 x2 
     (nt (newnt Rs) ∷ tm o3 ∷ nt x ∷ o1 ++ nt (newnt Rs) ∷ o2) filterAllSmbls-f
  | z3 
  | foldlnest  z1 (d1 ∷ z2) [] (λ res el → filterAllSmbls-f el ++ res) 
  | foldth2 z2 (filterAllSmbls-f d1 ++
     foldl (λ res el → filterAllSmbls-f el ++ res) [] z1) filterAllSmbls-f 
  with foldl (λ res el → filterAllSmbls-f el ++ res) [] z2 
  | filterAllSmbls-f d1 
  | foldl (λ res el → filterAllSmbls-f el ++ res) [] z1 
  | nt (newnt Rs) ∷ tm o3 ∷ nt x ∷ o1 ++ nt (newnt Rs) ∷ o2 
  | foldl (λ res r → filterAllSmbls-f r ++ res) [] x1 
... | a | b | c | d | e   = 
  inFirst {_} {x₅} 
   {((a ++ b ++ c) ++ d)} {e} 
   (inFirst {_} {x₅} {a ++ b ++ c} {d} 
     (inTwo {_} {x₅} {b ++ c} {a} (inFirst {_} {x₅} {b} {c} d3 )))
nt-step-preserves-symbols-step x₄ Rs sin 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃) , x4 , x5 , x6) 
  | it false j rewrite x6 | x4 = sin


nt-step-preserves-symbols : ∀ x Rs n → x ∈ filterAllSmbls Rs 
                           → x ∈ filterAllSmbls (repeatOn nt-step Rs n) 
nt-step-preserves-symbols x Rs zero sin = sin
nt-step-preserves-symbols x Rs (suc n) sin 
  = nt-step-preserves-symbols-step x 
    (repeatOn nt-step Rs n) 
    (nt-step-preserves-symbols x Rs n sin)


nt-step-complete' : ∀ Rs t zs o → ListOfTs Rs (tm t ∷ zs) o 
                           → Σ[ o' ∈ Symbols ] o ≡ (tm t) ∷ o' 
nt-step-complete' Rs t zs .(tm t ∷ ys) (_∷t_ {.zs} {ys} .t lot) = ys , refl

mutual 
 nt-step-complete : ∀ Rs A xs → Tree Rs A xs → Tree (nt-step Rs) A xs
 nt-step-complete Rs A xs tree 
  with applyToFirstLem nt-step-p (nt-step-f Rs) Rs
 nt-step-complete Rs A xs tree | inl x rewrite x = tree
 nt-step-complete Rs A xs tree | inr (x1 , x2 , x ⟶ [] , x4 , () , x6)
 nt-step-complete Rs A xs tree | inr (x1 , x2 , x ⟶ (x₁ ∷ []) , x4 , () , x6)
 nt-step-complete Rs A xs tree 
   | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃) , x4 , x5 , x6) 
   with inspect (not-all-nonterminals (x₁ ∷ x₂ ∷ x₃))
 nt-step-complete Rs A xs tree 
   | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃) , x4 , x5 , x6) 
   | it false p rewrite x6 | x4 = tree
 nt-step-complete Rs A xs tree 
   | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃) , x4 , x5 , x6) 
   | it true p with not-all-nonterminals-lem (x₁ ∷ x₂ ∷ x₃) p
 nt-step-complete Rs A xs (node {ws} x₄ x₅) 
   | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃) , x4 , x5 , x6) 
   | it true p | z1 , z2 , z3 , z4 
   with nt-step-completeMut Rs ws xs x₅
 nt-step-complete Rs A xs (node {ws} x₄ x₅) 
   | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃) , x4 , x5 , x6) 
   | it true p 
   | z1 , z2 , z3 , z4 | lot 
   rewrite z4 
   with incLem {Rule} {A ⟶ ws} {x1} 
         {x ⟶ (z1 ++ tm z3 ∷ z2) ∷ x2} (subst (λ r → A ⟶ ws ∈ r) x4 x₄)
 nt-step-complete Rs A xs (node {ws} x₄ x₅) 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃) , x4 , x5 , x6) 
  | it true p 
  | z1 , z2 , z3 , z4 
  | lot 
  | inl d 
  rewrite x6 
   = node (inFirst {Rule} {A ⟶ ws} {x1} 
          {x ⟶ (z1 ++ nt (newnt Rs) ∷ z2) ∷ newnt Rs ⟶ (tm z3 ∷ []) ∷ x2}  d) 
          lot
 nt-step-complete Rs A xs₁ (node {ws} x₄ x₅) 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃) , x4 , x5 , x6) 
  | it true p 
  | z1 , z2 , z3 , z4 
  | lot 
  | inr (step d) 
  rewrite x6 
  = node (inTwo {Rule} {A ⟶ ws} 
          {x ⟶ (z1 ++ nt (newnt Rs) ∷ z2) ∷ newnt Rs ⟶ (tm z3 ∷ []) ∷ x2}
          {x1} (step (step d))) lot
 nt-step-complete Rs .x xs (node x₄ x₅) 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃) , x4 , x5 , x6) 
  | it true p 
  | z1 , z2 , z3 , z4 
  | lot 
  | inr base rewrite x6 
  with tree-div (x1 ++
       x ⟶ (z1 ++ nt (newnt Rs) ∷ z2) ∷ newnt Rs ⟶ (tm z3 ∷ []) ∷ x2) z1
        (tm z3 ∷ z2) xs lot
 nt-step-complete Rs .x xs (node x₄ x₅) 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃) , x4 , x5 , x6)
  | it true p 
  | z1 , z2 , z3 , z4 
  | lot 
  | inr base 
  | o1 , o2 , o3 , o4 , o5 rewrite (sym o5) 
  with nt-step-complete'  (x1 ++
       x ⟶ (z1 ++ nt (newnt Rs) ∷ z2) ∷ newnt Rs ⟶ (tm z3 ∷ []) ∷ x2)  
       z3 z2 o2 o4 
 nt-step-complete Rs .x xs (node x₄ x₅) 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃) , x4 , x5 , x6) 
  | it true p 
  | z1 , z2 , z3 , z4 
  | lot 
  | inr base 
  |  o1 , o2 , o3 , o4 , o5 
  |  o' , prf  rewrite prf  with o4 
 ... | (_∷t_ .z3 o4') 
  = node (inTwo {Rule} 
     {x ⟶ (z1 ++ nt (newnt Rs) ∷ z2)} 
     {x ⟶ (z1 ++ nt (newnt Rs) ∷ z2) ∷ newnt Rs ⟶ (tm z3 ∷ []) ∷ x2}
     {x1} base) 
     (lot-cont (x1 ++
       x ⟶ (z1 ++ nt (newnt Rs) ∷ z2) ∷ newnt Rs ⟶ (tm z3 ∷ []) ∷ x2) z1 o1 _ _ o3
       (_∷n_  (node (inTwo {Rule} 
                  {newnt Rs ⟶ (tm z3 ∷ [])}  
                  {x ⟶ (z1 ++ nt (newnt Rs) ∷ z2) ∷ newnt Rs ⟶ (tm z3 ∷ []) ∷ x2} 
                  {x1}  (step base)) (_∷t_  z3 ⟦⟧) ) o4'))


 nt-step-completeMut : ∀ Rs xs ys → ListOfTs Rs xs ys 
                          → ListOfTs (nt-step Rs) xs ys
 nt-step-completeMut Rs .[] .[] ⟦⟧ = ⟦⟧
 nt-step-completeMut Rs .(tm t ∷ xs) .(tm t ∷ ys) (_∷t_ {xs} {ys} t lot) 
  = _∷t_ t (nt-step-completeMut Rs xs ys lot)
 nt-step-completeMut Rs .(nt n ∷ xs) .(zs ++ ys) (_∷n_ {xs} {ys} {n} {zs} x lot) 
  = _∷n_ (nt-step-complete Rs n zs x) (nt-step-completeMut Rs xs ys lot)



newntlemcorol-ntr : ∀ Rs xs ys → (newnt Rs) ⟶ xs ∈ (nt-step Rs) 
                      → (newnt Rs) ⟶ ys ∈ (nt-step Rs) → xs ≡ ys
newntlemcorol-ntr Rs xs ys rin1 rin2 
  with applyToFirstLem nt-step-p (nt-step-f Rs) Rs
newntlemcorol-ntr Rs xs ys rin1 rin2 
  | inl x rewrite x 
  = ex-falso-quodlibet (newntlem Rs (newntlemcorol1  (newnt Rs) xs Rs rin1))
newntlemcorol-ntr Rs xs ys rin1 rin2 
  | inr (x1 , x2 , x ⟶ [] , x4 , x5 , x6) rewrite x6 
  = ex-falso-quodlibet 
     (newntlem Rs 
      (newntlemcorol1 (newnt Rs) ys Rs 
       (subst (λ r → newnt Rs ⟶ ys ∈ r) (sym x4) rin2)))
newntlemcorol-ntr Rs xs ys rin1 rin2 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ []) , x4 , x5 , x6) 
  rewrite x6 
  = ex-falso-quodlibet 
     (newntlem Rs 
      (newntlemcorol1 (newnt Rs) ys Rs 
       (subst (λ r → newnt Rs ⟶ ys ∈ r) (sym x4) rin2)))
newntlemcorol-ntr Rs xs ys rin1 rin2 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃) , x4 , x5 , x6) 
  with inspect (not-all-nonterminals (x₁ ∷ x₂ ∷ x₃))
newntlemcorol-ntr Rs xs ys rin1 rin2 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃) , x4 , x5 , x6) 
  | it false j 
  rewrite x6 
  = ex-falso-quodlibet 
    (newntlem Rs 
     (newntlemcorol1 (newnt Rs) ys Rs 
      (subst (λ r → newnt Rs ⟶ ys ∈ r) (sym x4) rin2)))
newntlemcorol-ntr Rs xs ys rin1 rin2 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃) , x4 , x5 , x6) 
  | it true j 
  with (not-all-nonterminals-lem (x₁ ∷ x₂ ∷ x₃) j) 
newntlemcorol-ntr Rs xs ys rin1 rin2 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃) , x4 , x5 , x6) 
  | it true j 
  | proj₁ , proj₂ , proj₃ , proj₄  
  with incLem {_} {newnt Rs ⟶ ys} {x1} 
        {x ⟶ (proj₁ ++ nt (newnt Rs) ∷ proj₂) ∷ newnt Rs ⟶ (tm proj₃ ∷ []) ∷ x2}
        (subst (λ r → newnt Rs ⟶ ys ∈ r) x6 rin2) 
newntlemcorol-ntr Rs xs ys rin1 rin2 
  | inr (x1 , x2 , x ⟶ (x₂ ∷ x₃ ∷ x₄) , x4 , x5 , x6) 
  | it true j 
  | proj₁ , proj₂ , proj₃ , proj₄ 
  | inl x₁ 
  = ex-falso-quodlibet 
     (newntlem Rs 
      (newntlemcorol1 (newnt Rs) ys Rs 
       (subst (λ r → newnt Rs ⟶ ys ∈ r) (sym x4) 
        (inFirst {_} {newnt Rs ⟶ ys} {x1} {x ⟶ (x₂ ∷ x₃ ∷ x₄) ∷ x2} x₁))))
newntlemcorol-ntr Rs xs .(proj₁ ++ nt (newnt Rs) ∷ proj₂) rin1 rin2 
  | inr (x1 , x2 , .(newnt Rs) ⟶ (x₂ ∷ x₃ ∷ x₄) , x4 , x5 , x6) 
  | it true j 
  | proj₁ , proj₂ , proj₃ , proj₄ 
  | inr base 
  = ex-falso-quodlibet 
    (newntlem Rs 
     (newntlemcorol1 _ _ _ 
      (subst (λ r → newnt Rs ⟶ (x₂ ∷ x₃ ∷ x₄) ∈ r) (sym x4) 
       (inTwo {_}  {newnt Rs ⟶ (x₂ ∷ x₃ ∷ x₄)} 
        {newnt Rs ⟶ (x₂ ∷ x₃ ∷ x₄) ∷ x2} {x1} base))))
newntlemcorol-ntr Rs xs ys rin1 rin2 
  | inr (x1 , x2 , x ⟶ (x₂ ∷ x₃ ∷ x₄) , x4 , x5 , x6) 
  | it true j 
  | proj₁ , proj₂ , proj₃ , proj₄ 
  | inr (step (step x₁)) 
  = ex-falso-quodlibet 
     (newntlem Rs 
      (newntlemcorol1 _ _ _ 
       (subst (λ r → newnt Rs ⟶ ys ∈ r) (sym x4) 
        (inTwo {Rule} {newnt Rs ⟶ ys} 
         {x ⟶ (x₂ ∷ x₃ ∷ x₄) ∷ x2} {x1} ((step x₁))))))
newntlemcorol-ntr Rs xs .(tm proj₃ ∷ []) rin1 rin2 
  | inr (x1 , x2 , x ⟶ (x₂ ∷ x₃ ∷ x₄) , x4 , x5 , x6) 
  | it true j 
  | proj₁ , proj₂ , proj₃ , proj₄ 
  | inr (step base) 
  with incLem {_} 
   {newnt Rs ⟶ xs} {x1} 
   {x ⟶ (proj₁ ++ nt (newnt Rs) ∷ proj₂) ∷ newnt Rs ⟶ (tm proj₃ ∷ []) ∷ x2} 
   (subst (λ r → newnt Rs ⟶ xs ∈ r) x6 rin1) 
newntlemcorol-ntr Rs xs .(tm proj₃ ∷ []) rin1 rin2 
  | inr (x1 , x2 , x ⟶ (x₂ ∷ x₃ ∷ x₄) , x4 , x5 , x6) 
  | it true j 
  | proj₁ , proj₂ , proj₃ , proj₄ 
  | inr (step base) 
  | inl x₁ 
  = ex-falso-quodlibet 
    (newntlem Rs 
     (newntlemcorol1 (newnt Rs) xs Rs 
      (subst (λ r → newnt Rs ⟶ xs ∈ r) (sym x4) 
       (inFirst {_} {newnt Rs ⟶ xs} {x1} {x ⟶ (x₂ ∷ x₃ ∷ x₄) ∷ x2} x₁))))
newntlemcorol-ntr Rs .(proj₁ ++ nt (newnt Rs) ∷ proj₂) .(tm proj₃ ∷ []) rin1 rin2
  | inr (x1 , x2 , .(newnt Rs) ⟶ (x₂ ∷ x₃ ∷ x₄) , x4 , x5 , x6) 
  | it true j 
  | proj₁ , proj₂ , proj₃ , proj₄ 
  | inr (step base) 
  | inr base 
  = ex-falso-quodlibet 
     (newntlem Rs 
      (newntlemcorol1 _ _ _ 
       (subst (λ r → newnt Rs ⟶ (x₂ ∷ x₃ ∷ x₄) ∈ r) (sym x4) 
        (inTwo {_} {newnt Rs ⟶ (x₂ ∷ x₃ ∷ x₄)} 
          {newnt Rs ⟶ (x₂ ∷ x₃ ∷ x₄) ∷ x2} {x1} base))))
newntlemcorol-ntr Rs xs .(tm proj₃ ∷ []) rin1 rin2 
  | inr (x1 , x2 , x ⟶ (x₂ ∷ x₃ ∷ x₄) , x4 , x5 , x6) 
  | it true j 
  | proj₁ , proj₂ , proj₃ , proj₄ 
  | inr (step base) 
  | inr (step (step x₁)) 
  = ex-falso-quodlibet 
     (newntlem Rs 
      (newntlemcorol1 _ _ _ 
       (subst (λ r → newnt Rs ⟶ xs ∈ r) (sym x4) 
        (inTwo {_} {newnt Rs ⟶ xs} 
         {x ⟶ (x₂ ∷ x₃ ∷ x₄) ∷ x2} {x1} ((step x₁))))))
newntlemcorol-ntr Rs .(tm proj₃ ∷ []) .(tm proj₃ ∷ []) rin1 rin2 
  | inr (x1 , x2 , x ⟶ (x₂ ∷ x₃ ∷ x₄) , x4 , x5 , x6) 
  | it true j 
  | proj₁ , proj₂ , proj₃ , proj₄ 
  | inr (step base) 
  | inr (step base) = refl


allinlem1 : ∀ X xs ys zs →  AllInG {X} (xs ++ ys) zs → AllInG xs zs
allinlem1 X [] ys zs allin = all_c1
allinlem1 X (x ∷ xs) ys zs (all_c2 allin x₁) 
  = all_c2 (allinlem1 X xs ys zs allin) x₁

allinlem2 : ∀ X xs ys zs →  AllInG {X} (xs ++ ys) zs → AllInG ys zs
allinlem2 X [] ys zs allin = allin
allinlem2 X (x ∷ xs) ys zs (all_c2 allin x₁) = allinlem2 X xs ys zs allin


mutual 
 nt-step-sound : ∀ Rs A xs → Tree (nt-step Rs) A xs 
                 → (nt A) ∈ (filterAllSmbls Rs) → Tree Rs A xs
 nt-step-sound Rs A xs (node x x₁) oldp 
  with applyToFirstLem nt-step-p (nt-step-f Rs) Rs 
 nt-step-sound Rs A xs  (node x₁ x₂) oldp 
  | inl x rewrite x = node x₁ x₂
 nt-step-sound Rs A xs  (node x₂ x₃) oldp 
  | inr (x1 , x2 , x ⟶ [] , x4 , x5 , x6) rewrite x6 
  | (sym x4) =  node x₂ x₃
 nt-step-sound Rs A xs  (node x₃ x₄) oldp 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ []) , x4 , x5 , x6) rewrite x6 
  | (sym x4) = node x₃ x₄
 nt-step-sound Rs A xs  (node x₄ x₅) oldp 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃) , x4 , x5 , x6)  
  with inspect (not-all-nonterminals (x₁ ∷ x₂ ∷ x₃))
 nt-step-sound Rs A xs  (node x₅ x₆) oldp 
  | inr (x1 , x2 , x₄ ⟶ (x₁ ∷ x₂ ∷ x₃) , x4 , x5 , x6) 
  | it false x  rewrite x with x5 
 ... | ()
 nt-step-sound Rs A xs  (node {ws} x₅ x₆) oldp 
  | inr (x1 , x2 , x₄ ⟶ (x₁ ∷ x₂ ∷ x₃) , x4 , x5 , x6) 
  | it true x 
  with (not-all-nonterminals-lem (x₁ ∷ x₂ ∷ x₃) x)
 nt-step-sound Rs A xs  (node {ws} x₅ x₆) oldp 
  | inr (x1 , x2 , x₄ ⟶ (x₁ ∷ x₂ ∷ x₃) , x4 , x5 , x6) 
  | it true x 
  | p1 , p2 , p3 , p4 
  with incLem {Rule} {A ⟶ ws} {x1} 
        {x₄ ⟶ (p1 ++ nt (newnt Rs) ∷ p2) ∷ newnt Rs ⟶ (tm p3 ∷ []) ∷ x2} 
        (subst (λ r → A ⟶ ws ∈ r) x6 x₅ ) 
 nt-step-sound Rs A xs₁ (node {ws} x₅ x₇) oldp 
  | inr (x1 , x2 , x₄ ⟶ (x₁ ∷ x₂ ∷ x₃) , x4 , x5 , x6) 
  | it true x₆ 
  | p1 , p2 , p3 , p4 
  | inl x 
  = node (subst (λ r → A ⟶ ws ∈ r) (sym x4) 
          (inFirst {Rule} {A ⟶ ws} {x1} {x₄ ⟶ (x₁ ∷ x₂ ∷ x₃) ∷ x2} x)) 
         (nt-step-soundMut Rs ws xs₁ x₇ (
          filterAllSmblsLem1 A ws Rs 
          (subst (λ r → A ⟶ ws ∈ r) (sym x4) 
           (inFirst {Rule} {A ⟶ ws} {x1} {x₄ ⟶ (x₁ ∷ x₂ ∷ x₃) ∷ x2} x))))


 nt-step-sound Rs .(newnt Rs) xs₁  (node x₅ x₇) oldp 
  | inr (x1 , x2 , x₄ ⟶ (x₁ ∷ x₂ ∷ x₃) , x4 , x5 , x6) 
  | it true x₆ 
  | p1 , p2 , p3 , p4 
  | inr (step base) = ex-falso-quodlibet (newntlem Rs oldp)

 nt-step-sound Rs A xs₁  (node {ws} x₅ x₇) oldp 
  | inr (x1 , x2 , x₄ ⟶ (x₁ ∷ x₂ ∷ x₃) , x4 , x5 , x6) 
  | it true x₆ 
  | p1 , p2 , p3 , p4 
  | inr (step (step x)) 
  = node 
    (subst (λ r → A ⟶ ws ∈ r) (sym x4) 
     (inTwo {Rule} {A ⟶ ws} {x₄ ⟶ (x₁ ∷ x₂ ∷ x₃) ∷ x2} {x1} (step x))) 
     (nt-step-soundMut Rs ws xs₁  x₇ 
      (filterAllSmblsLem1 A ws Rs 
       ((subst (λ r → A ⟶ ws ∈ r) (sym x4) 
        (inTwo {Rule} {A ⟶ ws} {x₄ ⟶ (x₁ ∷ x₂ ∷ x₃) ∷ x2} {x1} (step x))))))
 nt-step-sound Rs .x₄ ys  (node x₅ x₇) oldp 
  | inr (x1 , x2 , x₄ ⟶ (x₁ ∷ x₂ ∷ x₃) , x4 , x5 , x6) 
  | it true x₆ 
  |  p1 , p2 , p3 , p4 
  | inr base rewrite p4 
  = node 
    (subst (λ r → x₄ ⟶ (p1 ++ tm p3 ∷ p2) ∈ r) (sym x4) 
    (inTwo {Rule} {x₄ ⟶ (p1 ++ tm p3 ∷ p2)} 
     {x₄ ⟶ (p1 ++ tm p3 ∷ p2) ∷ x2} {x1}  base)) 
    (nt-step-soundMut' Rs p1 p2 p3 ys 
     (subst (λ r → newnt Rs ⟶ (tm p3 ∷ []) ∈ r) (sym x6) 
    (inTwo {Rule} {newnt Rs ⟶ (tm p3 ∷ [])} 
     {x₄ ⟶ (p1 ++ nt (newnt Rs) ∷ p2) ∷ newnt Rs ⟶ (tm p3 ∷ []) ∷ x2} 
     {x1} (step base))) x₇ 
     (allinlem1 _ p1 _ (filterAllSmbls Rs) 
       (filterAllSmblsLem1 x₄ (p1 ++ tm p3 ∷ p2) Rs 
     (subst (λ r →  x₄ ⟶ (p1 ++ tm p3 ∷ p2) ∈ r) (sym x4) 
      (inTwo {Rule} {x₄ ⟶ (p1 ++ tm p3 ∷ p2)} 
       {x₄ ⟶ (p1 ++ tm p3 ∷ p2) ∷ x2} {x1} base)))) 
      (allindum _ (tm p3) _ _ (allinlem2 _ p1 (tm p3 ∷ p2) 
       (filterAllSmbls Rs) 
       (filterAllSmblsLem1 x₄ (p1 ++ tm p3 ∷ p2) Rs 
       (subst (λ r →  x₄ ⟶ (p1 ++ tm p3 ∷ p2) ∈ r) (sym x4) 
      (inTwo {Rule} {x₄ ⟶ (p1 ++ tm p3 ∷ p2)} 
       {x₄ ⟶ (p1 ++ tm p3 ∷ p2) ∷ x2} {x1} base))))))
   where
    allindum : ∀ X x xs ys → AllInG {X} (x ∷ xs) ys → AllInG xs ys
    allindum X x xs ys₁ (all_c2 allin x₈) = allin

 nt-step-soundMut' : ∀ Rs xs1 xs2 p3 ys  
   → newnt Rs ⟶ (tm p3 ∷ []) ∈ (nt-step Rs)  
   → ListOfTs (nt-step Rs)   (xs1 ++ [ nt (newnt Rs) ] ++ xs2) ys 
   → AllInG xs1 (filterAllSmbls Rs) 
   → AllInG xs2 (filterAllSmbls Rs) 
   → ListOfTs Rs (xs1 ++ tm p3 ∷ xs2) ys
 nt-step-soundMut' Rs [] xs2 p3 .(zs ++ ys) rin (_∷n_ {.xs2} {ys} 
  {.(newnt Rs)} {zs} (node {ws} x x₁) lot1) allin1 allin2 
  with newntlemcorol-ntr Rs ws (tm p3 ∷ []) x rin 
 nt-step-soundMut' Rs [] xs2 p3 .((tm p3 ∷ []) ++ ys) rin 
  (_∷n_ {.xs2} {ys} (node x (.p3 ∷t ⟦⟧)) lot1) allin1 allin2 
  | refl = _∷t_ p3 (nt-step-soundMut Rs xs2 ys lot1 allin2)
 nt-step-soundMut' Rs (tm x ∷ xs1) xs2 p3 .(tm x ∷ ys) rin 
  (_∷t_ {.(xs1 ++ nt (newnt Rs) ∷ xs2)} {ys} .x lot1) (all_c2 allin1 x₁) allin2 
  = _∷t_ x (nt-step-soundMut' Rs xs1 xs2 p3 ys rin lot1 allin1 allin2)
 nt-step-soundMut' Rs (nt x ∷ xs1) xs2 p3 .(zs ++ ys) rin 
  (_∷n_ {.(xs1 ++ nt (newnt Rs) ∷ xs2)} {ys} {.x} {zs} x₁ lot1) 
  (all_c2 allin1 x₂) allin2 
  = _∷n_ (nt-step-sound Rs x zs x₁ x₂) 
   (nt-step-soundMut' Rs xs1 xs2 p3 ys rin lot1 allin1 allin2)

 nt-step-soundMut : ∀ Rs xs ys → ListOfTs (nt-step Rs)  xs ys 
              → AllInG xs (filterAllSmbls Rs)  → ListOfTs Rs xs ys
 nt-step-soundMut Rs .[] .[] ⟦⟧ allin = ⟦⟧
 nt-step-soundMut Rs .(tm t ∷ xs) .(tm t ∷ ys) 
   (_∷t_ {xs} {ys} t lot) (all_c2 allin x) 
   = _∷t_ t (nt-step-soundMut Rs xs ys lot allin)
 nt-step-soundMut Rs .(nt n ∷ xs) .(zs ++ ys) 
  (_∷n_ {xs} {ys} {n} {zs} x lot) (all_c2 allin x₁) 
   = _∷n_ (nt-step-sound Rs n zs x x₁) (nt-step-soundMut Rs xs ys  lot  allin)


not-all-nontermlem : ∀ ws → not-all-nonterminals ws ≡ false 
                                       → ntr-length-f ws ≡ 0
not-all-nontermlem [] eq = refl
not-all-nontermlem (tm x ∷ ws) ()
not-all-nontermlem (nt x ∷ ws) eq = not-all-nontermlem ws eq


nt-step-f-lem : ∀ Rs A ws → 2 ≤ length ws → not-all-nonterminals ws ≡ true 
  → Σ[ r1 ∈ Rule ] 
    Σ[ r2 ∈ Rule ] nt-step-f Rs (A ⟶ ws) ≡ (r1 ∷ r2 ∷ []) 
nt-step-f-lem Rs A [] () eq
nt-step-f-lem Rs A (x ∷ []) (s≤s ()) eq
nt-step-f-lem Rs A (tm x ∷ x₁ ∷ ws) lss eq 
  = A ⟶ (nt (newnt Rs) ∷ x₁ ∷ ws) , newnt Rs ⟶ (tm x ∷ [])  , refl 
nt-step-f-lem Rs A (nt x ∷ tm x₁ ∷ []) lss eq 
  = _ , _ , refl
nt-step-f-lem Rs A (nt x ∷ nt x₁ ∷ []) lss ()
nt-step-f-lem Rs A (nt x ∷ x₁ ∷ x₂ ∷ ws) lss eq 
  with inspect (not-all-nonterminals (x₁ ∷ x₂ ∷ ws)) 
nt-step-f-lem Rs A (nt x₃ ∷ x₁ ∷ x₂ ∷ ws) lss eq | it true x 
  = A ⟶ (nt x₃ ∷ proj₁ (not-all-nonterminals-lem (x₁ ∷ x₂ ∷ ws) x) ++
       nt (newnt Rs) ∷
       proj₁ (proj₂ (not-all-nonterminals-lem (x₁ ∷ x₂ ∷ ws) x))) , newnt Rs ⟶
      (tm
       (proj₁ (proj₂ (proj₂ (not-all-nonterminals-lem (x₁ ∷ x₂ ∷ ws) x))))
       ∷ []) , refl
nt-step-f-lem Rs A (nt x₃ ∷ x₁ ∷ x₂ ∷ ws) lss eq 
    | it false x rewrite eq with x
... | ()


ntr-lengthDec' : (Rs : Rules)(f : Rule → Rules) 
  → Rs ≡ applyToFirst nt-step-p f Rs 
  → (∀ A ws →  2 ≤ length ws 
  → not-all-nonterminals ws ≡ true 
  → Σ[ r1 ∈ Rule ] 
    Σ[ r2 ∈ Rule ] f (A ⟶ ws) ≡ (r1 ∷ r2 ∷ [])) 
  → ntr-length Rs ≡ 0
ntr-lengthDec' [] f eq pr = refl
ntr-lengthDec' (x ⟶ [] ∷ Rs) f eq pr 
  = ntr-lengthDec' Rs f (cong (drop 1) eq) pr
ntr-lengthDec' (x ⟶ (x₁ ∷ []) ∷ Rs) f eq pr 
  = ntr-lengthDec' Rs f (cong (drop 1) eq) pr
ntr-lengthDec' (x ⟶ (x₁ ∷ x₂ ∷ x₃) ∷ Rs) f eq pr 
  with inspect (not-all-nonterminals (x₁ ∷ x₂ ∷ x₃))
ntr-lengthDec' (x ⟶ (x₁ ∷ x₂ ∷ x₃) ∷ Rs) f eq pr 
  | it true j 
  rewrite j with pr x (x₁ ∷ x₂ ∷ x₃) (s≤s (s≤s z≤n)) j 
ntr-lengthDec' (x ⟶ (x₁ ∷ x₂ ∷ x₃) ∷ Rs) f eq pr 
  | it true j | o1 , o2 , o3  rewrite o3 with eq 
... | ()
ntr-lengthDec' (x ⟶ (x₁ ∷ x₂ ∷ x₃) ∷ Rs) f eq pr 
  | it false j 
  rewrite j 
  | ntr-lengthDec' Rs f (cong (drop 1) eq) pr 
  | not-all-nontermlem (x₁ ∷ x₂ ∷ x₃) j = refl


ntr-length-len : ∀ A ws → 2 ≤ length ws 
             → ntr-length [ A ⟶ ws ] ≡ ntr-length-f ws
ntr-length-len A [] ()
ntr-length-len A (x ∷ []) (s≤s ())
ntr-length-len A (x ∷ x₁ ∷ ws) lss = a+0 _


ntr-length-comp : ∀ xs ys 
  → ntr-length (xs ++ ys) ≡ ntr-length xs + ntr-length ys
ntr-length-comp [] ys = refl
ntr-length-comp (x ⟶ [] ∷ xs) ys = ntr-length-comp xs ys
ntr-length-comp (x ⟶ (x₁ ∷ []) ∷ xs) ys = ntr-length-comp xs ys
ntr-length-comp (x ⟶ (x₁ ∷ x₂ ∷ x₃) ∷ xs) ys 
  rewrite ntr-length-comp xs ys 
  = +-ass (ntr-length-f (x₁ ∷ x₂ ∷ x₃)) (ntr-length xs) (ntr-length ys)


ntr-length-f-comp : ∀ xs ys 
  → ntr-length-f (xs ++ ys) ≡ ntr-length-f xs + ntr-length-f ys 
ntr-length-f-comp [] ys = refl
ntr-length-f-comp (tm x ∷ xs) ys 
  rewrite ntr-length-f-comp xs ys = refl
ntr-length-f-comp (nt x ∷ xs) ys = ntr-length-f-comp xs ys


ntr-lengthDec : (Rs : Rules) → (n : ℕ) → ntr-length Rs ≡ suc n
                                  → ntr-length (nt-step Rs) ≡ n
ntr-lengthDec Rs n eq 
  with applyToFirstLem nt-step-p (nt-step-f Rs) Rs
ntr-lengthDec Rs n eq 
  | inl x rewrite x  
  with ntr-lengthDec' Rs (nt-step-f Rs) (sym x) (nt-step-f-lem Rs) 
... | o rewrite o with eq
... | ()
ntr-lengthDec .(x1 ++ x ⟶ [] ∷ x2) n eq 
    | inr (x1 , x2 , x ⟶ [] , refl , x5 , x6) 
    rewrite x6 
    with ntr-lengthDec' (x1 ++ x ⟶ [] ∷ x2) 
    (nt-step-f (x1 ++ x ⟶ [] ∷ x2)) (sym x6) 
    (nt-step-f-lem (x1 ++ x ⟶ [] ∷ x2))
... | o rewrite o with eq
... | ()
ntr-lengthDec .(x1 ++ x ⟶ (x₁ ∷ []) ∷ x2) n eq 
    | inr (x1 , x2 , x ⟶ (x₁ ∷ []) , refl , x5 , x6)
    rewrite x6 
    with ntr-lengthDec' (x1 ++ x ⟶ (x₁ ∷ []) ∷ x2) 
          (nt-step-f (x1 ++ x ⟶ (x₁ ∷ []) ∷ x2)) (sym x6) 
          (nt-step-f-lem (x1 ++ x ⟶ (x₁ ∷ []) ∷ x2)) 
... | o rewrite o with eq
... | ()
ntr-lengthDec .(x1 ++ x ⟶ (x₁ ∷ x₂ ∷ x₃) ∷ x2) n eq 
  | inr (x1 , x2 , x ⟶ (x₁ ∷ x₂ ∷ x₃) , refl , x5 , x6) 
  with inspect ((not-all-nonterminals (x₁ ∷ x₂ ∷ x₃))) 
ntr-lengthDec .(x1 ++ x₄ ⟶ (x₁ ∷ x₂ ∷ x₃) ∷ x2) n eq 
  | inr (x1 , x2 , x₄ ⟶ (x₁ ∷ x₂ ∷ x₃) , refl , x5 , x6) 
  | it false x rewrite x with x5 
... 
  | ()
ntr-lengthDec .(x1 ++ x₄ ⟶ (x₁ ∷ x₂ ∷ x₃) ∷ x2) n eq 
  | inr (x1 , x2 , x₄ ⟶ (x₁ ∷ x₂ ∷ x₃) , refl , x5 , x6) 
  | it true x with not-all-nonterminals-lem (x₁ ∷ x₂ ∷ x₃) x
ntr-lengthDec .(x1 ++ x₄ ⟶ (x₁ ∷ x₂ ∷ x₃) ∷ x2) n eq 
  | inr (x1 , x2 , x₄ ⟶ (x₁ ∷ x₂ ∷ x₃) , refl , x5 , x6) 
  | it true x 
  | p1 , p2 , p3 , p4 
 rewrite p4 
  | x6 
  | sym p4 
  | ntr-length-comp x1 ((x₄ ⟶ (x₁ ∷ x₂ ∷ x₃) ∷ x2)) 
  | p4 
  | ntr-length-f-comp p1 (tm p3 ∷ p2) 
  | ntr-length-comp x1 
     (x₄ ⟶ (p1 ++ nt (newnt (x1 ++ x₄ ⟶ (p1 ++ tm p3 ∷ p2) ∷ x2)) ∷ p2) ∷
       newnt (x1 ++ x₄ ⟶ (p1 ++ tm p3 ∷ p2) ∷ x2) ⟶ (tm p3 ∷ []) ∷ x2)
  | ntr-length-comp 
    [ x₄ ⟶ (p1 ++ nt (newnt (x1 ++ x₄ ⟶ (p1 ++ tm p3 ∷ p2) ∷ x2)) ∷ p2) ] 
    (newnt (x1 ++ x₄ ⟶ (p1 ++ tm p3 ∷ p2) ∷ x2) ⟶ (tm p3 ∷ []) ∷ x2) 
    with ntr-length-len x₄ 
         (p1 ++ nt (newnt (x1 ++ x₄ ⟶ (p1 ++ tm p3 ∷ p2) ∷ x2)) ∷ p2) 
         (lss2  2 p1 p2  (tm p3)
         (nt (newnt (x1 ++ x₄ ⟶ (p1 ++ tm p3 ∷ p2) ∷ x2)))
         (subst (λ r → 2 ≤ length r) p4 (s≤s (s≤s z≤n))))
... | o rewrite o 
    | ntr-length-f-comp p1 
      (nt (newnt (x1 ++ x₄ ⟶ (p1 ++ tm p3 ∷ p2) ∷ x2)) ∷ p2) 
    | +-com (ntr-length-f p1) 
      (suc (ntr-length-f p2))  
    | +-com (ntr-length x1) 
      (suc (ntr-length-f p2 + ntr-length-f p1 + ntr-length x2)) 
    | +-com (ntr-length-f p2) (ntr-length-f p1) 
    | +-com (ntr-length-f p1 + ntr-length-f p2 + ntr-length x2) 
      (ntr-length x1) 
    = cong pred eq


ntr-norm' : (x : List Rule) → ntr-length x ≡ 0
      → ntr-length (nt-step x) ≡ 0
ntr-norm' x eq 
  with applyToFirstLem (nt-step-p) (nt-step-f x) x
ntr-norm' x eq 
  | inl x₁ rewrite x₁ = eq
ntr-norm' x eq 
  | inr (x1 , x2 , x₁ ⟶ [] , x4 , () , x6)
ntr-norm' x eq 
  | inr (x1 , x2 , x₁ ⟶ (x₂ ∷ []) , x4 , () , x6)
ntr-norm' x eq 
  | inr (x1 , x2 , x₁ ⟶ (x₂ ∷ x₃ ∷ x₄) , x4 , x5 , x6) 
  with inspect (not-all-nonterminals (x₂ ∷ x₃ ∷ x₄)) 
ntr-norm' x eq 
  | inr (x1 , x2 , x₁ ⟶ (x₂ ∷ x₃ ∷ x₄) , x4 , x5 , x6) 
  | it true j 
  with (not-all-nonterminals-lem (x₂ ∷ x₃ ∷ x₄) j) 
... | p1 , p2 , p3 , p4 
  rewrite x6 | x4 
  | ntr-length-comp x1 (x₁ ⟶ (x₂ ∷ x₃ ∷ x₄) ∷ x2) 
  | p4 | ntr-length-f-comp p1 (tm p3 ∷ p2) 
  | +-com (ntr-length-f p1) (suc (ntr-length-f p2)) 
  | +-com (ntr-length x1) 
          (suc (ntr-length-f p2 + ntr-length-f p1 + ntr-length x2)) 
  with eq
... | ()
ntr-norm' x eq 
  | inr (x1 , x2 , x₁ ⟶ (x₂ ∷ x₃ ∷ x₄) , x4 , x5 , x6) 
  | it false j rewrite x6 | x4 = eq


ntr-normalization1 : ∀ Rs n →
  ntr-length (repeatOn nt-step Rs n) ≡ (ntr-length Rs) ∸ n
ntr-normalization1 Rs n 
  = tozero Rs n ntr-length nt-step ntr-lengthDec ntr-norm'


full-ntr-completeness : ∀ Rs A xs n → Tree Rs A xs 
                      → Tree (repeatOn nt-step Rs n) A xs
full-ntr-completeness Rs A xs zero tree = tree
full-ntr-completeness Rs A xs (suc n) tree 
  = nt-step-complete _ _ _ (full-ntr-completeness Rs A xs n tree)



full-ntr-soundness : ∀ Rs A xs n → Tree (repeatOn nt-step Rs n) A xs 
                          → (nt A) ∈ (filterAllSmbls Rs) → Tree Rs A xs
full-ntr-soundness Rs A xs zero tree rin = tree
full-ntr-soundness Rs A xs (suc n) tree rin 
  = full-ntr-soundness Rs A xs n 
    (nt-step-sound _ _ _ tree (nt-step-preserves-symbols (nt A) Rs n rin)) rin


full-normalization : ∀ Rs → 
   ntr-length (repeatOn nt-step Rs (ntr-length Rs)) ≡ 0
full-normalization Rs 
  = trans (ntr-normalization1 Rs (ntr-length Rs)) (-self (ntr-length Rs)) 


ntr-length-lem' : ∀ ws →  ntr-length-f ws ≡ 0 
                → not-all-nonterminals ws ≡ false
ntr-length-lem' [] eq = refl
ntr-length-lem' (tm x ∷ []) ()
ntr-length-lem' (tm x ∷ x₁ ∷ ws) ()
ntr-length-lem' (nt x ∷ ws) eq = ntr-length-lem' ws eq


ntr-length-lem'' : ∀ a as →  ntr-length (a ∷ as) ≡ 0 → ntr-length as ≡ 0
ntr-length-lem'' (x ⟶ []) as eq = eq
ntr-length-lem'' (x ⟶ (x₁ ∷ [])) as eq = eq
ntr-length-lem'' (x ⟶ (x₁ ∷ x₂ ∷ x₃)) as eq 
  = b+a (ntr-length-f (x₁ ∷ x₂ ∷ x₃)) (ntr-length as) eq


ntr-length-lem :  (Rs : Rules) → (w₁ w₂ : Symbol) → (A : N) → (ws : Symbols)
  → ntr-length Rs ≡ 0 → (A ⟶ (w₁ ∷ w₂ ∷ ws)) ∈ Rs
  → not-all-nonterminals (w₁ ∷ w₂ ∷ ws) ≡ false
ntr-length-lem .(A ⟶ (w₁ ∷ w₂ ∷ ws) ∷ as) w₁ w₂ A ws len 
  (base {.(A ⟶ (w₁ ∷ w₂ ∷ ws))} {as}) 
  = ntr-length-lem'  (w₁ ∷ w₂ ∷ ws) (a+b _ (ntr-length as) len) 
ntr-length-lem .(x ⟶ x₁ ∷ as) w₁ w₂ A ws len 
  (step {.(A ⟶ (w₁ ∷ w₂ ∷ ws))} {x ⟶ x₁} {as} rin) 
  = ntr-length-lem as w₁ w₂ A ws (ntr-length-lem'' (x ⟶ x₁) as len) rin




norm-t : Rules → Rules
norm-t Rs = (repeatOn nt-step Rs (ntr-length Rs))

nt-snd : ∀ Rs A xs → Tree (norm-t Rs) A xs 
                          → (nt A) ∈ (filterAllSmbls Rs) → Tree Rs A xs
nt-snd Rs A xs = full-ntr-soundness Rs A xs (ntr-length Rs)

nt-cmplt : ∀ Rs A xs → Tree Rs A xs → Tree (norm-t Rs) A xs 
nt-cmplt Rs A xs = full-ntr-completeness Rs A xs (ntr-length Rs)

nt-progress : ∀ Rs A ws → A ⟶ ws ∈ norm-t Rs 
  → ((ws ≡ []) ∨ (Σ[ t ∈ T ] ws ≡ (tm t) ∷ [])) ∨ 
    (not-all-nonterminals ws ≡ false)
nt-progress Rs A [] rin = inl (inl refl)
nt-progress Rs A (tm x ∷ []) rin = inl (inr (x , refl))
nt-progress Rs A (nt x ∷ []) rin = inr refl
nt-progress Rs A (x ∷ x₁ ∷ ws) rin 
  = inr (ntr-length-lem 
    (repeatOn nt-step Rs (ntr-length Rs)) x x₁ A ws (full-normalization Rs)  rin)
