
open import Relation.Binary
open import Relation.Nullary.Core
open import Relation.Binary.PropositionalEquality 
            hiding ([_])
open import Data.List
open import ListsAddition


module Nullable (N T : Set)(_=n_ : Decidable (_≡_ {A = N}))(_=t_ : Decidable (_≡_ {A = T})) where

open import Data.Nat  hiding (_≟_)
open import Data.Bool hiding (_≟_ ; _∨_)
open import Data.Product

open import Logic

open import TopDownTree N T _=n_ _=t_
open import NullableUtility N T _=n_ _=t_

null-f : List N → Rule → List N
null-f  rec (x ⟶ x₁) = if allIn x₁ rec then [ x ]  else []


-- paper version nlbls'
nlbls′ : Rules → ℕ → List N
nlbls′ rs zero = start rs
  where
    start : Rules → List N
    start (r ∷ rs) = null-f [] r ++ start rs 
    start [] = []
nlbls′ rs (suc n) = collect (nlbls′ rs n)
  where   
    collect : List N → List N
    collect rec = foldl (λ res r → (null-f rec r) ++ res)  [] rs


nlbls : Rules → ℕ → List N
nlbls rs (suc n)     
  = foldl (λ res r → (null-f (nlbls rs n) r) ++ res)  [] rs
nlbls (r ∷ rs) zero  = null-f [] r ++ nlbls rs zero
nlbls [] n = []

-- both versions of nullables 
prf12 : ∀ rs n → nlbls rs n ≡ nlbls′ rs n
prf12 [] zero = refl
prf12 (x ∷ rs) zero rewrite prf12 rs zero = refl
prf12 [] (suc n) = refl
prf12 rs (suc n) rewrite prf12 rs n = refl

-- takes list of rules and returns list of nullable nonterminals
-- O(n*n) where n = length Rs
nullables : Rules → List N
nullables Rs = nlbls Rs (length Rs)
