open import Relation.Binary
open import Relation.Nullary.Core
open import Relation.Binary.PropositionalEquality 
            hiding ([_] ; inspect)
open import Data.List
open import ListsAddition

module NullableSound (N T : Set)(_=n_ : Decidable (_≡_ {A = N}))(_=t_ : Decidable (_≡_ {A = T})) where


open import Data.Nat hiding (_≟_)
open import Data.Bool hiding (_∨_ ; _≟_)
open import Data.Product

open import ListProperties
open DecExistance hiding (_∈?_)

open import Logic
open WF<

open import TopDownTree N T _=n_ _=t_
open import Nullable N T _=n_ _=t_
open import NullableUtility N T _=n_ _=t_



mutual 
 addRule : {R : Rules}{A B : N}{xs ws : Symbols} → Tree R A xs 
                                        → Tree (B ⟶ ws ∷ R) A xs
 addRule {R} {A} {B} {xs} {ws} (node {xs₁} x x₁) 
   = node (step x) (addRule'  {R} {B} {xs} {_} {ws}  x₁)
 

 addRule' : {R : Rules}{B : N}{ys xs ws : Symbols} 
   → ListOfTs R xs ys → ListOfTs (B ⟶ ws ∷ R) xs ys
 addRule' ⟦⟧ = ⟦⟧
 addRule' {R} {B} (t ∷t l) = t ∷t addRule' {R}  {B} l
 addRule' {R}  {B} (x ∷n l) = _∷n_ (addRule x) (addRule' {R} {B} l)


soundZ : {A : N}(R : Rules) → A ∈ nlbls R 0 → (A ⟶ []) ∈ R
soundZ [] ()
soundZ {A} (x ∷ R) p with incLem  {N} {A} {null-f [] x} {nlbls R 0}  p 
soundZ (x ⟶ x₁ ∷ R) p | inl x₂ with inspect (allIn x₁ [])
... | it true p1 rewrite p1 | incSngl x₂ | allInEmpt x₁ p1 = base
... | it false p1 rewrite p1 with x₂
... | ()
soundZ {A} (x ∷ R) p | inr x₁ = step (soundZ {A} R x₁)

open import NatProperties
-- Big troubles with termination because of the non-existance of
-- sub-runs of the run (solved by inner induction on AllIn structure)
mutual
  sound : {A : N}(n : ℕ) →  WF.Acc _<_ n → (R : Rules) 
                         → A ∈ nlbls R n → Tree R A []
  sound zero wf [] ()
  sound {A} zero wf (x ⟶ x₁ ∷ R) p 
    with incLem {_} {A} 
         {(if allIn x₁ [] then x ∷ [] else [])} 
         {nlbls R 0} p
  sound {A} zero wf (x ⟶ x₁ ∷ R) p 
   | inl e with inspect (allIn x₁ [])
  sound {A} zero wf (x ⟶ x₁ ∷ R) p 
   | inl e 
   | it true p1 rewrite allInEmpt x₁ p1 
   | incSngl  e = node base ⟦⟧
  sound {A} zero wf (x ⟶ x₁ ∷ R) p 
   | inl e 
   | it false p1 rewrite p1 with e
  ... 
   | ()
  sound {A} zero wf (x ⟶ x₁ ∷ R) p 
   | inr e = node (step (soundZ R e)) ⟦⟧
  sound {A} (suc n) wf [] ()
  sound {A} (suc n) wf (r ∷ R) p 
    with foldlth N (_=n_) A (r ∷ R) 
         (null-f (nlbls (r ∷ R) n)) p
  sound {A} (suc n) wf (r ∷ R) p  
   | B ⟶ ws , proj2 , proj3 
    with inspect 
         (allIn ws (nlbls (r ∷ R) n))
  sound {A} (suc n) wf (r ∷ R) p  
   | B ⟶ ws , proj2 , proj3 
   | it false p1 rewrite p1 with proj3
  ... | ()
  sound {A} (suc n) (acc wf) (r ∷ R) p  
   | B ⟶ ws , proj2 , proj3 
   | it true p1 
   with allInSound ws (nlbls (r ∷ R) n) p1 
  sound (suc n) (WF.acc wf) (r ∷ R) p 
   | B ⟶ .[] , proj2 , proj3 
   | it true p1 
   | all_c1 rewrite incSngl proj3 = node proj2 ⟦⟧
  sound (suc n) (WF.acc wf) (r ∷ R) p 
   | B ⟶ .(nt x ∷ xs) , proj2 , proj3 
   | it true p1 
   | all_c2 {x} {xs} q x₁ with sound n (wf n (refl≤ (suc n))) (r ∷ R) x₁  
   | sound' n (wf n (refl≤ (suc n))) xs (r ∷ R) q
  sound (suc n) (WF.acc wf) (r ∷ R) p 
   | B ⟶ .(nt x ∷ xs) , proj2 , proj3 
   | it true p1 
   | all_c2 {x} {xs} q x₁ 
   | d  
   | tree 
   with x ∈? nlbls (r ∷ R) n ∧ 
        allIn xs (nlbls (r ∷ R) n)
  sound (suc n) (WF.acc wf) (r ∷ R) p 
   | B ⟶ .(nt x ∷ xs) , proj2 , proj3 
   | it true p1 
   | all_c2 {x} {xs} q x₁ 
   | d  
   | tree 
   | true rewrite incSngl proj3 = node proj2 (_∷n_ d tree)
  sound (suc n) (WF.acc wf) (r ∷ R) p 
   | B ⟶ .(nt x ∷ xs) , proj2 , proj3 
   | it true p1 
   | all_c2 {x} {xs} q x₁ 
   | d  
   | tree 
   | false with proj3
  ... | () 


  sound' : (n : ℕ) → WF.Acc _<_ n → (ws : Symbols) →  (R : Rules) 
                     →  AllIn ws (nlbls R n)  → ListOfTs R ws []
  sound' n wf .[] R all_c1 = ⟦⟧
  sound' n wf .(nt x ∷ xs) R (all_c2 {x} {xs} ai x₁) 
    = _∷n_ (sound n wf R x₁) (sound' n wf xs R ai)


nlbls-snd :  {A : N}(n : ℕ) → (R : Rules) 
             → A ∈ nlbls R n → Tree R A []
nlbls-snd n R c = sound n (<-ℕ-wf n) R c


