
open import Relation.Binary
open import Relation.Nullary.Core
open import Relation.Binary.PropositionalEquality 
            hiding ([_])
open import Data.List
open import ListsAddition



module NullableUtility (N T : Set)(_=n_ : Decidable (_≡_ {A = N}))(_=t_ : Decidable (_≡_ {A = T})) where

open import Data.Bool hiding (_≟_ ; _∨_)
open import Data.Product

open import Logic
open import TopDownTree N T _=n_ _=t_



_∈?_ : N → List N → Bool
n ∈? [] = false
n ∈? (x ∷ ns) with n =n x 
n ∈? (x ∷ ns) | yes p = true
n ∈? (x ∷ ns) | no ¬p = n ∈? ns


_lft∈?_ : Symbol → List N → Bool
tm x lft∈? ls = false
nt x lft∈? ls = x ∈? ls


allIn : Symbols → List N → Bool
allIn [] zs = true
allIn (tm x ∷ xs) zs = false
allIn (nt x ∷ xs) zs = x ∈? zs ∧ allIn xs zs 



data AllIn : Symbols → List N → Set where
  all_c1 : {ys : List N} → AllIn [] ys
  all_c2 : {x : N}{xs : Symbols}{ys : List N} → AllIn xs ys 
           → x ∈ ys → AllIn (nt x ∷ xs) ys


∈?Complete : ∀ x xs →  x ∈ xs → x ∈? xs ≡ true
∈?Complete x .(x ∷ as) (base {.x} {as}) with x =n x 
∈?Complete x .(x ∷ as) (base {.x} {as}) | yes p = refl
∈?Complete x .(x ∷ as) (base {.x} {as}) | no ¬p with ¬p refl 
... | ()
∈?Complete x .(b ∷ as) (step {.x} {b} {as} p) with x =n b 
∈?Complete x .(b ∷ as) (step {.x} {b} {as} p₁) | yes p = refl
∈?Complete x .(b ∷ as) (step {.x} {b} {as} p) | no ¬p 
  = ∈?Complete x as p


∈?Sound : ∀ x xs → x ∈? xs ≡ true → x ∈ xs
∈?Sound x [] ()
∈?Sound x (x₁ ∷ xs) p with x =n x₁ 
∈?Sound x (x₁ ∷ xs) p₁ | yes p rewrite p = base
∈?Sound x (x₁ ∷ xs) p | no ¬p = step (∈?Sound x xs p) 


allInComplete : ∀ xs ys → AllIn xs ys → allIn xs ys ≡ true
allInComplete .[] ys all_c1 = refl
allInComplete .(nt x ∷ xs) [] (all_c2 {x} {xs} ai ())
allInComplete .(nt x₁ ∷ xs) (x ∷ ys) (all_c2 {x₁} {xs} ai x₂) 
  rewrite allInComplete xs (x ∷ ys) ai | ∈?Complete x₁ (x ∷ ys) x₂ = refl


and-split-left : ∀ a b → a ∧ b ≡ true → a ≡ true
and-split-left true b p = refl
and-split-left false b ()


and-split-right : ∀ a b → a ∧ b ≡ true → b ≡ true
and-split-right true b p = p
and-split-right false b ()


allInSound : ∀ xs ys → allIn xs ys ≡ true → AllIn xs ys
allInSound [] ys p = all_c1
allInSound (tm x ∷ xs) ys ()
allInSound (nt x ∷ xs) ys p with and-split-left (x ∈? ys) (allIn xs ys) p
 | and-split-right (x ∈? ys) (allIn xs ys) p
... | d | f  = all_c2 (allInSound xs ys f) (∈?Sound x ys d)


allInEmpt : ∀ x → allIn x [] ≡ true → x ≡ []
allInEmpt [] p = refl
allInEmpt (tm x ∷ x₁) ()
allInEmpt (nt x ∷ x₁) ()



