open import Relation.Binary
open import Relation.Nullary.Core
open import Relation.Binary.PropositionalEquality 
            hiding ([_])

module TopDownTree 
  (N T : Set)(_=n_ : Decidable (_≡_ {A = N}))(_=t_ : Decidable (_≡_ {A = T}))   
 where

open import Data.List hiding (all)
open import Data.List.All hiding (all)
open import Data.List.Properties
open import Data.Product
open import Data.Empty
open import Data.Nat hiding (_≟_)

open import ListsAddition
open import ListProperties
open import Logic


-- terminals and nonterminals
data Symbol : Set where
  tm : T → Symbol
  nt : N → Symbol


-- abbr.
Symbols = List Symbol

-- datatype for rules of CFG
data Rule : Set where
  _⟶_ : N → Symbols → Rule

-- abbr.
Rules = List Rule

-- parse trees
mutual 
  data Tree (Rs : Rules) : N → Symbols → Set where
     node : ∀ {xs ys n} → (n ⟶ xs) ∈ Rs 
                        → ListOfTs Rs xs ys → Tree Rs n ys

  data ListOfTs (Rs : Rules) : Symbols → Symbols → Set where
    ⟦⟧    : ListOfTs Rs [] []
    _∷t_  : ∀ {xs ys} → (t : T) → ListOfTs Rs xs ys
                      → ListOfTs Rs (tm t ∷ xs) (tm t ∷ ys)
    _∷n_  : ∀ {xs ys n zs} → Tree Rs n zs → ListOfTs Rs xs ys
                      → ListOfTs Rs (nt n ∷ xs) (zs ++ ys)


-- listing all symbols of some Rules
filterAllSmbls-f : Rule → Symbols
filterAllSmbls-f (x ⟶ x₁) = [ nt x ] ++ x₁  

filterAllSmbls : Rules → Symbols
filterAllSmbls Rs = foldl (λ res r → filterAllSmbls-f r ++ res) [] Rs


NTs' : Symbols → List N
NTs' [] = []
NTs' (tm x ∷ xs) = NTs' xs
NTs' (nt x ∷ xs) = x ∷ NTs' xs

-- filtering nonterminals from RHS
RHS : List Rule → List N
RHS [] = []
RHS (x ⟶ x₁ ∷ rs) = NTs' x₁ ++ RHS rs

-- filter LHSs
LHS-f : Rule → List N
LHS-f (x ⟶ x₁) = [ x ]

LHS : (Rs : Rules) → List N
LHS Rs = foldl (λ res r → LHS-f r ++ res) [] Rs

-- decidable equality on symbols
_=s_ : Decidable (_≡_ {A = Symbol})
tm x =s tm x₁ with x =t x₁ 
tm x =s tm x₁ | yes p rewrite p = yes refl
tm x =s tm x₁ | no ¬p = no (λ t → ¬p (_=s'_ x x₁ t) )
  where
   _=s'_ : ∀ x x' → tm x ≡ tm x' → x ≡ x'
   _=s'_ .x' x' refl = refl
tm x =s nt x₁ = no (λ { () })
nt x =s tm x₁ = no ((λ { () }))
nt x =s nt x₁ with x =n x₁
nt .x₁ =s nt x₁ | yes refl = yes refl
nt x =s nt x₁ | no ¬p = no (λ t → ¬p (_=s'_  x x₁ t))
   where
   _=s'_ : ∀ x x' → nt x ≡ nt x' → x ≡ x'
   _=s'_ .x' x' refl = refl


-- decidable equality of rules
_≟_ : Decidable (_≡_ {A = Rule})
(x ⟶ x₁) ≟ (x₂ ⟶ x₃) with x =n x₂ 
(x ⟶ x₁) ≟ (x₂ ⟶ x₃) | yes p with liftDecEqToList _=s_ x₁ x₃ 
(x ⟶ x₁) ≟ (x₂ ⟶ x₃) | yes p₁ | yes p rewrite p₁ | p = yes refl
(x ⟶ x₁) ≟ (x₂ ⟶ x₃) | yes p | no ¬p = no (λ t → ¬p (cong hlp t))
  where
  hlp : Rule → Symbols
  hlp (x₄ ⟶ x₅) = x₅
(x ⟶ x₁) ≟ (x₂ ⟶ x₃) | no ¬p = no (λ q → ¬p (cong hlp q))
  where
  hlp : Rule → N
  hlp (x₄ ⟶ x₅) = x₄


-- filter RHSs for some particular LHS
filterRHS-f : N → Rule → List Symbols
filterRHS-f n (x ⟶ x₁) with _=n_ x n
filterRHS-f n (x ⟶ x₁) | yes p = [ x₁ ]
filterRHS-f n (x ⟶ x₁) | no ¬p = []

filterRHS : N → (Rs : Rules) → List Symbols
filterRHS N Rs = foldl (λ res r → filterRHS-f N r ++ res) [] Rs


-- filter RHSs of unit rules
filterSnglsRHS-f : Rule → List N
filterSnglsRHS-f (x ⟶ []) = []
filterSnglsRHS-f (x ⟶ (x₁ ∷ x₂ ∷ x₃)) = []
filterSnglsRHS-f (x ⟶ (tm x₁ ∷ [])) = []
filterSnglsRHS-f (x ⟶ (nt x₁ ∷ [])) = [ x₁ ]

filterSnglsRHS : (Rs : Rules) → List N
filterSnglsRHS Rs = foldl (λ res r → filterSnglsRHS-f r ++ res) [] Rs

