
open import Relation.Binary
open import Relation.Nullary.Core
open import Relation.Binary.PropositionalEquality 
            hiding ([_])
open import Data.List
open import ListsAddition

module TopDownTreeProperties 
  (N T : Set)(_=n_ : Decidable (_≡_ {A = N}))(_=t_ : Decidable (_≡_ {A = T}))  where

open import TopDownTree N T (_=n_) (_=t_)
open import Data.Product
open import Data.Bool
open import Data.Empty

open import ListProperties
open import Logic
open DecExistance
open DecListMinus


-- grammar weakening
mutual 
 Rs-weaken : ∀ Rs A s r → Tree Rs A s → (Tree (r ∷ Rs) A s)
 Rs-weaken Rs A s r (node x x₁) = node (step x) (Rs-weaken-mut Rs _ _ r x₁)

 Rs-weaken-mut : ∀ Rs rhs s r → ListOfTs Rs rhs s → ListOfTs (r ∷ Rs) rhs s
 Rs-weaken-mut Rs .[] .[] r ⟦⟧ = ⟦⟧
 Rs-weaken-mut Rs .(tm t ∷ xs) .(tm t ∷ ys) r (_∷t_ {xs} {ys} t f) 
   = t ∷t Rs-weaken-mut Rs xs ys r f
 Rs-weaken-mut Rs .(nt n ∷ xs) .(zs ++ ys) r (_∷n_ {xs} {ys} {n} {zs} x f) 
   = Rs-weaken Rs n zs r x ∷n Rs-weaken-mut Rs xs ys r f

-- correctness of auxiliary functions
NTs'-snd : ∀ n x₁ → (nt n) ∈ x₁ → n ∈ NTs' x₁ 
NTs'-snd n .(nt n ∷ as) (base {.(nt n)} {as}) = base
NTs'-snd n .(tm x ∷ as) (step {.(nt n)} {tm x} {as} nin) 
  = NTs'-snd n as nin
NTs'-snd n .(nt x ∷ as) (step {.(nt n)} {nt x} {as} nin) 
  = step (NTs'-snd n as nin)


NTs'-compl : ∀ n x₁ →  n ∈ NTs' x₁ → (nt n) ∈ x₁
NTs'-compl n [] ()
NTs'-compl n (tm x ∷ x₁) nin = step (NTs'-compl n x₁  nin)
NTs'-compl n (nt .n ∷ x₁) base = base
NTs'-compl n (nt x ∷ x₁) (step nin) = step (NTs'-compl  n x₁ nin)


RHS-compl : ∀ A n rhs Rs → A ⟶ rhs ∈ Rs → (nt n) ∈ rhs → n ∈ (RHS Rs)
RHS-compl A n rhs .(A ⟶ rhs ∷ as) (base {.(A ⟶ rhs)} {as}) nin 
  = inFirst {_} {_} {_} {_} (NTs'-snd n rhs nin) 
RHS-compl A n rhs .(x ⟶ x₁ ∷ as) (step {.(A ⟶ rhs)} {x ⟶ x₁} {as} rin) nin
  = inTwo {_} {_} {RHS as} {NTs' x₁} (RHS-compl A n rhs as rin nin)


RHS-sound : ∀ n Rs → n ∈ RHS Rs 
  → Σ[ A ∈ N ] 
    Σ[ rhs ∈ Symbols ] A ⟶ rhs ∈ Rs × (nt n) ∈ rhs
RHS-sound n [] ()
RHS-sound n (x ⟶ x₁ ∷ Rs) nin 
    with incLem  {_} {_} {NTs' x₁}  {RHS Rs} nin 
... | inl l = x , x₁ , base , NTs'-compl n x₁ l
... | inr l with RHS-sound n Rs l 
... | a , b , c , d = a , b , step c , d


RHSh : ∀ Rs1 Rs2 → RHS (Rs1 ++ Rs2) ≡ RHS Rs1 ++ RHS Rs2
RHSh [] Rs2 = refl
RHSh (x ⟶ x₁ ∷ Rs1) Rs2 
  rewrite RHSh Rs1 Rs2 
  = ++-assoc (NTs' x₁) (RHS Rs1) (RHS Rs2)


NTs'h : ∀ Rs1 Rs2 → NTs' (Rs1 ++ Rs2) ≡ NTs' Rs1 ++ NTs' Rs2
NTs'h [] Rs2 = refl
NTs'h (tm x ∷ Rs1) Rs2 = NTs'h Rs1 Rs2
NTs'h (nt x ∷ Rs1) Rs2 rewrite NTs'h Rs1 Rs2 = refl


RHS∉s : ∀ Rs s → (∀ N zs → N ⟶ zs ∈ Rs → (nt s) ∉ zs) → s ∉ RHS Rs
RHS∉s Rs s pr z with RHS-sound s Rs z 
... | B , C , prf1 , prf2  = pr B C prf1 prf2


RHS∉c : ∀ Rs s → s ∉ RHS Rs → (∀ N zs → N ⟶ zs ∈ Rs → (nt s) ∉ zs)
RHS∉c Rs s pin N zs pin2 nin2 = pin (RHS-compl N s zs Rs pin2 nin2)


filterRHS-complete : ∀ xs Rs N → xs ∈ filterRHS N Rs → N ⟶ xs ∈ Rs
filterRHS-complete xs Rs N rin 
  with foldlth Symbols (liftDecEqToList _=s_) xs Rs (filterRHS-f N) rin
filterRHS-complete xs Rs N rin | x ⟶ x₁ , proj₂ , proj₃ 
  with x =n N
filterRHS-complete .x₁ Rs N rin | x ⟶ x₁ , proj₂ , base 
  | yes p rewrite p = proj₂
filterRHS-complete xs Rs N rin | x ⟶ x₁ , proj₂ , step () 
  | yes p
filterRHS-complete xs Rs N rin | x ⟶ x₁ , proj₂ , () 
  | no ¬p


filterRHS-sound : ∀ xs Rs N → N ⟶ xs ∈ Rs → xs ∈ filterRHS N Rs
filterRHS-sound xs .(N ⟶ xs ∷ as) N (base {.(N ⟶ xs)} {as}) 
  with N =n N
filterRHS-sound xs .(N ⟶ xs ∷ as) N (base {.(N ⟶ xs)} {as}) 
  | yes p rewrite foldInc' (xs ∷ [])  as (filterRHS-f N) 
  = inTwo {Symbols} {xs} {(xs ∷ [])} 
          {foldl (λ res r → filterRHS-f N r ++ res) [] as} base
filterRHS-sound xs .(N ⟶ xs ∷ as) N (base {.(N ⟶ xs)} {as}) 
  | no ¬p = ex-falso-quodlibet (¬p refl)
filterRHS-sound xs .(b ∷ as) N (step {.(N ⟶ xs)} {b} {as} rin) 
  rewrite foldInc' (filterRHS-f N b ++ [])  as (filterRHS-f N) 
  = inFirst {Symbols} {xs} {_} {(filterRHS-f N b ++ [])} 
            (filterRHS-sound xs as N rin)


LHS-complete : ∀ A xs Rs → A ⟶ xs ∈ Rs → A ∈ LHS Rs
LHS-complete A xs .(A ⟶ xs ∷ as) (base {.(A ⟶ xs)} {as}) 
  rewrite foldInc' (A ∷ []) as LHS-f = inTwo {N} {A} {A ∷ []} 
                   {foldl (λ res r → LHS-f r ++ res) [] as} base
LHS-complete A xs .(b ∷ as) (step {.(A ⟶ xs)} {b} {as} rin) 
  rewrite foldInc' (LHS-f b ++ []) as LHS-f 
  = inFirst {N} {A} 
    {foldl (λ res r → LHS-f r ++ res) [] as} {LHS-f b ++ []} 
    (LHS-complete A xs as rin)


LHS-sound : ∀ A Rs → A ∈ LHS Rs → Σ[ xs  ∈ Symbols ] A ⟶ xs ∈ Rs
LHS-sound A Rs rin with foldlth  N _=n_  A Rs LHS-f  rin 
LHS-sound .x Rs rin | x ⟶ x₁ , d2 , base = x₁ , d2
LHS-sound A Rs rin | x ⟶ x₁ , d2 , step ()


norm-ε-f-lem : ∀ {N rhs rhss}
  → rhs ∈ rhss 
  → (N ⟶ rhs) ∈ (foldl (λ res rhs → N ⟶ rhs ∷ res) [] rhss)
norm-ε-f-lem {N} {rhs} .{(rhs ∷ as)} (base {.rhs} {as}) 
  = foldInc (N ⟶ rhs) [] as (λ s → [ N ⟶ s ])
norm-ε-f-lem {N} {rhs} .{(b ∷ as)} (step {.rhs} {b} {as} rin) 
  rewrite foldInc' (N ⟶ b ∷ []) as (λ r → [ N ⟶ r ]) 
  = inFirst (norm-ε-f-lem {N} {rhs} {as} rin)


lemmR : ∀ {n xs₁ B zs} → n ⟶ xs₁ ≡ B ⟶ zs → n ≡ B
lemmR refl = refl


lemmR' : ∀ {n xs₁ B zs} → n ⟶ xs₁ ≡ B ⟶ zs → xs₁ ≡ zs
lemmR' refl = refl


soundLem' : {X : Set}{_≟_ : (x₁ y : X) → Dec (x₁ ≡ y)} 
   → ∀ a xs x → a ∈ (_/_ X _≟_ xs x) → a ∈ xs
soundLem' a [] x ()
soundLem' {X} {_≟_} a (x ∷ xs) x₁ rin with x ≟ x₁
soundLem' a (x ∷ xs) x₁ rin | yes p = step (soundLem' a xs x₁ rin)
soundLem' .x (x ∷ xs) x₁ base | no ¬p = base
soundLem' a (x ∷ xs) x₁ (step rin) | no ¬p = step (soundLem' a xs  x₁ rin)


soundLem'' : ∀ A zs N cmbs 
   → A ⟶ zs ∈ (foldl (λ res rhs → N ⟶ rhs ∷ res) [] cmbs) 
   → zs ∈ cmbs
soundLem'' A zs N [] ()
soundLem'' A zs N (cmbs ∷ cmbs₁) rin 
  rewrite foldInc' (N ⟶ cmbs ∷ []) cmbs₁ 
          (λ r → [ N ⟶ r ]) 
  with incLem {Rule} {A ⟶ zs} 
              {foldl (λ res r → N ⟶ r ∷ res) [] cmbs₁} 
              {N ⟶ cmbs ∷ []} rin
soundLem'' A zs N (cmbs ∷ cmbs₁) rin 
  | inl x = step (soundLem'' A zs N cmbs₁ x)
soundLem'' A zs N (cmbs ∷ cmbs₁) rin 
  | inr x rewrite lemmR' (incSngl x) = base


soundLem''' : ∀ A zs N cmbs 
  → A ⟶ zs ∈ (foldl (λ res rhs → N ⟶ rhs ∷ res) [] cmbs) 
  → A ≡ N
soundLem''' A zs N [] ()
soundLem''' A zs N (cmbs ∷ cmbs₁) rin 
 rewrite foldInc' (N ⟶ cmbs ∷ []) cmbs₁ 
                  (λ r → [ N ⟶ r ]) 
 with incLem {Rule} {A ⟶ zs} 
             {foldl (λ res r → N ⟶ r ∷ res) [] cmbs₁} 
             {N ⟶ cmbs ∷ []} rin
... | inl d  = soundLem''' A zs N cmbs₁ d
... | inr d  = lemmR (incSngl d)


tree-div : ∀ Rs xs ys zs → ListOfTs Rs (xs ++ ys) zs 
  → Σ[ zs1 ∈ Symbols ] 
    Σ[ zs2 ∈ Symbols ] ListOfTs Rs xs zs1 × ListOfTs Rs ys zs2 × zs1 ++ zs2 ≡ zs
tree-div Rs [] ys zs lot1 = [] , zs , ⟦⟧ , lot1 , refl
tree-div Rs (.(tm t) ∷ xs) ys .(tm t ∷ ys₁) (_∷t_ {.(xs ++ ys)} {ys₁} t lot1) 
  with tree-div _ xs ys _ lot1 
... | z1 , z2 , z3 , z4 , z5 
  = tm t ∷ z1 , z2 , _∷t_ t z3 , z4 , cong (_∷_ _) z5
tree-div Rs (.(nt n) ∷ xs) ys .(zs ++ ys₁) 
    (_∷n_ {.(xs ++ ys)} {ys₁} {n} {zs} x lot1) 
  with tree-div _ xs ys _ lot1 
... | z1 , z2 , z3 , z4 , z5 
  = zs ++ z1 ,  z2 , _∷n_ x z3 , z4 , 
           trans (sym (++-assoc zs z1 z2)) (cong (_++_ zs) z5)


mutual
 lot-append : ∀ Rs xs ys zs → ListOfTs Rs xs ys 
                            → ListOfTs Rs ys zs → ListOfTs Rs xs zs
 lot-append Rs .[] .[] zs ⟦⟧ lot2 = lot2
 lot-append Rs .(tm t ∷ xs) .(tm t ∷ ys) .(tm t ∷ ys₁) (_∷t_ {xs} {ys} t lot1) 
  (_∷t_ {.ys} {ys₁} .t lot2) = _∷t_ t (lot-append Rs _ _ _ lot1 lot2)
 lot-append Rs .(nt n ∷ xs) .(zs₁ ++ ys) zs (_∷n_ {xs} {ys} {n} {zs₁} x lot1) lot2 
   with tree-div Rs zs₁ _ _ lot2
 ... | z1 , z2 , z3 , z4  , z5  
   with tree-append _ _ _ _ x z3 | lot-append _ _ _ _ lot1 z4
 ... | tree' | lot' rewrite (sym z5) = _∷n_ tree' lot'

 tree-append : ∀ Rs A xs ys → Tree Rs A xs → ListOfTs Rs xs ys → Tree Rs A ys
 tree-append Rs A xs ys (node x x₁) lot = node x (lot-append _ _ _ _ x₁ lot)


lot-cont : ∀ Rs xs ys zs ws → ListOfTs Rs xs ys 
                         → ListOfTs Rs zs ws → ListOfTs Rs (xs ++ zs) (ys ++ ws)
lot-cont Rs .[] .[] zs ws ⟦⟧ lot2 = lot2
lot-cont Rs .(tm t ∷ xs) .(tm t ∷ ys) zs ws (_∷t_ {xs} {ys} t lot1) lot2 
  = _∷t_ t (lot-cont Rs xs ys zs ws lot1 lot2)
lot-cont Rs .(nt n ∷ xs) .(zs₁ ++ ys) zs ws (_∷n_ {xs} {ys} {n} {zs₁} x lot1) lot2 
  rewrite sym (++-assoc zs₁ ys ws) 
  = _∷n_ x (lot-cont Rs xs  ys zs ws lot1 lot2)


terminals : Symbols → Bool
terminals [] = true
terminals (tm x ∷ s) = terminals s
terminals (nt x ∷ s) = false


terminalsSplit1 : ∀ ys zs → terminals (ys ++ zs) ≡ true → terminals ys ≡ true
terminalsSplit1 [] zs run = refl
terminalsSplit1 (tm x ∷ yz) zs run = terminalsSplit1 yz zs run
terminalsSplit1 (nt x ∷ yz) zs ()


terminalsSplit2 : ∀ ys zs → terminals (ys ++ zs) ≡ true → terminals zs ≡ true
terminalsSplit2 [] zs run = run
terminalsSplit2 (tm x ∷ yz) zs run = terminalsSplit2 yz zs run
terminalsSplit2 (nt x ∷ yz) zs ()


terminalsDec : ∀ ys zs → terminals (ys ++ zs) ≡ terminals ys ∧ terminals zs
terminalsDec [] zs = refl
terminalsDec (tm x ∷ ys) zs = terminalsDec ys zs
terminalsDec (nt x ∷ ys) zs = refl


terminalsSwap : ∀ ys zs → terminals (ys ++ zs) ≡ true 
  → terminals (zs ++ ys) ≡ true
terminalsSwap ys zs run rewrite terminalsDec ys zs
 | terminalsDec zs ys with terminals zs | terminals ys  
terminalsSwap ys zs run | false | false  = run
terminalsSwap ys zs run | false | true  = run
terminalsSwap ys zs run | true  | false = run
terminalsSwap ys zs run | true  | true  = refl


mutual 
 terminalsLem : ∀ Rs A xs → Tree Rs A xs → terminals xs ≡ true
 terminalsLem Rs A xs (node {ws} x x₁) = terminalsLemMut Rs ws xs x₁

 terminalsLemMut : ∀ Rs xs ys → ListOfTs Rs xs ys → terminals ys ≡ true
 terminalsLemMut Rs .[] .[] ⟦⟧ = refl
 terminalsLemMut Rs .(tm t ∷ xs) .(tm t ∷ ys) (_∷t_ {xs} {ys} t lot) 
   = terminalsLemMut Rs xs ys lot
 terminalsLemMut Rs .(nt n ∷ xs) .(zs ++ ys) (_∷n_ {xs} {ys} {n} {zs} x lot) 
  with terminalsLem Rs n zs x | terminalsLemMut Rs xs ys lot
 ... | d | f rewrite terminalsDec zs ys | f | d = refl


filter-RHS-All : ∀ A Rs →  A ∈ RHS Rs → (nt A) ∈ filterAllSmbls Rs
filter-RHS-All A [] ()
filter-RHS-All A (x ⟶ x₁ ∷ Rs) ain 
  with incLem {_} {A} {NTs' x₁} {RHS Rs} ain 
filter-RHS-All A (x₂ ⟶ x₁ ∷ Rs) ain | inl x 
  rewrite foldth2 Rs (nt x₂ ∷ x₁ ++ []) filterAllSmbls-f 
  = inTwo {_} {nt A}  {nt x₂ ∷ x₁ ++ []} 
          {filterAllSmbls Rs} 
          (inFirst {_} {nt A} {nt x₂ ∷ x₁} {[]} 
          (step (NTs'-compl A x₁ x)))
filter-RHS-All A (x₂ ⟶ x₁ ∷ Rs) ain | inr x 
  rewrite foldth2 Rs (nt x₂ ∷ x₁ ++ []) 
          filterAllSmbls-f 
  = inFirst {_} {nt A} 
            {filterAllSmbls Rs} 
            {nt x₂ ∷ x₁ ++ []} 
            (filter-RHS-All A Rs x)


LHS-All : ∀ A Rs →  A ∈ LHS Rs → (nt A) ∈ filterAllSmbls Rs
LHS-All A Rs rin 
  with foldlth N _=n_ A Rs LHS-f  rin 
LHS-All .x Rs rin | x ⟶ x₁ , proj₂ , base 
  with exists-split  (x ⟶ x₁) Rs proj₂ 
LHS-All .rin Rs rin | x ⟶ x₁ , proj₂ , base | proj₁ , proj₃ , proj₄ 
  rewrite proj₄ 
  | foldlnest  proj₁  (x ⟶ x₁ ∷ proj₃) [] (λ res r → filterAllSmbls-f r ++ res) 
  | foldth2 proj₃ (nt x ∷ x₁ ++ foldl (λ res r → filterAllSmbls-f r ++ res) [] proj₁) 
            filterAllSmbls-f 
  =  inTwo {_} {nt x} 
           {nt x ∷ x₁ ++ foldl (λ res r → filterAllSmbls-f r ++ res) [] proj₁} 
           {foldl (λ res el → filterAllSmbls-f el ++ res) [] proj₃} base
LHS-All A Rs rin | x ⟶ x₁ , proj₂ , step ()

