module DivBelow where

----------------------------------------------------------------------

record ⊤ : Set where
  constructor tt

record _×_ (A B : Set) : Set where
  constructor _,_
  field
    π₁ : A
    π₂ : B

data _≡_ {A : Set} (x : A) : A → Set where
  refl : x ≡ x

data Bool : Set where
  true false : Bool

data Nat : Set where
  zero  : Nat
  suc : Nat → Nat

one = suc zero
two = suc one
three = suc two
four = suc three
five = suc four
six = suc five
seven = suc six

K : Set → Nat → Set
K A n = A

pred : Nat → Nat
pred zero = zero
pred (suc n) = n

minus : Nat → Nat → Nat
minus zero n = zero
minus (suc n) zero = suc n
minus (suc n) (suc m) = minus n m

isZero : Nat → Bool
isZero zero = true
isZero (suc _) = false

lessThan : Nat → Nat → Bool
lessThan n m = isZero (minus (suc n) m)

if : {A : Set} → Bool → A → A → A
if true x y = x
if false x y = y

plus : Nat → Nat → Nat
plus zero m = m
plus (suc n) m = suc (plus n m)

mult : Nat → Nat → Nat
mult zero m = zero
mult (suc n) m = plus (mult n m) m

caseNat : (P : Nat → Set)
  (pz : P zero)
  (ps : (n : Nat) → P (suc n))
  (n : Nat) → P n
caseNat P pz ps zero = pz
caseNat P pz ps (suc n) = ps n

BelowNat : (P : Nat → Set) → Nat → Set
BelowNat P zero = ⊤
BelowNat P (suc n) = P n × BelowNat P n

belowNat : (P : Nat → Set)
  (p : ((n : Nat) → BelowNat P n → P n))
  (n : Nat) → BelowNat P n
belowNat P p zero = tt
belowNat P p (suc n) = p n (belowNat P p n) , belowNat P p n

recNat : (P : Nat → Set)
  (p : ((n : Nat) → BelowNat P n → P n))
  (n : Nat) → P n
recNat P p n = p n (belowNat P p n)

{-
fib : Nat → Nat
fib 0 = 0
fib 1 = 1
fib (suc (suc n)) = fib (suc n) + fib n
-}

fibCase : (n : Nat) → BelowNat (K Nat) n → Nat
fibCase zero tt = zero
fibCase (suc zero) p = suc zero
fibCase (suc (suc n)) (n₁ , (n₂ , p)) = plus n₁ n₂

fib : Nat → Nat
fib = recNat (K Nat) fibCase

recMinus : (P : Nat → Set) (n m : Nat) → BelowNat P (suc n) → P (minus n m)
recMinus P zero m (pz , tt) = pz
recMinus P (suc n) zero (psn , (pn , bn)) = psn
recMinus P (suc n) (suc m) (psn , (pn , bn)) = recMinus P n m (pn , bn)

{-
div : Nat → Nat → Nat
div 0 m = 0
div (suc n) m = if (suc n < m) then 0 else (suc (div (n - pred m) m))
-}

divCase : (n : Nat) → BelowNat (K (Nat → Nat)) n → Nat → Nat
divCase zero tt m = zero
divCase (suc n) (pn , bn) m = if (lessThan (suc n) m)
  zero
  (suc (recMinus (K (Nat → Nat)) n (pred m) (pn , bn) m))

div : Nat → Nat → Nat
div = recNat (K (Nat → Nat)) divCase

testDiv-4-2 : div four two ≡ two
testDiv-4-2 = refl

testDiv-6-2 : div six two ≡ three
testDiv-6-2 = refl

sum : (Nat → Nat) → Nat → Nat
sum f zero = f zero
sum f (suc n) = plus (f (suc n)) (sum f n)

{-
cat : Nat → Nat
cat 0 = 1
cat (suc n) = sum (λ i → cat i * cat (n - i))
-}

catCase : (n : Nat) → BelowNat (K Nat) n → Nat
catCase zero tt = suc zero
catCase (suc n) (n' , bn) = sum (λ i → mult
    (recMinus (K Nat) n (minus n i) (n' , bn))
    (recMinus (K Nat) n i (n' , bn))
  ) n

cat : Nat → Nat
cat = recNat (K Nat) catCase

testMult-3-2 : mult three two ≡ six
testMult-3-2 = refl

testCat-0 : cat zero ≡ one
testCat-0 = refl

testCat-1 : cat one ≡ one
testCat-1 = refl

testCat-2 : cat two ≡ two
testCat-2 = refl

testCat-3 : cat three ≡ five
testCat-3 = refl

testCat-4 : cat four ≡ mult two seven
testCat-4 = refl
