{-# OPTIONS --sized-types #-}
module DivSized where
open import Agda.Builtin.Size public

data _≡_ {A : Set} (x : A) : A → Set where
  refl : x ≡ x

data Bool : Set where
  true false : Bool

data NatST : (ι : Size) → Set where
  zero  : ∀{ι} → NatST (↑ ι)
  suc : ∀ {ι} → NatST ι → NatST (↑ ι)

Nat : Set
Nat = NatST ∞

one = suc zero
two = suc one
three = suc two
four = suc three
five = suc four
six = suc five
seven = suc six

pred : {ι : Size} → NatST ι → NatST ι
pred zero = zero
pred (suc n) = n

minus : {ι : Size} → NatST ι → Nat → NatST ι
minus n zero = n
minus n (suc m) = pred (minus n m)

isZero : Nat → Bool
isZero zero = true
isZero (suc _) = false

lessThan : Nat → Nat → Bool
lessThan n m = isZero (minus (suc n) m)

if : {A : Set} → Bool → A → A → A
if true x y = x
if false x y = y

plus : Nat → Nat → Nat
plus zero m = m
plus (suc n) m = suc (plus n m)

mult : Nat → Nat → Nat
mult zero m = zero
mult (suc n) m = plus (mult n m) m

fib : Nat → Nat
fib zero = zero
fib (suc zero) = suc zero
fib (suc (suc n)) = plus (fib (suc n)) (fib n)

div : {ι : Size} → NatST ι → Nat → NatST ι
div zero m = zero
div (suc n) m = if (lessThan (suc n) m)
  zero
  (suc (div (minus n (pred m)) m))

testDiv-4-2 : div four two ≡ two
testDiv-4-2 = refl

testDiv-6-2 : div six two ≡ three
testDiv-6-2 = refl

sum : {ι : Size} → (NatST ι → Nat) → NatST ι → Nat
sum f zero = f zero
sum f (suc n) = plus (f (suc n)) (sum f n)

cat : {ι : Size} → NatST ι → Nat
cat zero = suc zero
cat (suc n) = sum (λ i → mult (cat i) (cat (minus n i))) n

testCat-0 : cat zero ≡ one
testCat-0 = refl

testCat-1 : cat one ≡ one
testCat-1 = refl

testCat-2 : cat two ≡ two
testCat-2 = refl

testCat-3 : cat three ≡ five
testCat-3 = refl

testCat-4 : cat four ≡ mult two seven
testCat-4 = refl
