

open import Utils.Logic

module CNF.Grammar (N T : Set)(_=n_ : DecEq N)(_=t_ : DecEq T) where

open import Relation.Nullary
open import Relation.Binary.PropositionalEquality hiding ([_]; inspect)


open import Data.List
open import Data.Sum
open import Data.Product

open import Utils.ListsAddition
open import Utils.ListMembership
open import Utils.ListProperties


-- terminals and nonterminals
Symbol = N ⊎ T

-- abbr.
Symbols = List Symbol

-- datatype for rules of CFG
Rule = N × Symbols

--infixl 6 _⟶_

_⟶_ : {A B : Set} → A → B → A × B
_⟶_ = _,_

nt : {A B : Set} → A → A ⊎ B
nt = inj₁

tm : {A B : Set} → B → A ⊎ B
tm = inj₂

NTs' : Symbols → List N
NTs' [] = []
NTs' (inj₂ x ∷ xs) = NTs' xs
NTs' (inj₁ x ∷ xs) = x ∷ NTs' xs


-- filtering nonterminals from RHS
RHS : List Rule → List N
RHS [] = []
RHS ((x , x₁) ∷ rs) = NTs' x₁ ++ RHS rs

_=R?_ : DecEq Rule
_=R?_ = prod-eq _=n_ (deq2lists (dsum-eq _=n_ _=t_))

Rules = List Rule


-- listing all symbols of some Rules
filterAllSmbls-f : Rule → Symbols
filterAllSmbls-f (x , x₁) = [ inj₁ x ] ++ x₁  

filterAllSmbls : Rules → Symbols
filterAllSmbls Rs = foldl (λ res r → filterAllSmbls-f r ++ res) [] Rs


-- filter LHSs
LHS-f : Rule → List N
LHS-f (x , x₁) = [ x ]

LHS : (Rs : Rules) → List N
LHS Rs = foldl (λ res r → LHS-f r ++ res) [] Rs

-- decidable equality on symbols
_=s_ : DecEq Symbol
inj₂ x =s inj₂ x₁ with x =t x₁ 
inj₂ x =s inj₂ x₁ | yes p rewrite p = yes refl
inj₂ x =s inj₂ x₁ | no ¬p = no (λ t → ¬p (_=s'_ x x₁ t) )
  where
   _=s'_ : ∀ x x' → inj₂ x ≡ inj₂ x' → x ≡ x'
   _=s'_ .x' x' refl = refl
inj₂ x =s inj₁ x₁ = no (λ { () })
inj₁ x =s inj₂ x₁ = no ((λ { () }))
inj₁ x =s inj₁ x₁ with x =n x₁
inj₁ .x₁ =s inj₁ x₁ | yes refl = yes refl
inj₁ x =s inj₁ x₁ | no ¬p = no (λ t → ¬p (_=s'_  x x₁ t))
   where
   _=s'_ : ∀ x x' → inj₁ x ≡ inj₁ x' → x ≡ x'
   _=s'_ .x' x' refl = refl


-- decidable equality of rules
_≟_ : DecEq Rule
(x , x₁) ≟ (x₂ , x₃) with x =n x₂ 
(x , x₁) ≟ (x₂ , x₃) | yes p with liftDecEqToList _=s_ x₁ x₃ 
(x , x₁) ≟ (x₂ , x₃) | yes p₁ | yes p rewrite p₁ | p = yes refl
(x , x₁) ≟ (x₂ , x₃) | yes p | no ¬p = no (λ t → ¬p (cong hlp t))
  where
  hlp : Rule → Symbols
  hlp (x₄ , x₅) = x₅
(x , x₁) ≟ (x₂ , x₃) | no ¬p = no (λ q → ¬p (cong hlp q))
  where
  hlp : Rule → N
  hlp (x₄ , x₅) = x₄


-- filter RHSs for some particular LHS
filterRHS-f : N → Rule → List Symbols
filterRHS-f n (x , x₁) with _=n_ x n
filterRHS-f n (x , x₁) | yes p = [ x₁ ]
filterRHS-f n (x , x₁) | no ¬p = []

filterRHS : N → (Rs : Rules) → List Symbols
filterRHS N Rs = foldl (λ res r → filterRHS-f N r ++ res) [] Rs


-- filter RHSs of unit rules
filterSnglsRHS-f : Rule → List N
filterSnglsRHS-f (x , []) = []
filterSnglsRHS-f (x , (x₁ ∷ x₂ ∷ x₃)) = []
filterSnglsRHS-f (x , (inj₂ x₁ ∷ [])) = []
filterSnglsRHS-f (x , (inj₁ x₁ ∷ [])) = [ x₁ ]

filterSnglsRHS : (Rs : Rules) → List N
filterSnglsRHS Rs = foldl (λ res r → filterSnglsRHS-f r ++ res) [] Rs



-- CFG as a list of rules with dedicated start nonterminal
record Grammar : Set where
  constructor ⟨_,_⟩
  field
    S  : N
    Rs : Rules    
open Grammar public


open import Data.Product
open import Data.Sum

isCNF : Grammar → Set
isCNF G = (A : N) → (rhs : Symbols) → (A , rhs) ∈ (Rs G) → 
          (((Σ[ n₁ ∈ N ] Σ[ n₂ ∈ N ] rhs ≡ (inj₁ n₁ ∷ inj₁ n₂ ∷ [])) ⊎ 
            (Σ[ t ∈ T ] rhs ≡ [ inj₂ t ] )) ⊎ 
            (rhs ≡ [] × A ≡ (S G))) ×
          (S G) ∉ RHS (Rs G)
