

open import Data.List
open import Utils.ListMembership
open import Utils.Logic

module CNF.NormCorrectness (N T : Set)(_=n_ : DecEq N)(_=t_ : DecEq T) 
  (newntlst : List N → N)  
  (newntlstlem : (ns : List N) → (newntlst ns) ∉ ns) where

open import Relation.Nullary
open import Relation.Binary.PropositionalEquality hiding ([_])

open import Data.Product hiding (map)
open import Data.Sum hiding (map)
open import Data.Nat hiding (_≟_)

open import Function

open import Utils.ListsAddition

open import CNF.Grammar N T _=n_ _=t_
open import CNF.ParseTree N T _=n_ _=t_
open import CNF.ParseTreeProperties N T _=n_ _=t_
open import CNF.NormEpsRules N T _=n_ _=t_  
open import CNF.NormUnitRules N T _=n_ _=t_ 
open import CNF.NormInvariants N T _=n_ _=t_ newntlst newntlstlem 
open import CNF.NormLongRules N T _=n_ _=t_ newntlst newntlstlem
open import CNF.NormTermRules N T _=n_ _=t_ newntlst newntlstlem
open import CNF.NormFreshNonterminals N T _=n_ _=t_ newntlst newntlstlem


{- normalization function -}
norm : Rules → Rules
norm = norm-u ∘ norm-e ∘ norm-t ∘ norm-l


norm-progress : ∀ Rs A xs → (A , xs) ∈ (norm Rs) 
   → (Σ[ n1 ∈ N ] Σ[ n2 ∈ N ]  xs ≡ (inj₁ n1 ∷ inj₁ n2 ∷ [])) ⊎ 
      (Σ[ t ∈ T ] xs ≡ [ inj₂ t ])
norm-progress Rs A [] rin = 
  ex-falso-quodlibet (nur-eps-invariant (norm-e (norm-t (norm-l Rs))) 
             (λ A2 rin2 → ne-progress A2 (norm-t (norm-l Rs)) rin2) A 
             (filterSnglsRHS (norm-e (norm-t (norm-l Rs)))) rin)
norm-progress Rs A (inj₂ x ∷ []) rin = (inj₂ (x , refl))
norm-progress Rs A (inj₂ x ∷ x₁ ∷ xs) rin with nur-term-invariant 
             (norm-e (norm-t (norm-l Rs)))  
             (λ A2 xs2 rin2 → ner-term-invariant (norm-t (norm-l Rs)) A2 xs2 
               (λ A3 xs3 rin3 → nt-progress (norm-l Rs) A3 xs3  rin3) rin2)  A 
             (filterSnglsRHS (norm-e (norm-t (norm-l Rs)))) (inj₂ x ∷ x₁ ∷ xs) rin 
norm-progress Rs A (inj₂ x ∷ x₁ ∷ xs) rin | inj₁ (inj₁ ())
norm-progress Rs A (inj₂ x ∷ x₁ ∷ xs) rin | inj₁ (inj₂ (proj₁ , ()))
norm-progress Rs A (inj₂ x ∷ x₁ ∷ xs) rin | inj₂ () 
norm-progress Rs A (inj₁ x ∷ []) rin 
  = ex-falso-quodlibet (nu-progress A x (norm-e (norm-t (norm-l Rs))) rin) 
norm-progress Rs A (inj₁ x ∷ inj₂ x₁ ∷ xs) rin with nur-term-invariant 
             (norm-e (norm-t (norm-l Rs)))  
             (λ A2 xs2 rin2 → ner-term-invariant (norm-t (norm-l Rs)) A2 xs2 
               (λ A3 xs3 rin3 → nt-progress (norm-l Rs) A3 xs3  rin3) rin2)  A 
             (filterSnglsRHS (norm-e (norm-t (norm-l Rs)))) (inj₁ x ∷ inj₂ x₁ ∷ xs) rin 
norm-progress Rs A (inj₁ x ∷ inj₂ x₁ ∷ xs) rin | inj₁ (inj₁ ())
norm-progress Rs A (inj₁ x ∷ inj₂ x₁ ∷ xs) rin | inj₁ (inj₂ (proj₁ , ()))
norm-progress Rs A (inj₁ x ∷ inj₂ x₁ ∷ xs) rin | inj₂ ()
norm-progress Rs A (inj₁ x ∷ inj₁ x₁ ∷ []) rin = inj₁ (x , x₁ , refl)
norm-progress Rs A (inj₁ x ∷ inj₁ x₁ ∷ x₂ ∷ xs) rin with nur-long-invariant 
              (norm-e (norm-t (norm-l Rs))) 
              (λ A2 xs2 rin2 → ner-long-invariant (norm-t (norm-l Rs)) A2 xs2 
                (λ A3 xs3 rin3 → nt-efct  (norm-l Rs) 
                  (λ A4 xs4 rin4 → nl-progress A4 xs4 Rs rin4) A3 xs3 
                    (ntr-length (norm-l Rs)) rin3 ) rin2)  A 
              (filterSnglsRHS (norm-e (norm-t (norm-l Rs)))) 
              (inj₁ x ∷ inj₁ x₁ ∷ x₂ ∷ xs) rin
norm-progress Rs A (inj₁ x ∷ inj₁ x₁ ∷ x₂ ∷ xs) rin | s≤s (s≤s ())


norm-snd : ∀ Rs A xs → Tree (norm Rs) A xs 
    → (inj₁ A) ∈ filterAllSmbls Rs → Tree Rs A xs
norm-snd Rs A xs tree sin = 
       nl-snd Rs A xs nlm
          (nt-snd nl A xs  
              (ne-snd nlt A xs 
                   (nu-snd nlte A xs tree))
              (stepPreservesSymbols (inj₁ A) Rs nlm sin))
      sin
  where
    nlm = nl-measure Rs
    nl = norm-l Rs
    nlt = norm-t nl
    nlte = norm-e nlt


norm-cmplt : ∀ Rs A xs → Tree Rs A xs 
     → xs ≠ [] → Tree (norm Rs) A xs
norm-cmplt Rs A xs tree prop = nu-cmplt 
           (norm-e (norm-t (norm-l Rs))) A xs
                 (ne-cmplt A (norm-t (norm-l Rs)) xs 
                       (nt-cmplt (norm-l Rs) A xs 
                            (nl-cmplt Rs A xs (nl-measure Rs) tree))
                  prop)
