

open import Utils.Logic

module CNF.NormEpsRules (N T : Set)(_=n_ : DecEq N)(_=t_ : DecEq T) where

open import Relation.Binary
open import Relation.Nullary
open import Relation.Binary.PropositionalEquality hiding ([_])

open import Data.Empty
open import Data.Product hiding (map)
open import Data.Sum hiding (map)
open import Data.List
open import Data.Bool hiding (_≟_ ; _∨_ ; T)
open import Data.Nat hiding (_≟_)

open import Utils.ListProperties 
open import Utils.ListMembership

open import CNF.Grammar N T _=n_ _=t_
open import CNF.ParseTree N T _=n_ _=t_
open import CNF.ParseTreeProperties N T _=n_ _=t_
open import CNF.Nullable N T _=n_ _=t_
open import CNF.NullableUtility N T _=n_ _=t_
open import CNF.NullableSound N T _=n_ _=t_ renaming (sound to null-sound)
open import CNF.NullableComplete N T _=n_ _=t_ renaming (complete to null-complete)
 
open DecListMinus
open DecExistance renaming (_∈?_ to _∈??_) 

norm-e-f : Rules → Rule → Rules
norm-e-f rs (N , ws)  
 = let z = nullables rs in _/_ Rule _≟_ (
      foldl (λ res rhs → (N , rhs) ∷ res) [] 
            (allSubSeq (λ s → s lft∈? z) ws)) 
            (N , [])


norm-e-f' : Rules → List N → Rule → Rules
norm-e-f' rs z (N , ws)  
 = _/_ Rule _≟_ (
      foldr (λ rhs res → (N , rhs) ∷ res) [] 
            (allSubSeq (λ s → s lft∈? z) ws)) 
            (N , [])


norm-e' : Rules → Rules
norm-e' rs
  = foldr (λ r res → norm-e-f' rs z r ++ res) [] rs
  where
    z = nullables rs


norm-e'' : Rules → List N →  Rules
norm-e'' rs z
  = foldr (λ r res → norm-e-f' rs z r ++ res) [] rs


norm-e : Rules → Rules
norm-e rs
  = foldl (λ res r → norm-e-f rs r ++ res) [] rs


filterNonEmpty : ∀ {Rs xs ys} → (ListOfTs Rs xs ys) → Symbols
filterNonEmpty {Rs} .{[]} .{[]} ⟦⟧ = []
filterNonEmpty {Rs} .{(inj₂ t ∷ xs)} .{(t ∷ ys)} (_∷t_ {xs} {ys} t ls) 
  = (inj₂ t) ∷ (filterNonEmpty ls)
filterNonEmpty {Rs} .{(inj₁ n ∷ xs)} .{(ys)} (_∷n_ {xs} {ys} {n} {[]} x ls) 
  = filterNonEmpty ls
filterNonEmpty {Rs} .{(inj₁ n ∷ xs)} .{(x ∷ zs ++ ys)} (_∷n_ {xs} {ys} {n} {x ∷ zs} x₁ ls) 
  = (inj₁ n) ∷ filterNonEmpty ls 



filterLem : ∀ {Rs xs ys} → (lot : ListOfTs Rs xs ys) 
  → SubSeq ((λ s → s lft∈? nullables Rs)) (filterNonEmpty lot) xs
filterLem ⟦⟧ = con1
filterLem (t ∷t lot) = con3 (filterLem lot)
filterLem (_∷n_ {xs} {ys} {n} {[]} x lot) 
  = con2 (filterLem lot) (∈?Complete _ _ (nlbls-cmplt _ x))
filterLem (_∷n_ {xs} {ys} {n} {x ∷ zs} x₁ lot) 
  = con3 (filterLem lot)


filterLem2 : ∀ {Rs xs ys} → (lot : ListOfTs Rs xs ys) 
               → ys ≢ [] → filterNonEmpty lot ≢ []
filterLem2 ⟦⟧ p1 p2 = p1 refl
filterLem2 (t ∷t lot) p1 ()
filterLem2 (_∷n_ {xs} {ys} {n} {[]} x lot) p1 p2 
  rewrite ++-th ys = filterLem2 lot  p1 p2
filterLem2 (_∷n_ {xs} {ys} {n} {x ∷ zs} x₁ lot) p1 ()


completeLem : ∀ {A Rs xs ys}→ (A , xs) ∈ Rs
  → (lot : ListOfTs Rs xs ys) → ys ≢ [] 
  → (A , (filterNonEmpty lot)) ∈ norm-e Rs
completeLem {A} {Rs} {xs} {ys}  rin lot p with ∈lem rin
... | d1 , d2 , d3 rewrite d3 
    | foldlLem d1 ((A , xs) ∷ d2) [] 
                  (λ res r → norm-e-f (d1 ++ (A , xs) ∷ d2) r ++ res) 
    with subseqcombs _ _ (filterLem lot) 
... | q =  foldIncG (A , filterNonEmpty lot) ((Rule / _≟_)
       (foldl (λ res rhs → (A , rhs) ∷ res) []
        (foldr
         (λ x res →
            if
            x lft∈?
            nlbls (d1 ++ (A , xs) ∷ d2)
            (foldr (λ _ → suc) 0 (d1 ++ (A , xs) ∷ d2))
            then res ++ Data.List.map (_∷_ x) res else
            Data.List.map (_∷_ x) res)
         ([] ∷ []) xs))
       (A , [])
       ++ foldl (λ res r → norm-e-f (d1 ++ (A , xs) ∷ d2) r ++ res) [] d1) d2  
       (norm-e-f (d1 ++ (A , xs) ∷ d2)) 
       (inFirst {Rule} {A , filterNonEmpty lot} {(Rule / _≟_)
       (foldl (λ res rhs → (A , rhs) ∷ res) []
        (foldr
         (λ x res →
            if
            x lft∈?
            nlbls (d1 ++ (A , xs) ∷ d2)
            (foldr (λ _ → suc) 0 (d1 ++ (A , xs) ∷ d2))
            then res ++ Data.List.map (_∷_ x) res else
            Data.List.map (_∷_ x) res)
         ([] ∷ []) xs))
       (A , [])} {foldl (λ res r → norm-e-f (d1 ++ (A , xs) ∷ d2) r ++ res) [] d1} 
       (sound/ Rule _≟_ {A , []} {A , filterNonEmpty lot} 
        (foldl (λ res rhs → (A , rhs) ∷ res) []
       (foldr
         (λ x res →
         if
         x lft∈?
         nlbls (d1 ++ (A , xs) ∷ d2)
         (foldr (λ _ → suc) 0 (d1 ++ (A , xs) ∷ d2))
         then res ++ Data.List.map (_∷_ x) res else
         Data.List.map (_∷_ x) res)
      ([] ∷ []) xs)) 
        (norm-ε-f-lem {A} 
        {filterNonEmpty lot} 
        {((allSubSeq (λ s → s lft∈? nullables (d1 ++ (A , xs) ∷ d2)) xs))} 
        (subseqcombs (filterNonEmpty lot) xs (filterLem  lot))) 
        (λ eq → filterLem2 lot p (sym (lemmR' eq)))))


mutual

 ne-cmplt :  ∀ A Rs xs → Tree Rs A xs → xs ≢ [] → Tree (norm-e Rs) A xs
 ne-cmplt A Rs [] (node x x₁) p with p refl
 ... | ()
 ne-cmplt A Rs (x ∷ xs) (node {[]} x₁ ()) p
 ne-cmplt A Rs (x ∷ xs) (node {x₁ ∷ xs₁} x₂ x₃) p 
   = node (completeLem x₂ x₃ p) (completeMut x₃)

 completeMut :  ∀ {Rs ws xs} → (lot : ListOfTs Rs ws xs) 
                → ListOfTs (norm-e Rs) (filterNonEmpty lot) xs
 completeMut ⟦⟧ = ⟦⟧
 completeMut (t ∷t lot) = _∷t_ t (completeMut lot)
 completeMut (_∷n_ {xs} {ys} {n} {[]} x lot) 
   rewrite ++-th ys = completeMut lot
 completeMut (_∷n_ {xs} {ys} {n} {x ∷ zs} x₁ lot) 
   = _∷n_ (ne-cmplt _ _ _ x₁ (λ { () })) (completeMut lot)


soundLem : ∀ A zs Rs → (A , zs) ∈ (norm-e Rs) 
         → Σ[ xs ∈ Symbols ] (A , xs) ∈ Rs × 
           SubSeq ((λ s → s lft∈? nullables Rs)) zs xs
soundLem A zs Rs rin 
  with foldlth Rule _≟_  (A , zs) Rs (norm-e-f Rs) rin
... | (x , x₁) , d2 , d3 rewrite soundLem''' A zs x ((allSubSeq (λ s → s lft∈? nullables Rs) x₁)) (soundLem' (A , zs) ((foldl (λ res rhs → (x , rhs) ∷ res) []
       (foldr
        (λ x₂ res →
           if x₂ lft∈? nullables Rs then
           res ++ map (_∷_ x₂) res else Data.List.map (_∷_ x₂) res)
        ([] ∷ []) x₁))) (x , []) d3)  = x₁ , d2 , subseqcombsInv  {_} {(λ s → s lft∈? nls)} zs x₁ q

 where
    z = soundLem' (A , zs) ((foldl (λ res rhs → (x , rhs) ∷ res) []
       (foldr
        (λ x₂ res →
           if x₂ lft∈? nlbls Rs (foldr (λ _ → suc) 0 Rs) then
           res ++ map (_∷_ x₂) res else Data.List.map (_∷_ x₂) res)
        ([] ∷ []) x₁))) (x , []) d3  
    nls = nullables Rs
    q = soundLem'' A zs x ((allSubSeq (λ s → s lft∈? nls) x₁)) z 


{- 
  = 
-}

SubSeqL : List N → List Symbol → List Symbol  → Set
SubSeqL as bs cs = SubSeq (λ s → s lft∈? as) bs cs

mutual
 ne-snd :  ∀ Rs A xs → Tree (norm-e Rs) A xs → Tree Rs A xs
 ne-snd Rs A xs (node {zs} x x₁) = node (proj₁ (proj₂ z)) (soundMut Rs zs (proj₁ z) xs (proj₂ (proj₂ z)) x₁)
   where
     z = soundLem A zs Rs x

 soundMut : ∀ Rs zs xs ws →
    SubSeqL (nullables Rs) zs xs →
       ListOfTs (norm-e Rs) zs ws → ListOfTs Rs xs ws
 soundMut Rs .[] .[] .[] con1 ⟦⟧ = ⟦⟧
 soundMut Rs zs .(inj₂ x ∷ ys) ws (con2 {.zs} {ys} {inj₂ x} sub ()) lot
 soundMut Rs zs .(inj₁ x ∷ ys) ws (con2 {.zs} {ys} {inj₁ x} sub x₁) lot 
     with _∷n_ (nlbls-snd (length Rs) Rs (∈?Sound x _ x₁)) (soundMut Rs zs ys ws sub lot) 
 ... | d rewrite ++-th ws = d
 soundMut Rs .(inj₂ x ∷ xs) .(inj₂ x ∷ ys) .(x ∷ ys₁) (con3 {xs} {ys} {inj₂ x} sub) (_∷t_ {.xs} {ys₁} .x lot) 
  = _∷t_ x (soundMut Rs xs ys ys₁ sub lot)
 soundMut Rs .(inj₁ x ∷ xs) .(inj₁ x ∷ ys) .(zs ++ ys₁) (con3 {xs} {ys} {inj₁ x} sub) 
   (_∷n_ {.xs} {ys₁} {.x} {zs} x₁ lot)
  = _∷n_ (ne-snd Rs x zs x₁) (soundMut Rs xs ys ys₁ sub lot)






nulls-gen : ∀ Rs xs ys ds → SubSeq (λ s → s lft∈? nullables Rs) xs ys 
                                   → ListOfTs Rs xs ds → ListOfTs Rs ys ds 
nulls-gen Rs .[] .[] .[] con1 ⟦⟧ = ⟦⟧
nulls-gen Rs xs .(inj₂ x ∷ ys) ds (con2 {.xs} {ys} {inj₂ x} sub ()) lot 
nulls-gen Rs xs .(inj₁ x ∷ ys) ds (con2 {.xs} {ys} {inj₁ x} sub x₁) lot 
  = _∷n_ (nlbls-snd (length Rs) Rs (∈?Sound x _ x₁)) 
         (nulls-gen Rs xs ys ds sub lot)
nulls-gen Rs .(inj₂ t ∷ xs) .(inj₂ t ∷ ys) .(t ∷ ys₁) (con3 {xs} {ys} sub) 
  (_∷t_ {.xs} {ys₁} t lot) = _∷t_ t (nulls-gen Rs xs ys ys₁ sub lot)
nulls-gen Rs .(inj₁ n ∷ xs) .(inj₁ n ∷ ys) .(zs ++ ys₁) (con3 {xs} {ys} sub) 
  (_∷n_ {.xs} {ys₁} {n} {zs} x lot) = _∷n_ x (nulls-gen Rs xs ys ys₁ sub lot)


ne-progress :  ∀ A Rs → (A , []) ∉ (norm-e Rs)
ne-progress  A Rs rin with foldlth Rule _≟_ {Rule} (A , []) Rs (norm-e-f Rs) rin
ne-progress A Rs rin | (x , x₁) , d2 , d3 with soundLem''' A [] x ((foldr
        (λ x₂ res →
           if x₂ lft∈? nlbls Rs (foldr (λ _ → suc) 0 Rs) then
           res ++ Data.List.map (_∷_ x₂) res else Data.List.map (_∷_ x₂) res)
        ([] ∷ []) x₁)) (soundLem' (A , []) (foldl (λ res rhs → (x , rhs) ∷ res) []
       (foldr
        (λ x₂ res →
           if x₂ lft∈? nlbls Rs (foldr (λ _ → suc) 0 Rs) then
           res ++ map (_∷_ x₂) res else map (_∷_ x₂) res)
        ([] ∷ []) x₁)) (x , []) d3) 
... | d rewrite d 
  = complete/ Rule _≟_  {(x , [])} (foldl (λ res rhs → (x , rhs) ∷ res) []
       (foldr
        (λ x₂ res →
           if x₂ lft∈? nlbls Rs (foldr (λ _ → suc) 0 Rs) then
           res ++ map (_∷_ x₂) res else map (_∷_ x₂) res)
        ([] ∷ []) x₁)) d3
