

module CNF.NormExample where

open import Relation.Nullary
open import Relation.Nullary.Decidable hiding (map)
open import Relation.Binary.PropositionalEquality as PropEq hiding ([_] ; inspect)

open import Data.Product hiding (map)
open import Data.Nat 
open import Data.Nat.Show 
open import Data.Bool hiding (_∨_ ; T ; _≟_)
open import Data.List
open import Data.Empty
open import Data.String renaming (_++_ to _++s_) hiding (_≟_)
open import Data.Char hiding (_≟_)

open import Utils.ListsAddition
open import Utils.ListMembership

open import CNF.NormInvariants
open import CNF.NormNatInstance
open import CNF.NormCorrectness ℕ ℕ _≟_ _≟_ newntlst newntlstlem
open import CNF.Grammar ℕ ℕ _≟_ _≟_


open import Foreign.Haskell
open import IO.Primitive

module Example1 where


  {-
              ### Example 1 ###
     Expr 	→ Term 	| Expr AddOp Term 	| AddOp Term
     Term 	→ Factor 	| Term MulOp Factor
     Factor 	→ Primary 	| Factor ^ Primary
     Primary 	→ Number 	| Variable 	| ( Expr )
     AddOp 	→ + 	| −
     MulOp 	→ * 	| /
  -}

  -- nonterminals
  Expr    = 1
  Term    = 2
  Factor  = 3
  Primary = 4
  AddOp   = 5
  MulOp   = 6
  Number  = 7
  Variable = 8
  -- terminals
  + = 2
  * = 3
  / = 4
  - = 5
  ^ = 6
  [ = 7
  ] = 8



  nt2str : ℕ → String
  nt2str 1 = "Expr"
  nt2str 2 = "Term"
  nt2str 3 = "Factor"
  nt2str 4 = "Primary"
  nt2str 5 = "AddOp"
  nt2str 6 = "MulOp"
  nt2str 7 = "Number"
  nt2str 8 = "Variable"
  nt2str n = "New" ++s (Data.Nat.Show.show n)

  tm2str : ℕ → String
  tm2str 1 = "1"
  tm2str 2 = "+"
  tm2str 3 = "*"
  tm2str 4 = "/"
  tm2str 5 = "-"
  tm2str 6 = "^"
  tm2str 7 = "("
  tm2str 8 = ")"
  tm2str 9 = "x"
  tm2str _ = ""

  open import Data.Sum
  open import Data.Product

  
  rs : Rules
  rs =   Expr ⟶ (nt Term ∷ []) 
       ∷ Expr ⟶ (nt Expr ∷ nt AddOp ∷ nt Term ∷ []) 
       ∷ Expr ⟶ (nt AddOp ∷ nt Term ∷ [])

       ∷ Term ⟶ (nt Factor ∷ []) 
       ∷ Term ⟶ (nt Term ∷ nt MulOp ∷ nt Factor ∷ []) 

       ∷ Factor ⟶ (nt Primary ∷ []) 
       ∷ Factor ⟶ (nt Factor ∷ tm ^ ∷ nt Primary ∷ [])

       ∷ Primary ⟶ (nt Number ∷ [])
       ∷ Primary ⟶ (nt Variable ∷ [])
       ∷ Primary ⟶ (tm [ ∷ nt Expr ∷ tm ] ∷ [])
       
       ∷ AddOp ⟶ (tm + ∷ [])
       ∷ AddOp ⟶ (tm - ∷ [])


       ∷ MulOp ⟶ (tm * ∷ [])
       ∷ MulOp ⟶ (tm / ∷ [])

       ∷ Number ⟶ (tm 1 ∷ [])

       ∷ Variable ⟶ (tm 9 ∷ [])

       ∷ []

  G : Grammar
  G = record{ Rs = rs ; S = Expr }


  symb2str : Symbols → String
  symb2str [] = ""
  symb2str (inj₂ x ∷ []) = tm2str x
  symb2str (inj₁ x ∷ []) = nt2str x
  symb2str (inj₂ x ∷ xs) = tm2str x ++s "∙" ++s symb2str xs
  symb2str (inj₁ x ∷ xs) = nt2str x ++s "∙" ++s symb2str xs


  rules2str : Rules → String
  rules2str [] = ""
  rules2str ((x , x₁) ∷ rs) = nt2str x ++s " ⟶ " ++s (symb2str x₁) ++s "\n"  ++s rules2str rs

  grammar2str : Grammar → String
  grammar2str G = "Start Nonterminal:" ++s (nt2str (S G)) ++s "\n" ++s rules2str (Rs G)

module Example2 where

  A = 1
  B = 2
  C = 3
  D = 4

  c = 1

  rs2 =  A ⟶ (nt B ∷ nt C ∷ nt D ∷ [])
       ∷ A ⟶ (nt B ∷ [])

       ∷ B ⟶ []
       ∷ B ⟶ (nt A ∷ [])
       

       ∷ C ⟶ (tm c ∷ [])

       ∷ D ⟶ []

       ∷ []


  {-
                 A
                 |
            B ∙  C ∙ D
            |    |   |
            A    |   |
            |    |   |
            B    |   |
            |    |   |
           [ ]   c  [ ]
  -}


open Example1

main : IO Unit
main = putStrLn (toCostring (rules2str (norm rs)))

