

open import Relation.Binary
open import Relation.Nullary
open import Relation.Binary.PropositionalEquality hiding ([_])
open import Data.List
open import Utils.ListsAddition
open import Utils.ListMembership

module CNF.NormFreshNonterminals  (N T : Set)(_=n_ : Decidable (_≡_ {A = N}))(_=t_ : Decidable (_≡_ {A = T}))  
  (newntlst : List N → N) 
  (newntlstlem : (ns : List N) → (newntlst ns) ∉ ns) where

open import Data.Product
open import Data.Sum
open import Data.Empty 

open import Utils.ListMembership

open import CNF.Grammar N T _=n_ _=t_
open import CNF.ParseTree N T _=n_ _=t_
open import Utils.ListProperties
open import Utils.Logic 

ntonly : List Symbol → List N
ntonly [] = []
ntonly (inj₂ x ∷ xs) = ntonly xs
ntonly (inj₁ x ∷ xs) = x ∷ ntonly xs


newnt : Rules → N
newnt [] = newntlst []
newnt Rs = newntlst (ntonly (filterAllSmbls Rs))


ntonly-lem : ∀ xs ys →  ntonly (xs ++ ys) ≡ ntonly xs ++ ntonly ys
ntonly-lem [] ys = refl
ntonly-lem (inj₂ x ∷ xs) ys = ntonly-lem xs ys 
ntonly-lem (inj₁ x ∷ xs) ys rewrite ntonly-lem xs ys =  refl

ntonly-lem2 : ∀ xs n → (inj₁ n) ∈ xs →  n ∈ ntonly xs 
ntonly-lem2 [] n ()
ntonly-lem2 (.(inj₁ n) ∷ xs) n here = here
ntonly-lem2 (inj₂ x ∷ xs) n (there prf) = ntonly-lem2 xs n prf 
ntonly-lem2 (inj₁ x ∷ xs) n (there prf) = there (ntonly-lem2 xs n prf)


newntlem33 : (Rs : Rules) → (n : N) → (inj₁ n) ∈ (filterAllSmbls Rs)
 → n ∈ (ntonly (filterAllSmbls Rs))
newntlem33 [] n ()
newntlem33 ((x , x₁) ∷ Rs) n prf 
  rewrite foldth2 Rs (inj₁ x ∷ x₁ ++ []) filterAllSmbls-f 
  with incLem {_} {inj₁ n} {(filterAllSmbls Rs)} {inj₁ x ∷ x₁ ++ []} prf 
... | inj₁ o with newntlem33 Rs n o 
... | z rewrite ntonly-lem (filterAllSmbls Rs) (inj₁ x ∷ x₁ ++ []) 
  = inFirst {_} {n} {ntonly (filterAllSmbls Rs)} {x ∷ ntonly (x₁ ++ [])} z

newntlem33 ((x , x₁) ∷ Rs) n prf | inj₂ o rewrite ++-th (inj₁ x ∷ x₁) 
 | ntonly-lem (filterAllSmbls Rs) (inj₁ x ∷ x₁)  
 = inTwo {_} {n} {ntonly (inj₁ x ∷ x₁)} {ntonly (filterAllSmbls Rs)} (ntonly-lem2 (inj₁ x ∷ x₁) n o)


newntlem : (Rs : Rules) → (inj₁ (newnt Rs)) ∉ (filterAllSmbls Rs)
newntlem [] ()
newntlem (r ∷ Rs) prf with newntlem33 (r ∷ Rs) (newnt (r ∷ Rs)) prf 
... | o =  newntlstlem _ o
