

open import Data.List
open import Utils.ListMembership
open import Utils.Logic

module CNF.NormGrammar (N T : Set)(_=n_ : DecEq N)(_=t_ : DecEq T) 
  (newntlst : List N → N)  
  (newntlstlem : (ns : List N) → (newntlst ns) ∉ ns) 
 where


open import Relation.Nullary
open import Relation.Binary.PropositionalEquality  hiding ([_]; inspect)

open import Function.Equivalence

open import Data.Empty
open import Data.Product hiding (map)
open import Data.Sum hiding (map)
open import Data.Nat hiding (_≟_)
open import Data.Bool hiding (_∨_ ; T ; _≟_)

open import Utils.ListProperties

open import CNF.Grammar N T _=n_ _=t_ 
open import CNF.ParseTree N T _=n_ _=t_
open import CNF.ParseTreeProperties N T _=n_ _=t_
open import CNF.NormEpsRules N T _=n_ _=t_ 
open import CNF.Nullable N T _=n_ _=t_
open import CNF.NullableUtility N T _=n_ _=t_
open import CNF.NullableSound  N T _=n_ _=t_
open import CNF.NullableComplete N T _=n_ _=t_
open import CNF.NormUnitRules N T _=n_ _=t_ 
open import CNF.NormLongRules N T _=n_ _=t_ newntlst newntlstlem 
open import CNF.NormTermRules N T _=n_ _=t_ newntlst newntlstlem 
open import CNF.NormCorrectness N T _=n_ _=t_ newntlst newntlstlem   
open import CNF.NormGrammarInvariants N T _=n_ _=t_ newntlst newntlstlem  
open import CNF.NormFreshNonterminals N T _=n_ _=t_ newntlst newntlstlem 


-- well-formedness predicate 
-- (start nonterminal must be used in the rules)
well-formed : (G : Grammar) → Set
well-formed G 
  = inj₁ (S G) ∈ filterAllSmbls (Rs G)

-- language of the grammar
TreeS : Grammar → List T → Set
TreeS G s = Tree (Rs G) (S G) s

TreeGen : Grammar → N → List T → Set
TreeGen G A s = Tree (Rs G) A s

ListOfTsGen : Grammar → Symbols → List T → Set
ListOfTsGen G xs s = ListOfTs (Rs G) xs s


-- grammar normalization function
normS : Grammar → Grammar
normS G = record { 
  S  = S'; 
  Rs = if (S G) ∈? nullables (Rs G)
       then (S' , []) ∷ Rs'
       else Rs'
  } 
 where
   S'  = newnt (Rs G)
   Rs' = norm ((newnt (Rs G) , [ inj₁ (S G) ]) ∷ Rs G)


-- progress
rhslem : ∀ S Rs → (inj₁ S) ∈ filterAllSmbls Rs → S ∉ RHS Rs → S ∉ RHS (norm Rs)
rhslem S Rs sin sout 
 with nlr-g-inv (nl-measure Rs) Rs S sin sout 
      | stepPreservesSymbols (inj₁ S) Rs (nl-measure Rs) sin
... | s-out | s-in 
    with ntr-g-inv (ntr-length (norm-l Rs)) (norm-l Rs) S s-in s-out 
... | t-s-out = normuRHS∉ (norm-e (norm-t (norm-l Rs))) S 
                      (normeRHS∉ (norm-t (norm-l Rs)) S t-s-out)


rhslemG' : ∀ Rs S → (inj₁ S) ∈ filterAllSmbls Rs → S ≢ (newnt Rs)
rhslemG' Rs .(newnt Rs) sin refl = newntlem Rs sin


rhslemG : ∀ S Rs → (inj₁ S) ∈ filterAllSmbls Rs 
                 → (newnt Rs) ∉ RHS (norm ((newnt Rs , [ inj₁ S ]) ∷ Rs))
rhslemG S Rs sin  newin with S =n (newnt Rs) 
... | yes p = rhslemG' Rs S sin p
... | no ¬p = rhslem (newnt Rs) (((newnt Rs , [ inj₁ S ]) ∷ Rs)) 
               (LHS-All (newnt Rs) 
               (((newnt Rs , [ inj₁ S ]) ∷ Rs)) 
               (LHS-complete (newnt Rs) [ inj₁ S ]  
               ((newnt Rs , [ inj₁ S ]) ∷ Rs) here))  
               (λ prf → hlp (newnt Rs) prf (newntlem3 Rs) ¬p) 
               newin
  where
   hlp : ∀ L → L ∈ (S ∷ RHS Rs) → L ∉ (RHS Rs) → S ≢ L → ⊥
   hlp .S here snin neq = neq refl
   hlp L (there prf) snin neq  = snin prf


-- normalized grammar is in CNF
progress : (G : Grammar) → (inj₁ (S G)) ∈ (filterAllSmbls (Rs G))
  → (A : N) → (rhs : Symbols)
  → let G' = normS G in (A , rhs) ∈ (Rs G')
  → (((Σ[ n₁ ∈ N ] Σ[ n₂ ∈ N ] rhs ≡ (inj₁ n₁ ∷ inj₁ n₂ ∷ [])) ⊎ 
     (Σ[ t ∈ T ] rhs ≡ [ inj₂ t ] )) ⊎ 
     (rhs ≡ [] × A ≡ (S G'))) ×
      (S G') ∉ RHS (Rs G')

progress G wf A rhs pin with (S G) ∈? nullables (Rs G) 
progress G wf A rhs pin | false
    with norm-progress ((newnt (Rs G) , [ inj₁ (S G) ]) ∷ Rs G) A rhs pin 
... | inj₁ x = inj₁ (inj₁ x) , rhslemG (S G) (Rs G) wf
... | inj₂ x = inj₁ (inj₂ x) , rhslemG (S G) (Rs G) wf
progress G wf A rhs (there pin) | true 
  with norm-progress ((newnt (Rs G) , [ inj₁ (S G) ]) ∷ Rs G) A rhs pin 
progress G wf A rhs (there pin) | true 
  | inj₁ x = inj₁ (inj₁ x) , rhslemG (S G) (Rs G) wf
progress G wf A rhs (there pin) | true 
  | inj₂ x = inj₁ (inj₂ x) , rhslemG (S G) (Rs G) wf
progress G wf .(newnt (Rs G)) .[] here
  | true = inj₂ (refl , refl) , rhslemG (S G) (Rs G) wf





-- completeness
cmplt : (G : Grammar) → (s : List T) → Tree (Rs G) (S G) s 
                                      → Tree (Rs (normS G)) (S (normS G)) s
cmplt G s t with inspect ((S G) ∈? nullables (Rs G))
cmplt G [] t | it false o rewrite o with nlbls-cmplt (Rs G) t 
... | p rewrite ∈?Complete (S G) _ p with o
... | ()
cmplt G (x ∷ xs) t | it false o rewrite o 
  with node here ((Rs-weaken (Rs G) (S G) (x ∷ xs) 
                            ((newnt (Rs G) , (inj₁ (S G) ∷ []))) t) ∷n ⟦⟧) 
... | t' rewrite ++-th (x ∷ xs)
   = (norm-cmplt _ _ _ t' (λ { () }))
cmplt G [] t | it true o rewrite o 
   = node here ⟦⟧ 
cmplt G (x ∷ xs) t 
    | it true o rewrite o 
    with node here ((Rs-weaken (Rs G) (S G) (x ∷ xs) 
                            ((newnt (Rs G) , (inj₁ (S G) ∷ []))) t) ∷n ⟦⟧) 
... | t' rewrite ++-th (x ∷ xs) 
    = Rs-weaken _ _ _ _ (norm-cmplt _ _ _ t' (λ { () }))



-- soundness
mutual
 snd-strngh : ∀ Rs L R A s → Tree ((L , [ inj₁ R ]) ∷ Rs) A s  
   → L ∉ RHS Rs
   → Tree Rs A s ⊎ (A ≡ L × Tree Rs R s)
 snd-strngh RS L R .L .(zs ++ []) (node here (_∷n_ {.[]} {.[]} {.R} {zs} x ⟦⟧)) pr 
   with snd-strngh _ _ _ _ _ x pr 
 ... | inj₁ q rewrite ++-th zs = inj₂ (refl , q)
 snd-strngh RS L .L .L .(zs ++ []) (node here (_∷n_ {.[]} {.[]} {.L} {zs} x ⟦⟧)) pr 
     | inj₂ (refl , proj₂) rewrite ++-th zs = inj₂ (refl , proj₂)
 snd-strngh RS L R A s (node (there x) x₁) pr 
     = inj₁ (node x (snd-strngh-mut _ _ _ _ _ x₁ pr (RHS∉c RS L pr A _ x)))

 snd-strngh-mut : ∀ Rs L R rhs s → ListOfTs ((L , [ inj₁ R ]) ∷ Rs) rhs s  
    → L ∉ RHS Rs
    → (inj₁ L) ∉ rhs
    → ListOfTs Rs rhs s  
 snd-strngh-mut Rs L R .[] .[] ⟦⟧ pr1 pr2 = ⟦⟧
 snd-strngh-mut Rs L R .(inj₂ t ∷ xs) .(t ∷ ys) (_∷t_ {xs} {ys} t lt) pr1 pr2 
     = t ∷t snd-strngh-mut  Rs L R xs ys lt pr1 (λ ntlin → pr2 (there ntlin)) 
 snd-strngh-mut Rs L R .(inj₁ n ∷ xs) .(zs ++ ys) (_∷n_ {xs} {ys} {n} {zs} x lt) pr1 pr2 
     with snd-strngh _ _ _ _ _ x pr1 
 snd-strngh-mut Rs L R .(inj₁ n ∷ xs) .(zs ++ ys) (_∷n_ {xs} {ys} {n} {zs} x lt) pr1 pr2 
     | inj₁ x₁ = x₁ ∷n snd-strngh-mut _ _ _ _ _ lt pr1  (λ ntlin → pr2 (there ntlin))
 snd-strngh-mut Rs L R .(inj₁ L ∷ xs) .(zs ++ ys) (_∷n_ {xs} {ys} {.L} {zs} x lt) pr1 pr2 
     | inj₂ (refl , proj₂) with pr2 here 
 ... | ()


mutual 
 snd-hlp : ∀ Rs L A s → Tree ((L , []) ∷ Rs) A s → L ∉ RHS Rs
  → Tree Rs A s ⊎ (A ≡ L × s ≡ [])
 snd-hlp Rs L .L .[] (node here ⟦⟧) z 
    = inj₂ (refl , refl) 
 snd-hlp Rs L A s (node (there x) x₁) z 
    = inj₁ (node x (snd-hlp-mut _ _ _ _ x₁ z (RHS∉c Rs L z A _ x )))

 snd-hlp-mut : ∀ Rs L rhs s → ListOfTs ((L , []) ∷ Rs) rhs s → L ∉ RHS Rs
   → (inj₁ L) ∉ rhs
   → ListOfTs Rs rhs s  
 snd-hlp-mut Rs L .[] .[] ⟦⟧ pr pr1 = ⟦⟧
 snd-hlp-mut Rs L .(inj₂ t ∷ xs) .(t ∷ ys) (_∷t_ {xs} {ys} t ts) pr pr1
    = t ∷t snd-hlp-mut Rs L xs ys ts pr (λ rin → pr1 (there rin))
 snd-hlp-mut Rs L .(inj₁ n ∷ xs) .(zs ++ ys) (_∷n_ {xs} {ys} {n} {zs} x ts) pr pr1 
   with snd-hlp Rs L n zs x pr 
 ... | inj₁ x₁ = x₁ ∷n snd-hlp-mut Rs L xs ys ts pr (λ prin → pr1 (there prin))
 snd-hlp-mut Rs L .(inj₁ L ∷ xs₁) .([] ++ ys) (_∷n_ {xs₁} {ys} (node x x₁) ts) pr pr1 
     | inj₂ (refl , refl) with pr1 here 
 ... | ()


snd : (G : Grammar) → well-formed G → (s : List T) 
            → Tree (Rs (normS G)) (S (normS G)) s → Tree (Rs G) (S G) s
snd G p s t with inspect ((S G) ∈? nullables (Rs G)) 
snd G p s t | it true x rewrite x 
  with snd-hlp _ (newnt (Rs G)) _ _ t (rhslemG (S G) (Rs G) p ) 
snd G p s t  | it true x | inj₁ x₁ 
  with let q = (LHS-All (newnt (Rs G)) 
                  (((newnt (Rs G) , [ inj₁ (S G) ]) ∷ Rs G)) 
                  (LHS-complete (newnt (Rs G)) [ inj₁ (S G) ] 
                  ((newnt (Rs G) , [ inj₁ (S G) ]) ∷ Rs G) here)) 
       in norm-snd ((newnt (Rs G) , [ inj₁ (S G) ]) ∷ Rs G) _ _ x₁ q
snd G p s t  | it true x | inj₁ x₁ | t'' 
  with snd-strngh _ _ _ _ _ t'' (newntlem3 (Rs G)) 
snd G p s t  | it true x | inj₁ x₁ | t'' | inj₂ x₂ = proj₂ x₂
snd G p s t  | it true x | inj₁ x₁ | t'' | inj₁ (node f r) 
  with newntlem4 (Rs G) (LHS-complete _ _ _ f) 
... | ()
snd G p .[] t  | it true x | inj₂ (refl , refl) 
  = nlbls-snd (length (Rs G)) _ 
              (∈?Sound (S G)  (nlbls (Rs G) (length (Rs G))) x) 
snd G p s t   | it false x rewrite x 
   with let q = (LHS-All (newnt (Rs G)) 
                  (((newnt (Rs G) , [ inj₁ (S G) ]) ∷ Rs G)) 
                  (LHS-complete (newnt (Rs G)) [ inj₁ (S G) ] 
                  ((newnt (Rs G) , [ inj₁ (S G) ]) ∷ Rs G) here)) 
       in norm-snd ((newnt (Rs G) , [ inj₁ (S G) ]) ∷ Rs G) _ _ t q
snd G p s t  | it false x |  t'' 
  with snd-strngh _ _ _ _ _ t'' (newntlem3 (Rs G)) 
snd G p s t  | it false x | t'' | inj₁ (node f r) 
  with newntlem4 (Rs G) (LHS-complete _ _ _ f) 
... | ()
snd G p s t  | it false x |  t'' | inj₂ x₂ = proj₂ x₂


-- grammar normalization is sound and complete
snd&cmplt : (G : Grammar) → (s : List T)
   → well-formed G
   → TreeS G s ⇔ TreeS (normS G) s 
snd&cmplt G s wf = equivalence 
                      (λ t → cmplt G s t) 
                      (λ t → snd G wf s t)
