

open import Data.List
open import Utils.ListMembership
open import Utils.Logic

-- this module establishes invariants important for grammar normalization
module CNF.NormGrammarInvariants (N T : Set)(_=n_ : DecEq N)(_=t_ : DecEq T) 
  (newntlst : List N → N)  
  (newntlstlem : (ns : List N) → (newntlst ns) ∉ ns) where 

open import Relation.Nullary
open import Relation.Binary.PropositionalEquality hiding ([_]; inspect)

open import Data.List
open import Data.Empty
open import Data.Product
open import Data.Sum
open import Data.Nat hiding (_≟_)
open import Data.Bool hiding (_≟_ ; _∨_ ; T)

open import Utils.ListsAddition
open import Utils.ListProperties

open import CNF.Grammar N T _=n_ _=t_
open import CNF.ParseTree N T _=n_ _=t_
open import CNF.ParseTreeProperties N T _=n_ _=t_
open import CNF.NormUnitRules N T _=n_ _=t_
open import CNF.NormEpsRules N T _=n_ _=t_
open import CNF.NormInvariants N T _=n_ _=t_ newntlst newntlstlem 
open import CNF.NormLongRules N T _=n_ _=t_ newntlst newntlstlem
open import CNF.NormTermRules N T _=n_ _=t_ newntlst newntlstlem
open import CNF.NormFreshNonterminals N T _=n_ _=t_ newntlst newntlstlem

open DecListMinus
open DecExistance



-- norm-l
nl-step-rhs : ∀ Rs L → (inj₁ L) ∈ filterAllSmbls Rs → L ∉ RHS Rs → L ∉ RHS (nl-step Rs)
nl-step-rhs Rs L p2 p pin with applyToFirstLem nl-step-p (nl-step-f Rs) Rs 
nl-step-rhs Rs L p2 p pin 
    | inj₁ x rewrite x with p pin 
... | ()
nl-step-rhs .(proj₁ ++ proj₃ ∷ proj₂) L p2 p pin 
  | inj₂ (proj₁ , proj₂ , proj₃ , refl , proj₄ , proj₅) rewrite proj₅ 
  | RHSh proj₁ (proj₃ ∷ proj₂) 
  | RHSh proj₁ (nl-step-f (proj₁ ++ proj₃ ∷ proj₂) proj₃ ++ proj₂) 
  | RHSh (nl-step-f (proj₁ ++ proj₃ ∷ proj₂) proj₃) proj₂ 
  with ∉p (RHS proj₁) (RHS (proj₃ ∷ proj₂)) L p 
nl-step-rhs .(proj₁ ++ proj₃ ∷ proj₂) L p2 p pin 
  | inj₂ (proj₁ , proj₂ , proj₃ , refl , proj₄ , proj₅) 
  | (pp1 , pp2) with ∈∉ _ _ L pin  pp1 
nl-step-rhs .(proj₁ ++ proj₃ ∷ proj₂) L p2 p pin 
  | inj₂ (proj₁ , proj₂ , proj₃ , refl , proj₄ , proj₅) 
  | (pp1 , pp2) 
  | z rewrite RHSh [ proj₃ ] proj₂  
  with (∉p (RHS [ proj₃ ])  (RHS proj₂ ) L pp2) 
nl-step-rhs .(proj₁ ++ proj₃ ∷ proj₂) L p2 p pin 
  | inj₂ (proj₁ , proj₂ , proj₃ , refl , proj₄ , proj₅) 
  | (pp1 , pp2) 
  | z 
  |  q1 , q2  
  with ∉∈ (RHS (nl-step-f (proj₁ ++ proj₃ ∷ proj₂) proj₃)) (RHS proj₂) L z q2 
nl-step-rhs .(proj₁ ++ (lhs , []) ∷ proj₂) L p2 p pin 
  | inj₂ (proj₁ , proj₂ , (lhs , []) , refl , () , proj₅) 
  | (pp1 , pp2) 
  | z | q1 , q2 | oo 
nl-step-rhs .(proj₁ ++ (lhs , (x₁ ∷ [])) ∷ proj₂) L p2 p pin 
  | inj₂ (proj₁ , proj₂ , (lhs , (x₁ ∷ [])) , refl , () , proj₅) 
  | (pp1 , pp2) 
  | z | q1 , q2 | oo
nl-step-rhs .(proj₁ ++ (lhs , (x₁ ∷ x₂ ∷ [])) ∷ proj₂) L p2 p pin 
  | inj₂ (proj₁ , proj₂ , (lhs , (x₁ ∷ x₂ ∷ [])) , refl , () , proj₅) 
  | (pp1 , pp2) 
  | z | q1 , q2 | oo 
nl-step-rhs .(proj₁ ++ (lhs , (x₁ ∷ x₂ ∷ x₃ ∷ x₄)) ∷ proj₂) L p2 p pin 
  | inj₂ (proj₁ , proj₂ , (lhs , (x₁ ∷ x₂ ∷ x₃ ∷ x₄)) , refl , proj₄ , proj₅) 
  | (pp1 , pp2) 
  | z | q1 , q2  
  | oo 
  with (proj₁ ++ (lhs , (x₁ ∷ x₂ ∷ x₃ ∷ x₄)) ∷ proj₂) 
... | Rs' rewrite ++-th (NTs' (x₁ ∷ x₂ ∷ x₃ ∷ x₄)) 
  | ++-th (NTs' (x₁ ∷ x₂ ∷ [])) 
  | NTs'h (x₁ ∷ x₂ ∷ []) (x₃ ∷ x₄) 
  with ∉p (NTs' (x₁ ∷ x₂ ∷ [])) (NTs' (x₃ ∷ x₄)) L q1 
... | w1 , w2 
  rewrite snglt (∉∈ [ newnt Rs' ] (NTs' (x₃ ∷ x₄)) L 
  (∉∈ (newnt Rs' ∷ NTs' (x₃ ∷ x₄)) 
  (NTs' (x₁ ∷ x₂ ∷ [])) L oo w1) w2) = newntlem Rs' p2


nlr-g-inv : ∀ n Rs L → (inj₁ L) ∈ (filterAllSmbls Rs) 
            → L ∉ RHS Rs → L ∉ RHS (repeatStep Rs n)
nlr-g-inv zero Rs L lin lout = lout
nlr-g-inv (suc n) Rs L lin lout
  with nlr-g-inv n Rs L lin lout
... | IH  = nl-step-rhs (repeatStep Rs n) L 
  (stepPreservesSymbols (inj₁ L) Rs n lin) IH 



-- norm-t
nt-step-rhs : ∀ Rs L → (inj₁ L) ∈ filterAllSmbls Rs 
                 → L ∉ RHS Rs → L ∉ RHS (nt-step Rs)
nt-step-rhs Rs L p2 p pin 
  with applyToFirstLem nt-step-p (nt-step-f Rs) Rs 
nt-step-rhs Rs L p2 p pin 
  | inj₁ x rewrite x with p pin 
... | ()
nt-step-rhs .(proj₁ ++ proj₃ ∷ proj₂) L p2 p pin 
  | inj₂ (proj₁ , proj₂ , proj₃ , refl , proj₄ , proj₅) 
  rewrite proj₅ 
  | RHSh proj₁ (proj₃ ∷ proj₂) 
  | RHSh proj₁ (nt-step-f (proj₁ ++ proj₃ ∷ proj₂) proj₃ ++ proj₂) 
  | RHSh (nt-step-f (proj₁ ++ proj₃ ∷ proj₂) proj₃) proj₂ 
  with ∉p (RHS proj₁) (RHS (proj₃ ∷ proj₂)) L p 
nt-step-rhs .(proj₁ ++ proj₃ ∷ proj₂) L p2 p pin 
  | inj₂ (proj₁ , proj₂ , proj₃ , refl , proj₄ , proj₅) 
  | (pp1 , pp2) with ∈∉ _ _ L pin  pp1 
nt-step-rhs .(proj₁ ++ proj₃ ∷ proj₂) L p2 p pin 
  | inj₂ (proj₁ , proj₂ , proj₃ , refl , proj₄ , proj₅) 
  | (pp1 , pp2) 
  | z rewrite RHSh [ proj₃ ] proj₂  
  with (∉p (RHS [ proj₃ ])  (RHS proj₂ ) L pp2) 
nt-step-rhs .(proj₁ ++ proj₃ ∷ proj₂) L p2 p pin 
  | inj₂ (proj₁ , proj₂ , proj₃ , refl , proj₄ , proj₅) 
  | (pp1 , pp2) 
  | z 
  | q1 , q2  
  with ∉∈ (RHS (nt-step-f (proj₁ ++ proj₃ ∷ proj₂) proj₃)) (RHS proj₂) L z q2 
nt-step-rhs .(proj₁ ++ (lhs , []) ∷ proj₂) L p2 p pin 
  | inj₂ (proj₁ , proj₂ , (lhs , []) , refl , () , proj₅) 
  | (pp1 , pp2) 
  | z 
  | q1 , q2  
  | oo 
nt-step-rhs .(proj₁ ++ (lhs , (x₁ ∷ [])) ∷ proj₂) L p2 p pin 
  | inj₂ (proj₁ , proj₂ , (lhs , (x₁ ∷ [])) , refl , () , proj₅)
  | (pp1 , pp2) 
  | z 
  | q1 , q2  
  | oo
nt-step-rhs .(proj₁ ++ (lhs , (x₁ ∷ x₂ ∷ x₃)) ∷ proj₂) L p2 p pin 
  | inj₂ (proj₁ , proj₂ , (lhs , (x₁ ∷ x₂ ∷ x₃)) , refl , proj₄ , proj₅)
  | (pp1 , pp2) 
  | z 
  | q1 , q2  
  | oo 
  with inspect (not-all-nonterminals (x₁ ∷ x₂ ∷ x₃))  
... | it false ok =  q1 oo
... | it true ok with not-all-nonterminals-lem (x₁ ∷ x₂ ∷ x₃) ok 
... | x1 , x2 , x3 , x4  
    rewrite x4 with (proj₁ ++ (lhs , (x1 ++ inj₂ x3 ∷ x2)) ∷ proj₂)
... | Rs' 
    rewrite ++-th (NTs' (x1 ++ inj₁ (newnt Rs') ∷ x2)) 
  | ++-th (NTs' (x1 ++ inj₂ x3 ∷ x2)) 
  | NTs'h x1 (inj₂ x3 ∷ x2) 
  | NTs'h x1 (inj₁ (newnt Rs') ∷ x2) 
  with ∉p (NTs' x1) (NTs' x2) L q1 
... | w1 , w2 
  rewrite 
   snglt (∉∈ [ newnt Rs' ] (NTs' x2) L (∈∉ (NTs' x1) 
    (newnt Rs' ∷ NTs' x2) L oo w1) w2) = newntlem Rs' p2  

ntr-g-inv : ∀ n Rs L → (inj₁ L) ∈ (filterAllSmbls Rs) → L ∉ RHS Rs 
                                → L ∉ RHS (repeatOn nt-step Rs n)
ntr-g-inv zero Rs L lin lout = lout
ntr-g-inv (suc n) Rs L lin lout 
  with ntr-g-inv n Rs L lin lout 
... | IH 
  = nt-step-rhs (repeatOn nt-step Rs n) L
    (nt-step-preserves-symbols (inj₁ L) Rs n lin) IH


-- norm-u
inst2 : ∀ s Rs → (∀ A xs → (A , xs) ∈ Rs → s ∉ xs) 
        → ∀ A xs →  (A , xs) ∈ (norm-u Rs) → s ∉ xs 
inst2 s Rs p A xs pin 
  = nu-efct (λ smb → s ∉ smb) Rs p A 
     (filterSnglsRHS Rs) xs pin


normuRHS∉ : ∀ Rs L → L ∉ RHS Rs  → L ∉ RHS (norm-u Rs)
normuRHS∉ Rs L lin = RHS∉s _ L (inst2 (inj₁ L) Rs (RHS∉c Rs L lin))


-- norm-e
inst : ∀ F xs ys →  (s : Symbol) → SubSeq F xs ys → s ∉ ys → s ∉ xs
inst F .[] .[] s con1 pr z = pr z
inst F xs .(y ∷ ys) s (con2 {.xs} {ys} {y} sub x) pr z 
  = inst F xs ys s sub (λ sxs → pr (there sxs)) z
inst F .(s ∷ xs) .(s ∷ ys) s (con3 {xs} {ys} sub) pr here
  = pr here
inst F .(y ∷ xs) .(y ∷ ys) s (con3 {xs} {ys} {y} sub) pr (there z) 
  = inst F xs ys s sub (λ sys → pr (there sys)) z


normeRHSp : ∀ Rs s → (∀ N zs → (N , zs) ∈ Rs → s ∉ zs)  → ∀ A xs 
                            → (A , xs) ∈ (norm-e Rs) → s ∉ xs 
normeRHSp Rs s pr A xs rin = ne-efct Rs (λ xs → s ∉ xs) 
  (λ f xs zs cmbs szs → inst f xs zs s 
    (subseqcombsInv {_} {f} xs zs cmbs) szs) A xs pr rin


normeRHS∉ : ∀ Rs L → L ∉ RHS Rs  → L ∉ RHS (norm-e Rs)
normeRHS∉ Rs L lin1  = RHS∉s _ L (normeRHSp Rs (inj₁ L) (RHS∉c Rs L lin1))
