

module CNF.NormStringInstance where

open import Relation.Nullary
open import Relation.Binary
open import Relation.Nullary.Decidable hiding (map)
open import Relation.Binary.PropositionalEquality as PropEq hiding ([_] ; inspect)

open import Data.Nat hiding (_<_)
open import Data.Char
open import Data.Empty
open import Data.List
open import Data.Product
open import Data.Sum
open import Data.String hiding (_++_)
open import Data.Nat.Show 

open import Utils.ListsAddition
open import Utils.ListProperties
open import Utils.ListMembership
open import Utils.Logic
open import Utils.NatProperties
open import Utils.ArithmeticProperties

StringC = List Char


′_′ : String → StringC
′ s ′  = toList s

newntstr : ℕ → StringC
newntstr zero = toList "zero"
newntstr (suc n) = toList "suc" ++ newntstr n

newntstr-lem : (n m : ℕ) → newntstr n ≡ newntstr m → n ≡ m
newntstr-lem zero zero prf = refl
newntstr-lem zero (suc m) ()
newntstr-lem (suc n) zero ()
newntstr-lem (suc n) (suc m) prf = cong suc (newntstr-lem n m (cong (drop 3) prf))


_=S?_ : DecEq StringC
_=S?_ = (deq2lists Data.Char._≟_)

dis : DecIn StringC
dis = eq2in _=S?_

newntlst'-lem : {X : Set} → (ls p1 p2 : List X) → (p : X) → (len : ℕ)
  → ls ≡ p1 ++ p ∷ p2
  → suc len ≡ length ls
  → len ≡ length (p1 ++ p2)
newntlst'-lem .(p1 ++ p ∷ p2) p1 p2 p len refl pr2 rewrite kkk' p1 (p ∷ p2) |
  (+-comm (length p1) (suc (length p2))) | +-comm (length p2) (length p1) 
  | kkk' p1 p2 = cong pred pr2


newntlst'-lem2 : {X : Set} → (ls p1 p2 : List X) → (p z : X) → (p ≡ z → ⊥)
  → ls ≡ p1 ++ p ∷ p2
  → z ∈ ls
  → z ∈ (p1 ++ p2)
newntlst'-lem2 .(p ∷ p2) [] p2 p .p prf refl here = ex-falso-quodlibet (prf refl)
newntlst'-lem2 .(p ∷ p2) [] p2 p z prf refl (there inp) = inp
newntlst'-lem2 .(x ∷ p1 ++ p ∷ p2) (x ∷ p1) p2 p .x prf refl here = here
newntlst'-lem2 .(x ∷ p1 ++ p ∷ p2) (x ∷ p1) p2 p z prf refl (there inp) = there (newntlst'-lem2 (p1 ++ p ∷ p2) p1 p2 p z prf refl inp)

newntlst' : (l : List StringC) → (len : ℕ) → len ≡ length l → ℕ → StringC
newntlst' ls len prf  n with dis (newntstr n) ls 
newntlst' ls len prf n | no ¬p = (newntstr n)
newntlst' ls len prf n | yes p with exists-split _ _ p 
newntlst' ls (suc len) prf n | yes p | p1 , p2 , p3 
   = newntlst' (p1 ++ p2) len (newntlst'-lem ls p1 p2  (newntstr n) len p3 prf) (suc n)
newntlst' [] zero prf n | yes p | [] , p2 , ()
newntlst' [] zero prf n | yes p | p1 ∷ p2 , p3 , ()
newntlst' (ls ∷ ls₁) zero () n | yes p | p1 , p2 , p3


newntlstlem'' : (l : List StringC) → (len : ℕ) → (p : len ≡ length l) → (n m : ℕ)  
  → m < n → newntlst' l len p n ≡ newntstr m → ⊥
newntlstlem'' ls len p n m <p inp with dis (newntstr n) ls  
newntlstlem'' ls len p n m <p inp | no ¬p = <-sm-eq _ _ <p (newntstr-lem m n (sym inp))
newntlstlem'' ls len p₁ n m <p inp | yes p with exists-split _ _ p 
newntlstlem'' [] zero p₁ n m <p inp | yes p | [] , p2 , ()
newntlstlem'' (ls ∷ ls₁) zero () n m <p inp | yes p | [] , p2 , p3
newntlstlem'' [] zero p₁ n m <p inp | yes p | p1 ∷ p2 , p3 , ()
newntlstlem'' (ls ∷ ls₁) zero () n m <p inp | yes p | p1 ∷ p2 , p3 , p4
newntlstlem'' ls (suc len) prf n m <p inp | yes p | p1 , p2 , p3 = newntlstlem'' (p1 ++ p2) len ((newntlst'-lem ls p1 p2  (newntstr n) len p3 prf)) (suc n) m (<-step <p) inp


newntlstlem' : (l : List StringC) → (len : ℕ) → (p : len ≡ length l) → (n : ℕ)  
  → newntlst' l len p n ∈ l → ⊥
newntlstlem' ls len p n inp with dis (newntstr n) ls  
newntlstlem' ls len p n inp | no ¬p = ¬p inp
newntlstlem' ls len p₁ n inp | yes p with exists-split _ _ p 
newntlstlem' [] zero p₁ n inp | yes p | [] , p2 , ()
newntlstlem' (ls ∷ ls₁) zero () n inp | yes p | [] , p2 , p3
newntlstlem' [] zero p₁ n inp | yes p | p1 ∷ p2 , p3 , ()
newntlstlem' (ls ∷ ls₁) zero () n inp | yes p | p1 ∷ p2 , p3 , p4
newntlstlem' ls (suc len) prf n inp | yes p | p1 , p2 , p3 = newntlstlem' (p1 ++ p2) len (newntlst'-lem ls p1 p2  (newntstr n) len p3 prf) (suc n) (newntlst'-lem2 ls p1 p2  (newntstr n) _  (λ r → newntlstlem'' (p1 ++ p2) len (newntlst'-lem ls p1 p2 (newntstr n) len p3 prf) (suc n) n <-base (sym r) ) p3 inp)


newntlst : List StringC  → StringC
newntlst ls = newntlst' ls (length ls) refl 0

newntlstlem : (ls : List StringC) → newntlst ls ∉ ls
newntlstlem ls = newntlstlem' ls _ refl 0
