

open import Utils.Logic

module CNF.NormUnitRules (N T : Set)(_=n_ : DecEq N)(_=t_ : DecEq T) where

open import Relation.Nullary
open import Relation.Binary.PropositionalEquality hiding ([_] ; inspect )

open import Data.Empty
open import Data.Bool hiding (_≟_ ; _∨_  ; T)
open import Data.Nat hiding (_≟_)
open import Data.Product
open import Data.Sum
open import Data.List

open import Utils.Logic
open import Utils.ListsAddition
open import Utils.ListProperties
open import Utils.ListMembership

open import CNF.Grammar N T _=n_ _=t_
open import CNF.ParseTree N T _=n_ _=t_
open import CNF.ParseTreeProperties N T _=n_ _=t_

open DecListMinus
open DecExistance

nur-f : N → Rules → Rule → Rules
nur-f N Rs (x , x₁) with liftDecEqToList _=s_ x₁ (inj₁ N ∷ [])
nur-f N Rs (x , x₁) | yes p 
  = foldl (λ res smbs →  [ (x , smbs) ] ++ res) [] 
      (_/_ Symbols (liftDecEqToList _=s_)
      (filterRHS N Rs) (inj₁ N ∷ []))
nur-f N Rs (x , x₁) | no ¬p = [ (x , x₁) ]

nu-step : N → Rules → Rules
nu-step N Rs = foldl (λ res r → nur-f N Rs r ++ res) [] Rs


nu-cmplt' : ∀ A B Rs rhs → (A , [ inj₁ B ]) ∈ Rs → (B , rhs) ∈ Rs 
                      → rhs ≢ [ inj₁ B ] → (A , rhs) ∈ (nu-step B Rs)
nu-cmplt' A N Rs xs rin1 rin2 ineq 
  with exists-split (A , (inj₁ N ∷ [])) Rs rin1
nu-cmplt' A N Rs xs rin1 rin2 ineq | z1 , z2 , z3 
  rewrite z3 
  | foldlnest z1 ((A , (inj₁ N ∷ [])) ∷ z2) [] 
                 (λ res r → nur-f N (z1 ++ (A , (inj₁ N ∷ [])) ∷ z2) r ++ res)
 with liftDecEqToList _=s_ (inj₁ N ∷ []) (inj₁ N ∷ [])
... | no f  = ex-falso-quodlibet (f refl)
... | yes f rewrite foldInc' (foldl (λ res smbs → (A , smbs) ∷ res) []
       ((List Symbol / liftDecEqToList _=s_)
        (foldl (λ res r → filterRHS-f N r ++ res) []
         (z1 ++ (A , (inj₁ N ∷ [])) ∷ z2))
        (inj₁ N ∷ []))
       ++
       foldl (λ res r → nur-f N (z1 ++ (A , (inj₁ N ∷ [])) ∷ z2) r ++ res) []
       z1)  z2 ( nur-f N (z1 ++ (A , (inj₁ N ∷ [])) ∷ z2)) |  
  ++-assoc (foldl (λ res r → nur-f N (z1 ++ (A , (inj₁ N ∷ [])) ∷ z2) r ++ res) []
       z2) (foldl (λ res smbs → (A , smbs) ∷ res) []
       ((List Symbol / liftDecEqToList _=s_)
        (foldl (λ res r → filterRHS-f N r ++ res) []
         (z1 ++ (A , (inj₁ N ∷ [])) ∷ z2))
        (inj₁ N ∷ []))) (foldl (λ res r → nur-f N (z1 ++ (A , (inj₁ N ∷ [])) ∷ z2) r ++ res) []
       z1) = inFirst {Rule} {A , xs} 
                     {(foldl (λ res r → nur-f N (z1 ++ (A , (inj₁ N ∷ [])) ∷ z2) r ++ res)
        [] z2
        ++
        foldl (λ res smbs → (A , smbs) ∷ res) []
        ((List Symbol / liftDecEqToList _=s_)
         (foldl (λ res r → filterRHS-f N r ++ res) []
          (z1 ++ (A , (inj₁ N ∷ [])) ∷ z2))
         (inj₁ N ∷ [])))} {foldl (λ res r → nur-f N (z1 ++ (A , (inj₁ N ∷ [])) ∷ z2) r ++ res) []
       z1} (inTwo {Rule} {A , xs} {foldl (λ res smbs → (A , smbs) ∷ res) []
       ((List Symbol / liftDecEqToList _=s_)
        (foldl (λ res r → filterRHS-f N r ++ res) []
         (z1 ++ (A , (inj₁ N ∷ [])) ∷ z2))
        (inj₁ N ∷ []))} {foldl (λ res r → nur-f N (z1 ++ (A , (inj₁ N ∷ [])) ∷ z2) r ++ res) []
       z2} (norm-ε-f-lem {A} {xs} {((List Symbol / liftDecEqToList _=s_)
       (foldl (λ res r → filterRHS-f N r ++ res) []
        (z1 ++ (A , (inj₁ N ∷ [])) ∷ z2))
       (inj₁ N ∷ []))} (sound/ Symbols (liftDecEqToList _=s_) 
       {(inj₁ N ∷ [])} {xs} (foldl (λ res r → filterRHS-f N r ++ res) []
       (z1 ++ (A , (inj₁ N ∷ [])) ∷ z2)) (filterRHS-sound xs (z1 ++ (A , (inj₁ N ∷ [])) ∷ z2) N rin2)  
       (λ t → ineq (sym t)))))


emptyIn : ∀ A N Rs → (A , []) ∈ Rs → (A , []) ∈ nu-step N Rs
emptyIn A N Rs rin with exists-split (A , []) Rs rin
emptyIn A N Rs rin | z1 , z2 , z3 
  rewrite z3 
  | foldlnest z1 ((A , []) ∷ z2) [] 
                 (λ res r → nur-f N (z1 ++ (A , []) ∷ z2) r ++ res)
  = foldInc (A , []) 
            (foldl (λ res r → nur-f N (z1 ++ (A , []) ∷ z2) r ++ res) [] z1) z2 
            (nur-f N (z1 ++ (A , []) ∷ z2)) 


notEqIn : ∀ A N N' Rs → (A , [ inj₁ N' ]) ∈ Rs → N' ≢ N → (A , [ inj₁ N' ]) ∈ nu-step N Rs
notEqIn A N N' Rs rin ineq
 with exists-split (A , [ inj₁ N' ]) Rs rin
... | z1 , z2 , z3 
  rewrite z3 
  | foldlnest z1 ((A , [ inj₁ N' ]) ∷ z2) [] 
                 (λ res r → nur-f N (z1 ++ (A , [ inj₁ N' ]) ∷ z2) r ++ res)
  with liftDecEqToList _=s_ (inj₁ N' ∷ []) (inj₁ N ∷ [])
... | no p 
  = foldInc (A , [ inj₁ N' ]) 
            (foldl (λ res r → nur-f N (z1 ++ (A , [ inj₁ N' ]) ∷ z2) r ++ res) [] z1) 
            z2 
            (nur-f N (z1 ++ (A , [ inj₁ N' ]) ∷ z2)) 
... | yes p = ex-falso-quodlibet (ineq (emptyIn'' (emptyIn' p)))
  where
    emptyIn' : {X : Set} →  {a b : X} →  [ a ] ≡ [ b ] → a ≡ b
    emptyIn' refl = refl

    emptyIn'' : ∀ {a b} →  (inj₁ a) ≡ (inj₁ b) → a ≡ b
    emptyIn'' refl = refl


longIn  : ∀ A x₁ x₂ xs N Rs → (A , (x₁ ∷ x₂ ∷ xs)) ∈ Rs → (A , (x₁ ∷ x₂ ∷ xs)) ∈ nu-step N Rs
longIn A x₁ x₂ xs N Rs rin 
  with exists-split (A , (x₁ ∷ x₂ ∷ xs)) Rs rin
... | z1 , z2 , z3 
    rewrite z3 
    | foldlnest z1 ((A , (x₁ ∷ x₂ ∷ xs)) ∷ z2) [] 
      (λ res r → nur-f N (z1 ++ (A , (x₁ ∷ x₂ ∷ xs)) ∷ z2) r ++ res) 
    with liftDecEqToList _=s_ (x₁ ∷ x₂ ∷ xs) (inj₁ N ∷ [])
... | no  z 
  = foldInc (A , (x₁ ∷ x₂ ∷ xs)) 
            (foldl (λ res r → nur-f N (z1 ++ (A , (x₁ ∷ x₂ ∷ xs)) ∷ z2) r ++ res) [] z1) 
            z2 (nur-f N (z1 ++ (A , (x₁ ∷ x₂ ∷ xs)) ∷ z2)) 
... | yes ()


termRulesIn  : ∀ A x N Rs → (A , [ inj₂ x ]) ∈ Rs → (A , [ inj₂ x ]) ∈ nu-step N Rs
termRulesIn A x n Rs rin 
  with exists-split (A , [ inj₂ x ]) Rs rin
... | z1 , z2 , z3 rewrite z3 
    | foldlnest z1 ((A , [ inj₂ x ]) ∷ z2) [] 
      (λ res r → nur-f n (z1 ++ (A , (inj₂ x ∷ [])) ∷ z2) r ++ res) 
    = foldInc (A , [ inj₂ x ]) 
              (foldl (λ res r → nur-f n (z1 ++ (A , [ inj₂ x ]) ∷ z2) r ++ res) [] z1) 
              z2 (nur-f n (z1 ++ (A , [ inj₂ x ]) ∷ z2))


mutual
 nur-completeness : ∀ Rs xs N A → Tree Rs A xs → terminals xs ≡ true 
   → Tree (nu-step N Rs) A xs
 nur-completeness Rs xs N A (node {[]} x x₁) onlyTerms 
   = node (emptyIn A N Rs x) (nur-completenessMut Rs [] xs N x₁ onlyTerms)
 nur-completeness Rs .(x ∷ []) N A (node {inj₂ x ∷ []} x₁ (.x ∷t ⟦⟧)) onlyTerms
   = node (termRulesIn  A x N Rs x₁) (_∷t_ x ⟦⟧)
 nur-completeness Rs .(zs ++ []) N A (node {inj₁ x ∷ []} x₁ 
   (_∷n_ {.[]} {.[]} {.x} {zs} (node x₂ x₃) ⟦⟧)) onlyTerms  
   with nur1 Rs x zs (node x₂ x₃) (terminalsSplit1 zs [] onlyTerms) 
   | nur-completeness Rs zs N x  (node x₂ x₃) 
     ((terminalsSplit1 zs [] onlyTerms)) 
   | x =n N
 nur-completeness Rs .zs N A (node {inj₁ x ∷ []} x₁ 
   (_∷n_ {.[]} {.[]} {.x} {zs} (node x₂ x₃) ⟦⟧)) onlyTerms  
   | z1 , z2 , z3 , z4 
   | p 
   | yes e 
   rewrite e | ++-th zs = node (nu-cmplt' A N Rs z1 x₁ z2 z4) z3
 nur-completeness Rs .zs N A 
   (node {inj₁ x ∷ []} x₁ (_∷n_ {.[]} {.[]} {.x} {zs} (node x₂ x₃) ⟦⟧)) onlyTerms 
   | z1 , z2 , z3 , z4 
   | p | no e = node (notEqIn A N x Rs x₁ e) (_∷n_ p ⟦⟧)

 nur-completeness Rs xs N A (node {x ∷ x₁ ∷ xs₁} x₂ x₃) onlyTerms 
   = node (longIn A x x₁ xs₁ N Rs x₂) 
          (nur-completenessMut Rs (x ∷ x₁ ∷ xs₁) xs N x₃ onlyTerms)


 nur-completenessMut : ∀ Rs xs ys N → ListOfTs Rs xs ys → terminals ys ≡ true 
                                                     → ListOfTs (nu-step N Rs) xs ys
 nur-completenessMut Rs .[] .[] N ⟦⟧ t = ⟦⟧
 nur-completenessMut Rs .(inj₂ t ∷ xs) .(t ∷ ys) N (_∷t_ {xs} {ys} t lot) t₁ 
   = _∷t_ t (nur-completenessMut Rs xs ys N lot t₁)
 nur-completenessMut Rs .(inj₁ n ∷ xs) .(zs ++ ys) N (_∷n_ {xs} {ys} {n} {zs} x lot) t 
   = _∷n_ (nur-completeness Rs zs N n x 
           (terminalsSplit2  ys zs 
            (terminalsSwap zs ys t))) 
           (nur-completenessMut Rs xs ys N lot 
            (terminalsSplit1  ys zs (terminalsSwap zs ys t)))


 nur1 : ∀ Rs N xs → (t : Tree Rs N xs) → terminals xs ≡ true 
   → Σ[ zs ∈ Symbols ] 
     Σ[ rin ∈ ((N , zs) ∈ Rs) ] 
     Σ[ lot ∈ ListOfTs (nu-step N Rs) zs xs ] zs ≢ [ inj₁ N ]
 nur1 Rs N xs (node {ws} x x₁) onlyTerms with liftDecEqToList _=s_  ws [ inj₁ N ]
 nur1 Rs N .[] (node x ⟦⟧) onlyTerms | yes ()
 nur1 Rs N .(t ∷ ys) (node x (_∷t_ {xs} {ys} t x₁)) onlyTerms | yes ()
 nur1 Rs N .(zs ++ []) (node x (_∷n_ {.[]} {.[]} {.N} {zs} x₁ ⟦⟧)) onlyTerms 
  | yes refl rewrite ++-th zs = nur1 Rs N zs x₁ onlyTerms
 nur1 Rs N .[] (node x ⟦⟧) onlyTerms | no p = [] , x , ⟦⟧ , p
 nur1 Rs N .(t ∷ ys) (node x (_∷t_ {xs} {ys} t x₁)) onlyTerms 
  | no p = (inj₂ t ∷ xs) , x , _∷t_ t 
           (nur-completenessMut Rs xs ys N x₁ onlyTerms) , p
 nur1 Rs N .(zs ++ ys) (node x (_∷n_ {xs} {ys} {n} {zs} x₁ x₂)) onlyTerms 
  | no p = inj₁ n ∷ xs , x , _∷n_ (nur-completeness Rs zs N n x₁ 
                                (terminalsSplit2 ys zs 
                                 (terminalsSwap zs ys onlyTerms))) 
                               (nur-completenessMut Rs  xs ys N x₂ 
                                ((terminalsSplit1 ys zs 
                                 (terminalsSwap zs ys onlyTerms)))) , p




abstract
 sound1 : ∀ A N xs Rs → (A , xs) ∈ (nu-step N Rs) 
        → ((A , xs) ∈ Rs) ⊎ ((A , [ inj₁ N ]) ∈ Rs × (N , xs) ∈ Rs)
 sound1 A N xs Rs rin with foldlth Rule _≟_ (A , xs) Rs (nur-f N Rs) rin
 sound1 A N xs Rs rin | (x , x₁) , z2 , z3 with liftDecEqToList _=s_ x₁ (inj₁ N ∷ [])
 ... | yes p  with soundLem''' A xs x ((List Symbol / liftDecEqToList _=s_)
        (foldl (λ res r → filterRHS-f N r ++ res) [] Rs) (inj₁ N ∷ [])) z3
 ... | d rewrite d with soundLem'' x xs x ((List Symbol / liftDecEqToList _=s_)
        (foldl (λ res r → filterRHS-f N r ++ res) [] Rs) (inj₁ N ∷ [])) z3
 ... | f with soundLem' {Symbols} {liftDecEqToList _=s_} xs 
                        (foldl (λ res r → filterRHS-f N r ++ res) [] Rs) 
                          (inj₁ N ∷ []) f 
 ... | o rewrite p = inj₂ (z2 , filterRHS-complete xs Rs N o)
 sound1 .x N .x₁ Rs rin | (x , x₁) , z2 , here  | no p = inj₁ z2
 sound1 A N xs Rs rin | (x , x₁) , z2 , there () | no p

sound1' : ∀ A N xs Rs → (A , xs) ∈ (nu-step N Rs) → (A , xs) ∉ Rs → ((A , [ inj₁ N ]) ∈ Rs × (N , xs) ∈ Rs)
sound1' A N xs Rs pi pin with sound1 A N xs Rs pi 
sound1' A N₁ xs Rs pi pin | inj₁ x with pin x
... | ()
sound1' A N₁ xs Rs pi pin | inj₂ y = y

{-
mutual 
 nur-soundness : ∀ N A Rs xs → Tree (nu-step N Rs) A xs → Tree Rs A xs
 nur-soundness N A Rs xs (node {ws} x x₁) with sound1 A N ws Rs x
 nur-soundness N A Rs xs₁ (node x x₂) | inj₁ x₁ = node x₁ (nur-soundnessMut _ _ _ _ x₂)
 nur-soundness N A Rs xs₁ (node x x₂) | inj₂ (proj₁ , proj₂)
   with nur-soundnessMut N Rs _ _ x₂ 
 ... | d with node proj₁ (_∷n_ (node proj₂ (nur-soundnessMut _ _ _ _ x₂)) ⟦⟧)
 ... | o rewrite ++-th xs₁ = o

 nur-soundnessMut : ∀ N Rs xs ys → ListOfTs (nu-step N Rs) xs ys → ListOfTs Rs xs ys
 nur-soundnessMut N Rs .[] .[] ⟦⟧ = ⟦⟧
 nur-soundnessMut N Rs .(inj₂ t ∷ xs) .(t ∷ ys) (_∷t_ {xs} {ys} t lot) 
   = _∷t_ t (nur-soundnessMut  N Rs xs ys lot)
 nur-soundnessMut N Rs .(inj₁ n ∷ xs) .(zs ++ ys) (_∷n_ {xs} {ys} {n} {zs} x lot) 
   = _∷n_ (nur-soundness N n Rs  zs x) (nur-soundnessMut N Rs xs ys  lot)
-}

mutual 
 nur-soundness : ∀ N A Rs xs → Tree (nu-step N Rs) A xs → Tree Rs A xs
 nur-soundness N A Rs xs (node {ws} x x₁) with eq2in _=R?_ (A , ws) Rs 
 nur-soundness N₁ A Rs xs (node x x₁) | yes p = node p ((nur-soundnessMut _ _ _ _ x₁))
 nur-soundness N₁ A Rs xs (node x x₁) | no ¬p 
   with nur-soundnessMut N₁ Rs _ _ x₁
 ... | d with node (proj₁ z) (_∷n_ (node (proj₂ z) (nur-soundnessMut _ _ _ _ x₁)) ⟦⟧)
    where 
     z = sound1' _ _ _ _ x ¬p 
 ... | o rewrite ++-th xs = o


 nur-soundnessMut : ∀ N Rs xs ys → ListOfTs (nu-step N Rs) xs ys → ListOfTs Rs xs ys
 nur-soundnessMut N Rs .[] .[] ⟦⟧ = ⟦⟧
 nur-soundnessMut N Rs .(inj₂ t ∷ xs) .(t ∷ ys) (_∷t_ {xs} {ys} t lot) 
   = _∷t_ t (nur-soundnessMut  N Rs xs ys lot)
 nur-soundnessMut N Rs .(inj₁ n ∷ xs) .(zs ++ ys) (_∷n_ {xs} {ys} {n} {zs} x lot) 
   = _∷n_ (nur-soundness N n Rs  zs x) (nur-soundnessMut N Rs xs ys  lot)



nur-normalizes : ∀ X N Rs → (X , [ inj₁ N ]) ∉ (nu-step N Rs)
nur-normalizes X N Rs rin 
  with foldlth Rule _≟_ (X , [ inj₁ N ]) Rs (nur-f N Rs) rin
nur-normalizes X N Rs rin | (z1 , z1s) , z2 , z3
  with liftDecEqToList _=s_ z1s (inj₁ N ∷ [])
nur-normalizes X N Rs rin | (z1 , z1s) , z2 , z3 | yes p 
  with soundLem'' X [ inj₁ N ] z1 ((List Symbol / liftDecEqToList _=s_)
       (foldl (λ res r → filterRHS-f N r ++ res) [] Rs) (inj₁ N ∷ [])) z3
nur-normalizes X N Rs rin | (z1 , z1s) , z2 , z3 | yes p | d 
  = complete/ Symbols (liftDecEqToList _=s_) {[ inj₁ N ]} 
    (foldl (λ res r → filterRHS-f N r ++ res) [] Rs) d
nur-normalizes X N Rs rin | (z1 , z1s) , z2 , z3 | no p 
  = p (sym (lemmR' (incSngl z3)))



-- LIFTING
data LiftedNur (Rs : Rules) : Rules → Set where
 bb : LiftedNur Rs Rs
 ss : {A : N}{Rs' : Rules} → LiftedNur Rs Rs' →  LiftedNur Rs (nu-step A Rs')


apply : List N → Rules → Rules
apply ns Rs = foldr (λ n rs → nu-step n rs) Rs ns

norm-u : Rules → Rules
norm-u Rs = apply (filterSnglsRHS Rs) Rs


filterSnglsRHS-complete : ∀ A N Rs →
  (A , [ inj₁ N ]) ∈ Rs → N ∈ filterSnglsRHS Rs
filterSnglsRHS-complete A N Rs rin 
  with exists-split (A , [ inj₁ N ]) Rs rin
... | z1 , z2 , z3 
  rewrite z3 
  | foldlnest z1 ((A , [ inj₁ N ]) ∷ z2) [] (λ res r → filterSnglsRHS-f r ++ res) 
  = foldInc N (foldl (λ res r → filterSnglsRHS-f r ++ res) [] z1) 
              z2 filterSnglsRHS-f


applyChange :  ∀ X N xs Rs → 
  (∀ X → (X , [ inj₁ N ]) ∉ Rs) → (X , [ inj₁ N ]) ∉ apply xs Rs 
applyChange X N [] Rs f rin = f X rin
applyChange X N (x ∷ xs) Rs f rin with inspect (apply xs Rs)
applyChange X N (x ∷ xs) Rs f rin | it d p1 
  rewrite p1 with foldlth Rule _≟_  (X , [ inj₁ N ])  d (nur-f x d) rin
applyChange X N (x ∷ xs) Rs f rin | it d p1 | (z1 , z1s) , z2 , z3 
  with liftDecEqToList _=s_ z1s (inj₁ x ∷ [])
applyChange X N (x ∷ xs) Rs f rin | it d p1 | (z1 , z1s) , z2 , z3 | yes p 
  with soundLem'' X [ inj₁ N ] z1 ((List Symbol / liftDecEqToList _=s_)
       (foldl (λ res r → filterRHS-f x r ++ res) [] d) (inj₁ x ∷ [])) z3
... | v with soundLem' [ inj₁ N ] 
             (foldl (λ res r → filterRHS-f x r ++ res) [] d) 
             [ inj₁ x ] v
... | z  with filterRHS-complete [ inj₁ N ] d x z
... | l rewrite sym p1 = applyChange x N xs Rs f l
applyChange X N (x ∷ xs) Rs f rin | it d p1 | (z1 , z1s) , z2 , z3 | no  p 
  rewrite sym (incSngl z3) | sym p1 = applyChange X N xs Rs f z2


applyComp : ∀ xs ys Rs →  apply (xs ++ ys) Rs ≡ apply xs (apply ys Rs)
applyComp [] ys Rs = refl
applyComp (x ∷ xs) ys Rs rewrite applyComp xs ys Rs = refl


applyIsNot : ∀ xs Rs N X →  (X , [ inj₁ N ]) ∈ apply xs Rs → N ∈ xs → ⊥
applyIsNot xs Rs N X rin ntin with exists-split N xs ntin
... | z1 , z2 , z3 
  rewrite z3 | applyComp z1 (N ∷ z2) Rs 
  = applyChange X N z1 (nu-step N (apply z2 Rs)) 
                       (λ X' rin' → nur-normalizes  X' N (apply z2 Rs) rin') rin


filterSnglLem' : ∀ A N Rs →
  A ∈ filterSnglsRHS (nu-step N Rs) → A ∈ filterSnglsRHS Rs
filterSnglLem' A N' Rs ntin 
  with foldlth N _=n_ A (nu-step N' Rs) (filterSnglsRHS-f) ntin
filterSnglLem' A N' Rs ntin | (z1 , []) , z2 , ()
filterSnglLem' A N' Rs ntin | (z1 , (inj₂ x ∷ [])) , z2 , ()
filterSnglLem' A N' Rs ntin | (z1 , (inj₁ x ∷ [])) , z2 , z3 
  with foldlth Rule _≟_ (z1 , [ inj₁ x ]) Rs (nur-f N' Rs) z2
filterSnglLem' A N' Rs ntin | (z1 , (inj₁ x ∷ [])) , z2 , z3 | (x1 , x1s) , x2 , x3 
  with liftDecEqToList _=s_ x1s (inj₁ N' ∷ [])
filterSnglLem' A N' Rs ntin | (z1 , (inj₁ x ∷ [])) , z2 , z3 | (x1 , x1s) , x2 , x3 
  | yes p 
  with soundLem'' z1 [ inj₁ x ] x1 ((List Symbol / liftDecEqToList _=s_)
        (foldl (λ res r → filterRHS-f N' r ++ res) [] Rs) (inj₁ N' ∷ [])) x3
... | z with soundLem' [ inj₁ x ] (foldl (λ res r → filterRHS-f N' r ++ res) [] Rs) [ inj₁ N' ] z
... | k with filterRHS-complete [ inj₁ x ] Rs N' k
... | m with exists-split (N' , [ inj₁ x ]) Rs m
... | q1 , q2 , q3 rewrite q3 
    | foldlnest q1 ((N' , [ inj₁ x ]) ∷ q2) [] (λ res r → filterSnglsRHS-f r ++ res)  
    | incSngl z3 
    = foldInc x  (foldl (λ res r → filterSnglsRHS-f r ++ res) [] q1) q2 
      filterSnglsRHS-f
filterSnglLem' A N' Rs ntin 
    | (z1 , (inj₁ x ∷ [])) , z2 , z3 
    | (x1 , x1s) , x2 , x3 
    | no  p with exists-split (x1 , x1s) Rs x2 
... | q1 , q2 , q3 rewrite q3 
    | foldlnest q1  ((x1 , x1s) ∷ q2) []  (λ res r → filterSnglsRHS-f r ++ res) 
    | sym (lemmR' (incSngl x3)) 
    | incSngl z3 
    = foldInc x (foldl (λ res r → filterSnglsRHS-f r ++ res) [] q1) q2 
                (filterSnglsRHS-f)
filterSnglLem' A N' Rs ntin | (z1 , (x ∷ x₁ ∷ z2s)) , z2 , ()


filterSnglLem : ∀ A xs Rs →
  A ∈ filterSnglsRHS (apply xs Rs) → A ∈ filterSnglsRHS Rs
filterSnglLem A [] Rs ntin = ntin
filterSnglLem A (x ∷ xs) Rs ntin 
  = filterSnglLem A xs Rs ((filterSnglLem' A  x  (apply xs Rs) ntin))


mkliftednur : ∀ Rs zs → LiftedNur Rs (apply zs Rs)
mkliftednur Rs [] = bb
mkliftednur Rs (x ∷ zs) = ss (mkliftednur Rs zs)



nu-step-sound : ∀ Rs A xs zz →  Tree (apply zz Rs) A xs → Tree Rs A xs
nu-step-sound Rs A xs [] x = x
nu-step-sound Rs A xs (x ∷ zz) x₁ = nu-step-sound Rs A xs zz 
   (nur-soundness _ _ _ _ x₁)



nu-step-complete : ∀ Rs Rs' A xs → LiftedNur Rs Rs' → Tree Rs A xs → Tree Rs' A xs
nu-step-complete .Rs' Rs' A xs bb tree = tree
nu-step-complete Rs .(foldl (λ res r → nur-f A₁ Rs' r ++ res) [] Rs') A xs 
  (ss {A₁} {Rs'} ln) tree 
  =  nur-completeness _ _ _ _ (nu-step-complete Rs Rs' A xs ln tree) 
    (terminalsLem Rs A xs tree)



nu-snd : ∀ Rs A xs → Tree (norm-u Rs) A xs → Tree Rs A xs
nu-snd Rs A xs tree 
  = nu-step-sound Rs A xs 
      (filterSnglsRHS Rs) tree



nu-cmplt : ∀ Rs A xs → Tree Rs A xs → Tree (norm-u Rs) A xs
nu-cmplt Rs A xs tree 
  = nu-step-complete Rs (norm-u Rs) A xs 
     (mkliftednur Rs (filterSnglsRHS Rs)) tree


nu-progress : ∀ X N Rs → (X , [ inj₁ N ]) ∉ (norm-u Rs)
nu-progress X N Rs rin 
    with filterSnglsRHS-complete  X N (norm-u Rs) rin
... | d with filterSnglLem N (filterSnglsRHS Rs) Rs d
... | f =  applyIsNot (filterSnglsRHS Rs) Rs N X rin f

