

open import Utils.Logic

module CNF.Nullable (N T : Set)(_=n_ : DecEq N)(_=t_ : DecEq T) where

open import Relation.Nullary
open import Relation.Binary.PropositionalEquality hiding ([_])

open import Data.List
open import Data.Nat  hiding (_≟_)
open import Data.Bool hiding (_≟_ ; _∨_ ; T)
open import Data.Product

open import CNF.Grammar N T _=n_ _=t_
open import CNF.NullableUtility N T _=n_ _=t_

open import Utils.ListsAddition
open import Utils.Logic

null-f : List N → Rule → List N
null-f  rec (x , x₁) = if allIn x₁ rec then [ x ]  else []


-- paper version nlbls'
nlbls′ : Rules → ℕ → List N
nlbls′ rs zero = start rs
  where
    start : Rules → List N
    start (r ∷ rs) = null-f [] r ++ start rs 
    start [] = []
nlbls′ rs (suc n) = collect (nlbls′ rs n)
  where   
    collect : List N → List N
    collect rec = foldl (λ res r → (null-f rec r) ++ res)  [] rs


nlbls : Rules → ℕ → List N
nlbls rs (suc n)     
  = let z = (nlbls rs n) in foldl (λ res r → (null-f z r) ++ res)  [] rs
nlbls (r ∷ rs) zero  = null-f [] r ++ nlbls rs zero
nlbls [] n = []


-- both versions of nullables 
prf12 : ∀ rs n → nlbls rs n ≡ nlbls′ rs n
prf12 [] zero = refl
prf12 (x ∷ rs) zero rewrite prf12 rs zero = refl
prf12 [] (suc n) = refl
prf12 rs (suc n) rewrite prf12 rs n = refl


-- takes list of rules and returns list of nullable nonterminals
-- O(n*n) where n = length Rs
nullables : Rules → List N
nullables Rs = nlbls Rs (length Rs)

nullables' : Rules → List N
nullables' Rs = nlbls′ Rs (length Rs)
