

open import Utils.Logic hiding (<-ℕ-wf)

module CNF.NullableComplete (N T : Set)(_=n_ : DecEq N)(_=t_ : DecEq T) where

open import Relation.Binary.PropositionalEquality hiding ([_] ; inspect)
open import Relation.Nullary

open import Data.List
open import Data.Empty
open import Data.Nat hiding (_≟_)
open import Data.Bool hiding (_≟_ ; T)
open import Data.Product
open import Data.Sum

open import Utils.ListProperties
open import Utils.ListsAddition
open import Utils.ListMembership
open import Utils.NatProperties

open import CNF.Grammar N T _=n_ _=t_
open import CNF.ParseTree N T _=n_ _=t_
open import CNF.ParseTreeProperties N T _=n_ _=t_
open import CNF.Nullable N T _=n_ _=t_
open import CNF.NullableUtility N T _=n_ _=t_

open WF<
open DecExistance   hiding (_∈?_)

lemm : {B : N}{R : Rules}(xs zs : Symbols)(gs : List T) → gs ≡ [] 
  → ListOfTs ((B , zs) ∷ R) xs gs → ListOfTs R xs gs ⊎ ListOfTs R zs gs
lemm .[]  zs .[] p ⟦⟧ = inj₁ ⟦⟧ 
lemm .(inj₂ t ∷ xs)  zs .(t ∷ ys₁) () (_∷t_ {xs} {ys₁} t s)
lemm {B} {R} .(inj₁ n ∷ xs)  zs .(zs₁ ++ ys₁) p 
  (_∷n_ {xs} {ys₁} {n} .{zs₁} (node {xs₁} {zs₁} x x₁) s) 
  with lemm _  _ _ (lemm' p) x₁
... | inj₁ q 
  rewrite p 
  | lemm' {T} {zs₁} p 
  | lemm'' {T} {zs₁} p 
  with (n , xs₁) ≟ (B , zs)
lemm {B} {R} .(inj₁ n ∷ xs)  zs .(ys₁ ++ zs₁) p 
  (_∷n_ {xs} {ys₁} {n} .{zs₁} (node {xs₁} {zs₁} x x₁) s) 
  | inj₁ q 
  | yes k 
  rewrite lemmR k 
  | lemmR' k with lemm _ _ _ refl x₁
... | inj₁ u = inj₂ u
... | inj₂ u = inj₂ u
lemm {B} {R} .(inj₁ n ∷ xs)  zs .(ys₁ ++ zs₁) p 
  (_∷n_ {xs} {ys₁} {n} .{zs₁} (node {xs₁} {zs₁} x x₁) s) 
  | inj₁ q | no k with lemm _ _ _ refl s
... | inj₁ u = inj₁ (_∷n_ ((node (lemmR'' x k) q)) u)
... | inj₂ u = inj₂ u
lemm {B} {R} .(inj₁ n ∷ xs)  zs .(ys₁ ++ zs₁) p 
  (_∷n_ {xs} {ys₁} {n} .{zs₁} (node {xs₁} {zs₁} x x₁) s) 
  | inj₂ q rewrite p | lemm' {T} {zs₁} p = inj₂ q


lemm′ : {B : N}{R : Rules}(xs : Symbols) 
  → ListOfTs ((B , xs) ∷ R) xs [] → ListOfTs R xs []
lemm′ xs  s with lemm  _ _ _ refl s 
lemm′ xs  s | inj₁ x = x
lemm′ xs  s | inj₂ x = x


inLemm : {X : Set}{rs p1 p2 : List X}{a b : X} → a ≢ b 
      → (a ∷ rs) ≡ (p1 ++ b ∷ p2) → Σ[ ys ∈  List X ] a ∷ ys ≡ p1
inLemm {X} {.p2} {[]} {p2} p3 refl with p3 refl
... | ()
inLemm {X} {.(p1 ++ b ∷ p2)} {x ∷ p1} {p2} .{x} {b} p3 refl = p1 , refl 


nlbls0  : ∀ a b → nlbls (a ++ b) 0 ≡ nlbls a 0 ++ nlbls b 0
nlbls0 [] b = refl
nlbls0 (x ∷ a) b 
  rewrite sym (++-assoc (null-f [] x) (nlbls a 0) (nlbls b 0)) 
  | nlbls0 a b = refl


mutual 
  G : {a : N} → (Rs1 Rs2 : Rules) → (n : ℕ) 
    → a ∈ (nlbls Rs1 n) → (∀ R → R ∈ Rs1 → R ∈ Rs2) → a ∈ (nlbls Rs2 n)
  G [] Rs2 zero () p
  G  {a} ((x , x₁) ∷ Rs1) Rs2 zero i p 
    with incLem {N} {a} 
         {(if allIn x₁ [] then x ∷ [] else [])} {nlbls Rs1 0} i 
  G  {a} ((x , x₁) ∷ Rs1) Rs2 zero i p 
    | inj₁ d with inspect (allIn x₁ [])
  G  {a} ((x , x₁) ∷ Rs1) Rs2 zero i p 
    | inj₁ d 
    | it true p1 with ∈lem (p (x , x₁) here) 
  ... | v1 , v2 , v3 
    rewrite v3 
    | nlbls0 v1 ((x , x₁) ∷ v2) | p1 
    | incSngl d  
    = inTwo {N} {x} {(x ∷ nlbls v2 0)} {nlbls v1 0} here
  G  {a} ((x , x₁) ∷ Rs1) Rs2 zero i p 
    | inj₁ d 
    | it false p1 
    rewrite p1 with d
  ... | ()
  G  {a} ((x , x₁) ∷ Rs1) Rs2 zero i p 
    | inj₂ d = G {a} Rs1 Rs2 zero d (λ R Rin → p R (there Rin))
  G  {a} Rs1 Rs2 (suc n) i p 
    with foldlth N _=n_ a Rs1 (null-f (nlbls Rs1 n)) i 
  G  {a} Rs1 Rs2 (suc n) i p | (d1 , ds) , d2 , d3 
    with p (d1 , ds) d2 
  G  {a} Rs1 Rs2 (suc n) i p | (d1 , ds) , d2 , d3 | f 
    with inspect (allIn ds (nlbls Rs1 n))
  G  {a} Rs1 Rs2 (suc n) i p | (d1 , ds) , d2 , d3 | f 
    | it true p1 
    rewrite p1 | incSngl d3 
    with allInSound ds (nlbls Rs1 n) p1 
  G Rs1 Rs2 (suc n) i p | (d1 , .[]) , d2 , d3 | f 
    | it true p1 | all_c1 with ∈lem {Rule} {Rs2} {d1 , []} f 
  ... | l1 , l2 , l3 
    rewrite l3 
    | foldlLem l1 ((d1 , []) ∷ l2) [] 
      (λ res r → null-f (nlbls (l1 ++ (d1 , []) ∷ l2) n) r ++ res) 
    = foldInc d1 (foldl
        (λ res r → null-f (nlbls (l1 ++ (d1 , []) ∷ l2) n) r ++ res) []
        l1) l2 (null-f (nlbls (l1 ++ (d1 , []) ∷ l2) n))
  G Rs1 Rs2 (suc n) i p | (d1 , .(inj₁ x ∷ xs)) , d2 , d3 | f 
    | it true p1 | all_c2 {x} {xs} k x₁ 
    with G Rs1 Rs2 n x₁ p | G' {xs} Rs1 Rs2 n p k
  ... | o1 | o2  
    with ∈lem {Rule} {Rs2} {d1 , (inj₁ x ∷ xs)} f 
  ... | i1 , i2 , i3 
    rewrite i3 | foldlLem i1 ((d1 , (inj₁ x ∷ xs)) ∷ i2) [] (λ res r →
          null-f (nlbls (i1 ++ (d1 , (inj₁ x ∷ xs)) ∷ i2) n) r ++ res) 
   | allInComplete _ _ (all_c2 o2 o1)
   = foldInc d1 (foldl
        (λ res r →
           null-f (nlbls (i1 ++ (d1 , (inj₁ x ∷ xs)) ∷ i2) n) r ++ res)
        [] i1) i2 (null-f (nlbls (i1 ++ (d1 , (inj₁ x ∷ xs)) ∷ i2) n))
  G  {a} Rs1 Rs2 (suc n) i p | (d1 , ds) , d2 , d3 | f | it false p1 
    rewrite p1 with d3
  ... | ()

  G' : {xs : Symbols} → (Rs1 Rs2 : Rules) → (n : ℕ) → (∀ R → R ∈ Rs1 → R ∈ Rs2) 
                      → AllIn xs (nlbls Rs1 n) → AllIn xs (nlbls Rs2 n)
  G' rs1 rs2 n p all_c1 = all_c1
  G' Rs1 Rs2 n p (all_c2 {x} ai x₁) 
    = all_c2 (G' Rs1 Rs2 n p ai) (G Rs1 Rs2 n x₁ p)


nlblsLemIncG' : {X : Set}(R r : X)(Rs1 Rs2 : List X)
                    → R ∈ (Rs1 ++ Rs2) → R ∈ (Rs1 ++ r ∷ Rs2)
nlblsLemIncG' R r [] Rs2 i = there i
nlblsLemIncG' .x r (x ∷ Rs1) Rs2 here = here
nlblsLemIncG' R r (x ∷ Rs1) Rs2 (there i) 
  = there (nlblsLemIncG' R r Rs1 Rs2 i)


nlblsLemIncG : {r : Rule}{a : N} → (Rs1 Rs2 : Rules) → (n : ℕ) 
  → a ∈ (nlbls (Rs1 ++ Rs2) n) → a ∈ (nlbls (Rs1 ++ r ∷ Rs2) n)
nlblsLemIncG {r} {a} Rs1 Rs2 n i 
  = G (Rs1 ++ Rs2) (Rs1 ++ r ∷ Rs2) n i 
    (λ R Rin → nlblsLemIncG' R r Rs1 Rs2 Rin)


liftLemIncG : ∀ n zs Rs1 Rs2 r → AllIn zs (nlbls (Rs1 ++ Rs2) n) 
                → AllIn zs (nlbls (Rs1 ++ r ∷ Rs2) n) 
liftLemIncG n .[] Rs1 Rs2 r all_c1 = all_c1
liftLemIncG n .(inj₁ x ∷ xs) Rs1 Rs2 r (all_c2 {x} {xs} ai x₁) 
  = all_c2 (liftLemIncG n xs Rs1 Rs2 r ai) (nlblsLemIncG Rs1 Rs2 n x₁)


lemm′Gen : {r : Rule}(R₁ R₂ : Rules)(xs : Symbols)(ys : List T)
  → ListOfTs (R₁ ++ r ∷ R₂) xs ys → ListOfTs (r ∷ (R₁ ++ R₂)) xs ys
lemm′Gen R₁ R₂ .[] .[] ⟦⟧ = ⟦⟧
lemm′Gen R₁ R₂ .(inj₂ t ∷ xs) .(t ∷ ys) (_∷t_ {xs} {ys} t t₁) 
  = _∷t_ t (lemm′Gen R₁ R₂ xs ys t₁)
lemm′Gen R₁ R₂ .(inj₁ n ∷ xs) .(zs ++ ys) (_∷n_ {xs} {ys} {n} {zs} (node x x₁) t)
  = _∷n_ (node 
    (incLemm {_} {_} {R₁} {_} {R₂} x) 
    (lemm′Gen R₁ R₂ _ zs x₁)) 
    (lemm′Gen R₁ R₂ xs ys t)


mutual 
  nlblsLemInc : {r : Rule}{a : N} → (Rs : Rules) → (n : ℕ)
    → a ∈ (nlbls Rs n) → a ∈ (nlbls (r ∷ Rs) n)
  nlblsLemInc [] zero ()
  nlblsLemInc {x , x₁} {a} ((x₂ , x₃) ∷ Rs) zero p 
    = inTwo {_} {a} 
      {((if allIn x₃ [] then x₂ ∷ [] else []) ++ nlbls Rs 0)} 
      {(if allIn x₁ [] then x ∷ [] else [])} p
  nlblsLemInc {r} {a} Rs (suc n) p 
    with foldlth N _=n_ a Rs (null-f (nlbls Rs n)) p
  nlblsLemInc {r} {a} Rs (suc n) p | (h1 , h1') , h2 , h3 
   with inspect (allIn h1' (nlbls Rs n))
  nlblsLemInc {r} {a} Rs (suc n) p | (h1 , h1') , h2 , h3 
   | it true p1
   with nlblsLemInc' h1' r Rs n (allInSound h1' _ p1) | ∈lem h2
  ... | dd | i1 , i2 , i3 rewrite i3 
   | foldlLem i1 ((h1 , h1') ∷ i2) 
     (null-f (nlbls (r ∷ i1 ++ (h1 , h1') ∷ i2) n) r ++ []) 
     (λ res r₁ → null-f (nlbls (r ∷ i1 ++ (h1 , h1') ∷ i2) n) r₁ ++ res) 
   | allInComplete  _ _ dd 
   | p1 
   | incSngl h3 = foldInc h1 ((foldl
        (λ res r₁ →
           null-f (nlbls (r ∷ i1 ++ (h1 , h1') ∷ i2) n) r₁ ++ res)
        (null-f (nlbls (r ∷ i1 ++ (h1 , h1') ∷ i2) n) r ++ []) i1)) i2 
        (null-f (nlbls (r ∷ i1 ++ (h1 , h1') ∷ i2) n))
  nlblsLemInc {r} {a} Rs (suc n) p | (h1 , h1') , h2 , h3 
    | it false p1 rewrite p1 with h3
  ... | () 
  nlblsLemInc' : (h1' : Symbols)(r : Rule)(Rs : Rules)(n : ℕ)
    → AllIn h1' (nlbls Rs n) → AllIn h1' (nlbls (r ∷ Rs) n)
  nlblsLemInc' .[] r Rs n all_c1 = all_c1
  nlblsLemInc' .(inj₁ x ∷ xs) r Rs n (all_c2 {x} {xs} p x₁) 
    = all_c2 (nlblsLemInc' xs r Rs n p) (nlblsLemInc Rs n x₁)


botListOfTs : ∀ gs x y ys → gs ≡ [] 
  → ListOfTs ((x , (y ∷ ys)) ∷ []) (y ∷ ys) gs → ⊥
botListOfTs .(t ∷ ys₁) x .(inj₂ t) ys () (_∷t_ {.ys} {ys₁} t t₁)
botListOfTs .(zs ++ ys₁) x .(inj₁ n) ys p (_∷n_ {.ys} {ys₁} {n} {zs} (node x₁ x₂) t) 
  rewrite lemmR' (incSngl x₁) 
  = botListOfTs  _ _ _ _ (addsToNil ys₁ zs (helpp zs ys₁ p)) x₂


liftLemInc : ∀ n zs Rs r → AllIn zs (nlbls Rs n)
   → AllIn zs (nlbls (r ∷ Rs) n) 
liftLemInc n .[] Rs r all_c1 = all_c1
liftLemInc n .(inj₁ x ∷ xs) Rs r (all_c2 {x} {xs} p x₁) 
  = all_c2 (liftLemInc n xs Rs r p) (nlblsLemInc {r} Rs n x₁)


mutual 
  complete : {A : N}{n : ℕ} →  WF.Acc _<_ n → (R : Rules) 
           → n ≡ (length R) → Tree R A [] → A ∈ nlbls R n
  complete wf []  p (node () x₁)
  complete {A} {zero} wf ((x , []) ∷ []) p (node x₁ x₂)  
    rewrite lemmR (incSngl x₁) = here
  complete {A} {suc n} wf ((x , []) ∷ []) p (node x₁ x₂) 
    rewrite lemmR (incSngl x₁) = here
  complete {A} {zero} wf ((x , (x₁ ∷ x₂)) ∷ []) () (node x₃ x₄) 
  complete {A} {suc n} wf ((x , (x₁ ∷ x₂)) ∷ []) p (node {xs} x₃ x₄) 
    rewrite (lemmR' (incSngl x₃)) with botListOfTs []  x x₁ x₂ refl x₄
  ... | ()
  complete {A} {zero} wf ((x , xs) ∷ Rs) () t
  complete {A} {suc n} wf ((x , xs) ∷ Rs) p (node {zs} x₂ x₃) 
    with _≟_  (x , xs) (A , zs) 
  --complete {A} {suc n} (acc wf) (x , xs ∷ Rs) p (node {zs} x₂ x₃) 
  complete {.A} {suc n} (WF.acc wf) ((A , xs) ∷ Rs) p (node x₂ x₃) | yes refl 

   with complete' {n}  (wf n (letn n))  Rs [] xs refl (cong pred p) 
         (lemm′ xs  x₃)
  ... | o rewrite cong pred p 
   with allInComplete xs (nlbls Rs (foldr (λ _ → suc) 0 Rs)) o
  ... | v  rewrite    sym (cong pred p) 
    | allInComplete  _ _ (liftLemInc n xs Rs (A , xs) o) 
    = foldInc A [] Rs (null-f (nlbls ((A , xs) ∷ Rs) n))
-- {!!}

  complete {A} {suc n} wf ((x , xs) ∷ Rs) p (node {zs} x₂ x₃) 
   | no  d  
   with ∈lem x₂ 
  complete {A} {suc n} (acc wf) ((x , xs) ∷ Rs) p (node {zs} x₂ x₃) 
   | no  d 
   | proj₁ , proj₂ , proj₃  rewrite proj₃  --= {!!}
   with complete' {n} (wf n (letn n)) (proj₁ ++ proj₂) [] zs refl 
      (trans (cong pred p) (kkk {Rule} (x , xs) (A , zs) Rs proj₁ proj₂ proj₃ d))
      (lemm′ zs (lemm′Gen proj₁ proj₂ zs [] x₃))
  ... | c with inLemm {Rule} {Rs} {proj₁} {proj₂} {x , xs} {A , zs} d proj₃
  ... | f1 , f2  rewrite sym f2 
   | cong (drop 1) proj₃ 
   | foldlLem  f1 ((A , zs) ∷ proj₂) 
       ((if allIn xs (nlbls ((x , xs) ∷ f1 ++ (A , zs) ∷ proj₂) n) then
         x ∷ [] else []) ++ [])  (λ res r →
          null-f (nlbls ((x , xs) ∷ f1 ++ (A , zs) ∷ proj₂) n) r ++ res) 
   | allInComplete _ _ (liftLemIncG n zs ((x , xs) ∷ f1) (proj₂) (A , zs) c) 
    = foldInc A (foldl
        (λ res r →
           null-f (nlbls ((x , xs) ∷ f1 ++ (A , zs) ∷ proj₂) n) r ++ res)
        ((if allIn xs (nlbls ((x , xs) ∷ f1 ++ (A , zs) ∷ proj₂) n) then
          x ∷ [] else [])
         ++ [])
        f1) proj₂ (null-f (nlbls ((x , xs) ∷ f1 ++ (A , zs) ∷ proj₂) n))


  complete' : {n : ℕ} → WF.Acc _<_ n  → (R : Rules)(gs : List T)(xs : Symbols) → gs ≡ [] 
                 → n ≡ length R  →  ListOfTs R xs gs  → AllIn xs (nlbls R n)
  complete' wf R .[] .[] p p2 ⟦⟧ = all_c1
  complete' wf R .(t ∷ ys) .(inj₂ t ∷ xs) () p2 (_∷t_ {xs} {ys} t ts)
  complete' {n} wf R .(zs ++ ys) .(inj₁ n₁ ∷ xs) p p2 
   (_∷n_ {xs} {ys} {n₁} {zs} x ts) rewrite sym p2 
   = all_c2 (complete' (<-ℕ-wf n) R ys xs 
             ((addsToNilL ys zs (helpp zs ys p))) p2 ts)
     (complete {_} {n} (<-ℕ-wf n) R p2 
       (subst (Tree R n₁) (addsToNil ys zs (helpp zs ys p)) x))


nlbls-cmplt : {A : N} → (R : Rules) → Tree R A [] → A ∈ nlbls R (length R)
nlbls-cmplt {A} R t = complete (<-ℕ-wf (length R)) R refl t
